/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.graphics.MAssigner;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MEFlowBasePoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import java.util.Iterator;
import java.util.TreeMap;

class MObjectDifferFactory {
    protected MObjectDiffer differ = null;
    protected boolean ignoreSelection = false;

    MObjectDifferFactory() {
    }

    public void ignoreSelection(boolean ignoreSelection) {
        this.ignoreSelection = ignoreSelection;
    }

    String diff(MObject object1, MObject object2) {
        if (object1 == null && object2 == null) {
            return null;
        }
        if (object1 == null || object2 == null) {
            return object1 == null ? DifferUtils.getAttributeDifferenceString("mobject", "null", "not null") : DifferUtils.getAttributeDifferenceString("mobject", "not null", "null");
        }
        if (!MObjectDifferFactory.compareType(object1, object2)) {
            return DifferUtils.getAttributeDifferenceString("mobject dynamic type", object1.getClass().getName(), object2.getClass().getName());
        }
        if (!this.ignoreSelection && !this.compareSelection(object1, object2)) {
            return DifferUtils.getAttributeDifferenceString("selection", object1.isSelected(), object2.isSelected());
        }
        this.differ = object1 instanceof MPolyline ? (object1 instanceof MRArrow ? new MRArrowDiffer() : (object1 instanceof MAssigner ? new MAssignerDiffer() : (object1 instanceof MRectangle ? (object1 instanceof MBracket ? new MBracketDiffer() : (object1 instanceof MRoundedRectangle ? new MRoundedRectangleDiffer() : new MRectangleDiffer())) : new MPolylineDiffer()))) : (object1 instanceof MPoint ? (object1 instanceof MAtomSetPoint ? new MAtomSetPointDiffer() : (object1 instanceof MEFlowBasePoint ? new MEFlowBasePointDiffer() : new MPointDiffer())) : new MObjectDiffer());
        return this.differ.diff(object1, object2);
    }

    boolean equals(MObject object1, MObject object2) {
        return this.diff(object1, object2) == null;
    }

    protected static boolean compareType(MObject object1, MObject object2) {
        return object1.getClass().getName() == object2.getClass().getName();
    }

    protected boolean compareSelection(MObject object1, MObject object2) {
        return object1.isSelected() == object2.isSelected();
    }

    private class MObjectDiffer {
        protected String result = null;

        private MObjectDiffer() {
        }

        public String diff(MObject object1, MObject object2) {
            this.result = this.compareColor(object1, object2);
            if (this.result != null) {
                return this.result;
            }
            this.result = this.compareLineColor(object1, object2);
            if (this.result != null) {
                return this.result;
            }
            this.result = this.compareBackground(object1, object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        public boolean equals(MObject object1, MObject object2) {
            return this.diff(object1, object2) == null;
        }

        protected String compareBackground(MObject object1, MObject object2) {
            if (object1.getBackground() == null && object2.getBackground() == null || object1.getBackground() != null && object1.getBackground().equals(object2.getBackground())) {
                return null;
            }
            return DifferUtils.getAttributeDifferenceString("mobject background", object1.getBackground(), object2.getBackground());
        }

        protected String compareLineColor(MObject object1, MObject object2) {
            if (object1.getLineColor() == null && object2.getLineColor() == null || object1.getLineColor() != null && object1.getLineColor().equals(object2.getLineColor())) {
                return null;
            }
            return DifferUtils.getAttributeDifferenceString("mobject line color", object1.getLineColor(), object2.getLineColor());
        }

        protected String compareColor(MObject object1, MObject object2) {
            if (object1.getColor() == null && object2.getColor() == null || object1.getColor() != null && object1.getColor().equals(object2.getColor())) {
                return null;
            }
            return DifferUtils.getAttributeDifferenceString("mobject color", object1.getColor(), object2.getColor());
        }
    }

    private class MPolylineDiffer
    extends MObjectDiffer {
        private MPolylineDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            MPolyline polyline1 = (MPolyline)object1;
            MPolyline polyline2 = (MPolyline)object2;
            this.result = this.compareThickness(polyline1, polyline2);
            if (this.result != null) {
                return this.result;
            }
            this.result = this.compareArcAngle(polyline1, polyline2);
            if (this.result != null) {
                return this.result;
            }
            this.result = this.compareArrows(polyline1, polyline2);
            if (this.result != null) {
                return this.result;
            }
            this.result = this.comparePoints(polyline1, polyline2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String comparePoints(MPolyline polyline1, MPolyline polyline2) {
            if (polyline1.getSkip(MPolyline.HEAD) != polyline2.getSkip(MPolyline.HEAD)) {
                return DifferUtils.getAttributeDifferenceString("mpolyline head skip", polyline1.getSkip(MPolyline.HEAD), polyline2.getSkip(MPolyline.HEAD));
            }
            if (polyline1.getSkip(MPolyline.TAIL) != polyline2.getSkip(MPolyline.TAIL)) {
                return DifferUtils.getAttributeDifferenceString("mpolyline tail skip", polyline1.getSkip(MPolyline.TAIL), polyline2.getSkip(MPolyline.TAIL));
            }
            if (polyline1.getPointCount() != polyline2.getPointCount()) {
                return DifferUtils.getAttributeDifferenceString("mpolyline point coount", polyline1.getPointCount(), polyline2.getPointCount());
            }
            for (int i = 0; i < polyline1.getPointCount(); ++i) {
                String diffOfPoints = new MObjectDifferFactory().diff(polyline1.getPoint(i), polyline2.getPoint(i));
                if (diffOfPoints == null) continue;
                return diffOfPoints;
            }
            return null;
        }

        protected String compareArrows(MPolyline polyline1, MPolyline polyline2) {
            if (polyline1.getArrowFlags(MPolyline.HEAD) == polyline2.getArrowFlags(MPolyline.HEAD) && polyline1.getArrowFlags(MPolyline.TAIL) == polyline2.getArrowFlags(MPolyline.TAIL) && polyline1.getArrowLength(MPolyline.HEAD) == polyline2.getArrowLength(MPolyline.HEAD) && polyline1.getArrowLength(MPolyline.TAIL) == polyline2.getArrowLength(MPolyline.TAIL) && polyline1.getArrowWidth(MPolyline.HEAD) == polyline2.getArrowWidth(MPolyline.HEAD) && polyline1.getArrowWidth(MPolyline.TAIL) == polyline2.getArrowWidth(MPolyline.TAIL)) {
                return null;
            }
            return "mpolyline arrows\n arrowFlags Head: 1: " + polyline1.getArrowFlags(MPolyline.HEAD) + " 2: " + polyline2.getArrowFlags(MPolyline.HEAD) + "\n arrowFlags Tail: 1: " + polyline1.getArrowFlags(MPolyline.TAIL) + " 2: " + polyline2.getArrowFlags(MPolyline.TAIL) + "\n arrowLegth: HEAD 1:" + polyline1.getArrowLength(MPolyline.HEAD) + " 2: " + polyline2.getArrowLength(MPolyline.HEAD) + "\n arrowLength TAIL 1:" + polyline1.getArrowLength(MPolyline.TAIL) + " 2: " + polyline2.getArrowLength(MPolyline.TAIL) + "\n arrowWidth Head 1:" + polyline1.getArrowWidth(MPolyline.HEAD) + " 2: " + polyline2.getArrowWidth(MPolyline.HEAD) + "\n arrowWidth Tail 1:" + polyline1.getArrowWidth(MPolyline.TAIL) + " 2: " + polyline2.getArrowWidth(MPolyline.TAIL);
        }

        protected String compareArcAngle(MPolyline polyline1, MPolyline polyline2) {
            if (polyline1.getArcAngle() != polyline2.getArcAngle()) {
                return DifferUtils.getAttributeDifferenceString("mpolyline arc angle", polyline1.getArcAngle(), polyline2.getArcAngle());
            }
            return null;
        }

        protected String compareThickness(MPolyline polyline1, MPolyline polyline2) {
            if (polyline1.getThickness() != polyline2.getThickness()) {
                return DifferUtils.getAttributeDifferenceString("mpolyline thickness", polyline1.getThickness(), polyline2.getThickness());
            }
            return null;
        }
    }

    private class MAssignerDiffer
    extends MPolylineDiffer {
        private MAssignerDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareOrder((MAssigner)object1, (MAssigner)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareOrder(MAssigner assigner1, MAssigner assigner2) {
            if (assigner1.getOrder() != assigner2.getOrder()) {
                return DifferUtils.getAttributeDifferenceString("massigner order", assigner1.getOrder(), assigner2.getOrder());
            }
            return null;
        }
    }

    private class MRArrowDiffer
    extends MPolylineDiffer {
        private MRArrowDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareArrowType((MRArrow)object1, (MRArrow)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareArrowType(MRArrow arrow1, MRArrow arrow2) {
            if (arrow1.getType() != arrow2.getType()) {
                return DifferUtils.getAttributeDifferenceString("mrarrow type", arrow1.getType(), arrow2.getType());
            }
            return null;
        }
    }

    private class MRectangleDiffer
    extends MPolylineDiffer {
        private MRectangleDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareOptions((MRectangle)object1, (MRectangle)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareOptions(MRectangle rectangle1, MRectangle rectangle2) {
            if (rectangle1.getTCenter() != rectangle2.getTCenter()) {
                return DifferUtils.getAttributeDifferenceString("mrectangle t center", rectangle1.getTCenter(), rectangle2.getTCenter());
            }
            if (rectangle1.getTOption() != rectangle2.getTOption()) {
                return DifferUtils.getAttributeDifferenceString("mrectangle t option", rectangle1.getTOption(), rectangle2.getTOption());
            }
            return null;
        }
    }

    private class MBracketDiffer
    extends MRectangleDiffer {
        private MBracketDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareBracketOptions((MBracket)object1, (MBracket)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareBracketOptions(MBracket bracket1, MBracket bracket2) {
            if (bracket1.getBracketOrientation() != bracket2.getBracketOrientation()) {
                return DifferUtils.getAttributeDifferenceString("mbracket orientation", bracket1.getBracketOrientation(), bracket2.getBracketOrientation());
            }
            if (bracket1.getType() != bracket2.getType()) {
                return DifferUtils.getAttributeDifferenceString("mbracket type", bracket1.getType(), bracket2.getType());
            }
            return null;
        }
    }

    private class MRoundedRectangleDiffer
    extends MRectangleDiffer {
        private MRoundedRectangleDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareArcOptions((MRoundedRectangle)object1, (MRoundedRectangle)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareArcOptions(MRoundedRectangle rectangle1, MRoundedRectangle rectangle2) {
            if (rectangle1.getArcWidth() != rectangle2.getArcWidth()) {
                return DifferUtils.getAttributeDifferenceString("mroundedrectangle arc width", rectangle1.getArcWidth(), rectangle2.getArcWidth());
            }
            if (rectangle1.getArcHeight() != rectangle2.getArcHeight()) {
                return DifferUtils.getAttributeDifferenceString("mroundedrectangle arc height", rectangle1.getArcHeight(), rectangle2.getArcHeight());
            }
            return null;
        }
    }

    private class MPointDiffer
    extends MObjectDiffer {
        private MPointDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareLocation((MPoint)object1, (MPoint)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        protected String compareLocation(MPoint point1, MPoint point2) {
            if (!point1.getLocation().equals(point2.getLocation())) {
                return DifferUtils.getAttributeDifferenceString("mpoint location", point1.getLocation(), point2.getLocation());
            }
            return null;
        }
    }

    private class MAtomSetPointDiffer
    extends MPointDiffer {
        private MAtomSetPointDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareAtomsAndWeights((MAtomSetPoint)object1, (MAtomSetPoint)object2);
            if (this.result != null) {
                return this.result;
            }
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        @Override
        protected String compareLocation(MPoint point1, MPoint point2) {
            return null;
        }

        protected String compareAtomsAndWeights(MAtomSetPoint point1, MAtomSetPoint point2) {
            int i;
            MolAtom[] atomsOfFirst = point1.getAtoms();
            MolAtom[] atomsOfSecond = point2.getAtoms();
            double[] weightsOfFirst = point1.getWeights();
            double[] weightsOfSecond = point2.getWeights();
            if (atomsOfFirst == null && atomsOfSecond == null) {
                return null;
            }
            if (atomsOfFirst == null || atomsOfSecond == null) {
                return atomsOfFirst == null ? DifferUtils.getAttributeDifferenceString("matomsetpoint atom", "null", "not null") : DifferUtils.getAttributeDifferenceString("matomsetpoint atom", "not null", "null");
            }
            TreeMap<Integer, Double> atomIndexToWeightMap1 = new TreeMap<Integer, Double>();
            TreeMap<Integer, Double> atomIndexToWeightMap2 = new TreeMap<Integer, Double>();
            for (i = 0; i < atomsOfFirst.length; ++i) {
                atomIndexToWeightMap1.put(atomsOfFirst[i].getParent().indexOf(atomsOfFirst[i]), weightsOfFirst == null ? 0.0 : weightsOfFirst[i]);
            }
            for (i = 0; i < atomsOfSecond.length; ++i) {
                atomIndexToWeightMap2.put(atomsOfSecond[i].getParent().indexOf(atomsOfSecond[i]), weightsOfSecond == null ? 0.0 : weightsOfSecond[i]);
            }
            if (!((Object)atomIndexToWeightMap1.keySet()).equals(atomIndexToWeightMap2.keySet())) {
                return DifferUtils.getAttributeDifferenceString("matomsetpoint atom indexes", atomIndexToWeightMap1.keySet(), atomIndexToWeightMap2.keySet());
            }
            Iterator i$ = atomIndexToWeightMap1.keySet().iterator();
            while (i$.hasNext()) {
                int i2 = (Integer)i$.next();
                if (((Double)atomIndexToWeightMap1.get(i2)).equals(atomIndexToWeightMap2.get(i2))) continue;
                return DifferUtils.getAttributeDifferenceString("matomsetpoint " + i2 + "th atom weight", atomIndexToWeightMap1.get(i2), atomIndexToWeightMap2.get(i2));
            }
            return null;
        }
    }

    private class MEFlowBasePointDiffer
    extends MPointDiffer {
        private MEFlowBasePointDiffer() {
        }

        @Override
        public String diff(MObject object1, MObject object2) {
            String parentDiff = super.diff(object1, object2);
            if (parentDiff != null) {
                return parentDiff;
            }
            this.result = this.compareAtoms((MEFlowBasePoint)object1, (MEFlowBasePoint)object2);
            if (this.result != null) {
                return this.result;
            }
            return null;
        }

        @Override
        protected String compareLocation(MPoint point1, MPoint point2) {
            return null;
        }

        protected String compareAtoms(MEFlowBasePoint point1, MEFlowBasePoint point2) {
            MolAtom sourceFirst = point1.getAtom();
            MolAtom sourceSecond = point2.getAtom();
            if (sourceFirst == null && sourceSecond == null) {
                return null;
            }
            if (sourceFirst == null || sourceSecond == null) {
                return sourceFirst == null ? DifferUtils.getAttributeDifferenceString("eflowbasepoint atom", "null", "not null") : DifferUtils.getAttributeDifferenceString("eflowbasepoint atom", "not null", "null");
            }
            if (sourceFirst.getParent().indexOf(sourceFirst) != sourceSecond.getParent().indexOf(sourceSecond)) {
                return DifferUtils.getAttributeDifferenceString("eflowbasepoint atoms", sourceFirst.getParent().indexOf(sourceFirst), sourceSecond.getParent().indexOf(sourceSecond));
            }
            String diffOfPoints = new MObjectDifferFactory().diff(point1.getOtherEnd(), point2.getOtherEnd());
            if (diffOfPoints != null) {
                return diffOfPoints;
            }
            return null;
        }
    }
}

