/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.DefaultSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.DifferenceObject;
import chemaxon.core.util.differ.MoleculeGraphDiffer;
import chemaxon.core.util.differ.SgroupAtomBondDiffer;
import chemaxon.core.util.differ.SgroupDiffer;
import chemaxon.core.util.differ.SimpleDifference;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;

class MoleculeDiffer
extends MoleculeGraphDiffer {
    private boolean[] ignoreSgroupTypes = new boolean[16];
    private boolean ignoreSgroupCount = false;
    private boolean ignoreSgroups = false;
    private boolean ignoreSgroupGraph = false;
    private boolean ignoreSgroupExpansionState = false;
    private boolean ignoreSuperatom = false;
    private SgroupDiffer sgroupDiffer = null;
    private boolean ignoreComment = false;
    private boolean ignoreInputFormat = false;

    MoleculeDiffer() {
        for (int i = 0; i < this.ignoreSgroupTypes.length; ++i) {
            this.ignoreSgroupTypes[i] = false;
        }
    }

    protected MoleculeDiffer(MoleculeDiffer differ) {
        super(differ);
        this.ignoreSgroupCount = differ.ignoreSgroupCount;
        this.ignoreSgroups = differ.ignoreSgroups;
        this.ignoreInputFormat = differ.ignoreInputFormat;
        this.ignoreComment = differ.ignoreComment;
        this.ignoreSgroupExpansionState = differ.ignoreSgroupExpansionState;
        this.ignoreSgroupGraph = differ.ignoreSgroupGraph;
        this.ignoreSuperatom = differ.ignoreSuperatom;
        System.arraycopy(differ.ignoreSgroupTypes, 0, this.ignoreSgroupTypes, 0, differ.ignoreSgroupTypes.length);
    }

    @Override
    public DifferenceObject diffStopFirst(MoleculeGraph mg1, MoleculeGraph mg2) {
        if (this.ignoreSgroupExpansionState) {
            throw new RuntimeException("Ignore S-group expansion state is not implemented yet.");
        }
        DifferenceObject result = super.diffStopFirst(mg1, mg2);
        if (result != null) {
            return result;
        }
        if (!mg1.isMolecule() || !mg2.isMolecule()) {
            String mg1Str = mg1.isMolecule() ? "Molecule" : "not Molecule";
            String mg2Str = mg2.isMolecule() ? "Molecule" : "not Molecule";
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("data type", mg1Str, mg2Str));
        }
        Molecule m1 = (Molecule)mg1;
        Molecule m2 = (Molecule)mg2;
        if (!this.ignoreComment && (result = this.compareComment(m1, m2)) != null) {
            return result;
        }
        if (!this.ignoreInputFormat && (result = this.compareInputFormat(m1, m2)) != null) {
            return result;
        }
        if (!this.ignoreSgroupCount) {
            Sgroup[] sgroups2;
            Sgroup[] sgroups1 = this.findNotIgnoredSgroups(m1);
            if (sgroups1.length != (sgroups2 = this.findNotIgnoredSgroups(m2)).length) {
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("not ignored S-group count", sgroups1.length, sgroups2.length));
            }
            if (!this.ignoreSgroups && (result = this.compareSgroups(sgroups1, sgroups2)) != null) {
                return result;
            }
        }
        return null;
    }

    private DifferenceObject compareInputFormat(Molecule m1, Molecule m2) {
        if (m1.getInputFormat() == null && m2.getInputFormat() == null) {
            return null;
        }
        if (m1.getInputFormat() == null || m2.getInputFormat() == null) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("input format", m1.getInputFormat(), m2.getInputFormat()));
        }
        if (!m1.getInputFormat().equals(m2.getInputFormat())) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("input format", m1.getInputFormat(), m2.getInputFormat()));
        }
        return null;
    }

    protected void ignoreInputFormat(boolean ignore) {
        this.ignoreInputFormat = ignore;
    }

    private DifferenceObject compareComment(Molecule m1, Molecule m2) {
        if (m1.getComment() == null && m2.getComment() == null) {
            return null;
        }
        if (m1.getComment() == null || m2.getComment() == null) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("comment", m1.getComment(), m2.getComment()));
        }
        if (!m1.getComment().equals(m2.getComment())) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("comment", m1.getComment(), m2.getComment()));
        }
        return null;
    }

    protected void ignoreComment(boolean ignore) {
        this.ignoreComment = ignore;
    }

    private Sgroup[] findNotIgnoredSgroups(Molecule m) {
        ArrayList<Sgroup> sgroups = new ArrayList<Sgroup>();
        for (int i = 0; i < m.getSgroupCount(); ++i) {
            if (this.ignoreSgroupTypes[m.getSgroup(i).getType()]) continue;
            sgroups.add(m.getSgroup(i));
        }
        return sgroups.toArray(new Sgroup[sgroups.size()]);
    }

    private DifferenceObject compareSgroups(Sgroup[] sgroups1, Sgroup[] sgroups2) {
        for (int i = 0; i < sgroups1.length; ++i) {
            DifferenceObject result;
            Sgroup sg1 = sgroups1[i];
            Sgroup sg2 = sgroups2[i];
            String resultStr = this.getSgroupDiffer().diff(sg1, sg2);
            if (resultStr != null && !resultStr.isEmpty()) {
                return new SimpleDifference(sg1, sg2, resultStr);
            }
            if (!this.ignoreSgroupGraph && (result = this.compareSgroupGraph(sg1, sg2)) != null) {
                return result;
            }
            if (this.ignoreSuperatom || !(sg1 instanceof SuperatomSgroup) || !(sg2 instanceof SuperatomSgroup) || (result = this.compareSuperatom((SuperatomSgroup)sg1, (SuperatomSgroup)sg2)) == null) continue;
            return result;
        }
        return null;
    }

    protected void ignoreSgroups(boolean ignore) {
        this.ignoreSgroups = ignore;
        if (ignore) {
            for (int i = 0; i < this.ignoreSgroupTypes.length; ++i) {
                this.ignoreSgroupTypes[i] = true;
            }
        }
    }

    protected void ignoreSgroups(int sgroupType, boolean ignore) {
        this.ignoreSgroupTypes[sgroupType] = ignore;
        if (!ignore) {
            this.ignoreSgroups = false;
        }
    }

    protected void ignoreSgroupCount(boolean ignore) {
        this.ignoreSgroupCount = ignore;
    }

    private DifferenceObject compareSgroupGraph(Sgroup sgroup1, Sgroup sgroup2) {
        MolBond[] bonds2;
        MolAtom[] atoms2;
        if (sgroup1 instanceof SuperatomSgroup && sgroup2 instanceof SuperatomSgroup && ((SuperatomSgroup)sgroup1).isContracted() && ((SuperatomSgroup)sgroup2).isContracted()) {
            DifferenceObject diffObj = super.diffStopFirst(sgroup1.getSgroupGraph(), sgroup2.getSgroupGraph());
            if (diffObj != null) {
                return diffObj;
            }
            return null;
        }
        SelectionMolecule graph1 = sgroup1.getSgroupGraph();
        SelectionMolecule graph2 = sgroup2.getSgroupGraph();
        MolAtom[] atoms1 = graph1.getAtomArray();
        String difference = SgroupAtomBondDiffer.compareAtomArrays(atoms1, atoms2 = graph2.getAtomArray(), "S-group atoms");
        if (difference != null) {
            return new SimpleDifference(sgroup1, sgroup2, difference);
        }
        MolBond[] bonds1 = graph1.getBondArray();
        difference = SgroupAtomBondDiffer.compareBondArrays(bonds1, bonds2 = graph2.getBondArray(), "S-group bonds");
        if (difference != null) {
            return new SimpleDifference(sgroup1, sgroup2, difference);
        }
        return null;
    }

    protected void ignoreSgroupGraph(boolean ignore) {
        this.ignoreSgroupGraph = ignore;
    }

    private DifferenceObject compareSuperatom(SuperatomSgroup sgroup1, SuperatomSgroup sgroup2) {
        if (sgroup1.isExpanded() && sgroup2.isExpanded()) {
            String difference = this.atomDiffer.diff(sgroup1.getSuperAtom(), sgroup2.getSuperAtom());
            if (difference != null && !difference.isEmpty()) {
                return new SimpleDifference(sgroup1.getSuperAtom(), sgroup2.getSuperAtom(), difference);
            }
            return null;
        }
        if (sgroup1.isExpanded() || sgroup2.isExpanded()) {
            throw new RuntimeException("Superatom S-groups are in different expansion state which must have been recognized earlier.");
        }
        String difference = SgroupAtomBondDiffer.compareAtoms(sgroup1.getSuperAtom(), sgroup2.getSuperAtom(), "superatom S-group superatom");
        if (difference != null && !difference.isEmpty()) {
            return new SimpleDifference(sgroup1.getSuperAtom(), sgroup2.getSuperAtom(), difference);
        }
        return null;
    }

    protected void ignoreSuperatom(boolean ignore) {
        this.ignoreSuperatom = ignore;
    }

    @Override
    protected void setSgroupDiffer(SgroupDiffer differ) {
        this.sgroupDiffer = differ;
    }

    protected SgroupDiffer getSgroupDiffer() {
        if (this.sgroupDiffer == null) {
            this.sgroupDiffer = new DefaultSgroupDiffer();
        }
        return this.sgroupDiffer;
    }
}

