/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.differ.AtomDiffer;
import chemaxon.core.util.differ.BondDiffer;
import chemaxon.core.util.differ.DefaultAtomDiffer;
import chemaxon.core.util.differ.DefaultBondDiffer;
import chemaxon.core.util.differ.Differ;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.DifferenceObject;
import chemaxon.core.util.differ.MDocumentDiffer;
import chemaxon.core.util.differ.SgroupDiffer;
import chemaxon.core.util.differ.SimpleDifference;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

class MoleculeGraphDiffer
implements Differ {
    private boolean checkName = true;
    private boolean checkDimension = true;
    private boolean checkBondCount = true;
    private boolean checkAtomCount = true;
    private boolean checkAtoms = true;
    private boolean checkBonds = true;
    private boolean checkBondDirection = true;
    private boolean checkProperties = true;
    private boolean checkDBStereo = true;
    private boolean checkParity = true;
    private boolean checkLigandOrder = true;
    private boolean checkLinkNode = true;
    private boolean checkDocument = true;
    protected AtomDiffer atomDiffer = null;
    private BondDiffer bondDiffer = null;
    private MDocumentDiffer documentDiffer = null;

    MoleculeGraphDiffer() {
    }

    protected MoleculeGraphDiffer(MoleculeGraphDiffer differ) {
        this.checkName = differ.checkName;
        this.checkDimension = differ.checkDimension;
        this.checkBondCount = differ.checkBondCount;
        this.checkAtomCount = differ.checkAtomCount;
        this.checkAtoms = differ.checkAtoms;
        this.checkBonds = differ.checkBonds;
        this.checkBondDirection = differ.checkBondDirection;
        this.checkProperties = differ.checkProperties;
        this.checkDBStereo = differ.checkDBStereo;
        this.checkParity = differ.checkParity;
        this.checkLigandOrder = differ.checkLigandOrder;
        this.checkLinkNode = differ.checkLinkNode;
        this.checkDocument = differ.checkDocument;
    }

    MoleculeGraphDiffer(AtomDiffer maDiff, BondDiffer mbDiff, MDocumentDiffer mdDiffer) {
        this.atomDiffer = maDiff;
        this.bondDiffer = mbDiff;
        this.documentDiffer = mdDiffer;
    }

    protected AtomDiffer getAtomDiffer() {
        if (this.atomDiffer == null) {
            this.atomDiffer = new DefaultAtomDiffer();
        }
        return this.atomDiffer;
    }

    protected BondDiffer getBondDiffer() {
        if (this.bondDiffer == null) {
            this.bondDiffer = new DefaultBondDiffer();
        }
        return this.bondDiffer;
    }

    protected MDocumentDiffer getDocumentDiffer() {
        if (this.documentDiffer == null) {
            this.documentDiffer = new MDocumentDiffer();
        }
        return this.documentDiffer;
    }

    protected void ignoreName(boolean b) {
        this.checkName = !b;
    }

    protected void ignoreDimension(boolean b) {
        this.checkDimension = !b;
    }

    protected void ignoreBondCount(boolean b) {
        this.checkBondCount = !b;
    }

    protected void ignoreAtomCount(boolean b) {
        this.checkAtomCount = !b;
    }

    protected void ignoreAtoms(boolean b) {
        this.checkAtoms = !b;
    }

    protected void ignoreBonds(boolean b) {
        this.checkBonds = !b;
    }

    protected void ignoreBondDirection(boolean b) {
        this.checkBondDirection = !b;
    }

    protected void ignoreProperties(boolean b) {
        this.checkProperties = !b;
    }

    protected void ignoreDoubleBondStereo(boolean b) {
        this.checkDBStereo = !b;
    }

    protected void ignoreParity(boolean b) {
        this.checkParity = !b;
    }

    protected void ignoreLigandOrder(boolean b) {
        this.checkLigandOrder = !b;
    }

    protected void ignoreLinkNode(boolean b) {
        this.checkLinkNode = !b;
    }

    protected void ignoreDocument(boolean b) {
        this.checkDocument = !b;
    }

    @Override
    public Collection<DifferenceObject> diff(MoleculeGraph arg0, MoleculeGraph arg1) {
        DifferenceObject simpleDiff = this.diffStopFirst(arg1, arg1);
        if (simpleDiff != null) {
            ArrayList<DifferenceObject> result = new ArrayList<DifferenceObject>();
            result.add(simpleDiff);
            return result;
        }
        return null;
    }

    @Override
    public DifferenceObject diffStopFirst(MoleculeGraph mg1, MoleculeGraph mg2) {
        DifferenceObject result = null;
        if (mg1 == null || mg2 == null) {
            String mgStr1 = mg1 == null ? "null" : "not null";
            String mgStr2 = mg2 == null ? "null" : "not null";
            return new SimpleDifference("moleculegraph", mgStr1, mgStr2);
        }
        if (this.checkName && !MoleculeGraphDiffer.compareName(mg1, mg2)) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("molecule name", mg1.getName(), mg2.getName()));
        }
        if (this.checkDimension && !MoleculeGraphDiffer.compareDimension(mg1, mg2)) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("molecule dimension", mg1.getDim(), mg2.getDim()));
        }
        if (this.checkBondCount && !MoleculeGraphDiffer.compareBondCount(mg1, mg2)) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("number of bonds", mg1.getBondCount(), mg2.getBondCount()));
        }
        if (this.checkAtomCount && !MoleculeGraphDiffer.compareAtomCount(mg1, mg2)) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("number of atoms", mg1.getAtomCount(), mg2.getAtomCount()));
        }
        if (this.checkAtoms && (result = this.compareAtoms(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkBonds && (result = this.compareBonds(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkProperties && (result = this.compareProperties(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkDBStereo && (result = this.compareDBStereo(mg1, mg2, true)) != null) {
            return result;
        }
        if (this.checkParity && (result = this.compareParity(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkLigandOrder && (result = this.compareLigandOrder(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkLinkNode && (result = this.compareLinkNodes(mg1, mg2)) != null) {
            return result;
        }
        if (this.checkDocument && (result = this.compareDocument(mg1, mg2)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public boolean equals(MoleculeGraph mg1, MoleculeGraph mg2) {
        return this.diffStopFirst(mg1, mg2) == null;
    }

    private DifferenceObject compareDocument(MoleculeGraph mg1, MoleculeGraph mg2) {
        String differenceStr = this.getDocumentDiffer().diff(mg1.getDocument(), mg2.getDocument());
        if (differenceStr == null || differenceStr.isEmpty()) {
            return null;
        }
        return new SimpleDifference(mg1.getDocument(), mg2.getDocument(), differenceStr);
    }

    private DifferenceObject compareLinkNodes(MoleculeGraph mg1, MoleculeGraph mg2) {
        for (int i = 0; i < mg1.getAtomCount(); ++i) {
            MolAtom a1 = mg1.getAtom(i);
            MolAtom a2 = mg2.getAtom(i);
            boolean isLinkNode1 = a1.isLinkNode();
            boolean isLinkNode2 = a2.isLinkNode();
            if (isLinkNode1 && isLinkNode2) {
                int outerIdx10 = MoleculeGraphDiffer.getOuterLigandIdx(mg1, a1, 0);
                int outerIdx11 = MoleculeGraphDiffer.getOuterLigandIdx(mg1, a1, 1);
                int outerIdx20 = MoleculeGraphDiffer.getOuterLigandIdx(mg2, a2, 0);
                int outerIdx21 = MoleculeGraphDiffer.getOuterLigandIdx(mg2, a2, 1);
                if (outerIdx10 != outerIdx20 || outerIdx11 != outerIdx21) {
                    return new SimpleDifference(a1, a2, DifferUtils.getAttributeDifferenceString("link nodes at atomindex (" + i + ")", outerIdx10, outerIdx20));
                }
                if (outerIdx11 == outerIdx21) continue;
                return new SimpleDifference(a1, a2, DifferUtils.getAttributeDifferenceString("link nodes at atomindex (" + i + ")", outerIdx11, outerIdx21));
            }
            if (!(isLinkNode1 ^ isLinkNode2)) continue;
            return new SimpleDifference(a1, a2, DifferUtils.getAttributeDifferenceString("atoms, either atom isn't link node at atomindex (" + i + ")", isLinkNode1, isLinkNode2));
        }
        return null;
    }

    private static int getOuterLigandIdx(MoleculeGraph m, MolAtom a, int i) {
        if (!a.isLinkNode()) {
            return -1;
        }
        int ligandIdx = a.getLinkNodeOuterAtom(i);
        if (ligandIdx < 0) {
            return -1;
        }
        MolAtom ligand = a.getLigand(ligandIdx);
        return m.indexOf(ligand);
    }

    private DifferenceObject compareLigandOrder(MoleculeGraph mg1, MoleculeGraph mg2) {
        for (int i = 0; i < mg1.getAtomCount(); ++i) {
            MolAtom a1 = mg1.getAtom(i);
            MolAtom a2 = mg2.getAtom(i);
            if (a1.getAtno() != 134 || a2.getAtno() != 134) continue;
            if (a1.getBondCount() != a2.getBondCount()) {
                return new SimpleDifference(a1, a2, DifferUtils.getAttributeDifferenceString("ligand order", a1.getBondCount(), a2.getBondCount()));
            }
            for (int j = 0; j < a1.getBondCount(); ++j) {
                MolAtom ligand2;
                MolAtom ligand = a1.getLigand(j);
                int ligandIdx = mg1.indexOf(ligand);
                int order = a1.getLigandOrder(ligand);
                if (order == a2.getLigandOrder(ligand2 = mg2.getAtom(ligandIdx))) continue;
                return new SimpleDifference(a1, a2, DifferUtils.getAttributeDifferenceString("ligand order", a1, a2));
            }
        }
        return null;
    }

    private DifferenceObject compareProperties(MoleculeGraph mg1, MoleculeGraph mg2) {
        Object[] stringArray2;
        MPropertyContainer p1 = mg1.properties();
        MPropertyContainer p2 = mg2.properties();
        if (p1.size() != p2.size()) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("number of properties", p1.size(), p2.size()));
        }
        Object[] stringArray1 = p1.getKeys();
        if (!Arrays.equals(stringArray1, stringArray2 = p2.getKeys())) {
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("property keys", Arrays.toString(stringArray1), Arrays.toString(stringArray2)));
        }
        for (Object key : stringArray1) {
            MProp mprop2;
            MProp mprop1 = p1.get((String)key);
            if (mprop1.equals(mprop2 = p2.get((String)key))) continue;
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("property values", mprop1.getPropValue(), mprop2.getPropValue()));
        }
        return null;
    }

    private DifferenceObject compareParity(MoleculeGraph mg1, MoleculeGraph mg2) {
        for (int i = 0; i < mg1.getAtomCount(); ++i) {
            int p2;
            int p1 = mg1.getParity(i);
            if (p1 == (p2 = mg2.getParity(i))) continue;
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("molecule parity", p1, p2));
        }
        return null;
    }

    private DifferenceObject compareDBStereo(MoleculeGraph mg1, MoleculeGraph mg2, boolean grcheck) {
        for (int i = 0; i < mg1.getBondCount(); ++i) {
            int ct2;
            MolBond b1 = mg1.getBond(i);
            MolAtom a11 = b1.getCTAtom1();
            MolAtom a14 = b1.getCTAtom4();
            MolBond b2 = mg2.getBond(i);
            MolAtom a21 = b2.getCTAtom1();
            MolAtom a24 = b2.getCTAtom4();
            int ct1 = mg1.getStereo2(b1, a11, a14, grcheck);
            if (ct1 == (ct2 = mg2.getStereo2(b2, a21, a24, grcheck))) continue;
            return new SimpleDifference(b1, b2, DifferUtils.getAttributeDifferenceString("bond stereo at bond (" + i + ")", ct1, ct2));
        }
        return null;
    }

    private static boolean compareDimension(MoleculeGraph mg1, MoleculeGraph mg2) {
        return mg1.getDim() == mg2.getDim();
    }

    private DifferenceObject compareBonds(MoleculeGraph mg1, MoleculeGraph mg2) {
        int bondCount;
        int n = bondCount = mg1.getBondCount() < mg2.getBondCount() ? mg1.getBondCount() : mg2.getBondCount();
        if (bondCount < mg1.getBondCount()) {
            return new SimpleDifference(mg1.getBond(bondCount), null, DifferUtils.getAttributeDifferenceString("bonds", "not null", "null"));
        }
        if (bondCount < mg2.getBondCount()) {
            return new SimpleDifference(mg2.getBond(bondCount), null, DifferUtils.getAttributeDifferenceString("bonds", "null", "not null"));
        }
        for (int i = 0; i < bondCount; ++i) {
            MolBond b2;
            MolBond b1 = mg1.getBond(i);
            String diffResult = MoleculeGraphDiffer.compareEndAtoms(mg1, mg2, b1, b2 = mg2.getBond(i));
            if (diffResult != null && !diffResult.isEmpty()) {
                return new SimpleDifference(b1, b2, diffResult);
            }
            if (this.checkBondDirection && !MoleculeGraphDiffer.compareBondDirection(mg1, mg2, b1, b2)) {
                return new SimpleDifference(b1, b2, DifferUtils.getAttributeDifferenceString("bond direction", "(" + b1.getAtom1() + ", " + b1.getAtom2() + ")", "(" + b1.getAtom1() + ", " + b1.getAtom2() + ")"));
            }
            diffResult = this.getBondDiffer().diff(b1, b2);
            if (diffResult == null || diffResult.isEmpty()) continue;
            return new SimpleDifference(b1, b2, diffResult);
        }
        return null;
    }

    private static String compareEndAtoms(MoleculeGraph mg1, MoleculeGraph mg2, MolBond b1, MolBond b2) {
        MolAtom a11 = b1.getAtom1();
        MolAtom a12 = b1.getAtom2();
        MolAtom a21 = b2.getAtom1();
        MolAtom a22 = b2.getAtom2();
        int i11 = mg1.indexOf(a11);
        int i12 = mg1.indexOf(a12);
        int i21 = mg2.indexOf(a21);
        int i22 = mg2.indexOf(a22);
        if (i11 == i21 && i12 == i22 || i11 == i22 && i12 == i21) {
            return null;
        }
        return i11 + "-" + i12 + " != " + i21 + "-" + i22;
    }

    private static boolean compareBondDirection(MoleculeGraph mg1, MoleculeGraph mg2, MolBond b1, MolBond b2) {
        return mg1.indexOf(b1.getAtom1()) == mg2.indexOf(b2.getAtom1()) && mg1.indexOf(b1.getAtom2()) == mg2.indexOf(b2.getAtom2());
    }

    private DifferenceObject compareAtoms(MoleculeGraph mg1, MoleculeGraph mg2) {
        int atomCount;
        int n = atomCount = mg1.getAtomCount() < mg2.getAtomCount() ? mg1.getAtomCount() : mg2.getAtomCount();
        if (atomCount < mg1.getAtomCount()) {
            return new SimpleDifference(mg1.getAtom(atomCount), null, DifferUtils.getAttributeDifferenceString("atoms", "not null", "null"));
        }
        if (atomCount < mg2.getAtomCount()) {
            return new SimpleDifference(null, mg2.getAtom(atomCount), DifferUtils.getAttributeDifferenceString("atoms", "null", "not null"));
        }
        for (int i = 0; i < atomCount; ++i) {
            MolAtom a1 = mg1.getAtom(i);
            MolAtom a2 = mg2.getAtom(i);
            String diffResult = this.getAtomDiffer().diff(a1, a2);
            if (diffResult != null && !diffResult.isEmpty()) {
                return new SimpleDifference(a1, a2, "Different atoms at index (" + i + "): " + diffResult);
            }
            if (!this.checkBonds || (diffResult = MoleculeGraphDiffer.compareBondIdxes(mg1, mg2, a1, a2)) == null || diffResult.isEmpty()) continue;
            return new SimpleDifference(a1, a2, diffResult);
        }
        return null;
    }

    private static String compareBondIdxes(MoleculeGraph mg1, MoleculeGraph mg2, MolAtom a1, MolAtom a2) {
        int[] bondIdxes1 = new int[a1.getBondCount()];
        for (int i = 0; i < a1.getBondCount(); ++i) {
            bondIdxes1[i] = mg1.indexOf(a1.getBond(i));
        }
        int[] bondIdxes2 = new int[a2.getBondCount()];
        for (int i = 0; i < a2.getBondCount(); ++i) {
            bondIdxes2[i] = mg2.indexOf(a2.getBond(i));
        }
        if (ArrayTools.equalsArrays(bondIdxes1, bondIdxes2)) {
            return null;
        }
        return "[" + Arrays.toString(bondIdxes1) + "] != [" + Arrays.toString(bondIdxes2) + "]";
    }

    private static boolean compareAtomCount(MoleculeGraph mg1, MoleculeGraph mg2) {
        return mg1.getAtomCount() == mg2.getAtomCount();
    }

    private static boolean compareBondCount(MoleculeGraph mg1, MoleculeGraph mg2) {
        return mg1.getBondCount() == mg2.getBondCount();
    }

    private static boolean compareName(MoleculeGraph mg1, MoleculeGraph mg2) {
        if (mg1.getName() == null && mg2.getName() == null) {
            return true;
        }
        if (mg1.getName() == null || mg2.getName() == null) {
            return false;
        }
        return mg1.getName().equals(mg2.getName());
    }

    protected void setSgroupDiffer(SgroupDiffer arg0) {
    }

    protected void setAtomDiffer(AtomDiffer differ) {
        this.atomDiffer = differ;
    }

    protected void setBondDiffer(BondDiffer differ) {
        this.bondDiffer = differ;
    }

    protected void setMDocumentDiffer(MDocumentDiffer differ) {
        this.documentDiffer = differ;
    }
}

