/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.DifferenceObject;
import chemaxon.core.util.differ.MoleculeDiffer;
import chemaxon.core.util.differ.SimpleDifference;
import chemaxon.core.util.differ.StructureDiffer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;

class RgMoleculeDiffer
extends MoleculeDiffer {
    private boolean checkRgroups = true;
    private StructureDiffer differ = null;

    RgMoleculeDiffer() {
    }

    protected RgMoleculeDiffer(RgMoleculeDiffer differ) {
        super(differ);
        this.checkRgroups = differ.checkRgroups;
    }

    void setStructureDiffer(StructureDiffer d) {
        this.differ = d;
    }

    StructureDiffer getStructureDiffer() {
        if (this.differ == null) {
            this.differ = new StructureDiffer(this.getAtomDiffer(), this.getBondDiffer(), this.getSgroupDiffer(), StructureDiffer.ComparisonDirection.SAME_CLASS);
        }
        return this.differ;
    }

    void ignoreRgroups(boolean b) {
        this.checkRgroups = !b;
    }

    @Override
    public DifferenceObject diffStopFirst(MoleculeGraph mg1, MoleculeGraph mg2) {
        DifferenceObject result = super.diffStopFirst(mg1, mg2);
        if (result != null) {
            return result;
        }
        if (!(mg1 instanceof RgMolecule) || !(mg2 instanceof RgMolecule)) {
            String mg1Str = mg1 instanceof RgMolecule ? "RgMolecule" : "not RgMolecule";
            String mg2Str = mg2 instanceof RgMolecule ? "RgMolecule" : "not RgMolecule";
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("data type", mg1Str, mg2Str));
        }
        RgMolecule m1 = (RgMolecule)mg1;
        RgMolecule m2 = (RgMolecule)mg2;
        result = this.getStructureDiffer().diffStopFirst(m1.getRoot(), m2.getRoot());
        if (result != null) {
            return new SimpleDifference(m1, m2, "Different root molecule: " + ((Object)result).toString());
        }
        if (this.checkRgroups && (result = this.compareRgroups(m1, m2)) != null) {
            return result;
        }
        return null;
    }

    private DifferenceObject compareRgroups(RgMolecule m1, RgMolecule m2) {
        if (m1.getRgroupCount() != m2.getRgroupCount()) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rgroup count", m1.getRgroupCount(), m2.getRgroupCount()));
        }
        for (int i = 0; i < m1.getRgroupCount(); ++i) {
            if (m1.getRgroupMemberCount(i) != m2.getRgroupMemberCount(i)) {
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rgroup member count", m1.getRgroupMemberCount(i), m2.getRgroupMemberCount(i)));
            }
            for (int j = 0; j < m1.getRgroupMemberCount(i); ++j) {
                Molecule rg2;
                Molecule rg1 = m1.getRgroupMember(i, j);
                DifferenceObject result = this.differ.diffStopFirst(rg1, rg2 = m2.getRgroupMember(i, j));
                if (result == null) continue;
                return new SimpleDifference(m1, m2, "Different Rgroup members at index (" + i + "): " + ((Object)result).toString());
            }
            if (m1.getRlogic(i) != m2.getRlogic(i)) {
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rlogic at index (" + i + "): ", m1.getRlogic(i), m2.getRlogic(i)));
            }
            String m1RlogicRange = m1.getRlogicRange(i);
            String m2RlogicRange = m2.getRlogicRange(i);
            if (m1RlogicRange != null && m2RlogicRange != null) {
                if (m1.getRlogicRange(i).equals(m2.getRlogicRange(i))) continue;
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rlogic range at index (" + i + "): ", m1.getRlogicRange(i), m2.getRlogicRange(i)));
            }
            if (m1RlogicRange == null && m2RlogicRange != null) {
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rlogic range at index (" + i + "): ", "null", "not null"));
            }
            if (m1RlogicRange == null || m2RlogicRange != null) continue;
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("Rlogic range at index (" + i + "): ", "not null", "null"));
        }
        return null;
    }
}

