/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.util.Arrays;

class SgroupAtomBondDiffer {
    SgroupAtomBondDiffer() {
    }

    protected static String compareAtoms(MolAtom atom1, MolAtom atom2, String atomName) {
        if (atom1 == null || atom2 == null) {
            return DifferUtils.getAttributeDifferenceString(atomName + " (illegal argument)", atom1, atom2);
        }
        if (atom1.getParent() == null || atom2.getParent() == null) {
            return DifferUtils.getAttributeDifferenceString(atomName + " parent molecule graph (illegal argument)", atom1.getParent(), atom2.getParent());
        }
        int i1 = atom1.getParent().indexOf(atom1);
        int i2 = atom2.getParent().indexOf(atom2);
        if (i1 == -1 || i2 == -1) {
            return DifferUtils.getAttributeDifferenceString(atomName + " index in molecule graph (illegal argument)", i1, i2);
        }
        if (i1 != i2) {
            return DifferUtils.getAttributeDifferenceString(atomName + " index in molecule graph (illegal argument)", i1, i2);
        }
        return null;
    }

    private static String fillAtomIndexes(int[] atomIndexes, MolAtom[] atoms, String atomArrayName) {
        for (int i = 0; i < atoms.length; ++i) {
            MolAtom atom = atoms[i];
            if (atom == null) {
                return DifferUtils.getAttributeDifferenceString(atomArrayName + "[" + i + "] (illegal argument)", "null", "unchecked");
            }
            if (atom.getParent() == null) {
                return DifferUtils.getAttributeDifferenceString(atomArrayName + "[" + i + "]  parent molecule graph (illegal argument)", "null", "unchecked");
            }
            if (atom.getParent().indexOf(atom) == -1) {
                return DifferUtils.getAttributeDifferenceString(atomArrayName + "[" + i + "]  index in parent molecule graph (illegal argument)", "-1", "unchecked");
            }
            atomIndexes[i] = atom.getParent().indexOf(atom);
        }
        return null;
    }

    protected static String compareAtomArrays(MolAtom[] atoms1, MolAtom[] atoms2, String atomArrayName) {
        if (atoms1 == null && atoms2 == null) {
            return null;
        }
        if (atoms1 == null) {
            return DifferUtils.getAttributeDifferenceString(atomArrayName, "null", "not null");
        }
        if (atoms2 == null) {
            return DifferUtils.getAttributeDifferenceString(atomArrayName, "not null", "null");
        }
        if (atoms1.length != atoms2.length) {
            return DifferUtils.getAttributeDifferenceString(atomArrayName + " length", atoms1.length, atoms2.length);
        }
        int[] atomIndexes1 = new int[atoms1.length];
        String difference = SgroupAtomBondDiffer.fillAtomIndexes(atomIndexes1, atoms1, atomArrayName);
        if (difference != null) {
            return difference;
        }
        int[] atomIndexes2 = new int[atoms2.length];
        difference = SgroupAtomBondDiffer.fillAtomIndexes(atomIndexes2, atoms2, atomArrayName);
        if (difference != null) {
            return difference;
        }
        if (!ArrayTools.equalsArrays(atomIndexes1, atomIndexes2)) {
            return DifferUtils.getAttributeDifferenceString(atomArrayName, Arrays.toString(atomIndexes1), Arrays.toString(atomIndexes2));
        }
        return null;
    }

    private static String fillBondIndexes(int[] bondIndexes, MolBond[] bonds, String bondArrayName) {
        for (int i = 0; i < bonds.length; ++i) {
            MolBond bond = bonds[i];
            if (bond == null) {
                return DifferUtils.getAttributeDifferenceString(bondArrayName + "[" + i + "] (illegal argument)", "null", "unchecked");
            }
            if (bond.getParent() == null) {
                return DifferUtils.getAttributeDifferenceString(bondArrayName + "[" + i + "]  parent molecule graph (illegal argument)", "null", "unchecked");
            }
            if (bond.getParent().indexOf(bond) == -1) {
                return DifferUtils.getAttributeDifferenceString(bondArrayName + "[" + i + "]  index in parent molecule graph (illegal argument)", "-1", "unchecked");
            }
            bondIndexes[i] = bond.getParent().indexOf(bond);
        }
        return null;
    }

    protected static String compareBondArrays(MolBond[] bonds1, MolBond[] bonds2, String bondArrayName) {
        if (bonds1 == null && bonds2 == null) {
            return null;
        }
        if (bonds1 == null) {
            return DifferUtils.getAttributeDifferenceString(bondArrayName, "null", "not null");
        }
        if (bonds2 == null) {
            return DifferUtils.getAttributeDifferenceString(bondArrayName, "not null", "null");
        }
        if (bonds1.length != bonds2.length) {
            return DifferUtils.getAttributeDifferenceString(bondArrayName + " length", bonds1.length, bonds2.length);
        }
        int[] bondIndexes1 = new int[bonds1.length];
        String difference = SgroupAtomBondDiffer.fillBondIndexes(bondIndexes1, bonds1, bondArrayName);
        if (difference != null) {
            return difference;
        }
        int[] bondIndexes2 = new int[bonds2.length];
        difference = SgroupAtomBondDiffer.fillBondIndexes(bondIndexes2, bonds2, bondArrayName);
        if (difference != null) {
            return difference;
        }
        if (!ArrayTools.equalsArrays(bondIndexes1, bondIndexes2)) {
            return DifferUtils.getAttributeDifferenceString(bondArrayName, Arrays.toString(bondIndexes1), Arrays.toString(bondIndexes2));
        }
        return null;
    }
}

