/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.AtomDiffer;
import chemaxon.core.util.differ.BondDiffer;
import chemaxon.core.util.differ.DefaultAtomDiffer;
import chemaxon.core.util.differ.DefaultBondDiffer;
import chemaxon.core.util.differ.DefaultSgroupDiffer;
import chemaxon.core.util.differ.Differ;
import chemaxon.core.util.differ.DifferBuilder;
import chemaxon.core.util.differ.MDocumentDiffer;
import chemaxon.core.util.differ.MoleculeDiffer;
import chemaxon.core.util.differ.MoleculeGraphDiffer;
import chemaxon.core.util.differ.RgMoleculeDiffer;
import chemaxon.core.util.differ.RxnMoleculeDiffer;
import chemaxon.core.util.differ.SgroupDiffer;
import chemaxon.core.util.differ.StructureDiffer;

public class SimpleDifferBuilder
implements DifferBuilder {
    private AtomDiffer atom;
    private BondDiffer bond;
    private SgroupDiffer sg;
    private StructureDiffer.ComparisonDirection direction;
    private MoleculeGraphDiffer mg = new MoleculeGraphDiffer();
    private MoleculeDiffer mol = new MoleculeDiffer();
    private RgMoleculeDiffer rg = new RgMoleculeDiffer();
    private RxnMoleculeDiffer rxn = new RxnMoleculeDiffer();
    private MDocumentDiffer doc = new MDocumentDiffer();

    public static DefaultAtomDiffer createDefaultAtomDiffer() {
        return new DefaultAtomDiffer();
    }

    public static DefaultBondDiffer createDefaultBondDiffer() {
        return new DefaultBondDiffer();
    }

    public static Differ createDefaultDiffer() {
        return new StructureDiffer(new DefaultAtomDiffer(), new DefaultBondDiffer(), new DefaultSgroupDiffer(), StructureDiffer.ComparisonDirection.CHILD_CLASS, new MoleculeGraphDiffer(), new MoleculeDiffer(), new RgMoleculeDiffer(), new RxnMoleculeDiffer(), new MDocumentDiffer());
    }

    public static SimpleDifferBuilder getChemicalDifferBuilder() {
        SimpleDifferBuilder b = new SimpleDifferBuilder();
        b.setAtomDiffer(SimpleDifferBuilder.createChemicalAtomDiffer());
        b.setBondDiffer(SimpleDifferBuilder.createChemicalBondDiffer());
        SimpleDifferBuilder.setChemicalDifferIgnores(b);
        return b;
    }

    public static DefaultAtomDiffer createChemicalAtomDiffer() {
        DefaultAtomDiffer dad = new DefaultAtomDiffer();
        dad.ignoreSelection(true);
        return dad;
    }

    public static DefaultBondDiffer createChemicalBondDiffer() {
        DefaultBondDiffer dbd = new DefaultBondDiffer();
        return dbd;
    }

    public static Differ createChemicalDiffer() {
        return SimpleDifferBuilder.getChemicalDifferBuilder().createDiffer();
    }

    private static void setChemicalDifferIgnores(SimpleDifferBuilder b) {
        b.ignoreComment(true);
        b.ignoreName(true);
        b.ignoreInputFormat(true);
        b.ignoreDocument(true);
        b.ignoreProperties(true);
        b.setAtomDiffer(SimpleDifferBuilder.createChemicalAtomDiffer());
    }

    public static SimpleDifferBuilder getColoredGraphDifferBuilder() {
        SimpleDifferBuilder b = new SimpleDifferBuilder();
        SimpleDifferBuilder.setColoredGraphDifferIgnores(b);
        DefaultAtomDiffer ad = SimpleDifferBuilder.createColoredAtomDiffer();
        b.setAtomDiffer(ad);
        DefaultBondDiffer bd = SimpleDifferBuilder.createColoredBondDiffer();
        b.setBondDiffer(bd);
        return b;
    }

    public static Differ createColoredGraphDiffer() {
        return SimpleDifferBuilder.getColoredGraphDifferBuilder().createDiffer();
    }

    private static void setColoredGraphDifferIgnores(SimpleDifferBuilder b) {
        SimpleDifferBuilder.setChemicalDifferIgnores(b);
        b.ignoreBondDirection(true);
        b.ignoreDimension(true);
        b.ignoreDoubleBondStereo(true);
        b.ignoreParity(true);
        b.ignoreReactionArrow(true);
        b.ignoreMultiStepReaction(true);
        b.ignoreSuperatom(true);
        b.ignoreSgroups(true);
    }

    public static SimpleDifferBuilder getTopologyDifferBuilder() {
        SimpleDifferBuilder b = new SimpleDifferBuilder();
        SimpleDifferBuilder.setColoredGraphDifferIgnores(b);
        b.setAtomDiffer(SimpleDifferBuilder.createTopologyAtomDiffer());
        b.setBondDiffer(SimpleDifferBuilder.createTopologyBondDiffer());
        return b;
    }

    public static DefaultAtomDiffer createTopologyAtomDiffer() {
        DefaultAtomDiffer dad = SimpleDifferBuilder.createColoredAtomDiffer();
        dad.ignoreAtomicNumber(true);
        return dad;
    }

    public static DefaultBondDiffer createTopologyBondDiffer() {
        DefaultBondDiffer dbd = new DefaultBondDiffer();
        return dbd;
    }

    public static Differ createTopologyDiffer() {
        return SimpleDifferBuilder.getTopologyDifferBuilder().createDiffer();
    }

    public static DefaultAtomDiffer createColoredAtomDiffer() {
        DefaultAtomDiffer ad = new DefaultAtomDiffer();
        ad.ignoreCoordinates(true);
        ad.ignoreAliasString(true);
        ad.ignoreAtomMap(true);
        ad.ignoreAtomStereo(true);
        ad.ignoreBicycloStereoDescriptors(true);
        ad.ignoreCharge(true);
        ad.ignoreChirality(true);
        ad.ignoreElectronProperty(true);
        ad.ignoreExtraLabel(true);
        ad.ignoreExtraLabelColor(true);
        ad.ignoreExtraLabel(true);
        ad.ignoreHybridizationState(true);
        ad.ignoreImplicitHCount(true);
        ad.ignoreLabelCenter(true);
        ad.ignoreLeftName(true);
        ad.ignoreNonQueryImplicitHCount(true);
        ad.ignoreParity(true);
        ad.ignoreProperties(true);
        ad.ignoreQueryProperties(true);
        ad.ignoreQueryString(true);
        ad.ignoreRadical(true);
        ad.ignoreRadicalCount(true);
        ad.ignoreReactionStereo(true);
        ad.ignoreRightName(true);
        ad.ignoreStereoGroupNumber(true);
        ad.ignoreStereoGroupType(true);
        ad.ignoreValenceProperty(true);
        ad.ignoreSelection(true);
        return ad;
    }

    public static DefaultBondDiffer createColoredBondDiffer() {
        DefaultBondDiffer bd = new DefaultBondDiffer();
        bd.ignoreBoldProperty(true);
        bd.ignoreHashedProperty(true);
        bd.ignoreDynamicType(true);
        bd.ignoreQueryStringProperties(true);
        bd.ignoreReactingCenterProperties(true);
        bd.ignoreStereo1Properties(true);
        bd.ignoreStereo2Properties(true);
        bd.ignoreStereoQueryProperties(true);
        return bd;
    }

    @Override
    public Differ createDiffer() {
        if (this.atom == null) {
            this.atom = new DefaultAtomDiffer();
        }
        if (this.bond == null) {
            this.bond = new DefaultBondDiffer();
        }
        if (this.sg == null) {
            this.sg = new DefaultSgroupDiffer();
        }
        if (this.direction == null) {
            this.direction = StructureDiffer.ComparisonDirection.CHILD_CLASS;
        }
        return new StructureDiffer(this.atom, this.bond, this.sg, this.direction, this.mg, this.mol, this.rg, this.rxn, this.doc);
    }

    public AtomDiffer getAtomDiffer() {
        return this.atom;
    }

    public BondDiffer getBondDiffer() {
        return this.bond;
    }

    public void setAtomDiffer(AtomDiffer differ) {
        this.atom = differ;
    }

    public void setBondDiffer(BondDiffer differ) {
        this.bond = differ;
    }

    public void setSgroupDiffer(SgroupDiffer differ) {
        this.sg = differ;
    }

    public void setComparisonDirection(StructureDiffer.ComparisonDirection dir) {
        this.direction = dir;
    }

    public void ignoreName(boolean b) {
        this.mg.ignoreName(b);
        this.mol.ignoreName(b);
        this.rg.ignoreName(b);
        this.rxn.ignoreName(b);
    }

    public void ignoreDimension(boolean b) {
        this.mg.ignoreDimension(b);
        this.mol.ignoreDimension(b);
        this.rg.ignoreDimension(b);
        this.rxn.ignoreDimension(b);
    }

    public void ignoreBondCount(boolean b) {
        this.mg.ignoreBondCount(b);
        this.mol.ignoreBondCount(b);
        this.rg.ignoreBondCount(b);
        this.rxn.ignoreBondCount(b);
    }

    public void ignoreAtomCount(boolean b) {
        this.mg.ignoreAtomCount(b);
        this.mol.ignoreAtomCount(b);
        this.rg.ignoreAtomCount(b);
        this.rxn.ignoreAtomCount(b);
    }

    public void ignoreAtoms(boolean b) {
        this.mg.ignoreAtoms(b);
        this.mol.ignoreAtoms(b);
        this.rg.ignoreAtoms(b);
        this.rxn.ignoreAtoms(b);
    }

    public void ignoreBonds(boolean b) {
        this.mg.ignoreBonds(b);
        this.mol.ignoreBonds(b);
        this.rg.ignoreBonds(b);
        this.rxn.ignoreBonds(b);
    }

    public void ignoreBondDirection(boolean b) {
        this.mg.ignoreBondDirection(b);
        this.mol.ignoreBondDirection(b);
        this.rg.ignoreBondDirection(b);
        this.rxn.ignoreBondDirection(b);
    }

    public void ignoreProperties(boolean b) {
        this.mg.ignoreProperties(b);
        this.mol.ignoreProperties(b);
        this.rg.ignoreProperties(b);
        this.rxn.ignoreProperties(b);
    }

    public void ignoreDoubleBondStereo(boolean b) {
        this.mg.ignoreDoubleBondStereo(b);
        this.mol.ignoreDoubleBondStereo(b);
        this.rg.ignoreDoubleBondStereo(b);
        this.rxn.ignoreDoubleBondStereo(b);
    }

    public void ignoreParity(boolean b) {
        this.mg.ignoreParity(b);
        this.mol.ignoreParity(b);
        this.rg.ignoreParity(b);
        this.rxn.ignoreParity(b);
    }

    public void ignoreLigandOrder(boolean b) {
        this.mg.ignoreLigandOrder(b);
        this.mol.ignoreLigandOrder(b);
        this.rg.ignoreLigandOrder(b);
        this.rxn.ignoreLigandOrder(b);
    }

    public void ignoreLinkNode(boolean b) {
        this.mg.ignoreLinkNode(b);
        this.mol.ignoreLinkNode(b);
        this.rg.ignoreLinkNode(b);
        this.rxn.ignoreAtoms(b);
    }

    public void ignoreInputFormat(boolean ignore) {
        this.mol.ignoreInputFormat(ignore);
        this.rg.ignoreInputFormat(ignore);
        this.rxn.ignoreInputFormat(ignore);
    }

    public void ignoreComment(boolean ignore) {
        this.mol.ignoreComment(ignore);
        this.rg.ignoreComment(ignore);
        this.rxn.ignoreComment(ignore);
    }

    public void ignoreSgroupCount(boolean ignore) {
        this.mol.ignoreSgroupCount(ignore);
        this.rg.ignoreSgroupCount(ignore);
        this.rxn.ignoreSgroupCount(ignore);
    }

    public void ignoreSgroups(boolean ignore) {
        this.mol.ignoreSgroups(ignore);
        this.rg.ignoreSgroups(ignore);
        this.rxn.ignoreSgroups(ignore);
    }

    public void ignoredRgroup(boolean b) {
        this.rg.ignoreRgroups(b);
    }

    public void ignoreMultiStepReaction(boolean b) {
        this.rxn.ignoreMultiStepReaction(b);
    }

    public void ignoreReactionArrow(boolean b) {
        this.rxn.ignoreReactionArrow(b);
    }

    public void ignoreAtomSetColorMode(boolean ignore) {
        this.doc.ignoreAtomSetColorMode(ignore);
    }

    public void ignoreAtomSetColors(boolean ignore) {
        this.doc.ignoreAtomSetColors(ignore);
    }

    public void ignoreAtomSetFonts(boolean ignore) {
        this.doc.ignoreAtomSetFonts(ignore);
    }

    public void ignoreAtomSelection(boolean ignore) {
    }

    public void ignoreBondSetColorMode(boolean ignore) {
        this.doc.ignoreBondSetColorMode(ignore);
    }

    public void ignoreBondSetColors(boolean ignore) {
        this.doc.ignoreBondSetColors(ignore);
    }

    public void ignoreBondSetThickness(boolean ignore) {
        this.doc.ignoreBondSetThickness(ignore);
    }

    public void ignoreDocument(boolean b) {
        this.mg.ignoreDocument(b);
        this.mol.ignoreDocument(b);
        this.rg.ignoreDocument(b);
        this.rxn.ignoreDocument(b);
    }

    public void ignoreSgroupGraph(boolean ignore) {
        this.mol.ignoreSgroupGraph(ignore);
        this.rg.ignoreSgroupGraph(ignore);
        this.rxn.ignoreSgroupGraph(ignore);
    }

    public void ignoreSuperatom(boolean ignore) {
        this.mol.ignoreSuperatom(ignore);
        this.rg.ignoreSuperatom(ignore);
        this.rxn.ignoreSuperatom(ignore);
    }

    public void ignoreSgroups(int sgroupType, boolean ignore) {
        this.mol.ignoreSgroups(sgroupType, ignore);
        this.rg.ignoreSgroups(sgroupType, ignore);
        this.rxn.ignoreSgroups(sgroupType, ignore);
    }
}

