/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.AtomDiffer;
import chemaxon.core.util.differ.BondDiffer;
import chemaxon.core.util.differ.Differ;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.DifferenceObject;
import chemaxon.core.util.differ.MDocumentDiffer;
import chemaxon.core.util.differ.MoleculeDiffer;
import chemaxon.core.util.differ.MoleculeGraphDiffer;
import chemaxon.core.util.differ.RgMoleculeDiffer;
import chemaxon.core.util.differ.RxnMoleculeDiffer;
import chemaxon.core.util.differ.SgroupDiffer;
import chemaxon.core.util.differ.SimpleDifference;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.Collection;

public class StructureDiffer
implements Differ {
    private ComparisonDirection compareLevel;
    private MoleculeGraphDiffer[] molDiffers;

    protected StructureDiffer(AtomDiffer atom, BondDiffer bond, SgroupDiffer sg, ComparisonDirection level) {
        this.compareLevel = level;
        this.molDiffers = new MoleculeGraphDiffer[CompareLevel.values().length];
        this.molDiffers[CompareLevel.MOLGRAPH.ordinal()] = new MoleculeGraphDiffer();
        this.molDiffers[CompareLevel.MOLECULE.ordinal()] = new MoleculeDiffer();
        this.molDiffers[CompareLevel.RXN.ordinal()] = new RxnMoleculeDiffer();
        this.molDiffers[CompareLevel.RG.ordinal()] = new RgMoleculeDiffer();
        for (MoleculeGraphDiffer diff : this.molDiffers) {
            diff.setBondDiffer(bond);
            diff.setAtomDiffer(atom);
            diff.setSgroupDiffer(sg);
            diff.setMDocumentDiffer(new MDocumentDiffer());
        }
        ((RgMoleculeDiffer)this.molDiffers[CompareLevel.RG.ordinal()]).setStructureDiffer(this);
        ((RxnMoleculeDiffer)this.molDiffers[CompareLevel.RXN.ordinal()]).setStructureDiffer(this);
    }

    protected StructureDiffer(AtomDiffer atom, BondDiffer bond, SgroupDiffer sg, ComparisonDirection level, MoleculeGraphDiffer mg, MoleculeDiffer mol, RgMoleculeDiffer rg, RxnMoleculeDiffer rxn, MDocumentDiffer doc) {
        this.compareLevel = level;
        this.molDiffers = new MoleculeGraphDiffer[CompareLevel.values().length];
        this.molDiffers[CompareLevel.MOLGRAPH.ordinal()] = new MoleculeGraphDiffer(mg);
        this.molDiffers[CompareLevel.MOLECULE.ordinal()] = new MoleculeDiffer(mol);
        this.molDiffers[CompareLevel.RXN.ordinal()] = new RxnMoleculeDiffer(rxn);
        this.molDiffers[CompareLevel.RG.ordinal()] = new RgMoleculeDiffer(rg);
        for (MoleculeGraphDiffer diff : this.molDiffers) {
            diff.setBondDiffer(bond);
            diff.setAtomDiffer(atom);
            diff.setSgroupDiffer(sg);
            diff.setMDocumentDiffer(doc);
        }
        ((RgMoleculeDiffer)this.molDiffers[CompareLevel.RG.ordinal()]).setStructureDiffer(this);
        ((RxnMoleculeDiffer)this.molDiffers[CompareLevel.RXN.ordinal()]).setStructureDiffer(this);
    }

    @Override
    public Collection<DifferenceObject> diff(MoleculeGraph arg0, MoleculeGraph arg1) {
        DifferenceObject d = this.diffStopFirst(arg0, arg1);
        if (d == null) {
            return null;
        }
        ArrayList<DifferenceObject> result = new ArrayList<DifferenceObject>();
        result.add(d);
        return result;
    }

    @Override
    public DifferenceObject diffStopFirst(MoleculeGraph arg0, MoleculeGraph arg1) {
        if (arg0 == arg1) {
            return null;
        }
        if (arg0 == null) {
            return new SimpleDifference(arg0, arg1, DifferUtils.getAttributeDifferenceString("moleculegraph", "null", "not null"));
        }
        if (arg1 == null) {
            return new SimpleDifference(arg0, arg1, DifferUtils.getAttributeDifferenceString("moleculegraph", "not null", "null"));
        }
        CompareLevel level = null;
        try {
            level = this.compareLevel.getLevel(arg0, arg1);
        }
        catch (UnsupportedOperationException uoe) {
            return new SimpleDifference(arg0, arg1, DifferUtils.getAttributeDifferenceString("Class ", arg0.getClass(), arg1.getClass()));
        }
        MoleculeGraphDiffer diff = (MoleculeGraphDiffer)level.getDiffer(this.molDiffers);
        return diff.diffStopFirst(level.getAdapter(arg0), level.getAdapter(arg1));
    }

    @Override
    public boolean equals(MoleculeGraph arg0, MoleculeGraph arg1) {
        return this.diffStopFirst(arg0, arg1) == null;
    }

    private static class MoleculeAdapter
    extends Molecule {
        private MoleculeGraph m;

        public MoleculeAdapter(MoleculeGraph m) {
            this.m = m;
        }

        @Override
        public int getAtomCount() {
            return this.m.getAtomCount();
        }

        @Override
        public MolAtom getAtom(int n) {
            return this.m.getAtom(n);
        }

        @Override
        public int getBondCount() {
            return this.m.getBondCount();
        }

        @Override
        public MolBond getBond(int n) {
            return this.m.getBond(n);
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public int getDim() {
            return this.m.getDim();
        }

        @Override
        public int indexOf(MolAtom ma) {
            return this.m.indexOf(ma);
        }

        @Override
        public int getStereo2(MolBond b, MolAtom a1, MolAtom a4, boolean grcheck) {
            return this.m.getStereo2(b, a1, a4, grcheck);
        }

        @Override
        public int getParity(int i) {
            return this.m.getParity(i);
        }

        @Override
        public MPropertyContainer properties() {
            return this.m.properties();
        }

        @Override
        public String getComment() {
            return "";
        }

        @Override
        public int indexOf(MolBond bond) {
            return this.m.indexOf(bond);
        }

        @Override
        public MDocument getDocument() {
            return this.m.getDocument();
        }
    }

    private static class RxnMoleculeAdapter
    extends RxnMolecule {
        private Molecule m;

        public RxnMoleculeAdapter(Molecule mol) {
            this.m = mol;
            this.addSgroupsOf(mol);
            this.setInputFormat(this.m.getInputFormat());
        }

        @Override
        public Molecule[] getReactants() {
            return new Molecule[]{this.m};
        }

        @Override
        public Molecule getComponent(int i, int j) {
            if (i == 0 && j == 0) {
                return this.m;
            }
            return null;
        }

        @Override
        public int getComponentCount(int i) {
            if (i == 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public int getAtomCount() {
            return this.m.getAtomCount();
        }

        @Override
        public MolAtom getAtom(int n) {
            return this.m.getAtom(n);
        }

        @Override
        public int getBondCount() {
            return this.m.getBondCount();
        }

        @Override
        public MolBond getBond(int n) {
            return this.m.getBond(n);
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public int getDim() {
            return this.m.getDim();
        }

        @Override
        public int indexOf(MolAtom ma) {
            return this.m.indexOf(ma);
        }

        @Override
        public int getStereo2(MolBond b, MolAtom a1, MolAtom a4, boolean grcheck) {
            return this.m.getStereo2(b, a1, a4, grcheck);
        }

        @Override
        public int getParity(int i) {
            return this.m.getParity(i);
        }

        @Override
        public MPropertyContainer properties() {
            return this.m.properties();
        }

        @Override
        public String getComment() {
            return this.m.getComment();
        }

        @Override
        public int indexOf(MolBond bond) {
            return this.m.indexOf(bond);
        }

        @Override
        public MDocument getDocument() {
            return this.m.getDocument();
        }
    }

    private static class RgMoleculeAdapter
    extends RgMolecule {
        private Molecule m;

        public RgMoleculeAdapter(Molecule mol) {
            this.m = mol;
            this.addSgroupsOf(mol);
            this.setInputFormat(this.m.getInputFormat());
        }

        @Override
        public Molecule getRoot() {
            return this.m;
        }

        @Override
        public int getAtomCount() {
            return this.m.getAtomCount();
        }

        @Override
        public MolAtom getAtom(int n) {
            return this.m.getAtom(n);
        }

        @Override
        public int getBondCount() {
            return this.m.getBondCount();
        }

        @Override
        public MolBond getBond(int n) {
            return this.m.getBond(n);
        }

        @Override
        public String getName() {
            return this.m.getName();
        }

        @Override
        public int getDim() {
            return this.m.getDim();
        }

        @Override
        public int indexOf(MolAtom ma) {
            return this.m.indexOf(ma);
        }

        @Override
        public int getStereo2(MolBond b, MolAtom a1, MolAtom a4, boolean grcheck) {
            return this.m.getStereo2(b, a1, a4, grcheck);
        }

        @Override
        public int getParity(int i) {
            return this.m.getParity(i);
        }

        @Override
        public MPropertyContainer properties() {
            return this.m.properties();
        }

        @Override
        public String getComment() {
            return this.m.getComment();
        }

        @Override
        public int indexOf(MolBond bond) {
            return this.m.indexOf(bond);
        }

        @Override
        public MDocument getDocument() {
            return this.m.getDocument();
        }
    }

    public static enum ComparisonDirection {
        PARENT_CLASS{

            @Override
            protected CompareLevel getLevel(MoleculeGraph m1, MoleculeGraph m2) {
                if (m1 instanceof RgMolecule && m2 instanceof RgMolecule) {
                    return CompareLevel.RG;
                }
                if (m1 instanceof RxnMolecule && m2 instanceof RxnMolecule) {
                    return CompareLevel.RXN;
                }
                if (m1 instanceof RxnMolecule && m2 instanceof RgMolecule || m1 instanceof RgMolecule && m2 instanceof RxnMolecule) {
                    return CompareLevel.RXN;
                }
                if (m1 instanceof Molecule && m2 instanceof Molecule) {
                    return CompareLevel.MOLECULE;
                }
                return CompareLevel.MOLGRAPH;
            }
        }
        ,
        CHILD_CLASS{

            @Override
            protected CompareLevel getLevel(MoleculeGraph m1, MoleculeGraph m2) {
                if (m1 instanceof RgMolecule || m2 instanceof RgMolecule) {
                    return CompareLevel.RG;
                }
                if (m1 instanceof RxnMolecule || m2 instanceof RxnMolecule) {
                    return CompareLevel.RXN;
                }
                if (m1 instanceof Molecule || m2 instanceof Molecule) {
                    return CompareLevel.MOLECULE;
                }
                return CompareLevel.MOLGRAPH;
            }
        }
        ,
        SAME_CLASS{

            @Override
            protected CompareLevel getLevel(MoleculeGraph m1, MoleculeGraph m2) {
                Class<?> c1 = m1.getClass();
                Class<?> c2 = m2.getClass();
                if (c1.equals(RgMolecule.class) && c2.equals(RgMolecule.class)) {
                    return CompareLevel.RG;
                }
                if (c1.equals(RxnMolecule.class) && c2.equals(RxnMolecule.class)) {
                    return CompareLevel.RXN;
                }
                if (c1.equals(Molecule.class) && c2.equals(Molecule.class)) {
                    return CompareLevel.MOLECULE;
                }
                if (c1.equals(MoleculeGraph.class) && c2.equals(MoleculeGraph.class)) {
                    return CompareLevel.MOLGRAPH;
                }
                throw new UnsupportedOperationException("Can`t diff " + m1.getClass() + " with " + m2.getClass() + " on this level of comparison.");
            }
        };


        protected abstract CompareLevel getLevel(MoleculeGraph var1, MoleculeGraph var2);
    }

    private static enum CompareLevel {
        MOLGRAPH{

            @Override
            public MoleculeGraph getAdapter(MoleculeGraph mg) {
                return mg;
            }

            @Override
            public Differ getDiffer(Differ[] differs) {
                return differs[this.ordinal()];
            }
        }
        ,
        MOLECULE{

            @Override
            public MoleculeGraph getAdapter(MoleculeGraph mg) {
                if (!(mg instanceof Molecule)) {
                    return new MoleculeAdapter(mg);
                }
                return mg;
            }

            @Override
            public Differ getDiffer(Differ[] differs) {
                return differs[this.ordinal()];
            }
        }
        ,
        RXN{

            @Override
            public MoleculeGraph getAdapter(MoleculeGraph mg) {
                if (!(mg instanceof RxnMolecule)) {
                    if (mg instanceof Molecule) {
                        if (mg instanceof RgMolecule) {
                            Molecule m = ((RgMolecule)mg).getRoot();
                            if (m instanceof RxnMolecule) {
                                return m;
                            }
                            return new RxnMoleculeAdapter(m);
                        }
                        return new RxnMoleculeAdapter((Molecule)mg);
                    }
                    return new RxnMoleculeAdapter(new MoleculeAdapter(mg));
                }
                return mg;
            }

            @Override
            public Differ getDiffer(Differ[] differs) {
                return differs[this.ordinal()];
            }
        }
        ,
        RG{

            @Override
            public MoleculeGraph getAdapter(MoleculeGraph mg) {
                if (!(mg instanceof RgMolecule)) {
                    if (mg instanceof Molecule) {
                        return new RgMoleculeAdapter((Molecule)mg);
                    }
                    return new RgMoleculeAdapter(new MoleculeAdapter(mg));
                }
                return mg;
            }

            @Override
            public Differ getDiffer(Differ[] differs) {
                return differs[this.ordinal()];
            }
        };


        public abstract MoleculeGraph getAdapter(MoleculeGraph var1);

        public abstract Differ getDiffer(Differ[] var1);
    }
}

