/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.BCUTParameters;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.Molecule;
import java.text.ParseException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class BCUT
extends MolecularDescriptor
implements Licensable {
    protected float[] lowestEigenvalues = null;
    protected float[] highestEigenvalues = null;
    private static final String[] metrics = new String[]{"Euclidean"};
    private static final float[] defaultThresholds = new float[]{10.0f};
    private String licenseEnvironment = "";

    public BCUT() {
    }

    public BCUT(BCUTParameters params) {
        super(params);
        this.lowestEigenvalues = new float[params.getLowestEigenvaluesCount()];
        this.highestEigenvalues = new float[params.getHighestEigenvaluesCount()];
        this.clear();
    }

    public BCUT(String params) {
        this.setParameters(params);
        BCUTParameters par = (BCUTParameters)this.params;
        this.lowestEigenvalues = new float[par.getLowestEigenvaluesCount()];
        this.highestEigenvalues = new float[par.getHighestEigenvaluesCount()];
        this.clear();
    }

    public BCUT(BCUT sd) {
        super(sd);
        BCUTParameters par = (BCUTParameters)this.params;
        this.lowestEigenvalues = new float[par.getLowestEigenvaluesCount()];
        this.highestEigenvalues = new float[par.getHighestEigenvaluesCount()];
        System.arraycopy(sd.lowestEigenvalues, 0, this.lowestEigenvalues, 0, this.lowestEigenvalues.length);
        System.arraycopy(sd.highestEigenvalues, 0, this.highestEigenvalues, 0, this.highestEigenvalues.length);
    }

    @Override
    public BCUT clone() {
        return new BCUT(this);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Molecular Descriptors", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Molecular Descriptors", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    void startGeneration() {
        this.checkLicense();
    }

    @Override
    public byte[] toData() {
        int j;
        int v;
        int i;
        byte[] d = this.params.getData();
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            v = Float.floatToIntBits(this.lowestEigenvalues[i]);
            for (j = 3; j >= 0; --j) {
                d[i * 4 + j + 1] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            v = Float.floatToIntBits(this.highestEigenvalues[i]);
            for (j = 3; j >= 0; --j) {
                d[(this.lowestEigenvalues.length + i) * 4 + j + 1] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return d;
    }

    @Override
    public void fromData(byte[] dbRepr) {
        int j;
        int v;
        int i;
        this.checkLicense();
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            v = 0;
            for (j = 0; j < 4; ++j) {
                v <<= 8;
                v += (dbRepr[i * 4 + j + 1] + 256) % 256;
            }
            this.lowestEigenvalues[i] = Float.intBitsToFloat(v);
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            v = 0;
            for (j = 0; j < 4; ++j) {
                v <<= 8;
                v += (dbRepr[(this.lowestEigenvalues.length + i) * 4 + j + 1] + 256) % 256;
            }
            this.highestEigenvalues[i] = Float.intBitsToFloat(v);
        }
    }

    @Override
    public String getName() {
        return "BCUT descriptor";
    }

    @Override
    public String getShortName() {
        return "BCUT";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            this.params = new BCUTParameters(parameters);
        } else {
            this.params.fromString(parameters);
        }
        BCUTParameters par = (BCUTParameters)this.params;
        this.lowestEigenvalues = new float[par.getLowestEigenvaluesCount()];
        this.highestEigenvalues = new float[par.getHighestEigenvaluesCount()];
    }

    @Override
    public void setParameters(MDParameters parameters) throws MDParametersException {
        super.setParameters(parameters);
        BCUTParameters par = (BCUTParameters)this.params;
        this.lowestEigenvalues = new float[par.getLowestEigenvaluesCount()];
        this.highestEigenvalues = new float[par.getHighestEigenvaluesCount()];
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.BCUTParameters";
    }

    public void clear() {
        Arrays.fill(this.lowestEigenvalues, 0.0f);
        Arrays.fill(this.highestEigenvalues, 0.0f);
    }

    void setLowestEigenvalue(int index, float value) {
        this.lowestEigenvalues[index] = value;
    }

    void setHighestEigenvalue(int index, float value) {
        this.highestEigenvalues[index] = value;
    }

    public float getLowestEigenvalue(int index) {
        return this.lowestEigenvalues[index];
    }

    public float getHighestEigenvalue(int index) {
        return this.highestEigenvalues[index];
    }

    @Override
    public final void fromString(String bcut) throws ParseException {
        this.checkLicense();
        try {
            int i;
            StringTokenizer st = new StringTokenizer(bcut, "\t ,;");
            for (i = 0; i < this.lowestEigenvalues.length; ++i) {
                this.lowestEigenvalues[i] = Float.parseFloat(st.nextToken());
            }
            for (i = 0; i < this.highestEigenvalues.length; ++i) {
                this.highestEigenvalues[i] = Float.parseFloat(st.nextToken());
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(bcut + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(bcut + " contains invalid numbers", 0);
        }
    }

    @Override
    public final String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            sb.append(this.lowestEigenvalues[i]);
            if (i + 1 >= this.lowestEigenvalues.length) continue;
            sb.append(", ");
        }
        if (this.highestEigenvalues.length > 0) {
            sb.append("; ");
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            sb.append(this.highestEigenvalues[i]);
            if (i + 1 >= this.highestEigenvalues.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public final String toDecimalString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(this.lowestEigenvalues[i]);
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            sb.append('\t');
            sb.append(this.highestEigenvalues[i]);
        }
        return sb.toString();
    }

    @Override
    public float[] toFloatArray() {
        float[] toReturn = new float[this.lowestEigenvalues.length + this.highestEigenvalues.length];
        System.arraycopy(this.lowestEigenvalues, 0, toReturn, 0, this.lowestEigenvalues.length);
        System.arraycopy(this.highestEigenvalues, 0, toReturn, this.lowestEigenvalues.length, this.highestEigenvalues.length);
        return toReturn;
    }

    @Override
    public void fromFloatArray(float[] descr) {
        this.checkLicense();
        System.arraycopy(descr, 0, this.lowestEigenvalues, 0, this.lowestEigenvalues.length);
        System.arraycopy(descr, this.lowestEigenvalues.length, this.highestEigenvalues, 0, this.highestEigenvalues.length);
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        try {
            String[] res = ((BCUTParameters)this.params).generate(m, this);
            return res;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Perhaps parameters are not set properly.");
        }
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    public final float getEuclidean(BCUT descr) {
        double df;
        int i;
        boolean norm = this.params.isNormalized();
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            df = this.lowestEigenvalues[i] - descr.lowestEigenvalues[i];
            d += df * df;
            if (!norm) continue;
            a += (double)(this.lowestEigenvalues[i] * this.lowestEigenvalues[i]);
            b += (double)(descr.lowestEigenvalues[i] * descr.lowestEigenvalues[i]);
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            df = this.highestEigenvalues[i] - descr.highestEigenvalues[i];
            d += df * df;
            if (!norm) continue;
            a += (double)(this.highestEigenvalues[i] * this.highestEigenvalues[i]);
            b += (double)(descr.highestEigenvalues[i] * descr.highestEigenvalues[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    public final float getWeightedEuclidean(BCUT descr) {
        double df;
        int i;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        boolean norm = this.params.isNormalized();
        float[] weights = this.params.getWeights();
        for (i = 0; i < this.lowestEigenvalues.length; ++i) {
            df = this.lowestEigenvalues[i] - descr.lowestEigenvalues[i];
            d += (double)weights[i] * (df * df);
            if (!norm) continue;
            a += (double)(this.lowestEigenvalues[i] * this.lowestEigenvalues[i]);
            b += (double)(descr.lowestEigenvalues[i] * descr.lowestEigenvalues[i]);
        }
        for (i = 0; i < this.highestEigenvalues.length; ++i) {
            df = this.highestEigenvalues[i] - descr.highestEigenvalues[i];
            d += (double)weights[i] * (df * df);
            if (!norm) continue;
            a += (double)(this.highestEigenvalues[i] * this.highestEigenvalues[i]);
            b += (double)(descr.highestEigenvalues[i] * descr.highestEigenvalues[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other) {
        return this.getDissimilarity(other, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other, int parametrizedMetricIndex) {
        this.params.setCurrentParametrizedMetric(parametrizedMetricIndex);
        int mi = this.params.getInternalMetricIndex();
        BCUTParameters p = (BCUTParameters)this.params;
        boolean as = p.isAsymmetric();
        float diss = 0.0f;
        switch (mi) {
            case 0: {
                boolean w = p.isWeighted();
                if (!as && !w) {
                    diss = this.getEuclidean((BCUT)other);
                } else if (!as && w) {
                    diss = this.getWeightedEuclidean((BCUT)other);
                }
                if (!p.isNormalized()) {
                    return diss;
                }
                return diss > 1.0f ? 1.0f : diss;
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + parametrizedMetricIndex + ") passed to BCUT.getDissimilarity()");
    }
}

