/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.calculations.AtomPolarizability;
import chemaxon.calculations.Charge;
import chemaxon.calculations.Interaction;
import chemaxon.core.util.BondTable;
import chemaxon.descriptors.BCUT;
import chemaxon.descriptors.BCUTParameters;
import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.SymEigenValues;

public class BCUTGenerator
extends MDGenerator {
    private SymEigenValues ev = new SymEigenValues();
    private Charge chargeCalculator = new Charge();
    private Interaction hBondCalculator = new Interaction();

    @Override
    public String[] generate(Molecule m, MolecularDescriptor d) throws MDGeneratorException {
        int i;
        int i2;
        BCUTParameters params = (BCUTParameters)d.getParameters();
        BCUT b = (BCUT)d;
        b.startGeneration();
        Molecule stdMol = params.standardize(m);
        int atomCount = stdMol.getAtomCount();
        if (atomCount == 0) {
            this.generateEmpty(d);
            return null;
        }
        double[][] burden = new double[atomCount][atomCount];
        BondTable conn = stdMol.getBondTable();
        for (i2 = 0; i2 < atomCount; ++i2) {
            for (int j = 0; j < i2; ++j) {
                if (conn.getBondIndex(i2, j) == -1) {
                    burden[i2][j] = 0.001;
                } else {
                    MolBond bond = stdMol.getBond(conn.getBondIndex(i2, j));
                    double d2 = burden[i2][j] = (bond.getFlags() & 4) != 0 ? 0.15 : (double)bond.getType() * 0.1;
                    if (bond.getAtom1().getBondCount() == 1 || bond.getAtom2().getBondCount() == 1) {
                        double[] dArray = burden[i2];
                        int n = j;
                        dArray[n] = dArray[n] + 0.01;
                    }
                }
                burden[j][i2] = burden[i2][j];
            }
        }
        if (params.getType().equals("Burden")) {
            for (i2 = 0; i2 < atomCount; ++i2) {
                burden[i2][i2] = stdMol.getAtom(i2).getAtno();
            }
        } else if (params.getType().equals("Charge")) {
            this.chargeCalculator.setMolecule(stdMol);
            this.chargeCalculator.calcCharges();
            for (i2 = 0; i2 < atomCount; ++i2) {
                burden[i2][i2] = this.chargeCalculator.getAccumulatedCharge(i2);
            }
        } else if (params.getType().equals("Polarizability")) {
            AtomPolarizability atomPolarizability = new AtomPolarizability(stdMol);
            for (int i3 = 0; i3 < atomCount; ++i3) {
                burden[i3][i3] = atomPolarizability.calculate(i3);
            }
        } else if (params.getType().equals("HBond")) {
            this.hBondCalculator.setMolecule(stdMol);
            this.hBondCalculator.calcAcceptorDonorCount();
            for (i2 = 0; i2 < atomCount; ++i2) {
                burden[i2][i2] = this.hBondCalculator.getDonorSiteCountListOfMacroState()[i2] + this.hBondCalculator.getAcceptorSiteCountListOfMacroState()[i2];
            }
        } else {
            throw new MDGeneratorException("Unknown BCUT descriptor type: " + params.getType());
        }
        this.ev.setSymMatr(burden);
        for (i = 0; i < params.getLowestEigenvaluesCount(); ++i) {
            b.setLowestEigenvalue(i, (float)this.ev.getRealEigenvalue(i));
        }
        for (i = 0; i < params.getHighestEigenvaluesCount(); ++i) {
            b.setHighestEigenvalue(i, (float)this.ev.getRealEigenvalue(this.ev.size() - 1 - i));
        }
        return null;
    }

    private void generateEmpty(MolecularDescriptor d) {
        int i;
        BCUTParameters params = (BCUTParameters)d.getParameters();
        BCUT b = (BCUT)d;
        for (i = 0; i < params.getLowestEigenvaluesCount(); ++i) {
            b.setLowestEigenvalue(i, 0.0f);
        }
        for (i = 0; i < params.getHighestEigenvaluesCount(); ++i) {
            b.setHighestEigenvalue(i, 0.0f);
        }
    }
}

