/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFGenerator;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.struc.Molecule;
import java.io.File;
import org.dom4j.Element;

public class CFParameters
extends MDParameters {
    public static final int DEFAULT_LENGTH = 1024;
    public static final int DEFAULT_BOND_COUNT = 7;
    public static final int DEFAULT_BITS_SET = 2;
    private static final String DEFAULT_XML_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<ChemicalFingerprintConfiguration Version =\"0.3\" schemaLocation=\"cfp.xsd\">\n<Parameters Length=\"1024\" BondCount=\"7\" BitCount=\"2\"/>\n<ScreeningConfiguration>\n   <ParametrizedMetrics>\n        <ParametrizedMetric Name=\"Tanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"Tanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\"\n             Metric=\"Euclidean\" Threshold=\"10\"/>\n        <ParametrizedMetric Name=\"Tversky\" ActiveFamily=\"Generic\"\n             Metric=\"Tversky\" Threshold=\"0.5\" TverskyAlpha=\"1\" TverskyBeta=\"1\"/>\n   </ParametrizedMetrics>\n</ScreeningConfiguration>\n</ChemicalFingerprintConfiguration>\n";
    private int bondCount = 7;
    private int bitCount = 2;
    private Element parameters = null;

    public CFParameters() {
        this.init();
        this.setLength(1024);
    }

    public CFParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.initGenerator();
    }

    public CFParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.initGenerator();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    @Override
    public void setLength(int length) throws MDParametersException {
        if (length % 32 != 0) {
            throw new MDParametersException("Fingerprint length should be multiple of 32.");
        }
        super.setLength(length);
        this.initParameters();
        this.initGenerator();
        if (this.parameters != null) {
            this.parameters.addAttribute("Length", Integer.toString(length));
        }
    }

    public void setBondCount(int bondCount) {
        this.bondCount = bondCount;
        if (this.parameters != null) {
            this.parameters.addAttribute("BondCount", Integer.toString(bondCount));
        }
    }

    public void setBitCount(int bitCount) {
        this.bitCount = bitCount;
        if (this.parameters != null) {
            this.parameters.addAttribute("BitCount", Integer.toString(bitCount));
        }
    }

    protected void initGenerator() throws MDParametersException {
        this.generator = new CFGenerator();
    }

    protected void init() {
        this.md = new ChemicalFingerprint();
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.internalSize = this.length / 32;
        this.data = new byte[this.internalSize * 4 + 1];
    }

    protected String[] generate(Molecule m, MolecularDescriptor cd) throws MDGeneratorException {
        return this.generator.generate(m, cd);
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.getLength();
            }
            case 2: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("ChemicalFingerprintConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("//ChemicalFingerprintConfiguration/Parameters");
            if (this.parameters == null) {
                throw new MDParametersException("Parameter configuration error. ");
            }
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        if (all) {
            String p = this.parameters.attributeValue("Length");
            this.setLength(p != null ? Integer.parseInt(p) : 1024);
            p = this.parameters.attributeValue("BondCount");
            if (p != null) {
                this.bondCount = Integer.parseInt(p);
            }
            if ((p = this.parameters.attributeValue("BitCount")) != null) {
                this.bitCount = Integer.parseInt(p);
            }
        }
        this.readMetricParameters();
    }
}

