/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.Metrics;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import java.text.ParseException;
import java.util.StringTokenizer;

public class ChemicalFingerprint
extends MolecularDescriptor {
    protected int[] fp = null;
    protected int brightness = 0;
    private static final String[] metrics = new String[]{"Tanimoto", "Euclidean", "Tversky"};
    private static final float[] defaultThresholds = new float[]{0.2f, 10.0f, 0.5f};
    private int defaultMetricIndex = 0;

    public ChemicalFingerprint() {
    }

    public ChemicalFingerprint(CFParameters params) {
        super(params);
        this.fp = new int[params.getInternalSize()];
        this.clear();
    }

    public ChemicalFingerprint(String params) {
        this.setParameters(params);
        this.clear();
    }

    public ChemicalFingerprint(ChemicalFingerprint cfp) {
        super(cfp.params);
        if (cfp.fp != null) {
            this.fp = new int[cfp.fp.length];
            for (int i = 0; i < this.fp.length; ++i) {
                this.fp[i] = cfp.fp[i];
            }
            this.brightness = cfp.brightness;
        } else {
            this.fp = null;
        }
    }

    @Override
    public ChemicalFingerprint clone() {
        return new ChemicalFingerprint(this);
    }

    @Override
    public String getName() {
        return "Chemical fingerprint";
    }

    @Override
    public String getShortName() {
        return "CF";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.CFParameters";
    }

    public int getBrightness() {
        return this.brightness;
    }

    @Override
    public void setParameters(MDParameters parameters) {
        super.setParameters(parameters);
        if (this.fp == null || this.fp.length != this.params.getInternalSize()) {
            this.fp = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new CFParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
        if (this.fp == null || this.fp.length != this.params.getInternalSize()) {
            this.fp = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    @Override
    public byte[] toData() {
        byte[] d = this.params.data;
        for (int i = 0; i < this.fp.length; ++i) {
            int v = this.fp[i];
            for (int j = 3; j >= 0; --j) {
                d[i * 4 + j] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return d;
    }

    @Override
    public void fromData(byte[] dbRepr) {
        this.brightness = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            int v = 0;
            for (int j = 0; j < 4; ++j) {
                v <<= 8;
                v += (dbRepr[i * 4 + j] + 256) % 256;
            }
            this.brightness += Metrics.calcBitCount(v);
            this.fp[i] = v;
        }
    }

    public final void clear() {
        for (int i = 0; i < this.fp.length; ++i) {
            this.fp[i] = 0;
        }
        this.brightness = 0;
    }

    @Override
    public final String toString() {
        return this.toDecimalString();
    }

    @Override
    public final String toDecimalString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fp.length; ++i) {
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(this.fp[i]);
        }
        return sb.toString();
    }

    @Override
    public String toBinaryString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.params.getLength(); ++i) {
            sb.append(this.get(i));
            if ((i + 1) % 8 != 0) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    @Override
    public final void fromString(String cfp) throws ParseException {
        CFParameters p = (CFParameters)this.params;
        this.clear();
        try {
            this.brightness = 0;
            StringTokenizer st = new StringTokenizer(cfp, "\t ");
            for (int i = 0; i < this.fp.length; ++i) {
                this.fp[i] = Integer.parseInt(st.nextToken());
                this.brightness += Metrics.calcBitCount(this.fp[i]);
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(cfp + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(cfp + " contains invalid numbers", 0);
        }
    }

    @Override
    public final float[] toFloatArray() {
        float[] toReturn = new float[this.params.getLength()];
        for (int a = 0; a < toReturn.length; ++a) {
            toReturn[a] = this.get(a);
        }
        return toReturn;
    }

    @Override
    public void fromFloatArray(float[] descr) throws RuntimeException {
        this.clear();
        int bc = 0;
        for (int i = 0; i < descr.length; ++i) {
            this.set(bc++, Math.round(descr[i]));
        }
        this.calcBrightness();
    }

    private void set(int cellIndex, int value) throws RuntimeException {
        if (value == 0) {
            return;
        }
        if (value == 1) {
            int n = cellIndex / 32;
            this.fp[n] = this.fp[n] | 1 << 31 - cellIndex % 32;
            return;
        }
        throw new RuntimeException("Value out of range, should be 0 or 1.");
    }

    private int get(int cellIndex) {
        return (this.fp[cellIndex / 32] & 1 << 31 - cellIndex % 32) == 0 ? 0 : 1;
    }

    private void calcBrightness() {
        this.brightness = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            this.brightness += Metrics.calcBitCount(this.fp[i]);
        }
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        try {
            return ((CFParameters)this.params).generate(m, this);
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    @Override
    public int getDefaultMetricIndex() {
        return this.defaultMetricIndex;
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return defaultThresholds[metricIndex];
    }

    public int getCommonBitCount(ChemicalFingerprint f) {
        int x = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
        }
        return x;
    }

    public float getTanimoto(ChemicalFingerprint f) {
        int x = 0;
        int y = this.brightness;
        int z = f.brightness;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
        }
        if (this.params.isAsymmetric()) {
            float alpha = this.params.getAsymmetryFactor();
            return 1.0f - (float)x / (alpha * (float)(y - x) + (1.0f - alpha) * (float)(z - x) + (float)x);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (float)(y + z - x);
    }

    public float getTversky(ChemicalFingerprint f) {
        return Metrics.binaryTversky(this.fp, this.params.getTverskyAlpha(), f.fp, this.params.getTverskyBeta());
    }

    public float getEuclidean(ChemicalFingerprint f) {
        boolean norm = this.params.isNormalized();
        int x = 0;
        int y = 0;
        int z = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] ^ f.fp[i]);
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getWeightedEuclidean(ChemicalFingerprint f) {
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float[] w = this.params.getWeights();
        for (int i = 0; i < this.fp.length; ++i) {
            int fi = this.fp[i] ^ f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                x += w[i * 32 + bi] * (float)(fi & 1);
                fi >>= 1;
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getAsymmetricEuclidean(ChemicalFingerprint f) {
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float a = this.params.getAsymmetryFactor();
        for (int i = 0; i < this.fp.length; ++i) {
            int f1i = this.fp[i];
            int f2i = f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += b1 == 1 ? a : 1.0f - a;
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    public float getWeightedAsymmetricEuclidean(ChemicalFingerprint f) {
        boolean norm = this.params.isNormalized();
        float x = 0.0f;
        int y = 0;
        int z = 0;
        float[] w = this.params.getWeights();
        float a = this.params.getAsymmetryFactor();
        for (int i = 0; i < this.fp.length; ++i) {
            int f1i = this.fp[i];
            int f2i = f.fp[i];
            for (int bi = 31; bi >= 0; --bi) {
                int b1 = f1i & 1;
                int b2 = f2i & 1;
                f1i >>= 1;
                f2i >>= 1;
                if (b1 == b2) continue;
                x += w[i * 32 + bi] * (b1 == 1 ? a : 1.0f - a);
            }
            if (!norm) continue;
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        return norm ? (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(z))) : (float)Math.sqrt(x);
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2) {
        return this.getDissimilarity(fp2, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2, int metricIndex) {
        this.params.setCurrentParametrizedMetric(metricIndex);
        int mi = this.params.getInternalMetricIndex();
        switch (mi) {
            case 0: {
                return this.getTanimoto((ChemicalFingerprint)fp2);
            }
            case 1: {
                boolean w = this.params.isWeighted();
                boolean a = this.params.isAsymmetric();
                if (!w & !a) {
                    return this.getEuclidean((ChemicalFingerprint)fp2);
                }
                if (w & !a) {
                    return this.getWeightedEuclidean((ChemicalFingerprint)fp2);
                }
                if (!w & a) {
                    return this.getAsymmetricEuclidean((ChemicalFingerprint)fp2);
                }
                if (w & a) {
                    return this.getWeightedAsymmetricEuclidean((ChemicalFingerprint)fp2);
                }
            }
            case 2: {
                return this.getTversky((ChemicalFingerprint)fp2);
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + metricIndex + ") passed to ChemicalFingerprint.getDissimilarity()");
    }

    public float getLowerBound(Object fp2) {
        return 0.0f;
    }

    public boolean isSubSetOf(ChemicalFingerprint f) {
        for (int i = 0; i < this.fp.length; ++i) {
            if ((this.fp[i] & f.fp[i]) == this.fp[i]) continue;
            return false;
        }
        return true;
    }
}

