/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.ECFPFeature;
import chemaxon.descriptors.ECFPGenerator;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ECFPFeatureLookup {
    private ECFPParameters params;
    private Molecule origMol;
    private Molecule stdMol;
    private int[] atomMap;
    private int[] atomRevMap;
    private Integer[][] ids;

    public ECFPFeatureLookup() {
        this.params = new ECFPParameters();
    }

    public ECFPFeatureLookup(String configString) {
        this.params = new ECFPParameters(configString);
    }

    public ECFPFeatureLookup(ECFPParameters params) {
        this.params = params;
    }

    public void processMolecule(Molecule mol) {
        this.origMol = mol;
        this.params.standardizer.setAtomIndexQuery(true);
        this.stdMol = this.params.standardize(this.origMol);
        this.atomMap = this.params.standardizer.getOldToNew();
        this.atomRevMap = this.params.standardizer.getNewToOld();
        this.ids = new ECFPGenerator().generateIdentifiers(this.stdMol, this.params);
    }

    public List<ECFPFeature> getFeaturesFromIdentifier(int id) {
        int pos = ECFPGenerator.getBitPosition(id, this.params);
        ArrayList<ECFPFeature> result = new ArrayList<ECFPFeature>();
        for (int k = 0; k < this.ids.length; ++k) {
            for (int i = 0; i < this.ids[k].length; ++i) {
                if (this.ids[k][i] == null || this.ids[k][i] != id || this.atomRevMap[i] < 0) continue;
                result.add(new ECFPFeature(this.origMol, this.origMol.getAtom(this.atomRevMap[i]), k * 2, id, pos));
            }
        }
        return result;
    }

    public List<ECFPFeature> getFeaturesFromBitPosition(int bitPos) {
        ArrayList<ECFPFeature> result = new ArrayList<ECFPFeature>();
        for (int k = 0; k < this.ids.length; ++k) {
            for (int i = 0; i < this.ids[k].length; ++i) {
                int id;
                if (this.ids[k][i] == null || ECFPGenerator.getBitPosition(id = this.ids[k][i].intValue(), this.params) != bitPos || this.atomRevMap[i] < 0) continue;
                result.add(new ECFPFeature(this.origMol, this.origMol.getAtom(this.atomRevMap[i]), k * 2, id, bitPos));
            }
        }
        return result;
    }

    public Integer getIdentifier(MolAtom atom, int diameter) throws IllegalArgumentException {
        if (diameter < 0 || diameter > this.params.getDiameter() || diameter % 2 != 0) {
            throw new IllegalArgumentException("Illegal diameter value: " + diameter);
        }
        int i = this.atomMap[this.origMol.indexOf(atom)];
        if (i < 0) {
            throw new IllegalArgumentException("Illegal atom: " + this.origMol.indexOf(atom) + ". " + "It was removed by the standardizer");
        }
        return this.ids[diameter / 2][i];
    }

    public Integer getBitPosition(MolAtom atom, int diameter) throws IllegalArgumentException {
        Integer id = this.getIdentifier(atom, diameter);
        return id == null ? null : Integer.valueOf(ECFPGenerator.getBitPosition(id, this.params));
    }

    public int getBitPosition(int id) {
        return ECFPGenerator.getBitPosition(id, this.params);
    }

    static Molecule getAtomNeighborhood(Molecule origMol, MolAtom centerAtom, int diameter) {
        Molecule mol = new Molecule();
        MolAtom newAtom = new MolAtom(131);
        newAtom.set(centerAtom);
        mol.add(newAtom);
        int start = origMol.indexOf(centerAtom);
        int[] atomMap = new int[origMol.getAtomCount()];
        Arrays.fill(atomMap, -1);
        atomMap[start] = 0;
        int[] parent = new int[origMol.getAtomCount()];
        Arrays.fill(parent, -1);
        int[] queue = new int[origMol.getAtomCount()];
        int qfirst = 0;
        int qlast = 0;
        queue[0] = start;
        int dist = 0;
        int levelEnd = -1;
        while (qfirst <= qlast) {
            if (qfirst > levelEnd) {
                levelEnd = qlast;
                if (++dist > diameter / 2 + 1) break;
            }
            int v = queue[qfirst++];
            MolAtom av = origMol.getAtom(v);
            MolAtom oldAtom = mol.getAtom(atomMap[v]);
            for (int k = 0; k < av.getBondCount(); ++k) {
                MolAtom aw = av.getLigand(k);
                int w = origMol.indexOf(aw);
                if (atomMap[w] == -1) {
                    newAtom = new MolAtom(131);
                    if (dist <= diameter / 2) {
                        newAtom.set(aw);
                    }
                    mol.add(newAtom);
                    atomMap[w] = mol.getAtomCount() - 1;
                    parent[w] = v;
                    queue[++qlast] = w;
                } else {
                    newAtom = mol.getAtom(atomMap[w]);
                }
                if (oldAtom.isBoundTo(newAtom)) continue;
                if (dist <= diameter / 2) {
                    mol.add(new MolBond(oldAtom, newAtom, av.getBond(k).getType()));
                    continue;
                }
                mol.add(new MolBond(oldAtom, newAtom, 0));
            }
        }
        return mol;
    }
}

