/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

class EnrichmentGraph {
    static final int TANIMOTO = 0;
    static final int SCORE = 1;
    private int activeCount = 0;
    private int decoyCount = 0;
    private Vector<DataElement> v = new Vector();

    private DataElement parse(String s, boolean active) {
        String[] a = s.split(" ");
        if (a.length != 5 || a[0].equals("seq.")) {
            return null;
        }
        int seq = Integer.parseInt(a[0]);
        double sc = Double.parseDouble(a[1]);
        double tani = Double.parseDouble(a[2]);
        if (sc == -1.0) {
            return null;
        }
        long t = Long.parseLong(a[4]);
        return new DataElement(seq, tani, active, t, sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFile(String s, boolean active) {
        BufferedReader in = null;
        IOException t = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(s));
            while ((str = in.readLine()) != null) {
                try {
                    DataElement d = this.parse(str, active);
                    if (d == null) continue;
                    this.v.add(d);
                    if (d.active) {
                        ++this.activeCount;
                        continue;
                    }
                    ++this.decoyCount;
                }
                catch (IllegalArgumentException ill) {
                    ill.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            t = e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    double averageTime() {
        double av = 0.0;
        for (DataElement dataElement : this.v) {
            av += (double)dataElement.t;
        }
        return av / (double)this.v.size();
    }

    void graph(int sort) {
        Collections.sort(this.v, new DataElementComparator(sort));
        int currentActives = 0;
        String l = "SCORE";
        if (sort == 0) {
            l = "TANI";
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("enrichment_" + l + ".txt"));
            out.write("dbRatio unbiased " + l + "_ranked \n");
            for (int i = 0; i < this.v.size(); ++i) {
                DataElement da = this.v.elementAt(i);
                System.err.println(da);
                double x = (double)i / (double)this.v.size() * 100.0;
                double yUnbiased = (double)this.activeCount * (double)i / (double)this.v.size() / (double)this.activeCount * 100.0;
                if (da.active) {
                    ++currentActives;
                }
                double yBiased = (double)currentActives / (double)this.activeCount * 100.0;
                out.write(x + " " + yUnbiased + " " + yBiased + "\n");
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String enrichment(double percent) {
        int sort = 0;
        Collections.sort(this.v, new DataElementComparator(sort));
        int currentActives = 0;
        String l = "SCORE";
        if (sort == 0) {
            l = "TANI";
        }
        double dist = -1.0;
        double enrichment = 0.0;
        double xE = 0.0;
        for (int i = 0; i < this.v.size(); ++i) {
            DataElement da = this.v.elementAt(i);
            double x = (double)i / (double)this.v.size() * 100.0;
            if (da.active) {
                ++currentActives;
            }
            double yBiased = (double)currentActives / (double)this.activeCount * 100.0;
            double distCurr = Math.abs(x - percent);
            if (dist != -1.0 && !(dist > distCurr)) continue;
            dist = distCurr;
            xE = x;
            enrichment = yBiased;
        }
        DecimalFormat df = new DecimalFormat("0.0");
        return "Enrichment at: " + df.format(xE) + "% " + df.format(enrichment);
    }

    void writeGeneralInfo() {
        try {
            String s = "Average time: " + this.averageTime() + "\n" + this.enrichment(1.0) + "\n" + this.enrichment(10.0) + "\n";
            System.err.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class DataElementComparator
    implements Comparator<DataElement> {
        int mode;

        public DataElementComparator(int mode) {
            this.mode = mode;
        }

        @Override
        public int compare(DataElement o1, DataElement o2) {
            if (this.mode == 0) {
                if (o1.tanimoto < o2.tanimoto) {
                    return 1;
                }
                if (o1.tanimoto > o2.tanimoto) {
                    return -1;
                }
                return 0;
            }
            if (this.mode == 1) {
                if (o1.score < o2.score) {
                    return 1;
                }
                if (o1.score > o2.score) {
                    return -1;
                }
                return 0;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class DataElement {
        int seq;
        double tanimoto;
        boolean active;
        long t;
        double score;

        public DataElement(int seq, double tanimoto, boolean active, long t, double score) {
            this.seq = seq;
            this.tanimoto = tanimoto;
            this.active = active;
            this.t = t;
            this.score = score;
        }

        public String toString() {
            String s = this.seq + " " + this.tanimoto + " " + this.score + "" + this.active + " " + this.t;
            return s;
        }
    }
}

