/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.descriptors.MDDBWriter;
import chemaxon.descriptors.MDFileWriter;
import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDWriter;
import chemaxon.descriptors.MDWriterException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.descriptors.ShapeParameters;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GenerateMD {
    private int descriptorCount = 1;
    private ConnectionHandler connectionHandler = null;
    private MDTableHandler mdTableHandler = null;
    private String structureTableName = null;
    private String structureTableSQLWhere = null;
    private Statement structureTableSelect = null;
    private boolean updateOnInsert = true;
    private ResultSet moleculesFetched = null;
    private InputStream inFile = System.in;
    private boolean sdfInput = false;
    private MolImporter molImp = null;
    private Molecule mol = null;
    private String outputFileName = null;
    private boolean sdfOutput = false;
    private String[] tagNames = null;
    private boolean decimalOutput = false;
    private boolean binaryOutput = false;
    private String[] descrTypes = null;
    private String[] descrNames = null;
    private String[] descrComments = null;
    private String[] descrSettings = null;
    private MDParameters[] descrParameters = null;
    private boolean generateId = false;
    private int firstId = 1;
    private int id;
    private String idTagName = null;
    private int counter = 0;
    private boolean createStat = false;
    private String activityTagName = null;
    private double clusteringRadius;
    private String metric = null;
    private ArrayList<MDSet> descrGen = null;
    private ArrayList activity = null;
    private int[] clusters = null;
    private MDWriter outputWriter = null;
    private boolean initialized = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String UserHome = System.getProperty("user.home");
    private static final String FileSep = System.getProperty("file.separator");
    private static final String PrgName = "GenerateMD";
    private static final String PrgHeader = NL + "GenerateMD" + " - " + "Molecular Descriptor Generator " + VersionInfo.JCHEM_VERSION + ", (C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Generates various kinds of molecular descriptors for input compounds." + NL + "" + NL + "Usage: generatemd <command> [input file] [options] " + NL + "" + NL + "Commands: " + NL + "   c       creates new descriptor" + NL + "   u       updates existing descriptor in database" + NL + "   d       deletes existing descriptor from database" + NL + "   a       adds new screening configurations to existing descriptors" + NL + "   r       removes screening configurations" + NL + "   l       list all descriptors stored in the database" + NL + "" + NL + "Command syntax: " + NL + "   c [input file] [options] " + NL + "   u <structure table name> <descriptor name> " + NL + "   d <structure table name> <descriptor name> " + NL + "   a <structure table name> <descriptor name> [<config. name>] <config. file>" + NL + "   r <structure table name> <descriptor name> <configuration name> ..." + NL + "   l [ <structure table name> ] " + NL + "" + NL + "General options: " + NL + "  -h, --help               this help message" + NL + "  -x, --expert-help        advanced options for expert users" + NL + "  -L, --list-descriptors   lists all available built-in descriptor types" + NL + "  -v, --verbose            verbose" + NL + "  -s, --saveconf           saves database settings" + NL + "" + NL + "Input/output options:" + NL + "  -a, --table-name <table> takes structures from the given database table" + NL + "  -q, --query <sql>        where-clause for reading structures from a table" + NL + "  -o, --output <filepath>  SDF output file path and name" + NL + "  -g, --generate-id [<first>] " + NL + "                             generate unique structure identifiers" + NL + "                             an optional value for the first ID can be given" + NL + "  -S, --sdf-output         generate SDfile output (otherwise descriptor file)" + NL + "" + NL + "Database options:" + NL + "  -d, --driver <JDBC>      JDBC driver" + NL + "  -u, --dburl <url>        URL of database" + NL + "  -l, --login <login>      login name" + NL + "  -p, --password <pwd>     password" + NL + "" + NL + "Descriptor options: " + NL + "  -k, --descriptor <type> <name> [ <comment> ]" + NL + "                           generates descriptors of the given type and name" + NL + "                             in database" + NL + "  -k, --descriptor <type> " + NL + "                           generates descriptors of the given type in file" + NL + "  -c, --config <config>    path and name of the XML configuration file" + NL + "";
    private static final String ExpertOptions = "" + NL + "Input/output options:" + NL + "  -D, --decimal-format     tab separated output of the descriptor values" + NL + "  -2, --binary-format      0 1 string" + NL + "  -T, --stat               print statistics on descriptors generated" + NL + "" + NL + "SDfile options:" + NL + "  -I, --id-tag <name>      name of the tag storing unique molecule identifiers" + NL + "  -t, --use-tag <name>     use the named tag instead of the default one to " + NL + "                             store descriptor data" + NL + "  -P, --PMAP-tag [<name>]  use existing PMAP data" + NL + "  -w, --validate <name>    validate the descriptor using activity-seeded, " + NL + "                             structure-based clustering, <name> is an SDfile" + NL + "                             tag containing the IC50 activity data" + NL + "" + NL + "Database options:" + NL + "  -O, --proptable <table>  name of the property table" + NL + "  -U, --update-on-insert   update descriptors when new structure is inserted" + NL + "" + NL + "ECFP fingerprint options:" + NL + "  -f, --fingerprint-length ECFP fingerprint length in bits" + NL + "  -n, --diameter           the diameter of the circular neighborhood considered" + NL + "                             for each atom" + NL + "" + NL + "3D Shape descriptor options:" + NL + "  -F, --treat-flexilble    the conformational flexiblity is taken into account" + NL + "" + NL + "Chemical fingerprint options:" + NL + "  -f, --fingerprint-length chemical fingerprint length in bits" + NL + "  -n, --pattern-length     maximum number of bonds in patterns" + NL + "  -b, --bit-count          maximum number of bits to set for each patterns" + NL + "" + NL + "Fuzzy smoothing options:" + NL + "  -z, --fuzzy <smoothing factor>  " + NL + "                           generate fuzzy pharmacophore fingerprints with the " + NL + "                             given fuzzy smoothing factor " + NL + "  -G, --Gaussian-cutoff <value> " + NL + "                           not smoothing outside <value>*sigma" + NL + "  -B, --smoothing-bound <value> " + NL + "                           lower bound for fuzzy smoothing " + NL + "  -A, --asymmetrical-smoothing" + NL + "                           do not smooth left side" + NL + "  -R, --ignore-rotomers    do not take into account the effect of rotatable" + NL + "                             bonds" + NL + "";
    private static final String Examples = "" + NL + "Examples:" + NL + "  generatemd c foo.smiles -k PF -c config/pharma-frag.xml -o foo.pf " + NL + "  generatemd c foo.sdf -k CF -c config/cfp.xml -o out.sdf -S" + NL + "  generatemd c foo.sdf -k TPSA -o out.sdf -S" + NL + "  generatemd c -a structuretable -k CF testcfp -c cfp.xml" + NL + "    -d org.gjt.mm.mysql.Driver -u jdbc:mysql://localhost/cdexample" + NL + "    -l user -p password" + NL + "" + NL + "";
    private static final String DescriptorList = PrgHeader + "Built in descriptor types: " + NL + "  ECFP fingerprint (ECFP)" + NL + "  3D Shape descriptor (Shape)" + NL + "  Chemical Fingerprint (CF)" + NL + "  Pharmacophore Fingerprint (PF)" + NL + "  Reaction Fingerprint (RF) " + NL + "  BCUT descriptors (BCUT)" + NL + "  Hydrogen bond Donor/Acceptor count (HDon/HAcc)" + NL + "  octanol-water distribution coefficient (LogD)" + NL + "  octanol-water partition coefficient (LogP)" + NL + "  Topological Polar Surface Area (TPSA) " + NL + "  Mass of molcule (Mass) " + NL + "  number of Heavy atoms (Heavy) " + NL + "";
    private CmdLine cmdLine = null;
    private boolean verbose = false;
    private int verboseFreq = 1000;
    private char command;
    private String[] configNames = null;
    private String configFileName = null;
    private boolean inputSDF = false;
    private String outputFN = null;
    private String inputTableName = null;
    private String type = null;
    private String name = null;
    private String comment = null;
    private MDParameters params = null;
    private String className = null;
    private boolean db = false;
    private ConnectionHandler connHandl = null;
    private SettingsHandler settingsHandler = null;
    private Properties dbConnectionProperties = null;

    public GenerateMD() {
    }

    public GenerateMD(int descriptorCount) {
        this.descriptorCount = descriptorCount;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) throws MDGeneratorException {
        this.checkNotInit();
        this.connectionHandler = connectionHandler;
    }

    public void setStructureTableName(String structureTableName) throws MDGeneratorException, SQLException {
        this.checkNotInit();
        this.checkConnection();
        if (this.activityTagName != null) {
            throw new MDGeneratorException("Descriptor validation is not supported for database tables.");
        }
        this.structureTableName = structureTableName;
        this.mdTableHandler = new MDTableHandler(this.connectionHandler, structureTableName);
    }

    public void setUpdateOnInsert(boolean updateOnInsert) {
        this.updateOnInsert = updateOnInsert;
    }

    public void setSelectStatement(String whereClause) throws MDGeneratorException {
        this.checkNotInit();
        if (this.mdTableHandler == null) {
            throw new MDGeneratorException("Structure table name has not been set.");
        }
        this.structureTableSQLWhere = whereClause;
    }

    public void setInput(String inputFileName) throws MDGeneratorException, IOException {
        this.checkNotInit();
        if (this.mdTableHandler != null) {
            throw new MDGeneratorException("Database input has already been specified.");
        }
        this.inFile = new BufferedInputStream(new FileInputStream(inputFileName));
    }

    public void setInput(InputStream input) throws MDGeneratorException {
        this.checkNotInit();
        if (this.mdTableHandler != null) {
            throw new MDGeneratorException("Database input has already been specified.");
        }
        this.inFile = input;
    }

    public void setSDfileInput(boolean sdfInput) throws MDGeneratorException {
        this.checkNotInit();
        if (this.inFile == null) {
            throw new MDGeneratorException("Input file has not yet been specified");
        }
        this.sdfInput = sdfInput;
    }

    public void setOutputFileName(String outputFileName) throws MDGeneratorException {
        this.checkNotInit();
        if (this.mdTableHandler != null) {
            throw new MDGeneratorException("File output is not allowed from database input.");
        }
        this.outputFileName = outputFileName;
    }

    public void setSDfileOutput(boolean sdfOutput) {
        this.sdfOutput = sdfOutput;
    }

    public void setDecimalOutput(boolean decimalOutput) {
        this.decimalOutput = decimalOutput;
    }

    public void setBinaryOutput(boolean binaryOutput) {
        this.binaryOutput = binaryOutput;
    }

    public void setIdTagName(String idTagName) {
        this.idTagName = idTagName;
    }

    public void setValidateDescriptor(String activityTagName, double clusteringRadius, String metric) throws MDGeneratorException {
        if (this.structureTableName != null) {
            throw new MDGeneratorException("Descriptor validation is not supported for database tables.");
        }
        this.activityTagName = activityTagName;
        this.clusteringRadius = clusteringRadius;
        this.metric = metric;
    }

    public void setDescriptor(String name, String type, String settings, String comment) throws MDGeneratorException {
        this.checkNotInit();
        if (this.descriptorCount != 1) {
            throw new MDGeneratorException("Bad usage: descriptor count is not 1.");
        }
        this.alloc();
        this.descrNames[0] = name;
        this.descrTypes[0] = type;
        this.descrSettings[0] = settings;
        this.descrParameters = null;
        this.descrComments[0] = comment;
    }

    public void setDescriptor(int index, String name, String type, String settings, String comment) throws MDGeneratorException {
        this.checkNotInit();
        this.alloc();
        this.descrNames[index] = name;
        this.descrTypes[index] = type;
        this.descrSettings[index] = settings;
        this.descrParameters = null;
        this.descrComments[index] = comment;
    }

    public void setDescriptors(String[] names, String[] types, String[] settings, String[] comments) throws MDGeneratorException {
        this.checkNotInit();
        this.descrNames = names;
        this.descrTypes = types;
        this.descrSettings = settings;
        this.descrParameters = null;
        this.descrComments = comments;
    }

    public void setDescriptor(String name, String type, MDParameters params, String comment) throws MDGeneratorException {
        this.checkNotInit();
        if (this.descriptorCount != 1) {
            throw new MDGeneratorException("Bad usage: descriptor count is not 1.");
        }
        this.alloc();
        this.descrNames[0] = name;
        this.descrTypes[0] = type;
        this.descrSettings = null;
        this.descrParameters[0] = params;
        this.descrComments[0] = comment;
    }

    public void setDescriptor(int index, String name, String type, MDParameters params, String comment) throws MDGeneratorException {
        this.checkNotInit();
        this.alloc();
        this.descrNames[index] = name;
        this.descrTypes[index] = type;
        this.descrSettings = null;
        this.descrParameters[index] = params;
        this.descrComments[index] = comment;
    }

    public void setDescriptors(String[] names, String[] types, MDParameters[] params, String[] comments) throws MDGeneratorException {
        this.checkNotInit();
        this.descrNames = names;
        this.descrTypes = types;
        this.descrSettings = null;
        this.descrParameters = params;
        this.descrComments = comments;
    }

    public void setTagName(String name) throws MDGeneratorException {
        this.checkNotInit();
        if (this.descriptorCount != 1) {
            throw new MDGeneratorException("Bad usage: descriptor count is not be 1");
        }
        this.alloc();
        this.tagNames[0] = name;
    }

    public void setTagName(int index, String name) throws MDGeneratorException {
        this.checkNotInit();
        this.alloc();
        this.tagNames[index] = name;
    }

    public void setTagNames(String[] names) throws MDGeneratorException {
        this.checkNotInit();
        this.alloc();
        this.tagNames = names;
    }

    public void setGenerateId(int from) throws MDGeneratorException {
        this.checkNotInit();
        if (this.structureTableName != null) {
            throw new MDGeneratorException("Generating ID-s is not allowed for database input.");
        }
        this.generateId = true;
        this.firstId = from;
    }

    public void setCreateStat(boolean createStat) {
        this.createStat = createStat;
    }

    public void init() throws MDGeneratorException {
        if (this.initialized) {
            throw new MDGeneratorException("Already initilized.");
        }
        if (this.sdfOutput) {
            if (this.generateId) {
                throw new MDGeneratorException("Cannot generate ID for structures in SDfile.");
            }
            if (this.idTagName != null) {
                this.idTagName = null;
            }
        } else if (!this.decimalOutput && !this.binaryOutput) {
            this.generateId = true;
        }
        try {
            this.outputWriter = this.initDestinations();
            this.initSource();
            this.id = this.firstId;
            this.counter = 0;
            this.initialized = true;
            if (this.createStat) {
                for (int i = 0; i < this.descrNames.length; ++i) {
                    this.outputWriter.getMDParameters(i).setCreateStatistics(true);
                }
            }
            if (this.activityTagName != null && this.connectionHandler == null) {
                this.descrGen = new ArrayList();
                this.activity = new ArrayList();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MDGeneratorException(e.getMessage());
        }
    }

    public boolean step() throws MDGeneratorException {
        this.checkInit();
        if (this.getNextMolecule()) {
            ++this.counter;
            try {
                if (this.idTagName != null) {
                    ((MDFileWriter)this.outputWriter).put(this.mol, this.mol.getProperty(this.idTagName));
                } else {
                    this.outputWriter.put(this.mol, this.id);
                }
                if (this.activityTagName != null) {
                    try {
                        this.activity.add(new Double(this.mol.getProperty(this.activityTagName)));
                        this.descrGen.add(((MDFileWriter)this.outputWriter).getMDSet());
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Invalid activity data: " + this.mol.getProperty(this.activityTagName) + " compound" + " skipped.");
                    }
                }
            }
            catch (MDWriterException e) {
                System.err.println("Descriptor generation failed. Compound " + this.counter + " was skipped.");
            }
            if (this.generateId) {
                ++this.id;
            }
            return true;
        }
        return false;
    }

    public int getCounter() throws MDGeneratorException {
        this.checkInit();
        return this.counter;
    }

    public int[] getASSBClusters() {
        return this.clusters;
    }

    public void run() throws MDGeneratorException {
        this.checkInit();
        while (this.getNextMolecule()) {
            try {
                if (this.idTagName != null) {
                    ((MDFileWriter)this.outputWriter).put(this.mol, this.mol.getProperty(this.idTagName));
                } else {
                    this.outputWriter.put(this.mol, this.id);
                }
            }
            catch (MDWriterException e) {
                e.printStackTrace();
                throw new MDGeneratorException(e.getMessage());
            }
            if (this.generateId) {
                ++this.id;
            }
            ++this.counter;
        }
        if (this.activityTagName != null) {
            this.validateDescriptor();
        }
    }

    public String getStatistics(int di) {
        MDGenerator gen = this.outputWriter.getMDParameters(di).getGenerator();
        DecimalFormat pf = new DecimalFormat("#0.00%");
        String NL = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("Number of molecules = ").append(gen.getMoleculeCount()).append(NL);
        sb.append("Number of bits set: ").append(NL);
        sb.append("    Average = ").append(this.pad(pf.format(gen.getAverageNonZeroRatio()), 7)).append(NL);
        sb.append("    Maximum = ").append(this.pad(pf.format(gen.getMaximumBitRatio()), 7)).append(" (molecule ").append(gen.getBrightestMolId()).append(")" + NL);
        sb.append("    Minimum = ").append(this.pad(pf.format(gen.getMinimumBitRatio()), 7)).append(" (molecule ").append(gen.getDarkestMolId()).append(")" + NL);
        sb.append("Density function:").append(NL);
        for (int i = 0; i < 10; ++i) {
            float dv = (float)gen.getDensityCounts()[i] / (float)gen.getMoleculeCount();
            if (i == 0) {
                sb.append(' ');
            }
            if (i == 9) {
                dv += (float)gen.getDensityCounts()[10] / (float)gen.getMoleculeCount();
            }
            sb.append(10 * i).append("%-").append(10 * i + 10).append("%\t").append(this.pad(pf.format(dv), 7)).append(NL);
        }
        sb.append("Cell frequencies: " + NL + "index    freq      %" + NL);
        int[] freq = gen.getFrequencyCounts();
        for (int i = 0; i < freq.length; ++i) {
            float fv = (float)freq[i] / (float)gen.getMoleculeCount();
            sb.append(this.pad(i, 3)).append(this.pad(freq[i], 10)).append(this.pad(pf.format(fv), 10)).append(NL);
        }
        return sb.toString();
    }

    public void validateDescriptor() {
        int i;
        if (this.activity == null) {
            return;
        }
        int size = this.activity.size();
        for (int i2 = size - 1; i2 > 0; --i2) {
            double a;
            int parent = i2 / 2;
            double pa = (Double)this.activity.get(parent);
            if (!(pa > (a = ((Double)this.activity.get(i2)).doubleValue()))) continue;
            this.swap(this.activity, i2, parent);
            this.swap(this.descrGen, i2, parent);
        }
        this.clusters = new int[size];
        int[] centers = new int[size];
        int clusterId = 1;
        int clusteredCompoundCount = 1;
        this.clusters[0] = clusterId;
        MDSet center = this.descrGen.get(0);
        MDParameters p = center.getDescriptor(0).getParameters();
        p.setCurrentParametrizedMetric(p.getMetricIndex(this.metric));
        centers[clusterId] = 0;
        block1: while (clusteredCompoundCount != size) {
            for (i = 1; i < size; ++i) {
                if (this.clusters[i] != 0 || !((double)center.getDissimilarity(this.descrGen.get(i)) <= this.clusteringRadius)) continue;
                this.clusters[i] = clusterId;
                ++clusteredCompoundCount;
            }
            for (i = 1; i < size; ++i) {
                if (this.clusters[i] != 0) continue;
                this.clusters[i] = ++clusterId;
                center = this.descrGen.get(i);
                centers[clusterId] = i;
                ++clusteredCompoundCount;
                continue block1;
            }
        }
        block4: for (i = 0; i <= clusterId; ++i) {
            center = this.descrGen.get(centers[i]);
            for (int j = i + 1; j <= clusterId; ++j) {
                if (!((double)center.getDissimilarity(this.descrGen.get(centers[j])) <= 2.0 * this.clusteringRadius)) continue;
                for (int k = 0; k < size; ++k) {
                    if (this.clusters[k] != j) continue;
                    this.clusters[k] = i;
                }
                continue block4;
            }
        }
    }

    private void swap(ArrayList v, int a, int b) {
        Object w = v.get(a);
        v.set(a, v.get(b));
        v.set(b, w);
    }

    private String pad(String s, int len) {
        if (s.length() >= len) {
            return s;
        }
        char[] p = new char[len - s.length()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = 32;
        }
        return new String(p) + s;
    }

    private String pad(int v, int len) {
        return this.pad(Integer.toString(v), len);
    }

    public void close() throws MDGeneratorException {
        this.checkInit();
        try {
            this.outputWriter.close();
        }
        catch (MDWriterException e) {
            e.printStackTrace();
            throw new MDGeneratorException(e.getMessage());
        }
    }

    private void alloc() {
        if (this.descrNames != null) {
            return;
        }
        this.descrNames = new String[this.descriptorCount];
        this.descrTypes = new String[this.descriptorCount];
        this.descrSettings = new String[this.descriptorCount];
        this.descrParameters = new MDParameters[this.descriptorCount];
        this.descrComments = new String[this.descriptorCount];
        this.tagNames = new String[this.descriptorCount];
    }

    private void initSource() throws IOException, SQLException {
        if (this.structureTableName == null) {
            this.molImp = new MolImporter(new MolInputStream(new BufferedInputStream(this.inFile)));
        } else {
            String sql = "SELECT cd_id, cd_structure FROM " + this.structureTableName;
            if (this.structureTableSQLWhere != null) {
                sql = sql + " WHERE " + this.structureTableSQLWhere;
            }
            this.structureTableSelect = this.connectionHandler.getConnection().createStatement();
            this.moleculesFetched = this.structureTableSelect.executeQuery(sql);
        }
    }

    private MDWriter initDestinations() throws MDWriterException, MDGeneratorException {
        if (this.connectionHandler != null) {
            for (int i = 0; i < this.descrNames.length; ++i) {
                if (this.descrNames[i] == null) {
                    throw new MDWriterException("Missing descriptor name");
                }
                this.createMDTable(this.descrNames[i], this.descrTypes[i], this.descrSettings != null ? this.descrSettings[i] : this.descrParameters[i].toString(), this.descrComments[i]);
            }
            MDDBWriter w = new MDDBWriter();
            w.setConnectionHandler(this.connectionHandler);
            w.setStructureTable(this.structureTableName);
            w.setMDNames(this.descrNames);
            return w;
        }
        MDFileWriter w = null;
        if (this.descrSettings != null) {
            w = this.sdfOutput ? new MDFileWriter(this.outputFileName, this.tagNames, this.descrTypes, this.descrSettings) : new MDFileWriter(this.descrNames, this.descrTypes, this.descrSettings);
        } else {
            MDFileWriter mDFileWriter = w = this.sdfOutput ? new MDFileWriter(this.outputFileName, this.tagNames, this.descrTypes, this.descrParameters) : new MDFileWriter(this.descrNames, this.descrTypes, this.descrParameters);
        }
        if (!this.sdfOutput) {
            w.setDecimalOutputFormat(this.decimalOutput);
            w.setBinaryOutputFormat(this.binaryOutput);
            w.setPrintId(this.idTagName != null || this.generateId);
        }
        return w;
    }

    private boolean getNextMolecule() throws MDGeneratorException {
        try {
            return this.moleculesFetched != null ? this.getNextMoleculeFromDB() : this.getNextMoleculeFromFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MDGeneratorException(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MDGeneratorException(e.getMessage());
        }
    }

    private boolean getNextMoleculeFromFile() throws IOException {
        this.mol = this.molImp.read();
        if (this.mol != null && this.mol instanceof RgMolecule) {
            this.mol = ((RgMolecule)this.mol).getRoot();
        }
        return this.mol != null;
    }

    private boolean getNextMoleculeFromDB() throws SQLException, MolFormatException {
        if (this.moleculesFetched.next()) {
            this.id = this.moleculesFetched.getInt("cd_id");
            byte[] data = DatabaseTools.readBytes(this.moleculesFetched, "cd_structure");
            this.mol = MolImporter.importMol(data);
            return true;
        }
        this.moleculesFetched.close();
        this.structureTableSelect.close();
        return false;
    }

    public void createMDTable(String descrName, String className, String settings, String comment) throws MDGeneratorException {
        this.checkMDTableHandler();
        try {
            this.mdTableHandler.createMDTable(descrName, className, settings, comment, this.updateOnInsert);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MDGeneratorException("SQL Exception: " + e.getMessage());
        }
    }

    public void deleteMDTable(String descrName) throws MDGeneratorException, SQLException {
        this.checkMDTableHandler();
        DatabaseProperties dbProp = new DatabaseProperties(this.connectionHandler);
        if (dbProp.getTableType(this.structureTableName) == 3) {
            String[] internalDescrNames;
            for (String intDescr : internalDescrNames = MarkushTableInfo.getMarkushDescriptorNames()) {
                if (!descrName.equalsIgnoreCase(intDescr)) continue;
                throw new IllegalArgumentException("Internal Markush descriptor table \"" + intDescr + "\" cannot be deleted");
            }
        }
        this.mdTableHandler.deleteMDTable(descrName);
    }

    public void updateMDTable(String descrName) throws MDGeneratorException, SQLException {
        this.checkMDTableHandler();
        this.mdTableHandler.incRegenerateDescriptorTable(descrName);
    }

    public void addMDConfig(String descrName, String configName, String config) throws MDGeneratorException, SQLException {
        this.checkMDTableHandler();
        if (!this.isNewConfig(descrName, configName)) {
            throw new MDGeneratorException("Configuration redefinition");
        }
        this.mdTableHandler.setMDConfig(descrName, configName, config);
    }

    public void addMDConfig(String descrName, String configName, File configFile) throws SQLException, IOException, MDGeneratorException {
        this.checkMDTableHandler();
        if (!this.isNewConfig(descrName, configName)) {
            throw new MDGeneratorException("Configuration redefinition");
        }
        FileReader in = new FileReader(configFile);
        char[] buf = new char[(int)configFile.length()];
        in.read(buf);
        this.mdTableHandler.setMDConfig(descrName, configName, new String(buf));
    }

    public void deleteMDConfig(String descrName, String configName) throws MDGeneratorException, SQLException {
        this.checkMDTableHandler();
        if (this.isNewConfig(descrName, configName)) {
            throw new MDGeneratorException("Configuration " + configName + " does not exist.");
        }
        this.mdTableHandler.deleteMDConfig(descrName, configName);
    }

    public String[] getMDNames() throws MDGeneratorException, SQLException {
        this.checkMDTableHandler();
        return this.mdTableHandler.getMolecularDescriptors();
    }

    private void checkConnection() throws MDGeneratorException {
        if (this.connectionHandler == null) {
            throw new MDGeneratorException("No connection to database.");
        }
    }

    private void checkMDTableHandler() throws MDGeneratorException {
        this.checkConnection();
        if (this.mdTableHandler == null) {
            throw new MDGeneratorException("Unknown structure table name.");
        }
    }

    private boolean isNewConfig(String descrName, String configName) throws SQLException {
        ArrayList<String> configs = new ArrayList<String>(Arrays.asList(this.mdTableHandler.getMDConfigs(descrName)));
        return configs.indexOf(configName) == -1;
    }

    private void checkInit() throws MDGeneratorException {
        if (!this.initialized) {
            throw new MDGeneratorException("Not yet initialized. Call init() first.");
        }
    }

    private void checkNotInit() throws MDGeneratorException {
        if (this.initialized) {
            throw new MDGeneratorException("Already initialized.");
        }
    }

    public static void main(String[] args) {
        GenerateMD mdGenerator = new GenerateMD();
        try {
            if (args.length > 0 && args[0].equals("config")) {
                args = GenerateMD.getArgsFromXML(args);
            }
            mdGenerator.cmdLine = new CmdLine(args);
            if (!mdGenerator.processCmdLineOptions()) {
                return;
            }
            if (mdGenerator.db) {
                switch (mdGenerator.command) {
                    case 'd': {
                        mdGenerator.setStructureTableName(mdGenerator.inputTableName);
                        try {
                            mdGenerator.deleteMDTable(mdGenerator.name);
                            System.out.println("Descriptor " + mdGenerator.name + " has been removed from the database. ");
                        }
                        catch (SQLException e) {
                            System.out.println("Descriptor " + mdGenerator.name + " cannot be removed from the database. " + " Already deleted?");
                        }
                        return;
                    }
                    case 'u': {
                        mdGenerator.setStructureTableName(mdGenerator.inputTableName);
                        System.out.println("Updating descriptor " + mdGenerator.name + NL);
                        mdGenerator.updateMDTable(mdGenerator.name);
                        return;
                    }
                    case 'a': {
                        mdGenerator.setStructureTableName(mdGenerator.inputTableName);
                        mdGenerator.addScreeningConfig();
                        return;
                    }
                    case 'r': {
                        mdGenerator.setStructureTableName(mdGenerator.inputTableName);
                        mdGenerator.removeScreeningConfigs();
                        return;
                    }
                    case 'l': {
                        mdGenerator.listScreeningConfigs();
                        return;
                    }
                }
            }
            mdGenerator.verboseMsg(NL + "Processing started at " + new GregorianCalendar().getTime() + NL);
            mdGenerator.init();
            while (mdGenerator.step()) {
                if (mdGenerator.getCounter() % mdGenerator.verboseFreq != 0) continue;
                mdGenerator.verboseMsg(mdGenerator.getCounter() + " molecules processed" + NL);
            }
            mdGenerator.close();
            if (mdGenerator.connHandl != null) {
                mdGenerator.connHandl.getConnection().close();
            }
            mdGenerator.validateDescriptor();
            int[] c = mdGenerator.getASSBClusters();
            if (c != null) {
                System.out.println("ASSB clusters");
                for (int i = 0; i < c.length; ++i) {
                    System.out.println(c[i]);
                }
            }
            mdGenerator.verboseMsg("Processing finished at " + new GregorianCalendar().getTime() + NL);
            if (mdGenerator.createStat) {
                System.out.println(mdGenerator.getStatistics(0));
            }
        }
        catch (MDParametersException mde) {
            System.err.println(mde.getMessage() + " Parameter type and parameter configuration don't match.");
            mde.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    private boolean processCmdLineOptions() throws MDGeneratorException, MDParametersException, IOException, ArgumentException, SQLException {
        if (this.cmdLine.isEmpty() || this.cmdLine.exists('h', "help")) {
            System.out.println(UsageInfo + Examples);
            return false;
        }
        if (this.cmdLine.exists('x', "expert-help")) {
            System.out.println(UsageInfo + ExpertOptions + Examples);
            return false;
        }
        if (this.cmdLine.exists('L', "list-descriptors")) {
            System.out.println(DescriptorList);
            return false;
        }
        int vPos = this.cmdLine.find('v', "verbose", 0, 1);
        boolean bl = this.verbose = vPos != -1;
        if (vPos != -1 && this.cmdLine.getParamCount(vPos) == 1) {
            this.verboseFreq = this.cmdLine.getInt(vPos + 1);
        }
        this.verboseMsg(PrgHeader + NL);
        this.processCommands();
        if (this.command == 'c') {
            this.processInputOptions();
            this.processOutputOptions();
            this.processDescriptorOptions();
        }
        this.saveConf();
        return true;
    }

    private void processCommands() throws ArgumentException, SQLException, MDGeneratorException {
        String cmd = this.cmdLine.getCommand(0);
        if (cmd == null) {
            throw new ArgumentException("Missing command. ");
        }
        this.command = cmd.charAt(0);
        if (cmd.length() != 1 || "cudarl".indexOf(this.command) == -1) {
            throw new ArgumentException("Invalid command " + cmd + NL + "Expecting: c, u, d, a, r, l");
        }
        if (this.command == 'c') {
            return;
        }
        int pc = this.cmdLine.getParamCount(0);
        if (this.command != 'l') {
            if (pc < 1) {
                throw new ArgumentException("Missing structure table name");
            }
            if (pc < 2) {
                throw new ArgumentException("Missing structure descriptor name");
            }
        }
        if (pc >= 1) {
            this.inputTableName = this.cmdLine.getString(1);
        }
        if (pc >= 2) {
            this.name = this.cmdLine.getString(2);
        }
        this.db = true;
        this.processDatabaseOptions();
        if (this.command == 'r') {
            this.configNames = new String[pc - 2];
            for (int i = 0; i < pc - 2; ++i) {
                this.configNames[i] = this.cmdLine.getString(3 + i);
            }
        } else if (this.command == 'a') {
            this.configNames = new String[1];
            this.configNames[0] = this.cmdLine.getString(3);
            if (pc == 4) {
                this.configFileName = this.cmdLine.getString(4);
            } else {
                this.configFileName = this.configNames[0];
                this.configNames[0] = GenerateMD.getDescriptorName(this.configFileName);
            }
        }
    }

    private void processInputOptions() throws MDGeneratorException, ArgumentException, IOException, SQLException {
        String fn = this.cmdLine.getFileName(1);
        if (fn == null) {
            int aPos = this.cmdLine.find('a', "table-name");
            if (aPos == -1) {
                this.verboseMsg("Reading standard input" + NL);
                this.setInput(System.in);
            } else {
                this.db = true;
                this.processDatabaseOptions();
                this.setStructureTableName(this.cmdLine.getString(aPos + 1));
                int qPos = this.cmdLine.find('q', "query");
                if (qPos != -1) {
                    this.setSelectStatement(this.cmdLine.getString(qPos + 1));
                }
            }
            return;
        }
        try {
            this.setInput(new BufferedInputStream(new FileInputStream(fn)));
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(fn));
            this.verboseMsg("Reading input file " + fn + NL);
            MolImporter molImp = new MolImporter(new MolInputStream(is));
            this.inputSDF = molImp.getFormat().endsWith("mol");
            this.setSDfileInput(this.inputSDF);
        }
        catch (IOException e) {
            throw new ArgumentException("File " + fn + " could not be opened.");
        }
    }

    private void processOutputOptions() throws MDGeneratorException {
        int gPos;
        this.outputFN = this.cmdLine.getParamString('o', "output");
        if (this.outputFN != null) {
            this.setOutputFileName(this.outputFN);
        }
        if (this.cmdLine.find('S', "sdf-output") != -1) {
            this.setSDfileOutput(true);
        }
        if ((gPos = this.cmdLine.find('g', "generate-id", 0, 1)) != -1) {
            this.setGenerateId(this.cmdLine.getParamCount(gPos) == 1 ? this.cmdLine.getInt(gPos + 1) : 1);
        }
        String idTagName = this.cmdLine.getParamString('I', "id-tag");
        if (this.cmdLine.find('D', "decimal-format") != -1) {
            if (this.sdfOutput) {
                System.err.println("Decimal format is not allowed for SDfile output. -D ignored.");
                return;
            }
            this.setDecimalOutput(true);
            if (idTagName != null) {
                if (gPos != -1) {
                    System.err.println("-I and -g are exclusive. -I ignored.");
                } else {
                    this.setIdTagName(idTagName);
                }
            }
        } else if (idTagName != null) {
            System.err.println("-I is not allowed without -D. -I ignored.");
        }
        if (this.cmdLine.find('2', "binary-format") != -1) {
            if (this.sdfOutput) {
                System.err.println("Binary format is not allowed for SDfile output. Option -2 ignored.");
                return;
            }
            this.setBinaryOutput(true);
        }
        this.setCreateStat(this.cmdLine.find('T', "stat") != -1);
        int wPos = this.cmdLine.find('w', "validate", 3);
        if (wPos != -1) {
            this.setValidateDescriptor(this.cmdLine.getString(wPos + 1), this.cmdLine.getDouble(wPos + 2) / 100.0, this.cmdLine.getString(wPos + 3));
        }
    }

    private void processDescriptorOptions() throws ArgumentException, IOException, MDParametersException, MDGeneratorException {
        int dtPos = this.cmdLine.find('k', "descriptor", 1, 3);
        if (dtPos == -1) {
            throw new ArgumentException("Missing -k flag.");
        }
        int pc = this.cmdLine.getParamCount(dtPos);
        if (!this.db && pc > 1) {
            System.err.println("Too many arguments after -k, ignored.");
        }
        this.type = this.cmdLine.getString(dtPos + 1);
        if (this.db) {
            switch (pc) {
                case 3: {
                    this.comment = this.cmdLine.getString(dtPos + 3);
                }
                case 2: {
                    this.name = this.cmdLine.getString(dtPos + 2);
                }
            }
        } else if (!this.sdfOutput) {
            this.name = this.outputFN;
        }
        this.processDescriptorTypeSpecificOptions();
        this.setDescriptor(this.name, this.type, this.params, this.comment);
        String optTagName = this.cmdLine.getParamString('t', "use-tag");
        this.setTagName(optTagName == null ? this.type : optTagName);
        this.setUpdateOnInsert(this.cmdLine.find('U', "update-on-insert") != -1);
    }

    private void processDescriptorTypeSpecificOptions() throws MDGeneratorException, ArgumentException {
        int cPos = this.cmdLine.find('c', "config", 1);
        if (this.type.equalsIgnoreCase("PharmacophoreFingerprint") || this.type.equalsIgnoreCase("PF")) {
            this.className = new PharmacophoreFingerprint().getClass().getName();
            this.params = cPos != -1 ? new PFParameters(new File(this.cmdLine.getString(cPos + 1))) : new PFParameters(new PFParameters().getDefaultDocumentFrame());
            this.processPFOptions();
        } else if (this.type.equalsIgnoreCase("ECFP")) {
            this.className = new ECFP().getClass().getName();
            this.params = cPos != -1 ? new ECFPParameters(new File(this.cmdLine.getString(cPos + 1))) : new ECFPParameters(new ECFPParameters().getDefaultDocumentFrame());
            this.processECFPOptions();
        } else if (this.type.equalsIgnoreCase("ShapeDescriptor") || this.type.equalsIgnoreCase("shape")) {
            this.params = cPos != -1 ? new ShapeParameters(new File(this.cmdLine.getString(cPos + 1))) : new ShapeParameters(new ShapeParameters().getDefaultDocumentFrame());
            this.processShapeOptions();
        } else if (this.type.equalsIgnoreCase("ChemicalFingerprint") || this.type.equalsIgnoreCase("CF")) {
            this.className = new ChemicalFingerprint().getClass().getName();
            this.params = cPos != -1 ? new CFParameters(new File(this.cmdLine.getString(cPos + 1))) : new CFParameters(new CFParameters().getDefaultDocumentFrame());
            this.processCFOptions();
        } else if (this.type.equalsIgnoreCase("ReactionFingerprint") || this.type.equalsIgnoreCase("RF")) {
            this.className = new ReactionFingerprint().getClass().getName();
            this.params = cPos != -1 ? new RFParameters(new File(this.cmdLine.getString(cPos + 1))) : new RFParameters(new RFParameters().getDefaultDocumentFrame());
            this.processRFOptions();
        } else {
            MolecularDescriptor md = MolecularDescriptor.newInstance(this.type);
            this.className = md.getClass().getName();
            String paramName = md.getParametersClassName();
            try {
                Class<?> p = Class.forName(paramName);
                this.params = (MDParameters)p.newInstance();
                if (cPos != -1) {
                    this.params.fromFile(new File(this.cmdLine.getString(cPos + 1)));
                } else {
                    this.params.fromString(this.params.getDefaultDocumentFrame());
                }
                md.setParameters(this.params);
            }
            catch (MDParametersException mde) {
                if (cPos != -1) {
                    System.err.println("Check configuration file " + this.cmdLine.getString(cPos + 1));
                    System.exit(1);
                }
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
                throw new ArgumentException("Wrong name: custom MolecularDescriptor " + this.type + " is not available. Failed to access MDParameters" + " subclass " + paramName + ".");
            }
        }
    }

    private String pickCaps(String text) {
        StringBuffer caps = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if ('A' > ch || ch > 'Z') continue;
            caps.append(ch);
        }
        return caps.toString();
    }

    private void processCFOptions() throws MDGeneratorException {
        int bPos;
        int nPos;
        CFParameters p = (CFParameters)this.params;
        int fPos = this.cmdLine.find('f', "fingerprint-length", 1);
        if (fPos != -1) {
            p.setLength(this.cmdLine.getInt(fPos + 1));
        }
        if ((nPos = this.cmdLine.find('n', "pattern-length", 1)) != -1) {
            p.setBondCount(this.cmdLine.getInt(nPos + 1));
        }
        if ((bPos = this.cmdLine.find('b', "bit-count", 1)) != -1) {
            p.setBitCount(this.cmdLine.getInt(bPos + 1));
        }
    }

    private void processECFPOptions() throws MDGeneratorException {
        int nPos;
        ECFPParameters p = (ECFPParameters)this.params;
        int fPos = this.cmdLine.find('f', "fingerprint-length", 1);
        if (fPos != -1) {
            p.setLength(this.cmdLine.getInt(fPos + 1));
        }
        if ((nPos = this.cmdLine.find('n', "diameter", 1)) != -1) {
            p.setDiameter(this.cmdLine.getInt(nPos + 1));
        }
    }

    private void processShapeOptions() throws MDGeneratorException {
        ShapeParameters p = (ShapeParameters)this.params;
        int fPos = this.cmdLine.find('F', "treat-flexilble", 0);
        p.setFlexible(fPos != -1);
    }

    private void processRFOptions() throws MDGeneratorException {
        int bPos;
        int nPos;
        RFParameters p = (RFParameters)this.params;
        int fPos = this.cmdLine.find('f', "fingerprint-length", 1);
        if (fPos != -1) {
            p.setLength(this.cmdLine.getInt(fPos + 1));
        }
        if ((nPos = this.cmdLine.find('n', "pattern-length", 1)) != -1) {
            p.setBondCount(this.cmdLine.getInt(nPos + 1));
        }
        if ((bPos = this.cmdLine.find('b', "bit-count", 1)) != -1) {
            p.setBitCount(this.cmdLine.getInt(bPos + 1));
        }
    }

    private void processPFOptions() throws MDGeneratorException {
        int pPos;
        int rPos;
        int aPos;
        int bPos;
        int gPos;
        PFParameters p = (PFParameters)this.params;
        int zPos = this.cmdLine.find('z', "fuzzy", 1);
        if (zPos != -1) {
            p.setFuzzySmoothingFactor(this.cmdLine.getFloat(zPos + 1));
        }
        if ((gPos = this.cmdLine.find('G', "Gaussian-cutoff", 1)) != -1) {
            p.setFuzzyCutOff(this.cmdLine.getFloat(gPos + 1));
        }
        if ((bPos = this.cmdLine.find('B', "smoothing-bound", 1)) != -1) {
            p.setFuzzyLowerBound(this.cmdLine.getInt(bPos + 1));
        }
        if ((aPos = this.cmdLine.find('A', "asymmetrical-smoothing")) != -1) {
            p.setSymmetricalFuzzy(false);
        }
        if ((rPos = this.cmdLine.find('R', "ignore-rotomers")) != -1) {
            p.setIgnoreRotatableBonds(true);
        }
        if ((pPos = this.cmdLine.find('P', "PMAP-tag", 0, 1)) != -1) {
            p.setUsePMAP(this.cmdLine.getParamCount(pPos) == 0 ? "PMAP" : this.cmdLine.getString(pPos + 1));
        }
    }

    private void processDatabaseOptions() throws ArgumentException, SQLException, MDGeneratorException {
        String proptable;
        String passwd;
        String login;
        String url;
        if (!this.db) {
            return;
        }
        try {
            this.settingsHandler = new SettingsHandler();
            Properties presetProperties = this.settingsHandler.getSettings();
            this.dbConnectionProperties = new Properties(presetProperties);
        }
        catch (IOException exc) {
            this.dbConnectionProperties = new Properties();
        }
        String driver = this.cmdLine.getParamString('d', "driver");
        if (driver != null) {
            this.dbConnectionProperties.setProperty("connection.jdbcDriver", driver);
        }
        if ((url = this.cmdLine.getParamString('u', "dburl")) != null) {
            this.dbConnectionProperties.setProperty("connection.jdbcUrl", url);
        }
        if ((login = this.cmdLine.getParamString('l', "login")) != null) {
            this.dbConnectionProperties.setProperty("connection.login", login);
        }
        if ((passwd = this.cmdLine.getParamString('p', "password")) != null) {
            this.dbConnectionProperties.setProperty("connection.password", passwd);
        }
        if ((proptable = this.cmdLine.getParamString('O', "proptable")) != null) {
            this.dbConnectionProperties.setProperty("connection.propertyTable", proptable);
        }
        if (this.dbConnectionProperties.getProperty("connection.jdbcDriver") == null) {
            throw new ArgumentException("Missing JDBC driver");
        }
        if (this.dbConnectionProperties.getProperty("connection.jdbcUrl") == null) {
            throw new ArgumentException("Missing URL");
        }
        if (this.dbConnectionProperties.getProperty("connection.login") == null) {
            throw new ArgumentException("Missing login name");
        }
        this.connHandl = new ConnectionHandler();
        this.connHandl.loadValuesFromProperties(this.dbConnectionProperties);
        try {
            this.connHandl.connect();
            this.setConnectionHandler(this.connHandl);
        }
        catch (ClassNotFoundException e) {
            throw new ArgumentException("Invalid driver specification");
        }
        catch (InstantiationException e) {
            throw new ArgumentException("Invalid driver specification");
        }
        catch (IllegalAccessException e) {
            throw new ArgumentException("Invalid driver specification");
        }
    }

    private void saveConf() throws IOException {
        if (this.cmdLine.find('s', "saveconf") != -1) {
            this.settingsHandler.save(this.dbConnectionProperties);
        }
    }

    private void addScreeningConfig() throws SQLException, FileNotFoundException, IOException {
        try {
            this.addMDConfig(this.name, this.configNames[0], new File(this.configFileName));
            System.out.println("Configuration " + this.configNames[0] + " has been " + "added to descriptor " + this.name + ".");
        }
        catch (MDGeneratorException g) {
            System.err.println("Configuration " + this.configNames[0] + " has already been defined in the database. " + NL + "Overwriting is not allowed, remove existing" + " configuration first.");
        }
    }

    private void removeScreeningConfigs() throws SQLException, MDGeneratorException {
        for (int i = 0; i < this.configNames.length; ++i) {
            try {
                this.deleteMDConfig(this.name, this.configNames[i]);
                System.out.println("Configuration " + this.configNames[0] + " has been removed from the database. ");
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to remove configuration " + this.configNames[0] + " from database. " + NL + e.getMessage());
            }
        }
    }

    private void listScreeningConfigs() throws SQLException {
        if (this.inputTableName != null) {
            this.listScreeningConfigs(this.inputTableName);
            return;
        }
        DatabaseProperties dbProps = new DatabaseProperties(this.connHandl);
        Vector<String> strucTables = dbProps.getStructureTableNames();
        for (int i = 0; i < strucTables.size(); ++i) {
            this.listScreeningConfigs(strucTables.get(i));
        }
    }

    private void listScreeningConfigs(String tableName) throws SQLException {
        MDTableHandler mdh = new MDTableHandler(this.connHandl, tableName);
        String[] descrs = mdh.getMolecularDescriptors();
        for (int i = 0; i < descrs.length; ++i) {
            System.out.println("Structure table: " + tableName);
            System.out.println("Descriptor name: " + descrs[i]);
            System.out.println("Descriptor type: " + mdh.getMDType(descrs[i]));
            if (mdh.getMDComment(descrs[i]) != null) {
                System.out.println("Comments: " + mdh.getMDComment(descrs[i]));
            }
            System.out.println();
        }
    }

    private void processRemaining() {
        String up = this.cmdLine.getUnused();
        while (up != null) {
            System.err.println(up);
            up = this.cmdLine.getUnused();
        }
    }

    private void verboseMsg(String msg) {
        if (this.verbose) {
            System.err.print(msg);
        }
    }

    private static String[] getArgsFromXML(String[] args) throws IOException, DocumentException {
        int j;
        String xmlFileName = args[1];
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(xmlFileName));
        StringBuffer sb = new StringBuffer();
        boolean inputInXml = GenerateMD.transformInput(sb, doc);
        GenerateMD.transformOutput(sb, doc);
        GenerateMD.transformDescriptors(sb, doc);
        StringTokenizer stk = new StringTokenizer(sb.toString());
        String[] newArgs = new String[stk.countTokens() + args.length - 1];
        int i = 0;
        newArgs[i++] = "c";
        if (!inputInXml) {
            newArgs[i++] = args[2];
        }
        while (stk.hasMoreTokens()) {
            newArgs[i++] = stk.nextToken();
        }
        int n = j = inputInXml ? 2 : 3;
        while (j < args.length) {
            newArgs[i++] = args[j];
            ++j;
        }
        return newArgs;
    }

    private static boolean transformInput(StringBuffer sb, Document doc) {
        boolean genId = false;
        Element dbNode = (Element)doc.selectSingleNode("//*/Input/Database");
        boolean targetFile = false;
        Element fileInp = (Element)doc.selectSingleNode("//*/Input/File");
        if (fileInp != null) {
            sb.append(fileInp.attributeValue("Name")).append(' ');
            genId = fileInp.attributeValue("GenerateID").equals("true");
            targetFile = true;
        }
        if (genId) {
            sb.append(" -g ");
        }
        if (!targetFile) {
            GenerateMD.append(sb, dbNode, "StructureTableName", "-a");
            GenerateMD.appendOptional(sb, dbNode, "Restrict", "-q");
            GenerateMD.appendOptional(sb, dbNode, "Driver", "-d");
            GenerateMD.appendOptional(sb, dbNode, "URL", "-u");
            GenerateMD.appendOptional(sb, dbNode, "LoginName", "-l");
            GenerateMD.appendOptional(sb, dbNode, "Password", "-p");
        }
        return targetFile;
    }

    private static void transformOutput(StringBuffer sb, Document doc) {
        Element out = (Element)doc.selectSingleNode("//*/Output");
        if (out == null) {
            return;
        }
        GenerateMD.appendOptional(sb, out, "SDFOutput", "-S");
        GenerateMD.appendOptional(sb, out, "FileName", "-o");
        if (out.attributeValue("DecimalFormat") != null && out.attributeValue("DecimalFormat").equals("true")) {
            sb.append(" -D ");
        }
    }

    private static void transformDescriptors(StringBuffer sb, Document doc) {
        Element descr = (Element)doc.selectSingleNode("//*/Descriptor");
        GenerateMD.append(sb, descr, "Type", "-k");
        GenerateMD.appendOptional(sb, descr, "Name", "");
        GenerateMD.appendOptional(sb, descr, "Comment", "");
        GenerateMD.append(sb, descr, "ConfigFile", "-c");
        GenerateMD.appendOptional(sb, descr, "UseTag", "-t");
        GenerateMD.appendOptional(sb, descr, "PMAPTag", "-P");
        GenerateMD.appendOptional(sb, descr, "FuzzySmoothingFactor", "-z");
        GenerateMD.appendOptional(sb, descr, "GaussianCutoff", "-G");
        GenerateMD.appendOptional(sb, descr, "SmoothingBound", "-B");
        GenerateMD.appendOptional(sb, descr, "AsymmetricalSmoothing", "-A");
        GenerateMD.appendOptional(sb, descr, "IgnoreRotatableBonds", "-R");
    }

    private static void append(StringBuffer sb, Element n, String attr, String flag) {
        sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
    }

    private static void appendOptional(StringBuffer sb, Element n, String attr, String flag) {
        if (n.attributeValue(attr) != null) {
            sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
        }
    }

    private static String getDescriptorName(String fileName) {
        String dn = fileName.substring(fileName.lastIndexOf(FileSep) + 1);
        if (dn.lastIndexOf(46) != -1) {
            return dn.substring(0, dn.lastIndexOf(46));
        }
        return dn;
    }
}

