/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CDParameters;
import chemaxon.descriptors.InHouseFingerprint;
import chemaxon.descriptors.InHouseGeneratorParser;
import chemaxon.descriptors.MDParametersException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

public class IHParameters
extends CDParameters {
    private static final String DEFAULT_FILENAME = "inHouse.smiles";
    private InHouseGeneratorParser parser;
    private String command;
    private String workDir;
    private boolean useStdInp;
    private String smilesTMPFile;

    public IHParameters() {
        this.init();
    }

    public IHParameters(int type) {
        super(type);
    }

    public IHParameters(File configFile) {
        super(configFile);
    }

    @Override
    protected void init() {
        this.md = new InHouseFingerprint();
        this.smilesTMPFile = DEFAULT_FILENAME;
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        this.command = this.parameters.attributeValue("command");
        this.workDir = this.parameters.attributeValue("workDir", ".");
        String p = this.parameters.attributeValue("parser", "chemaxon.descriptors.InHouseDefaultParser");
        try {
            this.parser = (InHouseGeneratorParser)Class.forName(p).newInstance();
        }
        catch (InstantiationException ex) {
            throw new MDParametersException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new MDParametersException(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new MDParametersException(ex.getMessage());
        }
        this.useStdInp = this.parameters.attributeValue("sinp", "yes").equalsIgnoreCase("yes");
        super.readValues(all);
    }

    @Override
    protected void initParameters() {
        if (this.data == null || this.data.length * 8 != this.length) {
            super.initParameters();
        }
    }

    public IHParameters(String XMLconfig) {
        super(XMLconfig);
    }

    public InHouseGeneratorParser getParser() {
        return this.parser;
    }

    @Override
    public String getDefaultDocumentFrame() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<InHouseFingerprintConfiguration>\n<Parameters parser=\"chemaxon.descriptors.GenerateMDParser\" workDir=\".\" command=\"generatemdstdin.bat \" sinp=\"yes\" Type=\"BINARY\"  Length=\"512\"/>\n<ScreeningConfiguration>\n   <ParametrizedMetrics>\n        <ParametrizedMetric Name=\"Tanimoto\" ActiveFamily=\"Generic\"\n             Metric=\"Tanimoto\" Threshold=\"0.2\"/>\n        <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\"\n             Metric=\"Euclidean\" Threshold=\"10\"/>\n        <ParametrizedMetric Name=\"Tversky\" ActiveFamily=\"Generic\"\n             Metric=\"Tversky\" Threshold=\"0.5\" TverskyAlpha=\"1\" TverskyBeta=\"1\"/>\n        <ParametrizedMetric Name=\"UnityTversky\" ActiveFamily=\"Generic\"\n             Metric=\"Tversky\" Threshold=\"0.5\" TverskyAlpha=\"0.\" TverskyBeta=\"0.\"/>\n   </ParametrizedMetrics>\n</ScreeningConfiguration>\n</InHouseFingerprintConfiguration>\n";
    }

    public boolean isUseStdInp() {
        return this.useStdInp;
    }

    public void setReader(BufferedReader b) throws IOException {
        this.parser.setReader(b);
    }

    public String getSmilesTMPFile() {
        return this.smilesTMPFile;
    }

    public void setSmilesTMPFile(String smilesTMPFile) {
        this.smilesTMPFile = smilesTMPFile;
    }

    public String getCommand() {
        return this.command;
    }

    public String getWorkDir() {
        return this.workDir;
    }
}

