/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CustomDescriptor;
import chemaxon.descriptors.IHParameters;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InHouseFingerprint
extends CustomDescriptor {
    private static Logger logger = Logger.getLogger(InHouseFingerprint.class.getName());

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.IHParameters";
    }

    @Override
    public String getName() {
        return "In house generated molecular descriptor";
    }

    @Override
    public String getShortName() {
        return "IH";
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        return this.generate(m.toFormat("smiles"));
    }

    public int[][] generate(String[] molStr) throws MDGeneratorException {
        IHParameters p = (IHParameters)this.params;
        try {
            int[][] ret = new int[molStr.length][];
            if (!p.isUseStdInp()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(p.getSmilesTMPFile()));
                for (int i = 0; i < molStr.length; ++i) {
                    out.write(molStr[i] + "\n");
                }
                out.close();
            }
            Process proc = Runtime.getRuntime().exec(p.getCommand(), null, new File(p.getWorkDir()));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            if (p.isUseStdInp()) {
                OutputStream os = proc.getOutputStream();
                PrintStream ps2 = new PrintStream(os);
                for (int i = 0; i < molStr.length; ++i) {
                    ps2.println(molStr[i] + "\n");
                }
                ps2.close();
            }
            if (proc.exitValue() != 0) {
                String s = "";
                while ((s = stdout.readLine()) != null) {
                    logger.severe(s);
                }
                logger.severe("");
                BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((s = stderr.readLine()) != null) {
                    logger.severe(s);
                }
                throw new MDGeneratorException("Abnormal termination of the external generator: " + proc.exitValue());
            }
            p.setReader(stdout);
            if (p.descrType == 0) {
                int i = 0;
                while ((this.intDescr = (int[])p.getParser().readLine()) != null) {
                    ret[i++] = MolGeom.arrayCopy(this.intDescr);
                }
                p.setLength(this.intDescr.length * 32);
                return ret;
            }
            throw new MDGeneratorException("Only binary descriptor can be generated in batch.");
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new MDGeneratorException(ex.getMessage());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new MDGeneratorException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] generate(String molStr) throws MDGeneratorException {
        IHParameters p = (IHParameters)this.params;
        try {
            if (!p.isUseStdInp()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(p.getSmilesTMPFile()));
                out.write(molStr + "\n");
                out.close();
            }
            Process proc = Runtime.getRuntime().exec(p.getCommand(), null, new File(p.getWorkDir()));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            try {
                if (p.isUseStdInp()) {
                    OutputStream os = proc.getOutputStream();
                    PrintStream ps2 = new PrintStream(os);
                    ps2.println(molStr);
                    ps2.close();
                }
                p.setReader(stdout);
                if (p.descrType == 0) {
                    this.intDescr = (int[])p.getParser().readLine();
                    p.setLength(this.intDescr.length * 32);
                }
                if (p.descrType == 1) {
                    this.intDescr = (int[])p.getParser().readLine();
                    p.setLength(this.intDescr.length);
                }
                if (p.descrType == 2) {
                    this.floatDescr = (float[])p.getParser().readLine();
                    p.setLength(this.floatDescr.length);
                }
                p.initParameters();
                proc.waitFor();
                if (proc.exitValue() != 0) {
                    String s = "";
                    while ((s = stdout.readLine()) != null) {
                        logger.severe(s);
                    }
                    BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    while ((s = stderr.readLine()) != null) {
                        logger.severe(s);
                    }
                    throw new MDGeneratorException("Abnormal termination of the external generator: " + proc.exitValue());
                }
            }
            finally {
                stdout.close();
            }
        }
        catch (NumberFormatException ex) {
            logger.log(Level.SEVERE, null, ex);
            logger.log(Level.SEVERE, p.getParser().getLastLine());
            throw new MDGeneratorException(ex.getMessage());
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new MDGeneratorException(ex.getMessage());
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, null, ex);
            logger.log(Level.SEVERE, p.getParser().getLastLine());
            throw new MDGeneratorException(ex.getMessage());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new MDGeneratorException(ex.getMessage());
        }
        return null;
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            this.params = new IHParameters(parameters);
            this.params.fromString(parameters);
        } else {
            this.params.fromString(parameters);
        }
        if (((IHParameters)this.params).getDescrType() == 2) {
            if (this.floatDescr == null || this.floatDescr.length < this.params.getLength()) {
                this.floatDescr = new float[this.params.getLength()];
            }
        } else if (this.intDescr == null || this.intDescr.length < this.params.getInternalSize()) {
            this.intDescr = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    public static void main(String[] args) {
        IHParameters ip = new IHParameters("");
        InHouseFingerprint ihp = new InHouseFingerprint();
        ihp.setParameters(ip);
        try {
            String smiles = "CCCCCC";
            ihp.generate(smiles);
            MolGeom.wr(ihp.intDescr);
            ihp.toData();
        }
        catch (MDGeneratorException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

