/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import java.util.ArrayList;

public class MDArrayReader
extends MDReader {
    private MDSet[] elements = null;
    private int nextElement = 0;

    public MDArrayReader(MDSet[] elements) {
        this.elements = elements;
        this.nextElement = 0;
    }

    public MDArrayReader(MDReader reader) throws MDReaderException {
        ArrayList<MDSet> readerElements = new ArrayList<MDSet>();
        boolean wasCloned = reader.getCloneResult();
        reader.setCloneResult(true);
        MDSet c = reader.next();
        while (c != null) {
            readerElements.add(c);
            c = reader.next();
        }
        reader.setCloneResult(wasCloned);
        this.elements = new MDSet[readerElements.size()];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = (MDSet)readerElements.get(i);
        }
        this.mdSet = reader.mdSet;
        this.nextElement = 0;
        this.cloneResult = reader.cloneResult;
    }

    @Override
    public void reset() throws MDReaderException {
        super.reset();
        this.nextElement = 0;
    }

    @Override
    public MDSet next() throws MDReaderException {
        MDSet mds = this.cloneResult ? (MDSet)this.mdSet.clone() : this.mdSet;
        mds.setId(this.id);
        if (this.generateId) {
            ++this.id;
        }
        if (this.nextElement == this.elements.length) {
            return null;
        }
        MDSet toCopy = this.elements[this.nextElement++];
        for (int d = 0; d < toCopy.size(); ++d) {
            mds.setDescriptor(d, toCopy.getDescriptor(d));
        }
        return mds;
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public void close() throws MDReaderException {
        this.nextElement = 0;
    }
}

