/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.common.util.IntVector;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MDDBReader
extends MDReader {
    private static final Logger logger = Logger.getLogger(MDDBReader.class.getName());
    private Connection con;
    private final ConnectionHandler conh;
    Statement stmt = null;
    private ResultSet rs;
    private String sql;
    private String strucTableName = null;
    private int lastId = -1;
    private String[] mdNames = null;
    private int descriptorCount = 0;
    private boolean initialized = false;
    private String query = null;
    private IntVector filter = null;
    private int[] filterIDList = null;
    private boolean filterIDsSorted = false;
    private int dbms;
    private IntVector mysql_id;
    private int mysqlPos = 0;
    private boolean indexTable = false;
    private static final int MYSQL_BATCH_SIZE = 500;

    @Deprecated
    public MDDBReader(ConnectionHandler ch, String strucTableName, MDSet mdSet, String sqlCondition) {
        this(strucTableName, ch, mdSet, sqlCondition != null && sqlCondition.length() > 0 ? "SELECT cd_id from " + strucTableName + " where " + sqlCondition : null);
    }

    public MDDBReader(String strucTableName, ConnectionHandler ch, MDSet mdSet, String query) {
        this.generateDescriptor = true;
        this.conh = ch;
        this.strucTableName = strucTableName;
        this.mdSet = mdSet;
        this.query = query;
    }

    @Deprecated
    public MDDBReader(ConnectionHandler ch, String strucTableName, String[] mdNames, String sqlCondition) {
        this(strucTableName, ch, mdNames, sqlCondition != null && sqlCondition.length() > 0 ? "SELECT cd_id from " + strucTableName + " where " + sqlCondition : null);
    }

    public MDDBReader(String strucTableName, ConnectionHandler ch, String[] mdNames, String query) {
        this(strucTableName, ch, mdNames, query, null, false);
    }

    public MDDBReader(String strucTableName, ConnectionHandler ch, String[] mdNames, String query, int[] filterIDList, boolean indexTable) {
        this.generateDescriptor = false;
        this.conh = ch;
        this.strucTableName = strucTableName;
        this.mdNames = mdNames;
        this.query = query;
        this.filterIDList = filterIDList;
        this.indexTable = indexTable;
    }

    private void initFiltering(StringBuffer sb) throws SQLException {
        if (this.query == null || this.query.length() == 0) {
            return;
        }
        boolean subselect = DatabaseOptions.isSubselectSupported(this.con);
        if (subselect) {
            if (this.generateDescriptor) {
                sb.append(" where ");
            } else {
                sb.append(" and ");
            }
            sb.append(this.strucTableName + ".cd_id in (" + this.query + ")");
        } else {
            this.fillFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillFilter() throws SQLException {
        this.filter = new IntVector();
        Statement stmt = this.con.createStatement();
        try {
            DatabaseOptions.setFetchSize(stmt, 2000, this.dbms);
            ResultSet rs = stmt.executeQuery(this.query);
            try {
                while (rs.next()) {
                    this.filter.addElement(rs.getInt(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    private void init() throws SQLException {
        this.con = this.conh.getConnection();
        this.dbms = DatabaseOptions.getDBMSType(this.con);
        if (this.dbms == 3) {
            this.initMySQL();
            return;
        }
        StringBuffer select = null;
        select = this.getSelect(true);
        this.initFiltering(select);
        if (this.filterIDList != null && !this.filterIDsSorted) {
            Arrays.sort(this.filterIDList);
            this.filterIDsSorted = true;
        }
        this.sql = select.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMySQL() throws SQLException {
        StringBuffer select = null;
        if (this.generateDescriptor) {
            this.descriptorCount = this.mdSet.size();
            select = new StringBuffer("SELECT cd_id FROM " + this.strucTableName);
        } else {
            select = this.getSelect(false);
        }
        this.initFiltering(select);
        String sql = select.toString();
        Statement stmt = this.con.createStatement();
        try {
            DatabaseOptions.setFetchSize(stmt, 1000, this.dbms);
            ResultSet rs = stmt.executeQuery(sql);
            try {
                this.mysql_id = new IntVector();
                while (rs.next()) {
                    this.mysql_id.addElement(rs.getInt(1));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    private StringBuffer getSelect(boolean includeData) {
        StringBuffer select = new StringBuffer();
        if (this.generateDescriptor) {
            this.descriptorCount = this.mdSet.size();
            select = new StringBuffer("SELECT cd_id, cd_structure FROM " + this.strucTableName);
        } else {
            String tableName;
            int i;
            this.descriptorCount = this.mdNames.length;
            select.append("select ").append(this.strucTableName).append(".CD_ID");
            if (includeData) {
                for (i = 0; i < this.descriptorCount; ++i) {
                    tableName = MDTableHandler.getMDTableName(this.strucTableName, this.mdNames[i]);
                    select.append(',').append(tableName).append(".MD_DATA");
                }
            }
            select.append(" from ").append(this.strucTableName);
            for (i = 0; i < this.descriptorCount; ++i) {
                tableName = MDTableHandler.getMDTableName(this.strucTableName, this.mdNames[i]);
                select.append(',').append(tableName);
            }
            select.append(" where ");
            for (i = 0; i < this.descriptorCount; ++i) {
                if (i != 0) {
                    select.append(" and ");
                }
                tableName = MDTableHandler.getMDTableName(this.strucTableName, this.mdNames[i]);
                select.append(this.strucTableName).append(".CD_ID=").append(tableName).append(".CD_ID");
            }
        }
        return select;
    }

    @Override
    public MDSet getMDSet() {
        if (this.mdSet == null) {
            try {
                this.createMDSet();
            }
            catch (SQLException e) {
                this.mdSet = null;
            }
        }
        return this.mdSet;
    }

    @Override
    public void reset() throws MDReaderException {
        super.reset();
        if (this.rs != null) {
            try {
                this.rs.close();
                this.stmt.close();
                this.rs = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new MDReaderException(e.getMessage());
            }
        }
        this.mysqlPos = 0;
    }

    private void createMDSet() throws SQLException {
        MDTableHandler mdth = new MDTableHandler(this.conh, this.strucTableName, this.indexTable);
        this.mdSet = mdth.createMDSet(this.mdNames);
    }

    @Override
    public MDSet next() throws MDReaderException {
        try {
            if (!this.initialized) {
                this.init();
                this.initialized = true;
            }
            if (this.mdSet == null) {
                this.createMDSet();
            }
            if (this.rs == null) {
                if (this.dbms != 3) {
                    this.stmt = this.con.createStatement();
                    DatabaseOptions.setFetchSize(this.stmt, 2000, this.dbms);
                    this.rs = this.stmt.executeQuery(this.sql);
                } else if (!this.getNextRSForMySQL()) {
                    return null;
                }
            }
            int currentId = -1;
            do {
                if (!this.rs.next()) {
                    if (this.dbms != 3) {
                        return null;
                    }
                    if (!this.getNextRSForMySQL()) {
                        return null;
                    }
                    if (!this.rs.next()) {
                        return null;
                    }
                }
                currentId = this.rs.getInt(1);
            } while (this.filter != null && !this.filter.contains(currentId) || this.filterIDList != null && Arrays.binarySearch(this.filterIDList, currentId) < 0);
            if (this.generateId) {
                currentId = this.id++;
            }
            this.mdSet.setId(currentId);
            this.lastId = currentId;
            if (!this.generateDescriptor) {
                byte[][] data = new byte[this.descriptorCount][];
                for (int x = 0; x < this.descriptorCount; ++x) {
                    data[x] = this.rs.getBytes(x + 2);
                }
                for (int i = 0; i < this.descriptorCount; ++i) {
                    MolecularDescriptor md = this.mdSet.getDescriptor(i);
                    md.fromData(data[i]);
                    this.lastReadMolecule = null;
                }
            } else {
                Molecule mol = new RgMolecule();
                try {
                    mol = MolImporter.importMol(DatabaseTools.readBytes(this.rs, 2));
                    this.lastReadMolecule = (Molecule)mol.clone();
                }
                catch (MolFormatException e) {
                    e.printStackTrace();
                    throw new MDReaderException(e.getMessage());
                }
                for (int i = 0; i < this.descriptorCount; ++i) {
                    MolecularDescriptor md = this.mdSet.getDescriptor(i);
                    try {
                        md.generate(mol);
                        continue;
                    }
                    catch (MDGeneratorException e) {
                        e.printStackTrace();
                        throw new MDReaderException(e.getMessage());
                    }
                }
            }
            return this.cloneResult ? (MDSet)this.mdSet.clone() : this.mdSet;
        }
        catch (SQLException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Error", e);
            }
            throw new MDReaderException(e.getMessage(), e);
        }
    }

    private boolean getNextRSForMySQL() throws SQLException {
        StringBuffer select = this.getSelect(true);
        if (!this.appendNextBatch(select)) {
            return false;
        }
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = this.con.createStatement();
        this.rs = this.stmt.executeQuery(select.toString());
        return true;
    }

    private boolean appendNextBatch(StringBuffer select) {
        int max = this.mysql_id.size();
        if (this.mysqlPos == max) {
            return false;
        }
        if (this.generateDescriptor) {
            select.append(" WHERE ");
        } else {
            select.append(" AND ");
        }
        select.append(this.strucTableName + ".cd_id IN (");
        int end = this.mysqlPos + 500;
        if (end > max) {
            end = max;
        }
        while (this.mysqlPos < end) {
            select.append(this.mysql_id.elementAt(this.mysqlPos) + ",");
            ++this.mysqlPos;
        }
        select.setLength(select.length() - 1);
        select.append(")");
        return true;
    }

    @Override
    public Molecule getMolecule() throws MDReaderException {
        if (this.lastReadMolecule != null) {
            return this.lastReadMolecule;
        }
        if (this.lastId != -1) {
            return this.getMolecule(this.lastId);
        }
        return null;
    }

    public int getLastID() throws MDReaderException {
        return this.lastId;
    }

    /*
     * Exception decompiling
     */
    private Molecule getMolecule(int id) throws MDReaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws MDReaderException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new MDReaderException(e.getMessage());
        }
    }
}

