/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSetParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.StringTokenizer;

public class MDFileReader
extends MDReader {
    private String[] inputFileNames = null;
    private BufferedReader[] inputs = null;
    private boolean moleculeReader;
    private InputStream molInput = null;
    private MolImporter molImp = null;
    private boolean keepOriginalMolecule = false;

    public MDFileReader(String inputFileName) throws MDReaderException {
        this.inputFileNames = new String[1];
        this.inputFileNames[0] = inputFileName;
        this.inputs = new BufferedReader[1];
        this.setInput(0);
        this.createMDSet(1);
    }

    public MDFileReader(String[] inputFileNames) throws MDReaderException {
        this.inputFileNames = inputFileNames;
        this.inputs = new BufferedReader[inputFileNames.length];
        for (int i = 0; i < this.inputFileNames.length; ++i) {
            this.setInput(i);
        }
        this.createMDSet(this.inputFileNames.length);
        this.moleculeReader = false;
    }

    public MDFileReader(String inputFileName, MDSet mdSet) throws MDReaderException {
        super(mdSet);
        this.inputFileNames = new String[1];
        this.inputFileNames[0] = inputFileName;
        try {
            this.molInput = new BufferedInputStream(new FileInputStream(inputFileName));
            this.molImp = new MolImporter(new MolInputStream(this.molInput));
            this.moleculeReader = true;
        }
        catch (IOException ioe) {
            throw new MDReaderException(ioe.getMessage());
        }
    }

    public MDFileReader(InputStream inputFile, MDSet mdSet) throws MDReaderException {
        super(mdSet);
        this.molInput = inputFile;
        try {
            this.molImp = new MolImporter(new MolInputStream(this.molInput));
            this.moleculeReader = true;
        }
        catch (IOException ieo) {
            throw new MDReaderException("Failed to read file." + ieo.getMessage());
        }
    }

    public void setKeepOriginalMolecule(boolean keep) {
        this.keepOriginalMolecule = keep;
    }

    @Override
    public Molecule getMolecule() throws MDReaderException {
        return this.lastReadMolecule;
    }

    @Override
    public void reset() throws MDReaderException {
        super.reset();
        if (this.moleculeReader) {
            if (this.inputFileNames == null) {
                throw new MDReaderException("Error in MDFileReader.reset(): Standardinput cannot be reset.");
            }
            try {
                this.molInput = new BufferedInputStream(new FileInputStream(this.inputFileNames[0]));
                this.molImp = new MolImporter(new MolInputStream(this.molInput));
            }
            catch (IOException ioe) {
                throw new MDReaderException("Error in MDFileReader.reset(): " + ioe.getMessage());
            }
            return;
        }
        for (int i = 0; i < this.inputFileNames.length; ++i) {
            if (this.inputFileNames[i] == null) {
                throw new MDReaderException("Error in MDFileReader.reset(). Standard input cannot be reset.");
            }
            this.setInput(i);
        }
    }

    @Override
    public MDSet next() throws MDReaderException {
        MDSet mds;
        MDSet mDSet = mds = this.cloneResult ? (MDSet)this.mdSet.clone() : this.mdSet;
        if (this.generateId) {
            mds.setId(this.id);
            ++this.id;
        }
        if (this.moleculeReader) {
            return this.readFromMolecule(mds) ? mds : null;
        }
        return this.readFromDescriptors(mds) ? mds : null;
    }

    private boolean readFromDescriptors(MDSet mds) throws MDReaderException {
        String line = null;
        try {
            for (int ci = 0; ci < mds.size(); ++ci) {
                line = this.inputs[ci].readLine();
                if (line == null) {
                    return false;
                }
                StringTokenizer st = new StringTokenizer(line, " ");
                String dsStr = st.nextToken();
                this.id = Integer.parseInt(dsStr);
                mds.setId(this.id);
                String string = dsStr = st.hasMoreTokens() ? st.nextToken("\n") : null;
                if (dsStr == null) continue;
                mds.getDescriptor(ci).fromString(dsStr);
            }
            return true;
        }
        catch (IOException ieo) {
            throw new MDReaderException("Failed to fetch next line in MDFileReader. Corrupt file? " + ieo.getMessage());
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new MDReaderException("Failed to parse descriptor: " + pe.getMessage() + ", in line: " + line);
        }
    }

    private boolean readFromMolecule(MDSet mds) throws MDReaderException {
        try {
            Molecule mol = this.molImp.read();
            if (mol == null) {
                return false;
            }
            if (mol instanceof RgMolecule) {
                mol = ((RgMolecule)mol).getRoot();
            }
            if (this.keepOriginalMolecule) {
                this.lastReadMolecule = (Molecule)mol.clone();
            }
            for (int i = 0; i < mds.size(); ++i) {
                MolecularDescriptor md = mds.getDescriptor(i);
                if (i < this.takeTags.size() && this.takeTags.get(i) != null && mol.getProperty((String)this.takeTags.get(i)) != null) {
                    md.fromString(mol.getProperty((String)this.takeTags.get(i)));
                    continue;
                }
                String[] newTags = md.generate(mol);
                if (this.lastReadMolecule == null || newTags == null) continue;
                for (int ti = 0; ti < newTags.length; ++ti) {
                    this.lastReadMolecule.setProperty(newTags[ti], mol.getProperty(newTags[ti]));
                }
            }
            if (this.idTagName != null) {
                mds.setNaturalId(mol.getProperty(this.idTagName));
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new MDReaderException("I/O error in MDMolFileReader.next(): " + ioe.getMessage());
        }
        catch (MDGeneratorException gene) {
            gene.printStackTrace();
            throw new MDReaderException("Error in MDMolFileReader.next(), reason: " + gene.getMessage());
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new MDReaderException("Invalid tag format in SDfile");
        }
    }

    @Override
    public void close() throws MDReaderException {
        try {
            if (this.moleculeReader) {
                this.molImp.close();
            } else {
                for (int i = 0; i < this.inputs.length; ++i) {
                    if (this.inputFileNames[i] == null) continue;
                    this.inputs[i].close();
                }
            }
        }
        catch (IOException ieo) {
            throw new MDReaderException("Failed to close input file in MDFileReader. " + ieo.getMessage());
        }
    }

    private void setInput(int componentIndex) throws MDReaderException {
        try {
            this.inputs[componentIndex] = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(this.inputFileNames[componentIndex]))));
        }
        catch (FileNotFoundException fnf) {
            throw new MDReaderException("File " + this.inputFileNames[componentIndex] + " not found ");
        }
        catch (IOException ieo) {
            throw new MDReaderException("Failed to read file " + this.inputFileNames[componentIndex] + ". Corrupt file? " + ieo.getMessage());
        }
    }

    private void createMDSet(int nComponents) throws MDReaderException {
        this.mdSet = new MDSet(nComponents);
        this.mdSet.setParameters(new MDSetParameters(nComponents));
        for (int i = 0; i < this.mdSet.size(); ++i) {
            try {
                String type = this.inputs[i].readLine();
                String param = this.inputs[i].readLine();
                param = StringUtil.replaceString(param, "\\n", "\n");
                this.createMDSetComponent(i, type, param);
                continue;
            }
            catch (IOException io) {
                if (this.inputFileNames != null) {
                    throw new MDReaderException("Error reading file " + this.inputFileNames[i] + ". " + io.getMessage());
                }
                throw new MDReaderException("Error reading standard input. " + io.getMessage());
            }
            catch (MDParametersException p) {
                throw new MDReaderException("Bad configuration: " + p.getMessage());
            }
        }
    }
}

