/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDWriter;
import chemaxon.descriptors.MDWriterException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import chemaxon.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MDFileWriter
extends MDWriter {
    private MDSet mdSet = null;
    private PrintStream[] out = null;
    private boolean headersWritten = false;
    private boolean sdfOutput = false;
    private boolean decimalOutputFormat = false;
    private boolean binaryOutputFormat = false;
    private boolean printId = false;

    public MDFileWriter(String[] descrNames, String[] types, MDParameters[] settings) throws MDWriterException {
        super(descrNames.length);
        this.mdSet = new MDSet(descrNames.length);
        this.out = new PrintStream[descrNames.length];
        for (int i = 0; i < descrNames.length; ++i) {
            this.setComponent(i, descrNames[i], types[i], settings[i]);
        }
    }

    public MDFileWriter(String[] descrNames, String[] types, String[] settings) throws MDWriterException {
        super(descrNames.length);
        this.mdSet = new MDSet(descrNames.length);
        this.out = new PrintStream[descrNames.length];
        for (int i = 0; i < descrNames.length; ++i) {
            this.setComponent(i, descrNames[i], types[i], settings[i]);
        }
    }

    public MDFileWriter(int nComponents) {
        super(nComponents);
        this.mdSet = new MDSet(nComponents);
        this.out = new PrintStream[nComponents];
    }

    public MDFileWriter(String descrName, String type, MDParameters settings) throws MDWriterException {
        super(1);
        this.mdSet = new MDSet(1);
        this.out = new PrintStream[1];
        this.setComponent(0, descrName, type, settings);
    }

    public MDFileWriter(String descrName, String type, String settings) throws MDWriterException {
        super(1);
        this.mdSet = new MDSet(1);
        this.out = new PrintStream[1];
        this.setComponent(0, descrName, type, settings);
    }

    public MDFileWriter(String SDfileName, int nComponents) {
        super(nComponents);
        this.mdSet = new MDSet(nComponents);
        this.sdfOutput = true;
        this.out = new PrintStream[1];
        try {
            this.out[0] = SDfileName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(SDfileName))) : System.out;
        }
        catch (FileNotFoundException fnf) {
            this.out[0] = System.out;
        }
    }

    public MDFileWriter(String SDfileName, String[] descrNames, String[] types, MDParameters[] settings) {
        super(descrNames.length);
        this.mdSet = new MDSet(descrNames.length);
        for (int i = 0; i < descrNames.length; ++i) {
            this.setMDSetComponent(i, descrNames[i], types[i], settings[i]);
        }
        this.sdfOutput = true;
        this.out = new PrintStream[1];
        try {
            this.out[0] = SDfileName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(SDfileName))) : System.out;
        }
        catch (FileNotFoundException fnf) {
            this.out[0] = System.out;
        }
    }

    public MDFileWriter(String SDfileName, String[] descrNames, String[] types, String[] settings) {
        super(descrNames.length);
        this.mdSet = new MDSet(descrNames.length);
        for (int i = 0; i < descrNames.length; ++i) {
            this.setMDSetComponent(i, descrNames[i], types[i], settings[i]);
        }
        this.sdfOutput = true;
        this.out = new PrintStream[1];
        try {
            this.out[0] = SDfileName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(SDfileName))) : System.out;
        }
        catch (FileNotFoundException fnf) {
            this.out[0] = System.out;
        }
    }

    public void setDecimalOutputFormat(boolean decimalOutputFormat) {
        this.decimalOutputFormat = decimalOutputFormat;
    }

    public void setBinaryOutputFormat(boolean binaryOutputFormat) {
        this.binaryOutputFormat = binaryOutputFormat;
    }

    public void setComponent(int index, String descrName, String type, MDParameters settings) {
        this.setMDSetComponent(index, descrName, type, settings);
        if (!this.sdfOutput) {
            try {
                this.out[index] = descrName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(descrName))) : System.out;
            }
            catch (FileNotFoundException fnf) {
                this.out[index] = System.out;
            }
        }
    }

    public void setComponent(int index, String descrName, String type, String settings) {
        this.setMDSetComponent(index, descrName, type, settings);
        if (!this.sdfOutput) {
            try {
                this.out[index] = descrName != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(descrName))) : System.out;
            }
            catch (FileNotFoundException fnf) {
                this.out[index] = System.out;
            }
        }
    }

    public void setPrintId(boolean printId) {
        this.printId = printId;
    }

    @Override
    public MDParameters getMDParameters(int id) {
        return this.mdSet.getDescriptor(id).getParameters();
    }

    public MDSet getMDSet() {
        return this.mdSet;
    }

    public void put(MDSet ds) throws MDWriterException {
        if (!(this.headersWritten || this.decimalOutputFormat || this.binaryOutputFormat)) {
            this.writeHeaders(ds);
        }
        for (int i = 0; i < ds.size(); ++i) {
            if (this.decimalOutputFormat || this.binaryOutputFormat) {
                if (this.printId) {
                    if (ds.getNaturalId() != null) {
                        this.out[i].print(ds.getNaturalId() + "\t");
                    } else {
                        this.out[i].print(ds.getId() + "\t");
                    }
                }
                if (this.decimalOutputFormat) {
                    this.out[i].println(ds.getDescriptor(i).toDecimalString());
                    continue;
                }
                this.out[i].println(ds.getDescriptor(i).toBinaryString());
                continue;
            }
            this.out[i].print(ds.getId() + " ");
            this.out[i].println(ds.getDescriptor(i).toString());
        }
        this.mdSet = (MDSet)ds.clone();
    }

    @Override
    public void put(Molecule mol, int id) throws MDWriterException {
        try {
            this.mdSet.generate(mol);
        }
        catch (MDGeneratorException g) {
            this.put(this.mdSet);
            throw new MDWriterException(g.getMessage());
        }
        this.mdSet.setId(id);
        if (this.sdfOutput) {
            for (int i = 0; i < this.mdSet.size(); ++i) {
                mol.setProperty(this.mdNames[i], this.mdSet.getDescriptor(i).toString());
            }
            this.out[0].print(mol.toFormat("sdf"));
        } else {
            this.put(this.mdSet);
        }
    }

    public void put(Molecule mol, String naturalId) throws MDWriterException {
        try {
            this.mdSet.generate(mol);
        }
        catch (MDGeneratorException g) {
            this.put(this.mdSet);
            throw new MDWriterException(g.getMessage());
        }
        this.mdSet.setNaturalId(naturalId);
        if (this.sdfOutput) {
            for (int i = 0; i < this.mdSet.size(); ++i) {
                mol.setProperty(this.mdNames[i], this.mdSet.getDescriptor(i).toString());
            }
            this.out[0].print(mol.toFormat("sdf"));
        } else {
            this.put(this.mdSet);
        }
    }

    @Override
    public void close() throws MDWriterException {
        for (int i = 0; i < this.out.length; ++i) {
            if (this.out[i] == System.out) continue;
            this.out[i].close();
        }
    }

    private void setMDSetComponent(int index, String descrName, String type, String settings) throws MDParametersException {
        MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
        descriptor.setParameters(settings);
        this.mdSet.setDescriptor(index, descriptor);
        this.mdNames[index] = descrName;
    }

    private void setMDSetComponent(int index, String descrName, String type, MDParameters settings) {
        MolecularDescriptor descriptor = MolecularDescriptor.newInstance(type);
        descriptor.setParameters(settings);
        this.mdSet.setDescriptor(index, descriptor);
        this.mdNames[index] = descrName;
    }

    private void writeHeaders(MDSet ds) {
        for (int i = 0; i < ds.size(); ++i) {
            this.out[i].println(ds.getDescriptor(i).getClass().getName());
            String param = ds.getDescriptor(i).getParameters().toString();
            param = StringUtil.replaceString(param, "\\n", "\\N");
            param = StringUtil.convertToUNIXStyle(param);
            param = StringUtil.replaceString(param, "\n", "\\n");
            this.out[i].println(param);
        }
        this.headersWritten = true;
    }
}

