/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDAvgHypothesisGenerator;
import chemaxon.descriptors.MDFileReader;
import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDMedHypothesisGenerator;
import chemaxon.descriptors.MDMinHypothesisGenerator;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import java.io.File;

public class MDHypothesisCreator {
    public static final String[] typeNames = new String[]{"Minimum", "Average", "Median"};
    public static final String defaultTypeName = "Minimum";

    public static final MDHypothesisGenerator create(String hypothesisTypeName) {
        if (hypothesisTypeName.equals(defaultTypeName) || hypothesisTypeName.equals("Min")) {
            return new MDMinHypothesisGenerator();
        }
        if (hypothesisTypeName.equals("Average") || hypothesisTypeName.equals("Avg")) {
            return new MDAvgHypothesisGenerator();
        }
        if (hypothesisTypeName.equals("Median") || hypothesisTypeName.equals("Med")) {
            return new MDMedHypothesisGenerator();
        }
        throw new IllegalArgumentException("Unknown hypothesis type name");
    }

    public static void main(String[] args) {
        try {
            MDSet ms = new MDSet(1);
            PFParameters par = new PFParameters(new File(args[0]));
            PharmacophoreFingerprint cfp = new PharmacophoreFingerprint(par);
            ms.addDescriptor(cfp);
            MDFileReader r = new MDFileReader(args[1], ms);
            r.setCloneResult(false);
            MDHypothesisGenerator gen = MDHypothesisCreator.create(args[2]);
            ms = r.next();
            while (ms != null) {
                System.out.println("read: " + ms.getDescriptor(0));
                gen.add(ms);
                ms = r.next();
            }
            System.out.println(gen.generate().getDescriptor(0));
            System.out.println(gen.generate().getDescriptor(0).toDecimalString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

