/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDArrayReader;
import chemaxon.descriptors.MDHitEvaluator;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.Optimizer;
import chemaxon.descriptors.OptimizerProblem;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;

public class MDMetricOptimizer {
    public int nrOfIterations = 100;
    public float maxErrorInF = 0.05f;
    public float maxErrorInX = 0.05f;
    public float percentage = 80.0f;
    private MDSimilarity similarity = null;
    private MDHitEvaluator evaluator = null;

    public MDMetricOptimizer(MDHitEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void optimizeParameters(int mdIndex, int metricIndex, MDReader similarSet, MDReader dissimilarSet) throws MDReaderException {
        MDArrayReader sSet = similarSet instanceof MDArrayReader ? (MDArrayReader)similarSet : new MDArrayReader(similarSet);
        sSet.setCloneResult(false);
        MDArrayReader dsSet = dissimilarSet instanceof MDArrayReader ? (MDArrayReader)dissimilarSet : new MDArrayReader(dissimilarSet);
        dsSet.setCloneResult(false);
        MDSet sampleMDSet = sSet.next();
        sSet.reset();
        MolecularDescriptor sampleDescriptor = sampleMDSet.getDescriptor(mdIndex);
        MDParameters params = sampleDescriptor.getParameters();
        params.setCurrentParametrizedMetric(metricIndex);
        Problem problem = new Problem(params, mdIndex, metricIndex, this.evaluator, sSet, dsSet);
        if (problem.nVariables() != 0) {
            Optimizer optimizer = new Optimizer(problem);
            optimizer.optimize(this.nrOfIterations, this.maxErrorInF, this.maxErrorInX);
            problem.setParameters(optimizer.getVariables());
        }
        sSet.close();
        dsSet.close();
    }

    private class Problem
    implements OptimizerProblem {
        private MDParameters params = null;
        private boolean isReducedWeights = false;
        private PharmacophoreFingerprint pfp = null;
        private PFParameters p = null;
        private int nFeatures = 0;
        private int nDistances = 0;
        private int mdIndex = 0;
        private int metricIndex = 0;
        private int nVars = 0;
        private float[] minValues = null;
        private float[] maxValues = null;
        private boolean[] isIndependent = null;
        private MDHitEvaluator evaluator = null;
        private MDReader similarSet = null;
        private MDReader dissimilarSet = null;

        public Problem(MDParameters params, int mdIndex, int metricIndex, MDHitEvaluator evaluator, MDArrayReader similarSet, MDArrayReader dissimilarSet) throws MDReaderException {
            this.params = params;
            this.mdIndex = mdIndex;
            this.metricIndex = metricIndex;
            this.evaluator = evaluator;
            this.similarSet = similarSet;
            this.dissimilarSet = dissimilarSet;
            MolecularDescriptor sampleDescriptor = similarSet.next().getDescriptor(mdIndex);
            boolean bl = this.isReducedWeights = sampleDescriptor instanceof PharmacophoreFingerprint && !params.isCellwiseWeights();
            if (this.isReducedWeights) {
                this.nFeatures = ((PFParameters)params).getNumberOfFeatures();
                this.nDistances = ((PFParameters)params).getNDists();
            }
            similarSet.reset();
            int nWeights = this.nVars = params.isWeighted() ? params.getNumberOfWeights() : 0;
            this.nVars += params.isScaled() ? 1 : 0;
            this.nVars += params.isAsymmetric() ? 1 : 0;
            this.minValues = new float[this.nVars];
            this.maxValues = new float[this.nVars];
            this.isIndependent = new boolean[this.nVars];
            int currentIndex = 0;
            if (params.isScaled()) {
                this.minValues[currentIndex] = 1.0f;
                this.maxValues[currentIndex] = 8.0f;
                this.isIndependent[currentIndex++] = true;
            }
            if (params.isAsymmetric()) {
                this.minValues[currentIndex] = 0.0f;
                this.maxValues[currentIndex] = 0.5f;
                this.isIndependent[currentIndex++] = true;
            }
            if (params.isWeighted()) {
                for (int i = 0; i < nWeights; ++i) {
                    this.minValues[currentIndex + i] = 0.0f;
                    this.maxValues[currentIndex + i] = 1.0f;
                    this.isIndependent[currentIndex + i] = false;
                }
                currentIndex += nWeights;
            }
        }

        @Override
        public float f(float[] actualParameters) {
            int currentIndex = 0;
            if (this.params.isScaled()) {
                this.params.setScaleFactor(actualParameters[currentIndex++]);
            }
            if (this.params.isAsymmetric()) {
                this.params.setAsymmetryFactor(actualParameters[currentIndex++]);
            }
            if (this.params.isWeighted()) {
                if (this.isReducedWeights) {
                    float[] featureWeights = new float[this.nFeatures];
                    float[] distanceWeights = new float[this.nDistances];
                    for (int f = 0; f < this.nFeatures; ++f) {
                        featureWeights[f] = actualParameters[currentIndex + f];
                    }
                    for (int d = 0; d < this.nDistances; ++d) {
                        distanceWeights[d] = actualParameters[currentIndex + this.nFeatures + d];
                    }
                    currentIndex += this.nFeatures + this.nDistances;
                    ((PFParameters)this.params).setWeights(featureWeights, distanceWeights);
                } else {
                    float[] weights = new float[this.params.getNumberOfWeights()];
                    while (currentIndex < weights.length) {
                        weights[currentIndex] = actualParameters[currentIndex];
                        ++currentIndex;
                    }
                    this.params.setWeights(weights);
                }
            }
            float toReturn = 0.0f;
            try {
                toReturn = this.evaluator.evaluateByMetric(this.mdIndex, this.metricIndex, MDMetricOptimizer.this.percentage, this.similarSet, this.dissimilarSet);
            }
            catch (MDReaderException crde) {
                System.out.println("Unexpected MDReaderException in MDMetricWeightGenerator.");
                System.exit(1);
            }
            return toReturn;
        }

        @Override
        public int nVariables() {
            return this.nVars;
        }

        @Override
        public float variableMinValue(int i) {
            return this.minValues[i];
        }

        @Override
        public float variableMaxValue(int i) {
            return this.maxValues[i];
        }

        @Override
        public boolean isIndependentVariable(int i) {
            return this.isIndependent[i];
        }

        public void setParameters(float[] parameters) {
            int currentIndex = 0;
            if (this.params.isScaled()) {
                this.params.setScaleFactor(parameters[currentIndex++]);
            }
            if (this.params.isAsymmetric()) {
                this.params.setAsymmetryFactor(parameters[currentIndex++]);
            }
            if (this.params.isWeighted()) {
                if (this.isReducedWeights) {
                    float[] featureWeights = new float[this.nFeatures];
                    float[] distanceWeights = new float[this.nDistances];
                    for (int f = 0; f < this.nFeatures; ++f) {
                        featureWeights[f] = parameters[currentIndex + f];
                    }
                    for (int d = 0; d < this.nDistances; ++d) {
                        distanceWeights[d] = parameters[currentIndex + this.nFeatures + d];
                    }
                    currentIndex += this.nFeatures + this.nDistances;
                    ((PFParameters)this.params).setWeights(featureWeights, distanceWeights);
                } else {
                    float[] weights = new float[this.params.getNumberOfWeights()];
                    while (currentIndex < weights.length) {
                        weights[currentIndex] = parameters[currentIndex];
                        ++currentIndex;
                    }
                    this.params.setWeights(weights);
                }
            }
        }
    }
}

