/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MDParameters {
    public static final float DEFAULT_SCALE_FACTOR = 1.0f;
    public static final float DEFAULT_ASYMMETRY_FACTOR = 0.0f;
    public static final float DEFAULT_WEIGHT = 1.0f;
    public static final int DEFAULT_OUTPUT_PRECISION = 2;
    protected int cellSize = 0;
    protected int length = 0;
    protected int internalSize = 0;
    private MolecularDescriptor scalingHypothesis = null;
    protected byte[] data = null;
    protected String configFilePath = null;
    private SAXReader reader = null;
    protected Document document = null;
    protected Node standardizerConfigurationNode = null;
    protected Element similarityNode = null;
    protected Node screeningConfigurationNode = null;
    protected Element parametrizedMetricsNode = null;
    protected List parametrizedMetricNodes = null;
    protected ArrayList parametrizedMetrics = new ArrayList();
    protected ArrayList metricIndexes = new ArrayList();
    protected ArrayList scaleFactors = new ArrayList();
    protected ArrayList<Float> tverskyA = new ArrayList();
    protected ArrayList<Float> tverskyB = new ArrayList();
    protected ArrayList asymmetryFactors = new ArrayList();
    protected ArrayList thresholds = new ArrayList();
    protected ArrayList normalized = new ArrayList();
    protected float defaultWeight = 1.0f;
    protected ArrayList weights = new ArrayList();
    protected ArrayList cellwiseWeights = new ArrayList();
    protected int outputPrecision = 2;
    protected int currentMetricIndex = -1;
    protected MolecularDescriptor md = null;
    protected NumberFormat decForm = null;
    protected MDGenerator generator = null;
    protected Standardizer standardizer = null;

    protected MDParameters() {
        this.reader = new SAXReader();
        this.decForm = NumberFormat.getInstance();
        if (this.decForm instanceof DecimalFormat) {
            ((DecimalFormat)this.decForm).setMaximumFractionDigits(this.outputPrecision);
            ((DecimalFormat)this.decForm).setMinimumFractionDigits(this.outputPrecision);
            ((DecimalFormat)this.decForm).setGroupingUsed(false);
            DecimalFormatSymbols dfs = ((DecimalFormat)this.decForm).getDecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            ((DecimalFormat)this.decForm).setDecimalFormatSymbols(dfs);
        }
    }

    protected void initParameters() {
        if (this.document == null) {
            try {
                String def = this.getDefaultDocumentFrame();
                if (def != null) {
                    this.document = this.reader.read((Reader)new StringReader(def));
                    this.processDocument(true);
                    this.readValues(true);
                } else {
                    this.createStandardizer();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create default XML configuration.", e);
            }
        }
        this.currentMetricIndex = 0;
        if (this.parametrizedMetrics.size() == 0) {
            this.appendParametrizedMetric(this.md.getDissimilarityMetrics()[0], this.md.getDissimilarityMetrics()[0]);
        }
    }

    public void fromString(String parameterString) throws MDParametersException {
        this.readFromXmlString(parameterString, false, true);
        this.initParameters();
    }

    public void fromFile(File parameterFile) throws MDParametersException {
        this.readFromXmlFile(parameterFile, false, true);
        this.initParameters();
    }

    public void addParameters(String parameterString) throws MDParametersException {
        this.readFromXmlString(parameterString, true, false);
    }

    public void addParameters(File parameterFile) throws MDParametersException {
        this.readFromXmlFile(parameterFile, true, false);
    }

    public void setParameters(String parametersString) throws MDParametersException {
        this.readFromXmlString(parametersString, false, false);
    }

    public void setParameters(File parametersFile) throws MDParametersException {
        this.readFromXmlFile(parametersFile, false, false);
    }

    public String toString() {
        if (this.document != null) {
            return this.document.asXML();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<MDParametersConfiguration Version =\"0.1\">\n</MDParametersConfiguration>\n";
    }

    public String getScreeningConfigurationString(String nodeName, String attrib, String value) throws MDParametersException {
        Document configDoc = this.reader.getDocumentFactory().createDocument();
        Node copiedNode = (Node)this.screeningConfigurationNode.clone();
        configDoc.add(copiedNode.detach());
        Element pm = null;
        Iterator i = configDoc.getRootElement().elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (e.getName().equals("ParametrizedMetrics")) {
                pm = e;
                continue;
            }
            e.detach();
        }
        ArrayList<Element> detachThese = new ArrayList<Element>();
        Iterator i2 = pm.elementIterator();
        while (i2.hasNext()) {
            Element e = (Element)i2.next();
            if (e.attributeValue(attrib).length() != 0 && e.attributeValue(attrib).equals(value)) continue;
            detachThese.add(e);
        }
        i2 = detachThese.iterator();
        while (i2.hasNext()) {
            ((Element)i2.next()).detach();
        }
        return configDoc.asXML();
    }

    protected String toString(Node node) throws MDParametersException {
        return node.asXML();
    }

    public void setCellSize(int cellSize) {
        if (1 > cellSize || cellSize > 32) {
            throw new IllegalArgumentException(cellSize + " is out of range [1..32]");
        }
        this.cellSize = cellSize;
    }

    public void setLength(int length) throws MDParametersException {
        if (length < 1) {
            throw new MDParametersException("Invalid MolecularDescriptor length: " + length + ", should be positive");
        }
        this.length = length;
    }

    public void setScalingHypothesis(MolecularDescriptor scalingHypothesis) {
        this.scalingHypothesis = scalingHypothesis;
    }

    public void setScaleFactor(float scaleFactor) {
        if (scaleFactor <= 0.0f) {
            throw new IllegalArgumentException(scaleFactor + " <= 0 " + " is not allowed, should be greater than 0");
        }
        this.scaleFactors.set(this.currentMetricIndex, new Float(scaleFactor));
        this.writeMetricParameter(this.scaleFactors, "ScaleFactor", this.currentMetricIndex, true);
    }

    public void setAsymmetryFactor(float af) {
        this.asymmetryFactors.set(this.currentMetricIndex, new Float(af));
        this.writeMetricParameter(this.asymmetryFactors, "AsymmetryFactor", this.currentMetricIndex, true);
    }

    public void setThreshold(float th) {
        this.thresholds.set(this.currentMetricIndex, new Float(th));
        this.writeMetricParameter(this.thresholds, "Threshold", this.currentMetricIndex, true);
    }

    public void setWeights(float[] w) {
        this.weights.set(this.currentMetricIndex, w);
        this.setCellwiseWeights(true);
        Element n = (Element)this.parametrizedMetricNodes.get(this.currentMetricIndex);
        StringBuffer sb = new StringBuffer();
        float[] fws = (float[])this.weights.get(this.currentMetricIndex);
        for (int i = 0; i < fws.length; ++i) {
            sb.append(this.decForm.format(fws[i]) + " ");
        }
        n.addAttribute("Weights", sb.toString());
    }

    public void setCellwiseWeights(boolean c) {
        this.cellwiseWeights.set(this.currentMetricIndex, new Boolean(c));
    }

    public void setNormalized(boolean yes) {
        this.normalized.set(this.currentMetricIndex, new Boolean(yes));
        this.writeMetricParameter(this.normalized, "Normalized", this.currentMetricIndex, false);
    }

    public void setOutputPrecision(int precision) {
        this.outputPrecision = precision;
        ((DecimalFormat)this.decForm).setMaximumFractionDigits(this.outputPrecision);
        ((DecimalFormat)this.decForm).setMinimumFractionDigits(this.outputPrecision);
    }

    public void setCurrentParametrizedMetric(int metricIndex) {
        if (metricIndex >= this.parametrizedMetrics.size()) {
            throw new IllegalArgumentException("Invalid parametrized metric  index: " + metricIndex);
        }
        this.currentMetricIndex = metricIndex;
    }

    public void setCreateStatistics(boolean createStatistics) {
        this.generator.setCreateStatistics(createStatistics);
    }

    public int addParametrizedMetric(String name, String metric, String activeFamily) throws MDParametersException {
        int mi;
        if (metric == null || metric.length() == 0) {
            throw new IllegalArgumentException("Missing metric name.");
        }
        if (activeFamily == null || activeFamily.length() == 0) {
            activeFamily = new String("Generic");
        }
        if (name == null || name.length() == 0) {
            name = new String(activeFamily + " by " + metric);
        }
        if ((mi = this.parametrizedMetrics.indexOf(name)) != -1) {
            throw new MDParametersException("Metric name " + name + " is not unique");
        }
        mi = this.appendParametrizedMetric(name, metric);
        this.addParametrizedMetricNode(name, activeFamily, metric);
        this.parametrizedMetricNodes = this.parametrizedMetricsNode.selectNodes("ParametrizedMetric");
        return mi;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getLength() {
        return this.length;
    }

    public int getInternalSize() {
        return this.internalSize;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getCurrentMetricIndex() {
        return this.currentMetricIndex;
    }

    public int getNumberOfMetrics() {
        return this.parametrizedMetrics.size();
    }

    public int getNumberOfWeights() {
        return this.getNumberOfWeights(this.currentMetricIndex);
    }

    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        return 0;
    }

    public float getThreshold(int metricIndex) {
        Object dt = this.thresholds.get(metricIndex);
        if (dt != null) {
            return ((Float)dt).floatValue();
        }
        return this.md.getDefaultDissimilarityMetricThresholds()[(Integer)this.metricIndexes.get(metricIndex)];
    }

    public float getThreshold() {
        return this.getThreshold(this.currentMetricIndex);
    }

    public MolecularDescriptor getScalingHypothesis() {
        return this.scalingHypothesis;
    }

    public int getInternalMetricIndex() {
        Object mi = this.metricIndexes.get(this.currentMetricIndex);
        return mi == null ? this.md.getDefaultMetricIndex() : ((Integer)mi).intValue();
    }

    public String getMetricName() {
        return (String)this.parametrizedMetrics.get(this.currentMetricIndex);
    }

    public String getMetricName(int metricIndex) {
        return (String)this.parametrizedMetrics.get(metricIndex);
    }

    public int getMetricIndex(String name) {
        return this.parametrizedMetrics.indexOf(name);
    }

    public float getScaleFactor() {
        Object sf = this.scaleFactors.get(this.currentMetricIndex);
        return sf == null ? 1.0f : ((Float)sf).floatValue();
    }

    public float getAsymmetryFactor() {
        Object af = this.asymmetryFactors.get(this.currentMetricIndex);
        return af == null ? 0.0f : ((Float)af).floatValue();
    }

    public float[] getWeights() {
        return (float[])this.weights.get(this.currentMetricIndex);
    }

    public float getTverskyAlpha() {
        return this.tverskyA.get(this.currentMetricIndex).floatValue();
    }

    public float getTverskyBeta() {
        return this.tverskyB.get(this.currentMetricIndex).floatValue();
    }

    MDGenerator getGenerator() {
        return this.generator;
    }

    public boolean isCellwiseWeights() {
        return (Boolean)this.cellwiseWeights.get(this.currentMetricIndex);
    }

    public DecimalFormat getDecForm() {
        return (DecimalFormat)this.decForm;
    }

    public boolean isScaled() {
        return this.scaleFactors.get(this.currentMetricIndex) != null;
    }

    public boolean isAsymmetric() {
        return this.asymmetryFactors.get(this.currentMetricIndex) != null;
    }

    public boolean isWeighted() {
        return this.weights.get(this.currentMetricIndex) != null;
    }

    public boolean isNormalized() {
        Boolean n = (Boolean)this.normalized.get(this.currentMetricIndex);
        return n != null && n != false;
    }

    public boolean isStandardizationMandatory() {
        return true;
    }

    public static String getDefaultStandardizerConfiguration() {
        return "<StandardizerConfiguration Version =\"0.1\" ><Actions><Action ID=\"aromatize\" Act=\"aromatize\"/><RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/></Actions></StandardizerConfiguration>";
    }

    public String getDefaultDocumentFrame() {
        return null;
    }

    public Molecule standardize(Molecule m) {
        if (this.standardizer != null) {
            try {
                return this.standardizer.standardize(m.cloneMolecule());
            }
            catch (SearchException e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    protected void readFromXmlFile(File file, boolean merge, boolean all) throws MDParametersException {
        this.configFilePath = this.getFilePath(file);
        try {
            Document doc = this.reader.read(file);
            if (all) {
                this.document = doc;
            } else {
                this.importNodes(doc, merge);
            }
            this.processDocument(all);
            this.readValues(all);
        }
        catch (DocumentException de) {
            throw new MDParametersException("Bad XML config file.", de);
        }
        catch (Exception e) {
            throw new MDParametersException("Cannot read XML configuration file", e);
        }
    }

    protected void readFromXmlString(String xml, boolean merge, boolean all) throws MDParametersException {
        if (xml == null || xml.length() == 0) {
            return;
        }
        try {
            Document doc = this.reader.read((Reader)new StringReader(xml));
            if (all) {
                this.document = doc;
            } else {
                this.importNodes(doc, merge);
            }
            this.processDocument(all);
            this.readValues(all);
        }
        catch (DocumentException de) {
            throw new MDParametersException("Bad XML configuration string: " + xml, de);
        }
    }

    protected void checkDocumentVersion(String docType, String version) throws MDParametersException {
    }

    protected void processDocument(boolean all) throws MDParametersException {
        if (all) {
            this.standardizerConfigurationNode = this.document.selectSingleNode("//*/StandardizerConfiguration");
            if (this.standardizerConfigurationNode == null && this.isStandardizationMandatory()) {
                this.createDefaultStandardizerConfiguration();
            }
            this.createStandardizer();
        }
        this.screeningConfigurationNode = this.document.selectSingleNode("//*/ScreeningConfiguration");
        if (this.screeningConfigurationNode == null) {
            return;
        }
        this.parametrizedMetricsNode = (Element)this.screeningConfigurationNode.selectSingleNode("ParametrizedMetrics");
        this.parametrizedMetricNodes = this.parametrizedMetricsNode.selectNodes("ParametrizedMetric");
    }

    private void createDefaultStandardizerConfiguration() {
        try {
            Document doc = this.reader.read((Reader)new StringReader(MDParameters.getDefaultStandardizerConfiguration()));
            this.standardizerConfigurationNode = doc.selectSingleNode("StandardizerConfiguration");
            if (this.standardizerConfigurationNode == null) {
                throw new RuntimeException("Internal error: bad or missing default standardizer configuration.");
            }
            this.standardizerConfigurationNode.detach();
            this.document.getRootElement().add(this.standardizerConfigurationNode);
            if (this.standardizerConfigurationNode == null) {
                throw new RuntimeException("Failed to set up standardizer configuration.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: failure to set up default standardizer configuration.", e);
        }
    }

    private void createStandardizer() throws MDParametersException {
        try {
            this.standardizer = this.standardizerConfigurationNode != null ? new Standardizer((Element)this.standardizerConfigurationNode) : new Standardizer(MDParameters.getDefaultStandardizerConfiguration());
        }
        catch (StandardizerException e) {
            throw new MDParametersException("Initialization of Standardizer failed", e);
        }
    }

    protected void readValues(boolean all) throws MDParametersException {
    }

    protected void readMetricParameters() throws MDParametersException {
        if (this.parametrizedMetricNodes == null || this.parametrizedMetricNodes.size() == 0) {
            throw new MDParametersException("No metrics defined.");
        }
        this.currentMetricIndex = 0;
        for (int i = 0; i < this.parametrizedMetricNodes.size(); ++i) {
            String alpha;
            int mi;
            String metric;
            Element mp = (Element)this.parametrizedMetricNodes.get(i);
            String family = mp.attributeValue("ActiveFamily");
            if (family == null) {
                family = new String("Generic");
            }
            if ((metric = mp.attributeValue("Metric")) == null) {
                throw new MDParametersException("Missing Metric name attribute");
            }
            String name = mp.attributeValue("Name");
            if (name == null) {
                name = new String(family + " by " + metric);
                mp.addAttribute("Name", name);
            }
            if ((mi = this.parametrizedMetrics.indexOf(name)) == -1) {
                mi = this.appendParametrizedMetric(name, metric);
            }
            this.tverskyA.set(mi, (alpha = mp.attributeValue("TverskyAlpha")) != null ? new Float(alpha) : null);
            String beta = mp.attributeValue("TverskyBeta");
            this.tverskyB.set(mi, beta != null ? new Float(beta) : null);
            String sf = mp.attributeValue("ScaleFactor");
            this.scaleFactors.set(mi, sf != null ? new Float(sf) : null);
            String af = mp.attributeValue("AsymmetryFactor");
            this.asymmetryFactors.set(mi, af != null ? new Float(af) : null);
            String th = mp.attributeValue("Threshold");
            this.thresholds.set(mi, th != null ? new Float(th) : null);
            String nm = mp.attributeValue("Normalized");
            this.normalized.set(mi, nm != null ? new Boolean(nm) : null);
            this.readMetricWeights(mp, mi);
        }
    }

    protected void readMetricWeights(Element parametrizedMetric, int metricIndex) throws MDParametersException {
        this.setCellwiseWeights(false);
        String wstr = parametrizedMetric.attributeValue("Weights");
        if (wstr != null) {
            StringTokenizer stok = new StringTokenizer(wstr, " ");
            float[] fws = new float[stok.countTokens()];
            int wi = 0;
            while (stok.hasMoreTokens()) {
                fws[wi] = Float.parseFloat(stok.nextToken());
                ++wi;
            }
            this.weights.set(metricIndex, fws);
        } else {
            this.weights.set(metricIndex, null);
        }
    }

    protected void writeMetricParameter(ArrayList pl, String attr, int mi, boolean useDecForm) {
        if (pl.get(mi) != null) {
            Element n = (Element)this.parametrizedMetricNodes.get(mi);
            n.addAttribute(attr, useDecForm ? this.decForm.format((Float)pl.get(mi)) : pl.get(mi).toString());
        }
    }

    protected int appendParametrizedMetric(String name, String metric) {
        this.parametrizedMetrics.add(name);
        int mi = this.parametrizedMetrics.size() - 1;
        this.metricIndexes.add(mi, new Integer(this.md.getDissimilarityMetricIndex(metric)));
        this.scaleFactors.add(mi, null);
        this.asymmetryFactors.add(mi, null);
        this.weights.add(mi, null);
        this.cellwiseWeights.add(mi, new Boolean(false));
        this.normalized.add(mi, null);
        this.thresholds.add(mi, null);
        this.tverskyA.add(mi, null);
        this.tverskyB.add(mi, null);
        return mi;
    }

    protected void addParametrizedMetricsNode() {
        if (this.parametrizedMetricsNode == null) {
            this.parametrizedMetricsNode = ((Element)this.screeningConfigurationNode).addElement("ParametrizedMetrics").addText("\n");
        }
    }

    protected Element addParametrizedMetricNode(String name, String activeFamily, String metric) {
        if (this.parametrizedMetricsNode == null) {
            this.addParametrizedMetricsNode();
        }
        this.parametrizedMetricsNode.addElement("ParametrizedMetric").addAttribute("Name", name).addAttribute("ActiveFamily", activeFamily).addAttribute("Metric", metric).addText("\n");
        return this.parametrizedMetricsNode;
    }

    protected boolean importNodes(Document doc, boolean merge) {
        try {
            Node newMetricNode = doc.selectSingleNode("//ScreeningConfiguration/ParametrizedMetrics");
            if (newMetricNode == null) {
                return false;
            }
            Element imported = (Element)newMetricNode.clone();
            imported.detach();
            if (merge) {
                List metrics2 = imported.elements();
                for (Node nn : metrics2) {
                    nn.detach();
                    this.parametrizedMetricsNode.add(nn);
                }
            } else {
                this.parametrizedMetricsNode.detach();
                ((Element)this.screeningConfigurationNode).add(imported);
            }
            this.setCurrentParametrizedMetric(0);
            this.parametrizedMetrics.clear();
            this.metricIndexes.clear();
            this.scaleFactors.clear();
            this.asymmetryFactors.clear();
            this.weights.clear();
            this.cellwiseWeights.clear();
            this.normalized.clear();
            this.thresholds.clear();
            return true;
        }
        catch (MDParametersException p) {
            p.printStackTrace();
            return false;
        }
    }

    private String getFilePath(File f) {
        try {
            String fp = f.getCanonicalPath();
            fp = fp.substring(0, fp.lastIndexOf(System.getProperty("file.separator")));
            return fp;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getDescriptorTypeName(String xmlConfig) {
        if (xmlConfig == null || xmlConfig.length() == 0) {
            return null;
        }
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(xmlConfig));
            Element r = doc.getRootElement();
            String docTypeName = r.getName();
            int configStrPos = docTypeName.indexOf("Configuration");
            if (configStrPos == -1) {
                throw new MDParametersException("Malformed descriptor configuration. Document type name does not end with 'Configuration'. ");
            }
            return docTypeName.substring(0, configStrPos);
        }
        catch (DocumentException de) {
            throw new MDParametersException("Bad XML configuration file", de);
        }
    }
}

