/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarityResultWriter;
import chemaxon.descriptors.MDSimilarityStatWriter;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import java.util.ArrayList;

public class MDSimilarity
implements Licensable {
    private String licenseEnvironment = "";
    private static final int MAX_NORMALIZATION_SAMPLES = 100;
    private ArrayList queries = new ArrayList(10);
    private ArrayList queryCoeffs = new ArrayList(10);
    private float[][] thresholds = null;
    private float[][] metricScales = null;
    private int[] nUsedMetrics = null;
    private boolean andMetrics = false;
    private boolean andDescriptors = false;
    private ArrayList resultWriters = new ArrayList();
    private boolean componentWise = false;
    private float threshold = 1.0f;
    private boolean initNeeded = false;

    public void setComponentWise(boolean componentWise) {
        this.componentWise = componentWise;
    }

    public void addResultWriter(MDSimilarityResultWriter rwr) {
        this.resultWriters.add(rwr);
    }

    public void addQuery(MDSet query) {
        if (this.thresholds == null) {
            this.thresholds = new float[query.size()][];
            this.nUsedMetrics = new int[this.thresholds.length];
            for (int i = 0; i < this.thresholds.length; ++i) {
                this.nUsedMetrics[i] = 0;
                MolecularDescriptor queryMD = query.getDescriptor(i);
                this.thresholds[i] = new float[queryMD.getNumberOfMetrics()];
                for (int j = 0; j < this.thresholds[i].length; ++j) {
                    this.thresholds[i][j] = -1.0f;
                }
            }
            this.metricScales = this.copy(this.thresholds);
        }
        this.queries.add(query);
        this.queryCoeffs.add(this.copy(this.thresholds));
    }

    public void addQueries(MDSet[] queries) {
        for (int q = 0; q < queries.length; ++q) {
            this.addQuery(queries[q]);
        }
    }

    public void addQueries(MDReader queryReader) throws MDReaderException {
        MDSet query = queryReader.next();
        while (query != null) {
            this.addQuery(query);
            query = queryReader.next();
        }
    }

    public MDSet getQuery(int queryIndex) {
        if (this.queries.size() == 0) {
            throw new RuntimeException("Bad usage. No queries have been added yet.");
        }
        return (MDSet)this.queries.get(queryIndex);
    }

    public int getNrOfQueries() {
        return this.queries.size();
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void useMetric(int mdIndex, int metricIndex, float threshold) {
        if (this.thresholds[mdIndex][metricIndex] < 0.0f) {
            int n = mdIndex;
            this.nUsedMetrics[n] = this.nUsedMetrics[n] + 1;
        }
        this.thresholds[mdIndex][metricIndex] = threshold;
    }

    public void useMetric(int mdIndex, int metricIndex) {
        if (this.thresholds[mdIndex][metricIndex] < 0.0f) {
            int n = mdIndex;
            this.nUsedMetrics[n] = this.nUsedMetrics[n] + 1;
        }
        this.thresholds[mdIndex][metricIndex] = 0.0f;
        this.initNeeded = true;
    }

    public boolean isUsedMetric(int mdIndex, int metricIndex) {
        return this.thresholds[mdIndex][metricIndex] >= 0.0f;
    }

    public int getNrOfUsedMetrics(int mdIndex) {
        return this.nUsedMetrics[mdIndex];
    }

    public float threshold(int mdIndex, int metricIndex) {
        return this.thresholds[mdIndex][metricIndex];
    }

    public boolean isComponentWise() {
        return this.componentWise;
    }

    public void passWithAllMetrics() {
        this.andMetrics = true;
    }

    public boolean isPassWithAllMetrics() {
        return this.andMetrics;
    }

    public void passWithOneMetric() {
        this.andMetrics = false;
    }

    public boolean isPassWithOneMetric() {
        return !this.andMetrics;
    }

    public void passWithAllDescriptors() {
        this.andDescriptors = true;
    }

    public boolean isPassWithAllDescriptors() {
        return this.andDescriptors;
    }

    public void passWithOneDescriptor() {
        this.andDescriptors = false;
    }

    public boolean isPassWithOneDescriptor() {
        return !this.andDescriptors;
    }

    private void initThresholds(MDSet mdSet) {
        if (!this.initNeeded) {
            return;
        }
        for (int mdIndex = 0; mdIndex < mdSet.size(); ++mdIndex) {
            MolecularDescriptor md = mdSet.getDescriptor(mdIndex);
            for (int metricIndex = 0; metricIndex < md.getNumberOfMetrics(); ++metricIndex) {
                if (this.thresholds[mdIndex][metricIndex] != 0.0f) continue;
                this.thresholds[mdIndex][metricIndex] = md.getThreshold(metricIndex);
            }
        }
        this.initNeeded = false;
    }

    public boolean compare(int mdIndex, int metricIndex, MDSet target) throws RuntimeException {
        this.checkLicense();
        if (this.queries.size() == 0) {
            throw new RuntimeException("Bad usage. No queries have been added yet.");
        }
        if (!this.componentWise) {
            throw new RuntimeException("Bad usage. This method is applicable in component-wise mode only.");
        }
        if (this.thresholds[mdIndex][metricIndex] < 0.0f) {
            this.thresholds[mdIndex][metricIndex] = target.getDescriptor(mdIndex).getThreshold(metricIndex);
        }
        this.clear(this.queryCoeffs);
        boolean passed = false;
        for (int q = 0; q < this.queries.size(); ++q) {
            float[][] coeffs = (float[][])this.queryCoeffs.get(q);
            MDSet query = (MDSet)this.queries.get(q);
            MolecularDescriptor descr = target.getDescriptor(mdIndex);
            coeffs[mdIndex][metricIndex] = descr.getDissimilarity(query.getDescriptor(mdIndex), metricIndex);
            if (this.metricScales[mdIndex][metricIndex] >= 0.0f) {
                float[] fArray = coeffs[mdIndex];
                int n = metricIndex;
                fArray[n] = fArray[n] * this.metricScales[mdIndex][metricIndex];
                if (coeffs[mdIndex][metricIndex] > 1.0f) {
                    coeffs[mdIndex][metricIndex] = 1.0f;
                }
            }
            passed = passed || coeffs[mdIndex][metricIndex] <= this.thresholds[mdIndex][metricIndex];
        }
        return passed;
    }

    public boolean compare(MDSet target) throws RuntimeException {
        this.checkLicense();
        if (this.initNeeded) {
            this.initThresholds(target);
        }
        if (this.queries.size() == 0) {
            throw new RuntimeException("Bad usage. No queries have been added yet.");
        }
        this.clear(this.queryCoeffs);
        boolean passed = false;
        int nDescrPassed = 0;
        for (int q = 0; q < this.queries.size(); ++q) {
            float[][] coeffs = (float[][])this.queryCoeffs.get(q);
            MDSet query = (MDSet)this.queries.get(q);
            if (!this.componentWise) {
                coeffs[0][0] = target.getDissimilarity(query);
                if (coeffs[0][0] < this.threshold) {
                    ++nDescrPassed;
                }
            } else {
                for (int d = 0; d < query.size(); ++d) {
                    int nMetricPassed = 0;
                    for (int t = 0; t < this.thresholds[d].length; ++t) {
                        if (!(this.thresholds[d][t] >= 0.0f)) continue;
                        MolecularDescriptor descr = target.getDescriptor(d);
                        coeffs[d][t] = descr.getDissimilarity(query.getDescriptor(d), t);
                        if (this.metricScales[d][t] >= 0.0f) {
                            float[] fArray = coeffs[d];
                            int n = t;
                            fArray[n] = fArray[n] * this.metricScales[d][t];
                            if (coeffs[d][t] > 1.0f) {
                                coeffs[d][t] = 1.0f;
                            }
                        }
                        nMetricPassed += coeffs[d][t] <= this.thresholds[d][t] ? 1 : 0;
                    }
                    boolean descrPassed = this.andMetrics ? nMetricPassed == this.nUsedMetrics[d] : nMetricPassed > 0;
                    nDescrPassed += descrPassed ? 1 : 0;
                }
            }
            passed = passed || (this.andDescriptors ? nDescrPassed == query.size() : nDescrPassed > 0);
        }
        return passed;
    }

    public int compare(MDReader targetReader) throws MDReaderException, RuntimeException {
        if (this.queries.size() == 0) {
            throw new RuntimeException("Bad usage. No queries have been added yet.");
        }
        int nPassedTargets = 0;
        this.openWriters();
        MDSet target = targetReader.next();
        if (this.initNeeded) {
            this.initThresholds(target);
        }
        while (target != null) {
            boolean passed = this.compare(target);
            nPassedTargets += passed ? 1 : 0;
            for (int r = 0; r < this.resultWriters.size(); ++r) {
                MDSimilarityResultWriter rw = (MDSimilarityResultWriter)this.resultWriters.get(r);
                if (rw.writesMolecules()) {
                    rw.setMolecule(targetReader.getMolecule());
                }
                rw.write(target, passed);
            }
            target = targetReader.next();
        }
        this.closeWriters();
        return nPassedTargets;
    }

    public float getDissimilarityCoeff(int queryIndex, int mdIndex, int metricIndex) {
        return ((float[][])this.queryCoeffs.get(queryIndex))[mdIndex][metricIndex];
    }

    public float[] getDissimilarityCoeffs(int queryIndex, int mdIndex) {
        return ((float[][])this.queryCoeffs.get(queryIndex))[mdIndex];
    }

    public float[][] getDissimilarityCoeffs(int queryIndex) {
        return (float[][])this.queryCoeffs.get(queryIndex);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Screen", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Screen", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    private void clear(ArrayList coeffs) {
        int n = coeffs.size();
        for (int i = 0; i < n; ++i) {
            float[][] cfs = (float[][])coeffs.get(i);
            for (int j = 0; j < cfs.length; ++j) {
                for (int k = 0; k < cfs[j].length; ++k) {
                    cfs[j][k] = -1.0f;
                }
            }
        }
    }

    private float[][] copy(float[][] s) {
        float[][] copied = new float[s.length][];
        for (int i = 0; i < s.length; ++i) {
            copied[i] = new float[s[i].length];
            for (int j = 0; j < s[i].length; ++j) {
                copied[i][j] = s[i][j];
            }
        }
        return copied;
    }

    private void openWriters() {
        for (int r = 0; r < this.resultWriters.size(); ++r) {
            MDSimilarityResultWriter rw = (MDSimilarityResultWriter)this.resultWriters.get(r);
            rw.open(this);
            if (!(rw instanceof MDSimilarityStatWriter)) continue;
            float[][] d1 = new float[this.queries.size()][this.queries.size()];
            float[][] d2 = new float[this.queries.size()][this.queries.size()];
            for (int qi1 = 0; qi1 < this.queries.size(); ++qi1) {
                MDSet q1 = (MDSet)this.queries.get(qi1);
                for (int qi2 = 0; qi2 < qi1; ++qi2) {
                    MDSet q2 = (MDSet)this.queries.get(qi2);
                    d1[qi1][qi2] = q1.getDescriptor(0).getDissimilarity(q2.getDescriptor(0), 1);
                    d2[qi1][qi2] = q1.getDescriptor(1).getDissimilarity(q2.getDescriptor(1), 2);
                }
            }
            ((MDSimilarityStatWriter)rw).setD1D2(d1, d2);
        }
    }

    private void closeWriters() {
        for (int r = 0; r < this.resultWriters.size(); ++r) {
            MDSimilarityResultWriter rw = (MDSimilarityResultWriter)this.resultWriters.get(r);
            rw.close();
        }
    }
}

