/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MDSimilarityResultWriter;
import chemaxon.descriptors.MolecularDescriptor;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MDSimilarityStatWriter
extends MDSimilarityResultWriter {
    private static final int DEFAULT_OUTPUT_PRECISION = 2;
    private static final String separator = "\t";
    private NumberFormat decimalForm;
    private boolean printId = false;
    private boolean printNaturalId = false;
    private String naturalIdName = "ID";
    private float[][] d1 = null;
    private float[][] d2 = null;

    public MDSimilarityStatWriter(PrintStream output) {
        this.output = output;
        this.decimalForm = NumberFormat.getInstance();
        this.setPrecision(2);
    }

    public MDSimilarityStatWriter(PrintStream output, int precision) {
        this.output = output;
        this.decimalForm = NumberFormat.getInstance();
        this.setPrecision(precision);
    }

    public void setPrecision(int precision) {
        if (this.decimalForm instanceof DecimalFormat) {
            this.decimalForm.setMinimumFractionDigits(precision);
            this.decimalForm.setMaximumFractionDigits(precision);
            this.decimalForm.setGroupingUsed(false);
            ((DecimalFormat)this.decimalForm).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
    }

    public void setPrintId(boolean printId) {
        this.printId = printId;
    }

    public void setD1D2(float[][] d1, float[][] d2) {
        this.d1 = d1;
        this.d2 = d2;
    }

    public void setPrintNaturalId(boolean printNaturalId) {
        this.printNaturalId = printNaturalId;
    }

    public void setNaturalIdName(String idName) {
        this.naturalIdName = idName;
    }

    @Override
    public void open(MDSimilarity cdSimilarity) {
        super.open(cdSimilarity);
        if (this.printId) {
            this.output.print("id");
        }
        if (this.printNaturalId) {
            if (this.printId) {
                this.output.print(separator);
            }
            this.output.print(this.naturalIdName);
        }
        int nQueries = this.similarity.getNrOfQueries();
        MDSet sample = this.similarity.getQuery(0);
        this.createLabels(sample);
        int pi = 0;
        for (int q = 0; q < nQueries; ++q) {
            for (int d = 0; d < sample.size(); ++d) {
                MolecularDescriptor descr = sample.getDescriptor(d);
                for (int m = 0; m < descr.getNumberOfMetrics(); ++m) {
                    if (!this.similarity.isUsedMetric(d, m)) continue;
                    this.output.print(separator + this.labels.get(pi++));
                }
            }
        }
        this.output.println();
    }

    @Override
    public void write(MDSet descr, boolean passed) {
        for (int q1 = 0; q1 < this.similarity.getNrOfQueries(); ++q1) {
            MolecularDescriptor md1 = descr.getDescriptor(0);
            int m1 = 1;
            MolecularDescriptor md2 = descr.getDescriptor(1);
            int m2 = 2;
            float d1tq1 = this.similarity.getDissimilarityCoeff(q1, 0, m1);
            for (int q2 = 0; q2 < q1; ++q2) {
                float d1tq2 = this.similarity.getDissimilarityCoeff(q2, 0, m1);
                if (!(this.d1[q1][q2] > d1tq1) && !(this.d1[q1][q2] > d1tq2)) continue;
                float d2tq1 = this.similarity.getDissimilarityCoeff(q1, 1, m2);
                float d2tq2 = this.similarity.getDissimilarityCoeff(q2, 1, m2);
                if (!(this.d2[q1][q2] < d2tq1) || !(this.d2[q1][q2] < d2tq2)) continue;
                this.output.print(descr.getId() + " " + q1 + " " + q2 + " ");
                this.output.print(d1tq1);
                this.output.print(' ');
                this.output.print(d1tq2);
                this.output.print(' ');
                this.output.print(this.d1[q1][q2]);
                this.output.print("   ");
                this.output.print(d2tq1);
                this.output.print(' ');
                this.output.print(d2tq2);
                this.output.print(' ');
                this.output.print(this.d2[q1][q2]);
                this.output.print(' ');
                this.output.print(d1tq1 / d2tq1);
                this.output.print(' ');
                this.output.print(d1tq2 / d2tq2);
                this.output.print(' ');
                this.output.print(this.d1[q1][q2] / this.d2[q1][q2]);
                this.output.print("   ");
                this.output.print(this.d1[q1][q2] / this.d2[q1][q2] / (d1tq1 / d2tq1));
                this.output.print(' ');
                this.output.print(this.d1[q1][q2] / this.d2[q1][q2] / (d1tq2 / d2tq2));
                this.output.print(' ');
                this.output.println();
            }
        }
    }

    @Override
    public void close() {
        this.output.println("End of table");
        this.output.close();
    }
}

