/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MDSimilarityResultWriter;
import chemaxon.descriptors.MolecularDescriptor;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MDSimilarityTableWriter
extends MDSimilarityResultWriter {
    private static final int DEFAULT_OUTPUT_PRECISION = 2;
    private static final String separator = "\t";
    private NumberFormat decimalForm;
    private boolean printId = false;
    private boolean printNaturalId = false;
    private String naturalIdName = "ID";

    public MDSimilarityTableWriter(PrintStream output) {
        this.output = output;
        this.decimalForm = NumberFormat.getInstance();
        this.setPrecision(2);
    }

    public MDSimilarityTableWriter(PrintStream output, int precision) {
        this.output = output;
        this.decimalForm = NumberFormat.getInstance();
        this.setPrecision(precision);
    }

    public void setPrecision(int precision) {
        if (this.decimalForm instanceof DecimalFormat) {
            this.decimalForm.setMinimumFractionDigits(precision);
            this.decimalForm.setMaximumFractionDigits(precision);
            this.decimalForm.setGroupingUsed(false);
            ((DecimalFormat)this.decimalForm).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
    }

    public void setPrintId(boolean printId) {
        this.printId = printId;
    }

    public void setPrintNaturalId(boolean printNaturalId) {
        this.printNaturalId = printNaturalId;
    }

    public void setNaturalIdName(String idName) {
        this.naturalIdName = idName;
    }

    @Override
    public void open(MDSimilarity cdSimilarity) {
        super.open(cdSimilarity);
        if (this.printId) {
            this.output.print("id");
        }
        if (this.printNaturalId) {
            if (this.printId) {
                this.output.print(separator);
            }
            this.output.print(this.naturalIdName);
        }
        int nQueries = this.similarity.getNrOfQueries();
        MDSet sample = this.similarity.getQuery(0);
        this.createLabels(sample);
        int pi = 0;
        for (int q = 0; q < nQueries; ++q) {
            if (this.similarity.isComponentWise()) {
                for (int d = 0; d < sample.size(); ++d) {
                    MolecularDescriptor descr = sample.getDescriptor(d);
                    for (int m = 0; m < descr.getNumberOfMetrics(); ++m) {
                        if (!this.similarity.isUsedMetric(d, m)) continue;
                        this.output.print(separator + this.labels.get(pi++));
                    }
                }
                continue;
            }
            this.output.print(separator + this.labels.get(pi++));
        }
        this.output.println();
    }

    @Override
    public void write(MDSet descr, boolean passed) {
        if (passed) {
            if (this.printId) {
                this.output.print(descr.getId());
            }
            if (this.printNaturalId) {
                if (this.printId) {
                    this.output.print(separator);
                }
                this.output.print(descr.getNaturalId());
            }
            for (int q = 0; q < this.similarity.getNrOfQueries(); ++q) {
                if (this.similarity.isComponentWise()) {
                    for (int d = 0; d < descr.size(); ++d) {
                        MolecularDescriptor descrComp = descr.getDescriptor(d);
                        for (int m = 0; m < descrComp.getNumberOfMetrics(); ++m) {
                            if (!this.similarity.isUsedMetric(d, m)) continue;
                            this.output.print(separator);
                            this.output.print(this.decimalForm.format(this.similarity.getDissimilarityCoeff(q, d, m)));
                        }
                    }
                    continue;
                }
                this.output.print(separator);
                this.output.print(this.decimalForm.format(this.similarity.getDissimilarityCoeff(q, 0, 0)));
            }
            this.output.println();
        }
        this.count();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

