/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MarkushDescriptorParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.markush.graph.UnsupportedMarkushException;
import chemaxon.sss.screen.MarkushScreenHandler;
import chemaxon.sss.screen.MarkushScreenOptions;
import chemaxon.sss.screen.MarkushScreenStorage;
import chemaxon.struc.Molecule;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MarkushDescriptor
extends MolecularDescriptor {
    public static final String SHORT_NAME = "MSCR";
    private static final Log LOG = LogFactory.getLog(MarkushDescriptor.class);
    MarkushScreenStorage storage = null;
    MarkushScreenOptions screenOptions = null;

    public MarkushDescriptor() {
    }

    public MarkushDescriptor(MarkushDescriptorParameters params) {
        super(params);
    }

    public MarkushDescriptor(String params) {
        this.setParameters(params);
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return 0.5f;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return new float[]{0.5f};
    }

    public MarkushDescriptor(MarkushDescriptor md) {
        super(md.params);
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public MarkushDescriptor clone() {
        return new MarkushDescriptor(this);
    }

    @Override
    public String getName() {
        return "Markush screen descriptor";
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.MarkushDescriptorParameters";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new MarkushDescriptorParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
        this.storage = null;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        this.generateTargetDescriptor(m);
        return null;
    }

    public int getDataSize() {
        if (this.storage == null || ((MarkushDescriptorParameters)this.params).screenHandler == null) {
            return 1;
        }
        return this.storage.getRawDataSize();
    }

    @Override
    public byte[] toData() {
        try {
            MarkushScreenHandler screenHandler = ((MarkushDescriptorParameters)this.params).screenHandler;
            if (this.storage == null || screenHandler == null) {
                return new byte[]{0};
            }
            return this.storage.toRawData();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("MSCR exception: " + e.getMessage()), (Throwable)e);
            }
            return new byte[]{0};
        }
    }

    @Override
    public void fromData(byte[] dbRepr) {
        try {
            MarkushScreenHandler screenHandler = ((MarkushDescriptorParameters)this.params).screenHandler;
            this.storage = dbRepr == null || dbRepr.length <= 1 || screenHandler == null ? null : screenHandler.fromRawData(dbRepr);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("MSCR exception: " + e.getMessage()), (Throwable)e);
            }
            this.storage = null;
        }
    }

    @Override
    public String toString() {
        byte[] data = this.toData();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(data[i]);
        }
        return sb.toString();
    }

    @Override
    public String toDecimalString() {
        return this.toString();
    }

    @Override
    public void fromString(String descr) throws ParseException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public float[] toFloatArray() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void fromFloatArray(float[] descr) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String toBinaryString() {
        return this.toString();
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return new String[]{"Similarity"};
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other, int parametrizedMetricIndex) {
        return this.getDissimilarity(other);
    }

    public void generateTargetDescriptor(Molecule targetMol) throws MDGeneratorException {
        try {
            MarkushScreenHandler screenHandler = ((MarkushDescriptorParameters)this.params).screenHandler;
            this.storage = screenHandler == null ? null : screenHandler.generateTargetDescriptor(targetMol);
        }
        catch (UnsupportedMarkushException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MSCR known limitation: " + e.getMessage()), (Throwable)e);
            }
            this.storage = null;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("MSCR exception: " + e.getMessage()), (Throwable)e);
            }
            this.storage = null;
        }
    }

    public void generateQueryDescriptor(Molecule queryMol, MarkushScreenOptions screenOptions) throws MDGeneratorException {
        try {
            MarkushScreenHandler screenHandler = ((MarkushDescriptorParameters)this.params).screenHandler;
            if (screenHandler == null) {
                this.storage = null;
            } else {
                this.screenOptions = screenHandler.convertScreenOptions(screenOptions, queryMol);
                this.storage = screenHandler.generateQueryDescriptor(queryMol, this.screenOptions);
            }
        }
        catch (UnsupportedMarkushException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MSCR known limitation: " + e.getMessage()), (Throwable)e);
            }
            this.storage = null;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("MSCR exception: " + e.getMessage()), (Throwable)e);
            }
            this.storage = null;
        }
    }

    public boolean acceptTarget(MarkushDescriptor targetDescr) {
        try {
            MarkushScreenHandler screenHandler = ((MarkushDescriptorParameters)this.params).screenHandler;
            if (this.storage == null || targetDescr.storage == null || screenHandler == null) {
                return true;
            }
            return screenHandler.accept(this.storage, targetDescr.storage, this.screenOptions);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("MSCR exception: " + e.getMessage()), (Throwable)e);
            }
            return true;
        }
    }
}

