/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MarkushDescriptor;
import chemaxon.descriptors.MarkushDescriptorGenerator;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.sss.screen.MarkushScreenHandler;
import chemaxon.sss.screen.MarkushScreenHandlerFactory;
import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class MarkushDescriptorParameters
extends MDParameters {
    private static final Log LOG = LogFactory.getLog(MarkushDescriptorParameters.class);
    private static final String DEFAULT_STANDARDIZER_XML_CONFIG = "    <StandardizerConfiguration Version=\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize:b\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n";
    private static final String DEFAULT_XML_CONFIG = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<MarkushDescriptorConfiguration Version=\"1.0\" schemaLocation=\"\">\n    <Parameters Type=\"%s\" Config=\"%s\" Version=\"%s\"/>\n    <StandardizerConfiguration Version=\"0.1\">\n        <Actions>\n            <Action ID=\"aromatize\" Act=\"aromatize:b\"/>\n            <RemoveExplicitH ID=\"RemoveExplicitH\" Groups=\"target\"/>\n        </Actions>\n    </StandardizerConfiguration>\n    <ScreeningConfiguration>\n       <ParametrizedMetrics>\n            <ParametrizedMetric Name=\"Screen\" ActiveFamily=\"Generic\"\n                 Metric=\"Screen\" Threshold=\"0.5\"/>\n       </ParametrizedMetrics>\n    </ScreeningConfiguration>\n</MarkushDescriptorConfiguration>\n", "AtomStat", "", VersionInfo.JCHEM_TABLE_VERSION);
    private Element parameters = null;
    MarkushScreenHandler screenHandler = null;

    public MarkushDescriptorParameters() {
        this.initEmbeddedMD();
        this.initParameters();
        this.initGenerator();
        this.currentMetricIndex = 0;
    }

    public MarkushDescriptorParameters(File configFile) throws MDParametersException {
        this.initEmbeddedMD();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.initGenerator();
        this.currentMetricIndex = 0;
    }

    public MarkushDescriptorParameters(String XMLconfig) throws MDParametersException {
        this.initEmbeddedMD();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.initGenerator();
        this.currentMetricIndex = 0;
    }

    private void initScreenHandler(String screenType, String screenConfig) {
        ServiceLoader<MarkushScreenHandlerFactory> loader;
        Iterator<MarkushScreenHandlerFactory> it;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("initConfiguration(). Screen type: " + screenType + "; config: " + screenConfig));
        }
        if ((it = (loader = ServiceLoader.load(MarkushScreenHandlerFactory.class)).iterator()).hasNext()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Handler factory implementation is available");
            }
            MarkushScreenHandlerFactory factory = it.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Used factory implementation: " + factory.getClass().getCanonicalName()));
                if (it.hasNext()) {
                    LOG.debug((Object)("Another factory implementation is also available: " + it.next().getClass().getCanonicalName()));
                }
            }
            try {
                this.screenHandler = factory.constructScreenHandler(screenType, screenConfig);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Failed to construct the descriptor handler using " + factory.getClass().getCanonicalName()), (Throwable)e);
                    LOG.error((Object)("Screen type: " + screenType + "; screen config: " + screenConfig));
                }
                this.screenHandler = null;
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Handler factory implementation is not available");
            }
            this.screenHandler = null;
        }
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    protected final void initGenerator() throws MDParametersException {
        this.generator = new MarkushDescriptorGenerator();
    }

    protected final void initEmbeddedMD() {
        this.md = new MarkushDescriptor();
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    public static String getDefaultStandardizerConfiguration() {
        return DEFAULT_STANDARDIZER_XML_CONFIG;
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("MarkushDescriptorConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("//MarkushDescriptorConfiguration/Parameters");
            if (this.parameters == null) {
                throw new MDParametersException("MarkushDescriptor configuration error: missing <Parameters>");
            }
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        String config;
        super.readValues(all);
        String type = this.parameters.attributeValue("Type");
        if (type == null) {
            type = "";
        }
        if ((config = this.parameters.attributeValue("Config")) == null) {
            config = "";
        }
        this.initScreenHandler(type, config);
    }
}

