/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.OptimizerProblem;

public class Optimizer {
    private static final int STARTING_NR_OF_POINTS = 11;
    private OptimizerProblem p;
    private float[] variables = null;

    public Optimizer(OptimizerProblem p) {
        this.p = p;
        this.variables = new float[p.nVariables()];
        int n = 10;
        for (int v = 0; v < this.variables.length; ++v) {
            float a = p.variableMinValue(v);
            float b = p.variableMaxValue(v);
            this.variables[v] = a + (b - a) / (float)n * (float)(n / 2);
        }
    }

    public boolean optimize(int maxNIterations, float maxErrorInF, float maxErrorInX) {
        int v;
        float[] actVariables = (float[])this.variables.clone();
        float[] oldVariables = new float[actVariables.length];
        float[] previousVariables = new float[actVariables.length];
        for (v = 0; v < this.variables.length; ++v) {
            oldVariables[v] = Float.MAX_VALUE;
            previousVariables[v] = Float.MAX_VALUE;
        }
        float maxFVal = this.p.f(this.variables);
        float oldMaxFVal = -3.4028235E38f;
        float previousMaxFVal = -3.4028235E38f;
        int n = 11;
        float errorInX = 0.0f;
        float scale = 1.0f;
        for (int i = 0; i < maxNIterations; ++i) {
            boolean valuesChange = true;
            while (valuesChange) {
                for (v = 0; v < this.variables.length; ++v) {
                    if (this.variables.length > 50 && this.variables[v] == previousVariables[v]) continue;
                    previousVariables[v] = this.variables[v];
                    float a = this.p.variableMinValue(v);
                    float b = this.p.variableMaxValue(v);
                    float step = (b - a) / (float)(n - 1);
                    maxFVal = -3.4028235E38f;
                    actVariables[v] = a;
                    for (int j = 0; j < n; ++j) {
                        float fval = this.p.f(actVariables);
                        if (fval >= maxFVal) {
                            maxFVal = fval;
                            this.variables[v] = actVariables[v];
                        }
                        int n2 = v;
                        actVariables[n2] = actVariables[n2] + step;
                    }
                    actVariables[v] = this.variables[v];
                }
                valuesChange = !this.checkTerminationCondition(this.variables, previousVariables, maxFVal, previousMaxFVal, maxErrorInX, maxErrorInF);
                previousMaxFVal = maxFVal;
            }
            if (this.checkTerminationCondition(this.variables, oldVariables, maxFVal, oldMaxFVal, maxErrorInX, maxErrorInF)) {
                return true;
            }
            oldMaxFVal = maxFVal;
            for (v = 0; v < this.variables.length; ++v) {
                previousVariables[v] = oldVariables[v];
                oldVariables[v] = this.variables[v];
            }
            n += n - 1;
        }
        return false;
    }

    public float getVariable(int i) {
        return this.variables[i];
    }

    public float[] getVariables() {
        return this.variables;
    }

    private boolean checkTerminationCondition(float[] variables, float[] previousVariables, float maxFVal, float previousMaxFVal, float maxErrorInX, float maxErrorInF) {
        int v;
        float errorInX = 0.0f;
        boolean allIndependent = true;
        float quasiZero = maxErrorInX / 100.0f;
        for (v = 0; v < variables.length && ((allIndependent &= this.p.isIndependentVariable(v)) || !(variables[v] > quasiZero)); ++v) {
        }
        if (!allIndependent && v == variables.length) {
            throw new RuntimeException("All variables are set to zero");
        }
        while (v < variables.length && ((allIndependent &= this.p.isIndependentVariable(v)) || !(variables[v] > maxErrorInX))) {
            ++v;
        }
        float rescale = allIndependent || v == variables.length || previousVariables[v] <= maxErrorInX ? 1.0f : previousVariables[v] / variables[v];
        for (v = 0; v < variables.length; ++v) {
            float scale = this.p.isIndependentVariable(v) ? 1.0f : rescale;
            errorInX = Math.max(errorInX, Math.abs(scale * variables[v] - previousVariables[v]));
        }
        return Math.abs(maxFVal - previousMaxFVal) <= maxErrorInF && errorInX <= maxErrorInX;
    }
}

