/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.Metrics;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;

public class PharmacophoreFingerprint
extends MolecularDescriptor
implements Licensable {
    protected float[] fp = null;
    private static final String[] metrics = new String[]{"Tanimoto", "Euclidean", "FBPA", "Tversky"};
    private static final float[] defaultThresholds = new float[]{0.2f, 20.0f, 0.15f, 0.5f};
    private static final int NO_COMPRESSION_CODE = 0;
    private static final int ZERO_SEQUENCE_COMPRESSION_CODE = 1;
    private String licenseEnvironment = "";

    public PharmacophoreFingerprint() {
    }

    public PharmacophoreFingerprint(PFParameters params) {
        this.params = params;
        this.fp = new float[params.getLength()];
        this.clear();
    }

    public PharmacophoreFingerprint(String params) {
        this.setParameters(params);
        this.clear();
    }

    public PharmacophoreFingerprint(PharmacophoreFingerprint pfp) {
        this.params = pfp.params;
        if (pfp.fp != null) {
            this.fp = new float[pfp.fp.length];
            for (int i = 0; i < this.fp.length; ++i) {
                this.fp[i] = pfp.fp[i];
            }
        } else {
            this.fp = null;
        }
    }

    @Override
    public PharmacophoreFingerprint clone() {
        return new PharmacophoreFingerprint(this);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Molecular Descriptors", this.licenseEnvironment);
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Molecular Descriptors", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    void startGeneration() {
        this.checkLicense();
    }

    @Override
    public String getName() {
        return "2D pharmacophore fingerprint";
    }

    @Override
    public String getShortName() {
        return "PF";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.PFParameters";
    }

    @Override
    public void setParameters(MDParameters parameters) {
        this.params = parameters;
        if (this.fp == null || this.fp.length < this.params.getLength()) {
            this.fp = new float[this.params.getLength()];
        }
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            this.params = new PFParameters(parameters);
        } else {
            this.params.fromString(parameters);
        }
        if (this.fp == null || this.fp.length < this.params.getLength()) {
            this.fp = new float[this.params.getLength()];
        }
        this.clear();
    }

    @Override
    public byte[] toData() {
        byte[] d = this.params.getData();
        d[0] = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            int v = Float.floatToIntBits(this.fp[i]);
            for (int j = 3; j >= 0; --j) {
                d[i * 4 + j + 1] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return ((PFParameters)this.params).isFuzzyFingerprint() ? d : this.compress(d);
    }

    @Override
    public void fromData(byte[] dbRepr) {
        this.checkLicense();
        byte[] data = this.decompress(dbRepr);
        for (int i = 0; i < this.fp.length; ++i) {
            int v = 0;
            for (int j = 0; j < 4; ++j) {
                v <<= 8;
                v += (data[i * 4 + j + 1] + 256) % 256;
            }
            this.fp[i] = Float.intBitsToFloat(v);
        }
    }

    private byte[] compress(byte[] d) {
        int cLen;
        int zLen;
        int to = 1;
        int from = 1;
        while (from < d.length) {
            if (d[from] != 0) {
                ++to;
                ++from;
                continue;
            }
            zLen = 0;
            while (from < d.length && d[from] == 0) {
                ++from;
                ++zLen;
            }
            while (zLen > 0) {
                ++to;
                cLen = zLen > 255 ? 255 : zLen;
                ++to;
                zLen -= cLen;
            }
        }
        if ((double)to > 0.7 * (double)d.length) {
            d[0] = 0;
            return d;
        }
        to = 1;
        from = 1;
        while (from < d.length) {
            if (d[from] != 0) {
                d[to++] = d[from++];
                continue;
            }
            zLen = 0;
            while (from < d.length && d[from] == 0) {
                ++from;
                ++zLen;
            }
            while (zLen > 0) {
                d[to++] = 0;
                cLen = zLen > 255 ? 255 : zLen;
                d[to++] = (byte)cLen;
                zLen -= cLen;
            }
        }
        d[0] = 1;
        PFParameters p = (PFParameters)this.params;
        if (p.compressedData[to] == null) {
            p.compressedData[to] = new byte[to];
        }
        System.arraycopy(d, 0, p.compressedData[to], 0, to);
        return p.compressedData[to];
    }

    protected byte[] decompress(byte[] data) {
        if (data[0] != 1) {
            return data;
        }
        byte[] d = this.params.getData();
        int di = 1;
        for (int i = 1; i < data.length; ++i) {
            if (data[i] != 0) {
                d[di++] = data[i];
                continue;
            }
            int zLen = (data[++i] + 256) % 256;
            for (int j = 0; j < zLen; ++j) {
                d[di++] = 0;
            }
        }
        return d;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        try {
            String[] res = ((PFParameters)this.params).generate(m, this);
            return res;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    public final void inc(int fa, int fb, int dist) {
        PFParameters p = (PFParameters)this.params;
        if (dist < p.getMinDist()) {
            dist = p.getMinDist();
        }
        if (dist > p.getMaxDist()) {
            dist = p.getMaxDist();
        }
        if (fa >= fb) {
            this.incBin(this.index(fa, fb, dist), 1);
        } else {
            this.incBin(this.index(fb, fa, dist), 1);
        }
    }

    public final void inc(int fa, int fb, int dist, int nrRotBonds) {
        float[][] fuzzyIncrements;
        PFParameters p = (PFParameters)this.params;
        if (dist < p.getMinDist()) {
            dist = p.getMinDist();
        }
        if (dist > p.getMaxDist()) {
            dist = p.getMaxDist();
        }
        if (nrRotBonds >= (fuzzyIncrements = p.getGaussianFuzzyIncrements()).length) {
            nrRotBonds = fuzzyIncrements.length - 1;
        }
        int ffa = fa >= fb ? fa : fb;
        int ffb = fa >= fb ? fb : fa;
        boolean stillWithin = true;
        for (int d = 0; stillWithin && d < p.getNDists(); ++d) {
            stillWithin = false;
            float fv = fuzzyIncrements[nrRotBonds][d];
            if (dist + d <= p.getMaxDist()) {
                this.incBin(this.index(ffa, ffb, dist + d), fv);
                stillWithin = true;
            }
            if (!p.isSymmetricalFuzzy() || dist - d < p.getMinDist() || d == 0) continue;
            this.incBin(this.index(ffa, ffb, dist - d), fv);
            stillWithin = true;
        }
    }

    public final void inc(int fa, int fb, int dist, float[] incr) {
        int ffb;
        PFParameters p = (PFParameters)this.params;
        if (dist < p.getMinDist()) {
            dist = p.getMinDist();
        }
        if (dist > p.getMaxDist()) {
            dist = p.getMaxDist();
        }
        int ffa = fa >= fb ? fa : fb;
        int n = ffb = fa >= fb ? fb : fa;
        if (incr == null) {
            this.incBin(this.index(ffa, ffb, dist), 1);
            return;
        }
        boolean stillWithin = true;
        for (int d = 0; stillWithin && d < p.getNDists(); ++d) {
            stillWithin = false;
            if (dist + d <= p.getMaxDist()) {
                this.incBin(this.index(ffa, ffb, dist + d), incr[p.getNDists() + d]);
                stillWithin = true;
            }
            if (!p.isSymmetricalFuzzy() || dist - d < p.getMinDist() || d == 0) continue;
            this.incBin(this.index(ffa, ffb, dist - d), incr[p.getNDists() - d]);
            stillWithin = true;
        }
    }

    public final void inc(int bin) {
        int n = bin;
        this.fp[n] = this.fp[n] + 1.0f;
    }

    public final void put(int bin, int newValue) {
        this.fp[bin] = newValue;
    }

    public final void put(int bin, float newValue) {
        this.fp[bin] = newValue;
    }

    public final float get(int fa, int fb, int dist) {
        PFParameters p = (PFParameters)this.params;
        if (fa >= fb) {
            return this.getBin(this.index(fa, fb, dist));
        }
        return this.getBin(this.index(fb, fa, dist));
    }

    public final float get(int bin) {
        return this.fp[bin];
    }

    public final void clear() {
        for (int i = 0; i < this.fp.length; ++i) {
            this.fp[i] = 0.0f;
        }
    }

    @Override
    public final String toString() {
        return this.toHistogramString(", ", true);
    }

    @Override
    public final void fromString(String pfp) throws ParseException {
        this.checkLicense();
        PFParameters p = (PFParameters)this.params;
        this.clear();
        try {
            StringTokenizer st = new StringTokenizer(pfp, " |=,");
            while (st.hasMoreTokens()) {
                int fa = p.getSymbolIndex(st.nextToken());
                int fb = p.getSymbolIndex(st.nextToken());
                for (int d = p.getMinDist(); d <= p.getMaxDist(); d += p.getResolution()) {
                    String hs = st.nextToken();
                    this.putBin(this.index(fa, fb, d), Float.parseFloat(hs));
                }
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(pfp + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(pfp + " contains invalid numbers", 0);
        }
    }

    public final String toString(String sep, boolean nonZeroOnly) {
        PFParameters p = (PFParameters)this.params;
        DecimalFormat df = this.params.getDecForm();
        boolean fuzzy = p.isFuzzyFingerprint();
        StringBuffer sb = new StringBuffer();
        for (int fa = 0; fa < p.getNumberOfFeatures(); ++fa) {
            for (int fb = 0; fb <= fa; ++fb) {
                for (int dist = p.getMinDist(); dist <= p.getMaxDist(); dist += p.getResolution()) {
                    float v = this.get(fa, fb, dist);
                    if (v == 0.0f && nonZeroOnly) continue;
                    if (sb.length() > 0) {
                        sb.append(sep);
                    }
                    sb.append(p.getSymbol(fa) + " " + p.getSymbol(fb) + " @ " + dist + " = ");
                    sb.append(df.format(v));
                }
            }
        }
        return sb.toString();
    }

    public final String toHistogramString(String sep, boolean nonZeroOnly) {
        PFParameters p = (PFParameters)this.params;
        DecimalFormat df = this.params.getDecForm();
        boolean fuzzy = p.isFuzzyFingerprint();
        StringBuffer sb = new StringBuffer();
        StringBuffer hb = new StringBuffer();
        for (int fa = 0; fa < p.getNumberOfFeatures(); ++fa) {
            for (int fb = 0; fb <= fa; ++fb) {
                boolean nzFound = false;
                hb.delete(0, hb.length());
                hb.append(p.getSymbol(fa) + " " + p.getSymbol(fb) + " = | ");
                for (int dist = p.getMinDist(); dist <= p.getMaxDist(); dist += p.getResolution()) {
                    float v = this.get(fa, fb, dist);
                    nzFound |= v != 0.0f;
                    if (fuzzy) {
                        hb.append(df.format(v)).append(' ');
                        continue;
                    }
                    hb.append((int)v).append(' ');
                }
                if (!nzFound && nonZeroOnly) continue;
                if (sb.length() > 0) {
                    sb.append(sep);
                }
                sb.append(hb.toString()).append("|");
            }
        }
        return sb.toString();
    }

    @Override
    public final String toDecimalString() {
        PFParameters p = (PFParameters)this.params;
        DecimalFormat df = this.params.getDecForm();
        boolean fuzzy = p.isFuzzyFingerprint();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fp.length; ++i) {
            if (sb.length() > 0) {
                sb.append('\t');
            }
            float v = this.get(i);
            sb.append(df.format(v));
        }
        return sb.toString();
    }

    @Override
    public float[] toFloatArray() {
        float[] toReturn = (float[])this.fp.clone();
        return toReturn;
    }

    @Override
    public void fromFloatArray(float[] descr) {
        this.checkLicense();
        if (this.fp == null) {
            this.fp = (float[])descr.clone();
            return;
        }
        for (int i = 0; i < this.fp.length; ++i) {
            this.fp[i] = descr[i];
        }
    }

    @Override
    public Color[] getAtomSetColors() {
        return ((PFParameters)this.params).getAtomSetColors();
    }

    @Override
    public String[] getAtomSetNames() {
        return ((PFParameters)this.params).getAtomSetNames();
    }

    @Override
    public int[] getAtomSetIndexes(Molecule m) {
        return ((PFParameters)this.params).getAtomSetIndexes(m, this);
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    public final float getEuclidean(PharmacophoreFingerprint f) {
        boolean norm = this.params.isNormalized();
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < this.fp.length; ++i) {
            double df = this.fp[i] - f.fp[i];
            d += df * df;
            if (!norm) continue;
            a += (double)(this.fp[i] * this.fp[i]);
            b += (double)(f.fp[i] * f.fp[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    public final float getAsymmetricEuclidean(PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        boolean norm = this.params.isNormalized();
        double k1 = p.getAsymmetryFactor();
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < this.fp.length; ++i) {
            double df = this.fp[i] - f.fp[i];
            d += (df >= 0.0 ? k1 : k2) * (df * df);
            if (!norm) continue;
            a += (double)(this.fp[i] * this.fp[i]);
            b += (double)(f.fp[i] * f.fp[i]);
        }
        double sqrtD = Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    public final float getWeightedEuclidean(PharmacophoreFingerprint f) {
        boolean norm = this.params.isNormalized();
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        float[] weights = this.params.getWeights();
        for (int i = 0; i < this.fp.length; ++i) {
            double df = this.fp[i] - f.fp[i];
            d += (double)weights[i] * (df * df);
            if (!norm) continue;
            a += (double)(this.fp[i] * this.fp[i]);
            b += (double)(f.fp[i] * f.fp[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    public final float getWeightedAsymmetricEuclidean(PharmacophoreFingerprint f) {
        boolean norm = this.params.isNormalized();
        double k1 = this.params.getAsymmetryFactor();
        double k2 = 1.0 - k1;
        double d = 0.0;
        double a = 0.0;
        double b = 0.0;
        float[] weights = this.params.getWeights();
        for (int i = 0; i < this.fp.length; ++i) {
            double df = this.fp[i] - f.fp[i];
            d += (df >= 0.0 ? k1 : k2) * (double)weights[i] * (df * df);
            if (!norm) continue;
            a += (double)(this.fp[i] * this.fp[i]);
            b += (double)(f.fp[i] * f.fp[i]);
        }
        double sqrtD = (float)Math.sqrt(d);
        return (float)(norm ? sqrtD / (Math.sqrt(a) + Math.sqrt(b)) : sqrtD);
    }

    public final float getSymmetricFBPA(PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        float nom = 0.0f;
        float den = 0.0f;
        float[] w = this.params.getWeights();
        for (int fa = 0; fa < p.getNumberOfFeatures(); ++fa) {
            for (int fb = 0; fb < p.getNumberOfFeatures(); ++fb) {
                float MM = f.getConvolutionProduct(fa, fb, f);
                float mm = this.getConvolutionProduct(fa, fb, this);
                if (!(mm + MM > 0.0f)) continue;
                float mM = this.getConvolutionProduct(fa, fb, f);
                float wab = w[fa] * w[fb];
                nom += wab * (1.0f - 2.0f * mM / (mm + MM));
                den += wab;
            }
        }
        return den != 0.0f ? nom / den : 0.0f;
    }

    public final float getAsymmetricFBPA(PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        float nom = 0.0f;
        float den = 0.0f;
        float[] w = p.getWeights();
        for (int fa = 0; fa < p.getNumberOfFeatures(); ++fa) {
            for (int fb = 0; fb < p.getNumberOfFeatures(); ++fb) {
                float MM = f.getConvolutionProduct(fa, fb, f);
                float mm = this.getAsymetricConvolutionProduct(fa, fb, f, true);
                if (!(mm + MM > 0.0f)) continue;
                float mM = this.getAsymetricConvolutionProduct(fa, fb, f, false);
                float wab = w[fa] * w[fb];
                nom += wab * (1.0f - 2.0f * mM / (mm + MM));
                den += wab;
            }
        }
        return den != 0.0f ? nom / den : 0.0f;
    }

    private float getConvolutionProduct(int fa, int fb, PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        float[][] exp = p.getFuzzyExponents();
        float cp = 0.0f;
        for (int d1 = p.getMinDist(); d1 < p.getMaxDist(); d1 += p.getResolution()) {
            float psim = this.get(fa, fb, d1);
            for (int d2 = p.getMinDist(); d2 < p.getMaxDist(); d2 += p.getResolution()) {
                cp += psim * f.get(fa, fb, d2) * exp[d1][d2];
            }
        }
        return cp;
    }

    private float getAsymetricConvolutionProduct(int fa, int fb, PharmacophoreFingerprint M2, boolean self) {
        PharmacophoreFingerprint fM = M2;
        PFParameters p = (PFParameters)this.params;
        float[][] exp = p.getFuzzyExponents();
        float cp = 0.0f;
        float epsilon = p.getAsymmetryFactor();
        for (int d1 = p.getMinDist(); d1 < p.getMaxDist(); d1 += p.getResolution()) {
            float psim = this.get(fa, fb, d1);
            for (int d2 = p.getMinDist(); d2 < p.getMaxDist(); d2 += p.getResolution()) {
                float psiM = fM.get(fa, fb, d2);
                float psiStar = Math.min(psim, psiM);
                float psiEps = (1.0f - epsilon) * psiStar + epsilon * psim;
                cp += psiEps * (self ? psiEps : psiM) * exp[d1][d2];
            }
        }
        return cp;
    }

    public final float getTanimoto(PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        this.calculateXYZ(f);
        if (p.isAsymmetric()) {
            float alpha = p.getAsymmetryFactor();
            return 1.0f - p.xyz[0] / (alpha * (p.xyz[1] - p.xyz[0]) + (1.0f - alpha) * (p.xyz[2] - p.xyz[0]) + p.xyz[0]);
        }
        return 1.0f - p.xyz[0] / (p.xyz[1] + p.xyz[2] - p.xyz[0]);
    }

    public float getTversky(PharmacophoreFingerprint f) {
        return Metrics.tversky(this.fp, this.params.getTverskyAlpha(), f.fp, this.params.getTverskyBeta());
    }

    public final float getScaledTanimoto(PharmacophoreFingerprint f, PharmacophoreFingerprint hypothesis) {
        PFParameters p = (PFParameters)this.params;
        if (hypothesis == null) {
            return this.getTanimoto(f);
        }
        this.calculateXYZ(f, hypothesis);
        if (p.isAsymmetric()) {
            float alpha = p.getAsymmetryFactor();
            return 1.0f - p.xyz[0] / (alpha * (p.xyz[1] - p.xyz[0]) + (1.0f - alpha) * (p.xyz[2] - p.xyz[0]) + p.xyz[0]);
        }
        return 1.0f - p.xyz[0] / (p.xyz[1] + p.xyz[2] - p.xyz[0]);
    }

    private void calculateXYZ(PharmacophoreFingerprint f) {
        PFParameters p = (PFParameters)this.params;
        p.xyz[2] = 0.0f;
        p.xyz[1] = 0.0f;
        p.xyz[0] = 0.0f;
        for (int i = 0; i < this.fp.length; ++i) {
            p.xyz[0] = p.xyz[0] + Math.min(this.fp[i], f.fp[i]);
            p.xyz[1] = p.xyz[1] + this.fp[i];
            p.xyz[2] = p.xyz[2] + f.fp[i];
        }
    }

    private void calculateXYZ(PharmacophoreFingerprint f, PharmacophoreFingerprint hypothesys) {
        PFParameters p = (PFParameters)this.params;
        float sf = p.getScaleFactor();
        p.xyz[2] = 0.0f;
        p.xyz[1] = 0.0f;
        p.xyz[0] = 0.0f;
        for (int i = 0; i < this.fp.length; ++i) {
            float csf = hypothesys.get(i) == 0.0f ? 1.0f : sf * hypothesys.get(i);
            p.xyz[0] = p.xyz[0] + Math.min(this.fp[i], f.fp[i]) * csf;
            p.xyz[1] = p.xyz[1] + this.fp[i] * csf;
            p.xyz[2] = p.xyz[2] + f.fp[i] * csf;
        }
    }

    private void incBin(int bi, int value) {
        int n = bi;
        this.fp[n] = this.fp[n] + (float)value;
    }

    private void incBin(int bi, float value) {
        int n = bi;
        this.fp[n] = this.fp[n] + value;
    }

    private void putBin(int bi, int newValue) {
        this.fp[bi] = newValue;
    }

    private void putBin(int bi, float newValue) {
        this.fp[bi] = newValue;
    }

    private float getBin(int bi) {
        return this.fp[bi];
    }

    public int index(int fa, int fb, int dist) {
        PFParameters p = (PFParameters)this.params;
        return (fa * (fa + 1) / 2 + fb) * p.getNDists() + (dist - p.getMinDist()) / p.getResolution();
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2) {
        return this.getDissimilarity(fp2, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2, int metricIndex) {
        this.params.setCurrentParametrizedMetric(metricIndex);
        int mi = this.params.getInternalMetricIndex();
        PFParameters p = (PFParameters)this.params;
        float pena = 1.0f;
        float diss = 0.0f;
        boolean as = p.isAsymmetric();
        switch (mi) {
            case 0: {
                diss = pena * (p.isScaled() ? this.getScaledTanimoto((PharmacophoreFingerprint)fp2, (PharmacophoreFingerprint)p.getScalingHypothesis()) : this.getTanimoto((PharmacophoreFingerprint)fp2));
                return diss > 1.0f ? 1.0f : diss;
            }
            case 1: {
                boolean w = p.isWeighted();
                diss = !as && !w ? pena * this.getEuclidean((PharmacophoreFingerprint)fp2) : (as && !w ? pena * this.getAsymmetricEuclidean((PharmacophoreFingerprint)fp2) : (!as && w ? pena * this.getWeightedEuclidean((PharmacophoreFingerprint)fp2) : pena * this.getWeightedAsymmetricEuclidean((PharmacophoreFingerprint)fp2)));
                if (!p.isNormalized()) {
                    return diss;
                }
                return diss > 1.0f ? 1.0f : diss;
            }
            case 2: {
                diss = !as ? pena * this.getSymmetricFBPA((PharmacophoreFingerprint)fp2) : pena * this.getAsymmetricFBPA((PharmacophoreFingerprint)fp2);
                return diss;
            }
            case 3: {
                diss = this.getTversky((PharmacophoreFingerprint)fp2);
                return diss > 1.0f ? 1.0f : diss;
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + metricIndex + ") passed to PharmacophoreFingerprint.getDissimilarity()");
    }

    @Override
    public float getLowerBound(MolecularDescriptor fp2) {
        return 0.0f;
    }

    public boolean isSubsetOf(PharmacophoreFingerprint d) {
        PharmacophoreFingerprint pd = d;
        for (int i = 0; i < this.params.getLength(); ++i) {
            if (!(this.get(i) > pd.get(i))) continue;
            return false;
        }
        return true;
    }

    private float calcPharmacophorePenalty(PharmacophoreFingerprint pf) {
        int nCommon = 0;
        int nInThis = 0;
        int nInPf = 0;
        PFParameters p = (PFParameters)this.params;
        for (int fa = 0; fa < p.getNumberOfFeatures(); ++fa) {
            block1: for (int fb = 0; fb <= fa; ++fb) {
                for (int dist = p.getMinDist(); dist <= p.getMaxDist(); dist += p.getResolution()) {
                    boolean inPf;
                    boolean inThis = this.get(fa, fb, dist) > 0.0f;
                    boolean bl = inPf = pf.get(fa, fb, dist) > 0.0f;
                    if (inThis) {
                        if (inPf) {
                            ++nCommon;
                            continue block1;
                        }
                        ++nInThis;
                        continue block1;
                    }
                    if (!inPf) continue;
                    ++nInPf;
                    continue block1;
                }
            }
        }
        return nCommon != 0 ? (float)(nInThis + nInPf) / (float)nCommon : (float)(nInThis + nInPf);
    }

    public float getMaxDist() {
        return ((PFParameters)this.params).getMaxDist();
    }

    public float getMinDist() {
        return ((PFParameters)this.params).getMinDist();
    }

    public float getResolution() {
        return ((PFParameters)this.params).getResolution();
    }

    public int getNumberOfFeatures() {
        return ((PFParameters)this.params).getNumberOfFeatures();
    }

    public String getSymbol(int feature) {
        return ((PFParameters)this.params).getSymbol(feature);
    }

    public float get(int feature1, int feature2, float dist) {
        return this.get(feature1, feature2, (int)dist);
    }
}

