/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.struc.Molecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import chemaxon.util.MolHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Random;

public class RandomMoleculeSubset {
    private static final String NL = System.getProperty("line.separator");
    private static final String PrgName = "RandomMS";
    private static final String PrgHeader = NL + "RandomMS" + " - " + "Select subset of molecules, (C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Randomly selects given number of molecules from a larger set." + NL + "" + NL + "Usage: randomms <input file> <selected output file> <not selected output file> [<options>]" + NL + "" + NL + "General options: " + NL + "  -h, --help               this help message" + NL + "  -v, --verbose            verbose" + NL + "" + NL + "Subset options:" + NL + "  -p, --percentage <value> percentage of molecules to select. Default is 50%. " + NL + "  -n, --size <value>       number of molecules to select. Alternative to" + NL + "                             giving percentage." + NL + "" + NL + "";
    private static boolean verbose = false;
    private static String inFileName = null;
    private static String selectedFileName = null;
    private static String notSelectedFileName = null;
    private static int nSamples = 0;
    private static float percentage = 50.0f;

    public static void main(String[] args) {
        verbose = false;
        inFileName = null;
        selectedFileName = null;
        notSelectedFileName = null;
        nSamples = 0;
        percentage = 50.0f;
        try {
            if (RandomMoleculeSubset.processCmdLine(args)) {
                int l;
                int n;
                int nMolecules = 0;
                RandomMoleculeSubset.verboseMsg("Reading input file " + inFileName + NL);
                BufferedInputStream inFile = new BufferedInputStream(new FileInputStream(inFileName));
                MolImporter molImp = new MolImporter(new MolInputStream(inFile));
                while (molImp.read() != null) {
                    ++nMolecules;
                }
                if (nSamples == 0) {
                    nSamples = (int)Math.ceil(percentage / 100.0f * (float)nMolecules);
                }
                inFile.close();
                RandomMoleculeSubset.verboseMsg("Initializing output file " + selectedFileName + NL);
                PrintStream selectedFile = new PrintStream(new FileOutputStream(selectedFileName));
                RandomMoleculeSubset.verboseMsg("Initializing output file " + notSelectedFileName + NL);
                PrintStream notSelectedFile = new PrintStream(new FileOutputStream(notSelectedFileName));
                if (nSamples > nMolecules) {
                    nSamples = nMolecules;
                }
                int windowSize = Math.IEEEremainder(nMolecules, nSamples) == 0.0 ? nMolecules / nSamples : (Math.IEEEremainder(nMolecules, nSamples - 1) != 0.0 ? nMolecules / (nSamples - 1) : nMolecules / (nSamples - 1) - 1);
                Random r = new Random();
                inFile = new BufferedInputStream(new FileInputStream(inFileName));
                molImp = new MolImporter(new MolInputStream(inFile));
                String inFormat = molImp.getFormat();
                inFormat = MolHandler.isDaylightFormat(inFormat) ? "smiles" : inFormat;
                String outFormat = inFormat.equals("mol") ? "sdf" : inFormat;
                String sep = MolHandler.isDaylightFormat(inFormat) ? "\n" : "";
                for (int w = 0; w < nSamples - 1; ++w) {
                    n = r.nextInt(windowSize);
                    for (l = 0; l < n; ++l) {
                        Molecule cm = molImp.read();
                        notSelectedFile.print(cm.toFormat(outFormat) + sep);
                    }
                    RandomMoleculeSubset.verboseMsg("      Selecting molecule nr." + (w * windowSize + n + 1) + NL);
                    selectedFile.print(molImp.read().toFormat(outFormat) + sep);
                    for (l = n + 1; l < windowSize; ++l) {
                        notSelectedFile.print(molImp.read().toFormat(outFormat) + sep);
                    }
                }
                int nRemaining = nMolecules - windowSize * (nSamples - 1);
                n = r.nextInt(nRemaining);
                for (l = 0; l < n; ++l) {
                    notSelectedFile.print(molImp.read().toFormat(outFormat) + sep);
                }
                RandomMoleculeSubset.verboseMsg("      Selecting molecule nr." + ((nSamples - 1) * windowSize + n + 1) + NL);
                selectedFile.print(molImp.read().toFormat(outFormat) + sep);
                for (l = n + 1; l < nRemaining; ++l) {
                    notSelectedFile.print(molImp.read().toFormat(outFormat) + sep);
                }
                inFile.close();
                selectedFile.close();
                notSelectedFile.close();
                RandomMoleculeSubset.verboseDone();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static boolean processCmdLine(String[] args) throws ArgumentException {
        int pPos;
        if (args.length == 0) {
            System.out.println(UsageInfo);
            return false;
        }
        CmdLine cmdLine = new CmdLine(args);
        if (cmdLine.exists('h', "help")) {
            System.out.println(UsageInfo);
            return false;
        }
        inFileName = cmdLine.getFileName(0);
        if (inFileName == null) {
            throw new ArgumentException("Missing input file name");
        }
        selectedFileName = cmdLine.getFileName(1);
        if (selectedFileName == null) {
            throw new ArgumentException("Missing 'selected' output file name");
        }
        notSelectedFileName = cmdLine.getFileName(2);
        if (notSelectedFileName == null) {
            throw new ArgumentException("Missing 'not selected' output file name");
        }
        verbose = cmdLine.exists('v', "verbose");
        RandomMoleculeSubset.verboseMsg(PrgHeader + NL);
        int nPos = cmdLine.find('n', "size", 1);
        if (nPos != -1) {
            nSamples = cmdLine.getInt(nPos + 1);
        }
        if ((pPos = cmdLine.find('p', "percentage", 1)) != -1) {
            percentage = cmdLine.getFloat(pPos + 1);
        }
        return true;
    }

    private static void verboseMsg(String msg) {
        if (verbose) {
            System.out.print(msg);
            System.out.flush();
        }
    }

    private static void verboseDone() {
        if (verbose) {
            System.out.println(" done");
        }
    }
}

