/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.common.util.ArrayTools;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.Metrics;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.RFParameters;
import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.File;
import java.text.ParseException;
import java.util.StringTokenizer;

public class ReactionFingerprint
extends MolecularDescriptor {
    protected int[] fp = null;
    protected int brightness = 0;
    private static final String[] metrics = new String[]{"ReactantTanimoto", "ProductTanimoto", "CoarseReactionTanimoto", "MediumReactionTanimoto", "StrictReactionTanimoto"};
    private static final float[] defaultThresholds = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f};
    private int defaultMetricIndex = 3;
    private boolean reactionMappingIncomplete;

    public ReactionFingerprint() {
    }

    public ReactionFingerprint(RFParameters params) {
        super(params);
        this.fp = new int[params.getInternalSize()];
        this.clear();
    }

    public ReactionFingerprint(String params) {
        this.setParameters(params);
        this.clear();
    }

    public ReactionFingerprint(ReactionFingerprint rfp) {
        super(rfp.params);
        if (rfp.fp != null) {
            this.fp = new int[rfp.fp.length];
            for (int i = 0; i < this.fp.length; ++i) {
                this.fp[i] = rfp.fp[i];
            }
            this.brightness = rfp.brightness;
        } else {
            this.fp = null;
        }
    }

    @Override
    public ReactionFingerprint clone() {
        return new ReactionFingerprint(this);
    }

    @Override
    public String getName() {
        return "Reaction Fingerprint";
    }

    @Override
    public String getShortName() {
        return "RF";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.RFParameters";
    }

    public int getBrightness() {
        return this.brightness;
    }

    @Override
    public void setParameters(MDParameters parameters) {
        super.setParameters(parameters);
        if (this.fp == null || this.fp.length < this.params.getInternalSize()) {
            this.fp = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new RFParameters(parameters));
            this.fp = new int[this.params.getInternalSize()];
        } else {
            this.params.fromString(parameters);
        }
    }

    @Override
    public byte[] toData() {
        byte[] d = this.params.data;
        for (int i = 0; i < this.fp.length; ++i) {
            int v = this.fp[i];
            for (int j = 3; j >= 0; --j) {
                d[i * 4 + j] = (byte)(v & 0xFF);
                v >>>= 8;
            }
        }
        return d;
    }

    @Override
    public void fromData(byte[] dbRepr) {
        this.brightness = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            int v = 0;
            for (int j = 0; j < 4; ++j) {
                v <<= 8;
                v += (dbRepr[i * 4 + j] + 256) % 256;
            }
            this.brightness += Metrics.calcBitCount(v);
            this.fp[i] = v;
        }
    }

    public final void clear() {
        for (int i = 0; i < this.fp.length; ++i) {
            this.fp[i] = 0;
        }
        this.brightness = 0;
    }

    @Override
    public final String toString() {
        return this.toDecimalString();
    }

    @Override
    public final String toDecimalString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fp.length; ++i) {
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(this.fp[i]);
        }
        return sb.toString();
    }

    @Override
    public String toBinaryString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.params.getLength(); ++i) {
            sb.append(this.get(i));
            if ((i + 1) % 8 != 0) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    @Override
    public final void fromString(String cfp) throws ParseException {
        RFParameters p = (RFParameters)this.params;
        this.clear();
        try {
            this.brightness = 0;
            StringTokenizer st = new StringTokenizer(cfp, "\t ");
            for (int i = 0; i < this.fp.length; ++i) {
                this.fp[i] = Integer.parseInt(st.nextToken());
                this.brightness += Metrics.calcBitCount(this.fp[i]);
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(cfp + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(cfp + " contains invalid numbers", 0);
        }
    }

    @Override
    public final float[] toFloatArray() {
        float[] toReturn = new float[this.params.getLength()];
        for (int a = 0; a < toReturn.length; ++a) {
            toReturn[a] = this.get(a);
        }
        return toReturn;
    }

    @Override
    public void fromFloatArray(float[] descr) throws RuntimeException {
        this.clear();
        int bc = 0;
        for (int i = 0; i < descr.length; ++i) {
            this.set(bc++, Math.round(descr[i]));
        }
        this.calcBrightness();
    }

    private void set(int cellIndex, int value) throws RuntimeException {
        if (value == 0) {
            return;
        }
        if (value == 1) {
            int n = cellIndex / 32;
            this.fp[n] = this.fp[n] | 1 << 31 - cellIndex % 32;
            return;
        }
        throw new RuntimeException("Value out of range, should be 0 or 1.");
    }

    private int get(int cellIndex) {
        return (this.fp[cellIndex / 32] & 1 << 31 - cellIndex % 32) == 0 ? 0 : 1;
    }

    private void calcBrightness() {
        this.brightness = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            this.brightness += Metrics.calcBitCount(this.fp[i]);
        }
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        try {
            String[] propertyNames = ((RFParameters)this.params).generate(m, this);
            this.reactionMappingIncomplete = ((RFParameters)this.params).isReactionMappingIncomplete();
            return propertyNames;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    public boolean isReactionMappingIncomplete() {
        return this.reactionMappingIncomplete;
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    public int[] getDissimilarityMetricsParamNum() {
        int[] numOfParams = new int[metrics.length];
        numOfParams = ArrayTools.initArrayAndFill(numOfParams, numOfParams.length, 0);
        return numOfParams;
    }

    public String[] getDissimilarityMetricsParamNames() {
        return this.getEmptyMetricStringArray();
    }

    private String[] getEmptyMetricStringArray() {
        String[] res = new String[metrics.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = "";
        }
        return res;
    }

    public String[] getDissimilarityMetricsParamRanges() {
        return this.getEmptyMetricStringArray();
    }

    public String[] getDissimilarityMetricsParamDefault() {
        return this.getEmptyMetricStringArray();
    }

    public String[] getDissimilarityMetricsParamHelp() {
        return this.getEmptyMetricStringArray();
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    @Override
    public int getDefaultMetricIndex() {
        return this.defaultMetricIndex;
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return defaultThresholds[metricIndex];
    }

    public int getCommonBitCount(ReactionFingerprint f) {
        int x = 0;
        for (int i = 0; i < this.fp.length; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
        }
        return x;
    }

    private float getTanimotoFT(ReactionFingerprint f, int from, int to) {
        int x = 0;
        int y = 0;
        int z = 0;
        for (int i = from; i < to; ++i) {
            x += Metrics.calcBitCount(this.fp[i] & f.fp[i]);
            y += Metrics.calcBitCount(this.fp[i]);
            z += Metrics.calcBitCount(f.fp[i]);
        }
        if (this.params.isAsymmetric()) {
            float alpha = this.params.getAsymmetryFactor();
            return 1.0f - (float)x / (alpha * (float)(y - x) + (1.0f - alpha) * (float)(z - x) + (float)x);
        }
        return y + z - x == 0 ? 0.0f : 1.0f - (float)x / (float)(y + z - x);
    }

    public float getReactantTanimoto(ReactionFingerprint f) {
        return this.getTanimotoFT(f, 0, this.fp.length / 4);
    }

    public float getProductTanimoto(ReactionFingerprint f) {
        return this.getTanimotoFT(f, this.fp.length / 4, this.fp.length / 2);
    }

    public float getCoarseReactionTanimoto(ReactionFingerprint f) {
        float pCenterTanimoto;
        float rCenterTanimoto = this.getTanimotoFT(f, this.fp.length / 2, 9 * this.fp.length / 16);
        return rCenterTanimoto > (pCenterTanimoto = this.getTanimotoFT(f, 9 * this.fp.length / 16, 10 * this.fp.length / 16)) ? rCenterTanimoto : pCenterTanimoto;
    }

    public float getMediumReactionTanimoto(ReactionFingerprint f) {
        float pCenterTanimoto;
        float rCenterTanimoto = this.getTanimotoFT(f, 10 * this.fp.length / 16, 11 * this.fp.length / 16);
        float medium = rCenterTanimoto > (pCenterTanimoto = this.getTanimotoFT(f, 11 * this.fp.length / 16, 12 * this.fp.length / 16)) ? rCenterTanimoto : pCenterTanimoto;
        float coarse = this.getCoarseReactionTanimoto(f);
        return medium < coarse ? coarse : medium;
    }

    public float getStrictReactionTanimoto(ReactionFingerprint f) {
        float pCenterTanimoto;
        float rCenterTanimoto = this.getTanimotoFT(f, 6 * this.fp.length / 7, 7 * this.fp.length / 8);
        float strict = rCenterTanimoto > (pCenterTanimoto = this.getTanimotoFT(f, 7 * this.fp.length / 8, this.fp.length)) ? rCenterTanimoto : pCenterTanimoto;
        float medium = this.getMediumReactionTanimoto(f);
        return strict < medium ? medium : strict;
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2) {
        return this.getDissimilarity(fp2, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor fp2, int metricIndex) {
        this.params.setCurrentParametrizedMetric(metricIndex);
        int mi = this.params.getInternalMetricIndex();
        switch (mi) {
            case 0: {
                return this.getReactantTanimoto((ReactionFingerprint)fp2);
            }
            case 1: {
                return this.getProductTanimoto((ReactionFingerprint)fp2);
            }
            case 2: {
                return this.getCoarseReactionTanimoto((ReactionFingerprint)fp2);
            }
            case 3: {
                return this.getMediumReactionTanimoto((ReactionFingerprint)fp2);
            }
            case 4: {
                return this.getStrictReactionTanimoto((ReactionFingerprint)fp2);
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + metricIndex + ") passed to ReactionFingerprint.getDistance()");
    }

    @Override
    public float getLowerBound(MolecularDescriptor fp2) {
        return 0.0f;
    }

    public boolean isSubSetOf(ReactionFingerprint f) {
        for (int i = 0; i < this.fp.length; ++i) {
            if ((this.fp[i] & f.fp[i]) == this.fp[i]) continue;
            return false;
        }
        return true;
    }

    public static int[] getChemicalHashedFingerprint(int[] reactionFingerprint, int length) {
        int columns = length / 4;
        int[] result = new int[columns];
        for (int x = 0; x < columns; ++x) {
            result[x] = reactionFingerprint[x] | reactionFingerprint[columns + x];
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            ReactionFingerprint rfp = new ReactionFingerprint(new RFParameters(new File("rfp.xml")));
            Molecule m = MolImporter.importMol("CC(O)=O.CCO>>CCOC(C)=O");
            rfp.generate(m);
            System.out.println(rfp.toString());
            ReactionFingerprint rp = rfp.clone();
            rp.clear();
            rp.fromString(rfp.toString());
            System.out.println(rp.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

