/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.ScalarDescriptor;
import chemaxon.jchem.version.VersionInfo;
import java.io.File;
import org.dom4j.Element;

public class SDParameters
extends MDParameters {
    private Element parameters = null;

    public SDParameters() {
        this.init();
        this.setLength(1);
    }

    public SDParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
    }

    public SDParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
    }

    @Override
    public void setLength(int length) throws MDParametersException {
        if (length != 1) {
            throw new MDParametersException("ScalarDescriptor length should  always be 1.");
        }
        super.setLength(length);
        this.initParameters();
    }

    @Override
    public int getNumberOfMetrics() {
        return 1;
    }

    protected void init() {
        this.md = new ScalarDescriptor();
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.internalSize = 1;
        this.data = new byte[this.internalSize * 4 + 1];
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("ScalarDescriptorConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("//ScalarDescriptorConfiguration/ScalarDescriptors");
            if (this.parameters == null) {
                throw new MDParametersException("Parameter configuration error. ");
            }
        }
        super.processDocument(all);
    }

    public String getType() {
        return ((Element)this.parameters.selectSingleNode("ScalarDescriptor")).attributeValue("Name");
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
    }
}

