/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ECFPParameters;
import chemaxon.descriptors.MDArrayReader;
import chemaxon.descriptors.MDDBReader;
import chemaxon.descriptors.MDFileReader;
import chemaxon.descriptors.MDHypothesisCreator;
import chemaxon.descriptors.MDHypothesisGenerator;
import chemaxon.descriptors.MDMedHypothesisGenerator;
import chemaxon.descriptors.MDMinHypothesisGenerator;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSimilarity;
import chemaxon.descriptors.MDSimilarityResultWriter;
import chemaxon.descriptors.MDSimilaritySDfileWriter;
import chemaxon.descriptors.MDSimilarityStatWriter;
import chemaxon.descriptors.MDSimilarityTableWriter;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PFParameters;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ShapeParameters;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import chemaxon.util.ConnectionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ScreenMD {
    private static final String NL = System.getProperty("line.separator");
    private static final String UserHome = System.getProperty("user.home");
    private static final String FileSep = System.getProperty("file.separator");
    private static final String PrgName = "ScreenMD";
    private static final String PrgHeader = NL + "ScreenMD" + " - " + "Molecular Descriptor Screening " + VersionInfo.JCHEM_VERSION + ", (C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Screens a given set of molecules against a given set of actives." + NL + "" + NL + "Usage: screenmd [<target input file>] <query input file> [options]" + NL + "" + NL + "General options: " + NL + "  -h, --help               this help message" + NL + "  -x, --expert-help        advanced options for expert users" + NL + "  -v, --verbose            verbose" + NL + "  -s  --saveconf           saves database settings" + NL + "" + NL + "Input/Output options:" + NL + "  -a, --table-name <name>  name of the structure table" + NL + "  -q, --query <where>      where clause of select statements to read targets" + NL + "  -o, --output [ TABLE | SDF ] <filepath> " + NL + "                           output file type and name with full path" + NL + "                             Flag can be given more than once" + NL + "  -g, --generate-id [<first>] " + NL + "                           generate unique structure identifiers" + NL + "                             an optional value for the first ID can be given" + NL + "  -e, --precision <prec>   number of decimal places after the decimal point" + NL + "" + NL + "Database options:" + NL + "  -d, --driver <JDBC>      JDBC driver" + NL + "  -u, --dburl <url>        URL of database" + NL + "  -l, --login <login>      login name" + NL + "  -p, --password <pwd>     password" + NL + "" + NL + "Descriptor options: " + NL + "  -k, --descriptor <type> <descriptor options> " + NL + "                           create and use descriptors of the given type " + NL + "  -k, --descriptor <name>  use descriptors created and stored previously" + NL + "" + NL + "Descriptor options: " + NL + "  -c, --config <configfile> " + NL + "                           path and name of the XML configuration file" + NL + "  -t, --use-tag [<name>]   use existing descriptor data" + NL + "  -M, --metric {<name>}    use the metric <name> as specified in the config file" + NL + "                             More than one metrics can be specified." + NL + "" + NL + "Similarity options:" + NL + "  -L, --threshold          dissimilarity threshold " + NL + "  -Q, --compare-queries    compare against query descriptor sets" + NL + "  -H, --compare-hypothesis [<name> [C]]" + NL + "                           generate hypothesis <name> and compare against it" + NL + "                             Valid names are: Minimum, Average, Median." + NL + "                             Default hypothesis type is Minimum." + NL + "                             'C' indicates consensus fingerprint." + NL + "                             This flag may occur more than once with different" + NL + "                             hypothesis types." + NL + "" + NL + "";
    private static final String ExpertOptions = "" + NL + "Advanced options for expert users:" + NL + "" + NL + "SDfile options:" + NL + "  -I, --id-tag <name>      name of the tag storing unique molecule identifiers" + NL + "  -N, --mol-name <name>    name of the tag storing compound name" + NL + "" + NL + "Database options:" + NL + "  -O, --proptable <table>  name of the property table" + NL + "" + NL + "2D pharmacophore fingerprint options:" + NL + "  -P, --PMAP-tag [<name>]  use existing PMAP data" + NL + "" + NL + "Similarity options:" + NL + "  -C, --component-wise     apply threshold for individual descriptors" + NL + "  -r, --descriptors-and    thresholds for all descriptors, default is any" + NL + "  -m, --metrics-and        thresholds for all metrics, default is any" + NL + "  -Z, --zero-threshold     percentage threshold for zero limit in median" + NL + "                             hypothesis" + NL + "" + NL + "";
    private static final String Examples = "" + NL + "Examples:" + NL + "  screenmd targets.sdf queries.smiles -g -k PF -c pharma-frag.xml" + NL + "  screenmd targets.sdf queries.smiles -g -k PF -c pharma-frag.xml -k CF -c cfp.xml" + NL + "  screenmd query.smiles -k pfp.file " + NL + "    (after: generatemd c target.smiles -k PF -c pharma-frag.xml -o pfp.file) " + NL + "  screenmd queries.sdf -a compr1 -d \"org.gjt.mm.mysql.Driver\" " + NL + "    -u \"jdbc:mysql://localhost/cdexample\" -l cduser -p secret -s " + NL + "    -k my_descr -M Tanimoto Euclidean " + NL + "" + NL + "";
    private CmdLine cmdLine = null;
    private boolean verbose = false;
    private int verboseFreq = 1000;
    private String targetFileName = null;
    private String queryFileName = null;
    private String structureTableName = null;
    private String dbSelectTarget = null;
    private boolean dbInput;
    private boolean targetDescrInput = false;
    private int descriptorCount = 0;
    private String[] descrTypes = null;
    private String[] tagNames = null;
    private String[] descrNames = null;
    private String[] params = null;
    private String[] PMAPtag = null;
    private String idTagName = null;
    private String nameTagName = null;
    private boolean generateId = false;
    private int firstId = 1;
    private boolean sdfOutput = false;
    private ArrayList hypoNames = new ArrayList();
    private float zeroThreshold = -1.0f;
    private MDReader queryReader = null;
    private MDReader targetReader = null;
    private MDSimilarityResultWriter resultWriter = null;
    private ArrayList outFiles = new ArrayList();
    private ArrayList outFileTypes = new ArrayList();
    private int precision = 2;
    private int scalingHypoIndex = -1;
    private float threshold = 30.0f;
    private String[][] metricNames = null;
    private boolean componentWise = false;
    private boolean compareQueries = false;
    private boolean andDescriptors = false;
    private boolean andMetrics = false;
    private Properties dbConnectionProperties = null;
    private SettingsHandler settingsHandler = null;
    private ConnectionHandler connHandler = null;
    private MDTableHandler mdTableHandler = null;
    private MDSet mdSet = null;
    private MDSimilarity similarity = null;
    private boolean verboseSet = false;

    protected ScreenMD() {
    }

    public static void main(String[] args) {
        ScreenMD screen = new ScreenMD();
        try {
            if (args.length > 0 && args[0].equals("config")) {
                args = ScreenMD.getArgsFromXML(args);
            }
            screen.cmdLine = new CmdLine(args);
            if (screen.processCmdLineOptions()) {
                screen.initSources();
                screen.initSimilarity();
                screen.initResultWriters();
                screen.verboseMsg(NL + "Processing started at " + new GregorianCalendar().getTime() + NL);
                screen.compare();
                screen.queryReader.close();
                screen.targetReader.close();
                if (screen.connHandler != null) {
                    screen.connHandler.getConnection().close();
                }
                screen.verboseMsg("Processing finished at " + new GregorianCalendar().getTime() + NL);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void initSimilarity() throws MDReaderException, ArgumentException {
        this.similarity = new MDSimilarity();
        MDArrayReader qar = new MDArrayReader(this.queryReader);
        if (this.compareQueries) {
            this.similarity.addQueries(qar);
            qar.reset();
        }
        boolean supportHypo = true;
        for (int i = 0; i < this.descriptorCount; ++i) {
            if (this.descrTypes[i].equalsIgnoreCase("ChemicalFingerprint") || this.descrTypes[i].equalsIgnoreCase("CF") || this.descrTypes[i].equalsIgnoreCase("PharmacophoreFingerprint") || this.descrTypes[i].equalsIgnoreCase("PF")) continue;
            supportHypo = false;
            if (this.hypoNames.size() <= 0) break;
            throw new ArgumentException(this.descrTypes[i] + " does not support hypothesis generation.");
        }
        for (int h = 0; h < this.hypoNames.size(); ++h) {
            MDHypothesisGenerator hypoGen = MDHypothesisCreator.create((String)this.hypoNames.get(h));
            if (hypoGen instanceof MDMedHypothesisGenerator && this.zeroThreshold >= 0.0f) {
                ((MDMedHypothesisGenerator)hypoGen).setZeroPercentageThreshold(this.zeroThreshold);
            }
            MDSet query = qar.next();
            while (query != null) {
                hypoGen.add(query);
                query = qar.next();
            }
            MDSet hypothesis = hypoGen.generate();
            this.similarity.addQuery(hypothesis);
            if (h == this.scalingHypoIndex) {
                for (int d = 0; d < hypothesis.size(); ++d) {
                    MolecularDescriptor component = hypothesis.getDescriptor(d);
                    component.getParameters().setScalingHypothesis(component);
                }
            }
            qar.reset();
        }
        if (supportHypo && this.scalingHypoIndex == -1) {
            MDMinHypothesisGenerator hypoGen = new MDMinHypothesisGenerator();
            MDSet query = qar.next();
            while (query != null) {
                hypoGen.add(query);
                query = qar.next();
            }
            qar.reset();
            MDSet hypothesis = hypoGen.generate();
            for (int d = 0; d < hypothesis.size(); ++d) {
                MolecularDescriptor component = hypothesis.getDescriptor(d);
                component.getParameters().setScalingHypothesis(component);
            }
        }
        this.similarity.setComponentWise(this.componentWise);
        MDSet mds = this.mdSet != null ? this.mdSet : this.targetReader.getMDSet();
        for (int di = 0; di < this.descriptorCount; ++di) {
            MolecularDescriptor md = mds.getDescriptor(di);
            if (this.metricNames[di] == null) {
                if (!this.componentWise) continue;
                for (int i = 0; i < md.getNumberOfMetrics(); ++i) {
                    this.similarity.useMetric(di, i);
                }
                continue;
            }
            if (this.componentWise) {
                for (int mi = 0; mi < this.metricNames[di].length; ++mi) {
                    this.similarity.useMetric(di, md.getMetricIndex(this.metricNames[di][mi]));
                }
                continue;
            }
            if (this.metricNames[di] == null) continue;
            if (this.metricNames[di].length > 1) {
                this.verboseMsg("Only one metric is allowed in Descriptor Set mode. ");
            }
            this.similarity.useMetric(di, md.getMetricIndex(this.metricNames[di][0]));
        }
        if (!this.componentWise) {
            this.similarity.setThreshold(this.threshold);
        }
        if (this.andMetrics) {
            this.similarity.passWithAllMetrics();
        } else {
            this.similarity.passWithOneMetric();
        }
        if (this.andDescriptors) {
            this.similarity.passWithAllDescriptors();
        } else {
            this.similarity.passWithOneDescriptor();
        }
    }

    private void compare() throws MDReaderException {
        this.similarity.compare(this.targetReader);
    }

    private boolean processCmdLineOptions() throws ArgumentException, FileNotFoundException, IOException, ParseException, MDReaderException, SQLException, MDParametersException {
        if (this.cmdLine.isEmpty() || this.cmdLine.find('h', "help") != -1) {
            System.out.println(UsageInfo + Examples);
            return false;
        }
        if (this.cmdLine.find('x', "expert-help") != -1) {
            System.out.println(UsageInfo + ExpertOptions + Examples);
            return false;
        }
        int v = this.cmdLine.find('v', "verbose", 0, 1);
        boolean bl = this.verbose = v != -1;
        if (v != -1 && this.cmdLine.getParamCount(v) == 1) {
            this.verboseFreq = this.cmdLine.getInt(v + 1);
        }
        this.verboseMsg(PrgHeader + NL);
        this.alloc();
        this.getInputFileNames();
        this.processInputOptions();
        this.processSDFileOptions();
        this.processOutputOptions();
        this.processDatabaseOptions();
        this.processDescriptorOptions();
        this.processSimilarityOptions();
        if (this.descriptorCount == 1) {
            this.componentWise = true;
        }
        this.saveConf();
        return true;
    }

    private void getInputFileNames() throws ArgumentException {
        this.targetFileName = this.cmdLine.getFileName(0);
        if (this.targetFileName == null) {
            throw new ArgumentException("Missing query molecule source file.");
        }
        this.queryFileName = this.cmdLine.getFileName(1);
        if (this.queryFileName == null) {
            this.queryFileName = this.targetFileName;
            this.targetFileName = null;
            this.dbInput = true;
            return;
        }
        if (this.targetFileName != null) {
            this.targetDescrInput = false;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.targetFileName));
                MolImporter molImporter = new MolImporter(new MolInputStream(is));
            }
            catch (MolFormatException mfe) {
                throw new ArgumentException("File " + this.targetFileName + " is not a molecular structure file.");
            }
            catch (IOException e) {
                throw new ArgumentException("File " + this.targetFileName + " could not be opened.");
            }
        }
    }

    private void alloc() throws ArgumentException {
        this.descriptorCount = this.cmdLine.countFlag('k', "descriptor");
        if (this.descriptorCount == 0) {
            throw new ArgumentException("Missing descriptor option.");
        }
        this.descrTypes = new String[this.descriptorCount];
        this.tagNames = new String[this.descriptorCount];
        this.descrNames = new String[this.descriptorCount];
        this.params = new String[this.descriptorCount];
        this.metricNames = new String[this.descriptorCount][];
        this.PMAPtag = new String[this.descriptorCount];
    }

    private void processInputOptions() throws ArgumentException {
        this.structureTableName = this.cmdLine.getParamString('a', "table-name");
        this.dbInput = this.structureTableName != null;
        this.dbSelectTarget = this.cmdLine.getParamString('q', "query");
    }

    private void processSDFileOptions() throws ArgumentException {
        this.idTagName = this.cmdLine.getParamString('I', "id-tag");
        this.nameTagName = this.cmdLine.getParamString('N', "mol-name");
    }

    private void processDatabaseOptions() throws ArgumentException, CmdLine.CmdLineException, SQLException {
        String proptable;
        String passwd;
        String login;
        String url;
        if (this.structureTableName == null) {
            return;
        }
        this.dbConnectionProperties = null;
        try {
            this.settingsHandler = new SettingsHandler();
            Properties presetProperties = this.settingsHandler.getSettings();
            this.dbConnectionProperties = new Properties(presetProperties);
        }
        catch (IOException exc) {
            this.dbConnectionProperties = new Properties();
        }
        String driver = this.cmdLine.getParamString('d', "driver");
        if (driver != null) {
            this.dbConnectionProperties.setProperty("connection.jdbcDriver", driver);
        }
        if ((url = this.cmdLine.getParamString('u', "dburl")) != null) {
            this.dbConnectionProperties.setProperty("connection.jdbcUrl", url);
        }
        if ((login = this.cmdLine.getParamString('l', "login")) != null) {
            this.dbConnectionProperties.setProperty("connection.login", login);
        }
        if ((passwd = this.cmdLine.getParamString('p', "password")) != null) {
            this.dbConnectionProperties.setProperty("connection.password", passwd);
        }
        if ((proptable = this.cmdLine.getParamString('T', "proptable")) != null) {
            this.dbConnectionProperties.setProperty("connection.propertyTable", proptable);
        }
        if (this.dbConnectionProperties.getProperty("connection.jdbcDriver") == null) {
            throw new ArgumentException("Missing JDBC driver");
        }
        if (this.dbConnectionProperties.getProperty("connection.jdbcUrl") == null) {
            throw new ArgumentException("Missing URL");
        }
        if (this.dbConnectionProperties.getProperty("connection.login") == null) {
            throw new ArgumentException("Missing login name");
        }
        this.connHandler = new ConnectionHandler();
        this.connHandler.loadValuesFromProperties(this.dbConnectionProperties);
        try {
            this.connHandler.connect();
            this.mdTableHandler = new MDTableHandler(this.connHandler, this.structureTableName);
        }
        catch (ClassNotFoundException e) {
            throw new ArgumentException("Invalid driver specification");
        }
        catch (InstantiationException e) {
            throw new ArgumentException("Invalid driver specification");
        }
        catch (IllegalAccessException e) {
            throw new ArgumentException("Invalid driver specification");
        }
    }

    private void processOutputOptions() throws ArgumentException, FileNotFoundException {
        int precPos;
        int genIdPos = this.cmdLine.find('g', "generate-id", 0, 1);
        if (genIdPos != -1) {
            this.generateId = true;
            int n = this.firstId = this.cmdLine.getParamCount(genIdPos) == 1 ? this.cmdLine.getInt(genIdPos + 1) : 1;
        }
        if ((precPos = this.cmdLine.find('e', "precision", 1)) != -1) {
            this.precision = this.cmdLine.getInt(precPos + 1);
        }
        if (this.cmdLine.exists('o', "output")) {
            int oPos = this.cmdLine.find('o', "output", 1, 2);
            while (oPos != -1) {
                boolean defaultType = this.cmdLine.getParamCount(oPos) == 1;
                String type = defaultType ? "table" : this.cmdLine.getString(oPos + 1);
                String fn = this.cmdLine.getString(oPos + (defaultType ? 1 : 2));
                try {
                    this.outFiles.add(new PrintStream(new BufferedOutputStream(new FileOutputStream(fn))));
                    this.outFileTypes.add(type);
                }
                catch (IOException ioe) {
                    System.err.println("Failed to create file " + fn);
                }
                oPos = this.cmdLine.find('o', "output", 1, 2);
            }
        } else {
            this.outFileTypes.add("table");
            this.outFiles.add(System.out);
        }
    }

    private void processDescriptorOptions() throws ArgumentException, IOException, ParseException, SQLException, MDReaderException, MDParametersException {
        for (int i = 0; i < this.descriptorCount; ++i) {
            this.cmdLine.lockDynamicBlock('k', "descriptor");
            this.descrNames[i] = this.cmdLine.getParamString('k', "descriptor");
            if (this.descrNames[i] == null) {
                throw new ArgumentException("Missing descriptor type  or descriptor name");
            }
            boolean isConfig = this.cmdLine.exists('c', "config");
            if (this.dbInput) {
                boolean bl = this.targetDescrInput = !isConfig;
                if (isConfig) {
                    this.descrTypes[i] = this.descrNames[i];
                    this.descrNames[i] = null;
                }
            } else if (this.targetFileName != null) {
                this.descrTypes[i] = this.descrNames[i];
                this.descrNames[i] = null;
                this.targetDescrInput = false;
            } else {
                if (isConfig) {
                    throw new ArgumentException("Config file is not allowed for descriptor file input.");
                }
                this.targetDescrInput = true;
            }
            this.processDescriptorOptions(i);
            this.processMetricOptions(i);
            this.cmdLine.unlockDynamicBlock();
        }
    }

    private void processDescriptorOptions(int descrId) throws MDParametersException {
        int pPos;
        int tPos = this.cmdLine.find('t', "use-tag", 0, 1);
        if (tPos != -1) {
            String string = this.tagNames[descrId] = this.cmdLine.getParamCount(tPos) == 0 ? this.descrNames[descrId] : this.cmdLine.getString(tPos + 1);
        }
        if ((pPos = this.cmdLine.find('P', "PMAP-tag", 0, 1)) != -1) {
            this.PMAPtag[descrId] = this.cmdLine.getString(pPos + 1);
        }
        if (this.targetDescrInput) {
            return;
        }
        int cPos = this.cmdLine.find('c', "config", 1);
        if (cPos != -1) {
            this.params[descrId] = this.cmdLine.getString(cPos + 1);
        }
        if (this.descrTypes[descrId].equalsIgnoreCase("PharmacophoreFingerprint") || this.descrTypes[descrId].equalsIgnoreCase("PF")) {
            this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : new PFParameters().getDefaultDocumentFrame();
        } else if (this.descrTypes[descrId].equalsIgnoreCase("ChemicalFingerprint") || this.descrTypes[descrId].equalsIgnoreCase("CF")) {
            this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : new CFParameters().getDefaultDocumentFrame();
        } else if (this.descrTypes[descrId].equalsIgnoreCase("ECFP")) {
            this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : new ECFPParameters().getDefaultDocumentFrame();
        } else if (this.descrTypes[descrId].equalsIgnoreCase("Shape")) {
            this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : new ShapeParameters().getDefaultDocumentFrame();
        } else if (this.descrTypes[descrId].equalsIgnoreCase("ReactionFingerprint") || this.descrTypes[descrId].equalsIgnoreCase("RF")) {
            this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : new RFParameters().getDefaultDocumentFrame();
        } else {
            MolecularDescriptor md = MolecularDescriptor.newInstance(this.descrTypes[descrId]);
            String paramName = md.getParametersClassName();
            try {
                MDParameters p = (MDParameters)Class.forName(paramName).newInstance();
                if (md.needsConfig()) {
                    this.params[descrId] = cPos != -1 ? this.getParametersFromFile(this.cmdLine.getString(cPos + 1)) : p.getDefaultDocumentFrame();
                }
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
                throw new MDParametersException("Wrong name: custom MolecularDescriptor " + this.descrTypes[descrId] + " is not available. Failed to access MDParameters" + " subclass " + paramName + ".");
            }
        }
    }

    private String getParametersFromFile(String fName) throws MDParametersException {
        try {
            File f = new File(fName);
            char[] s = new char[(int)f.length()];
            FileReader in = new FileReader(f);
            in.read(s);
            return new String(s);
        }
        catch (Exception e) {
            throw new MDParametersException("Failed to read parameter file " + fName + ".");
        }
    }

    private void processMetricOptions(int descrId) throws ArgumentException, IllegalArgumentException {
        int metrPos = this.cmdLine.find('M', "metric", 0, 20);
        if (metrPos != -1) {
            int mp = this.cmdLine.getParamCount(metrPos);
            if (mp == 0) {
                throw new ArgumentException("Missing metric name after the --metric option");
            }
            this.metricNames[descrId] = new String[mp];
            for (int i = 0; i < mp; ++i) {
                this.metricNames[descrId][i] = this.cmdLine.getString(metrPos + i + 1);
            }
        }
    }

    private void processSimilarityOptions() throws ArgumentException {
        Object hypoGen = null;
        int hypoPos = this.cmdLine.find('H', "compare-hypothesis", 0, 2);
        while (hypoPos != -1) {
            if (this.cmdLine.getParamCount(hypoPos) == 0) {
                this.verboseMsg("Using Minimum hypothesis" + NL);
                this.hypoNames.add("Minimum");
                this.scalingHypoIndex = 0;
            } else {
                for (int h = 0; h < MDHypothesisCreator.typeNames.length; ++h) {
                    if (!this.cmdLine.getString(hypoPos + 1).equals(MDHypothesisCreator.typeNames[h])) continue;
                    this.hypoNames.add(MDHypothesisCreator.typeNames[h]);
                    if (this.cmdLine.getParamCount(hypoPos) != 2) continue;
                    if (this.cmdLine.getString(hypoPos + 2).equals("C")) {
                        this.scalingHypoIndex = this.hypoNames.size() - 1;
                        continue;
                    }
                    System.err.println("Invalid option " + this.cmdLine.getString(hypoPos + 2));
                }
                if (this.hypoNames.size() == 0) {
                    System.err.println("Missing or bad hypothesis name, using Minimum");
                    this.hypoNames.add("Minimum");
                }
                if (this.scalingHypoIndex == -1) {
                    this.scalingHypoIndex = 0;
                }
            }
            hypoPos = this.cmdLine.find('H', "compare-hypothesis", 0, 2);
        }
        int zeroThreshPos = this.cmdLine.find('Z', "zero-threshold", 1, 1);
        if (zeroThreshPos != -1) {
            this.zeroThreshold = this.cmdLine.getFloat(zeroThreshPos + 1);
            if (this.zeroThreshold <= 0.0f || this.zeroThreshold > 100.0f) {
                throw new ArgumentException("Zero threshold percentage should be a value in (0.0, 100.0]");
            }
        }
        boolean bl = this.compareQueries = this.cmdLine.find('Q', "compare-queries") != -1;
        if (this.hypoNames.size() == 0 && !this.compareQueries) {
            this.verboseMsg("Comparing against all individual queries");
            this.compareQueries = true;
        }
        this.componentWise = this.cmdLine.find('C', "component-wise") != -1;
        int threPos = this.cmdLine.find('L', "threshold");
        if (this.componentWise && threPos != -1) {
            System.err.println("-L, --threshold cannot be used with -C', --component-wise. Flag ignored.");
        } else if (this.descriptorCount == 1 && threPos != -1) {
            System.err.println("-L, --threshold is meaningless for one descriptor. Flag ignored.");
        } else if (threPos != -1) {
            this.threshold = this.cmdLine.getFloat(threPos + 1);
        }
        boolean bl2 = this.andDescriptors = this.cmdLine.find('r', "descriptors-and") != -1;
        if (!this.componentWise && this.andDescriptors) {
            System.err.println("-r, --descriptors-and valid only together with -C', --component-wise. Flag ignored.");
        }
        boolean bl3 = this.andMetrics = this.cmdLine.find('m', "metrics-and") != -1;
        if (!this.componentWise && this.andDescriptors) {
            System.err.println("-m, --metrics-and valid only together with -C', --component-wise. Flag ignored.");
        }
    }

    private void saveConf() throws IOException {
        if (this.cmdLine.find('s', "saveconf") != -1) {
            this.settingsHandler.save(this.dbConnectionProperties);
        }
    }

    private void initSources() throws SQLException, MDReaderException {
        if (!this.targetDescrInput) {
            this.mdSet = MDSet.newInstance(this.descrTypes, this.params);
        }
        MDReader mDReader = this.targetReader = !this.dbInput ? this.initFileReader(this.targetFileName, this.targetDescrInput) : this.initDBReader(this.dbSelectTarget, this.targetDescrInput);
        if (this.targetDescrInput) {
            this.mdSet = this.targetReader.getMDSet();
        }
        this.queryReader = this.initFileReader(this.queryFileName, false);
        this.targetReader.setGenerateId(this.generateId);
        this.targetReader.setFirstId(this.firstId);
        this.applyCommandlineSettings();
    }

    private MDReader initDBReader(String sql, boolean descrInput) throws SQLException {
        for (int i = 0; descrInput && i < this.descriptorCount; ++i) {
            if (this.mdTableHandler.isMDTableValid(this.descrNames[i])) continue;
            System.err.println("WARNING: Structure table " + this.structureTableName + " is more recent than " + "descriptor " + this.descrNames[i] + ". " + NL + "Regenerate descriptors by: generatemd u " + this.structureTableName.substring(this.structureTableName.lastIndexOf(46) + 1) + " " + this.descrNames[i]);
        }
        String sqlSelect = sql != null ? "SELECT cd_id from " + this.structureTableName + " where " + sql : null;
        MDDBReader mr = descrInput ? new MDDBReader(this.structureTableName, this.connHandler, this.descrNames, sqlSelect) : new MDDBReader(this.structureTableName, this.connHandler, this.mdSet, sqlSelect);
        MDSet ms = ((MDReader)mr).getMDSet();
        for (int i = 0; descrInput && i < this.descriptorCount; ++i) {
            String[] cfgs = this.mdTableHandler.getMDConfigs(this.descrNames[i]);
            if (cfgs == null) continue;
            MDParameters pars = ms.getDescriptor(i).getParameters();
            for (int j = 0; j < cfgs.length; ++j) {
                String conf = this.mdTableHandler.getMDConfig(this.descrNames[i], cfgs[j]);
                ms.getDescriptor(i).setScreeningConfiguration(conf);
            }
        }
        return mr;
    }

    private MDReader initFileReader(String fn, boolean descrInput) throws MDReaderException {
        if (descrInput) {
            try {
                return new MDFileReader(this.descrNames);
            }
            catch (RuntimeException cnf) {
                throw new MDReaderException("File " + fn + " is not a valid" + " molecular descriptor file.");
            }
        }
        for (int i = 0; i < this.outFileTypes.size(); ++i) {
            String type = (String)this.outFileTypes.get(i);
            if (!type.equalsIgnoreCase("sdf")) continue;
            this.sdfOutput = true;
        }
        MDFileReader r = new MDFileReader(fn, this.mdSet);
        for (int i = 0; i < this.descriptorCount; ++i) {
            if (this.tagNames[i] == null) continue;
            r.setTakeTag(i, this.tagNames[i]);
        }
        if (fn.equals(this.targetFileName) && this.sdfOutput) {
            r.setKeepOriginalMolecule(true);
            r.setIdTagName(this.idTagName);
        } else if (this.nameTagName != null) {
            r.setKeepOriginalMolecule(true);
        }
        return r;
    }

    private void initResultWriters() throws MDReaderException {
        for (int i = 0; i < this.outFileTypes.size(); ++i) {
            String type = (String)this.outFileTypes.get(i);
            if (type.equalsIgnoreCase("table")) {
                this.createTableWriter((PrintStream)this.outFiles.get(i));
                continue;
            }
            if (type.equalsIgnoreCase("sdf")) {
                this.createSDfWriter((PrintStream)this.outFiles.get(i));
                continue;
            }
            if (!type.equalsIgnoreCase("stat")) continue;
            this.createStatWriter((PrintStream)this.outFiles.get(i));
        }
    }

    private void createTableWriter(PrintStream os) throws MDReaderException {
        MDSimilarityTableWriter twr = new MDSimilarityTableWriter(os, this.precision);
        if (!this.verboseSet) {
            twr.setVerbosity(this.verbose);
            twr.setVerboseFrequency(this.verboseFreq);
            this.verboseSet = true;
        }
        twr.setPrintId(this.generateId);
        if (this.idTagName != null) {
            twr.setPrintNaturalId(true);
            twr.setNaturalIdName(this.idTagName);
        }
        twr.setPrecision(this.precision);
        this.similarity.addResultWriter(twr);
        this.setLabels(twr);
    }

    private void createSDfWriter(PrintStream os) throws MDReaderException {
        MDSimilaritySDfileWriter swr = new MDSimilaritySDfileWriter(os);
        if (!this.verboseSet) {
            swr.setVerbosity(this.verbose);
            swr.setVerboseFrequency(this.verboseFreq);
            this.verboseSet = true;
        }
        this.similarity.addResultWriter(swr);
        this.setLabels(swr);
    }

    private void createStatWriter(PrintStream os) throws MDReaderException {
        MDSimilarityStatWriter twr = new MDSimilarityStatWriter(os, this.precision);
        if (!this.verboseSet) {
            twr.setVerbosity(this.verbose);
            twr.setVerboseFrequency(this.verboseFreq);
            this.verboseSet = true;
        }
        twr.setPrintId(this.generateId);
        if (this.idTagName != null) {
            twr.setPrintNaturalId(true);
            twr.setNaturalIdName(this.idTagName);
        }
        twr.setPrecision(this.precision);
        this.similarity.addResultWriter(twr);
        this.setLabels(twr);
    }

    private void setLabels(MDSimilarityResultWriter rw) throws MDReaderException {
        int qi = 0;
        if (this.compareQueries) {
            this.queryReader.reset();
            MDSet q = this.queryReader.next();
            while (q != null) {
                rw.setQueryName(qi, this.nameTagName != null ? this.queryReader.getMolecule().getProperty(this.nameTagName) : new String("q" + (qi + 1)));
                ++qi;
                q = this.queryReader.next();
            }
        }
        for (int h = 0; h < this.hypoNames.size(); ++h) {
            rw.setQueryName(qi++, (String)this.hypoNames.get(h));
        }
    }

    private void applyCommandlineSettings() {
        for (int i = 0; i < this.descriptorCount; ++i) {
            MolecularDescriptor md = this.queryReader.getMDSet().getDescriptor(i);
            if (md instanceof PharmacophoreFingerprint) {
                PFParameters p = (PFParameters)md.getParameters();
                if (this.PMAPtag[i] == null) continue;
                p.setPMAPTagName(this.PMAPtag[i]);
                continue;
            }
            if (this.PMAPtag[i] == null) continue;
            this.verboseMsg("PMAP is not accepted by " + md.getName() + ", ignoring -P flag.");
        }
    }

    private void notYetImplemented(char shortForm, String longForm) {
        System.err.println("Option -" + shortForm + ", --" + longForm + " is not yet implemented, ignored");
    }

    private void verboseMsg(String msg) {
        if (this.verbose) {
            System.err.print(msg);
        }
    }

    private void verboseDone() {
        if (this.verbose) {
            System.err.println(" done");
        }
    }

    private static String[] getArgsFromXML(String[] args) throws DocumentException, IOException {
        int j;
        String xmlFileName = args[1];
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new File(xmlFileName));
        StringBuffer sb = new StringBuffer();
        boolean inputInXml = ScreenMD.transformInput(sb, doc);
        ScreenMD.transformOutput(sb, doc);
        ScreenMD.transformDescriptors(sb, doc);
        ScreenMD.transformSimilarityOptions(sb, doc);
        StringTokenizer stk = new StringTokenizer(sb.toString());
        String[] newArgs = new String[stk.countTokens() + args.length - 2];
        int i = 0;
        int fileCount = 0;
        if (!inputInXml) {
            for (j = 2; j < 4 && args[j].charAt(0) != '-'; ++j) {
                newArgs[i++] = args[j];
                ++fileCount;
            }
        }
        while (stk.hasMoreTokens()) {
            newArgs[i++] = stk.nextToken();
        }
        int n = j = inputInXml ? 2 : fileCount + 2;
        while (j < args.length) {
            newArgs[i++] = args[j];
            ++j;
        }
        return newArgs;
    }

    private static boolean transformInput(StringBuffer sb, Document doc) {
        Element qu;
        boolean genId = false;
        boolean targetFile = false;
        boolean queryFile = false;
        Element dbNode = (Element)doc.selectSingleNode("//*/Input/Target/Database");
        Element tgFile = (Element)doc.selectSingleNode("//*/Input/Target/File");
        if (tgFile != null) {
            sb.append(tgFile.attributeValue("Name")).append(' ');
            targetFile = true;
            genId = tgFile.attributeValue("GenerateID").equals("true");
        }
        if ((qu = (Element)doc.selectSingleNode("//*/Input/Query")) != null) {
            sb.append(qu.attributeValue("Name"));
            queryFile = true;
        }
        if (genId) {
            sb.append(" -g ");
        }
        if (!targetFile) {
            ScreenMD.append(sb, dbNode, "StructureTableName", "-a");
            ScreenMD.appendOptional(sb, dbNode, "Restrict", "-q");
            ScreenMD.appendOptional(sb, dbNode, "Driver", "-d");
            ScreenMD.appendOptional(sb, dbNode, "URL", "-u");
            ScreenMD.appendOptional(sb, dbNode, "LoginName", "-l");
            ScreenMD.appendOptional(sb, dbNode, "Password", "-p");
        }
        Element inp = (Element)doc.selectSingleNode("//*/Input");
        ScreenMD.appendOptional(sb, inp, "IDTag", "-I");
        ScreenMD.appendOptional(sb, inp, "CompoundNameTag", "-N");
        return targetFile || queryFile;
    }

    private static void transformOutput(StringBuffer sb, Document doc) {
        Element out = (Element)doc.selectSingleNode("//*/Output");
        if (out == null) {
            return;
        }
        ScreenMD.appendOptional(sb, out, "Precision", "-e");
        List files = doc.selectNodes("//*/Output/Files/File");
        if (files == null) {
            return;
        }
        for (Element e : files) {
            ScreenMD.append(sb, e, "Type", "-o");
            ScreenMD.append(sb, e, "Name", "");
        }
    }

    private static void transformDescriptors(StringBuffer sb, Document doc) {
        ScreenMD.transformDescriptors("New", sb, doc);
        ScreenMD.transformDescriptors("Existing", sb, doc);
    }

    private static void transformDescriptors(String type, StringBuffer sb, Document doc) {
        List l = doc.selectNodes("//*/Descriptors/Descriptor/" + type);
        for (Element e : l) {
            ScreenMD.append(sb, e, "Type", "-k");
            ScreenMD.append(sb, e, "ConfigFile", "-c");
            List opts = e.selectNodes("Options");
            for (Element opt : opts) {
                ScreenMD.transformMetrics(sb, opt.selectNodes("Metrics/Metric"));
            }
            ScreenMD.appendOptional(sb, e, "UseTag", "-t");
            ScreenMD.appendOptional(sb, e, "PMAPTag", "-P");
        }
    }

    private static void transformMetrics(StringBuffer sb, List metrics2) {
        boolean first = true;
        for (Element e : metrics2) {
            if (first) {
                sb.append(" -M ");
                first = false;
            }
            sb.append(e.attributeValue("Name")).append(' ');
        }
    }

    private static void transformSimilarityOptions(StringBuffer sb, Document doc) {
        Element inp = (Element)doc.selectSingleNode("//*/SimilarityOptions");
        if (inp != null) {
            if (inp.attributeValue("CompareQueries") != null && inp.attributeValue("CompareQueries").equals("true")) {
                sb.append(" -Q ");
            }
            List l = inp.selectNodes("Hypotheses/Hypothesis");
            for (Element e : l) {
                sb.append(" -H ").append(e.attributeValue("Type"));
                if (e.attributeValue("Consensus") == null || !e.attributeValue("Consensus").equals("true")) continue;
                sb.append(" C ");
            }
            if (inp.attributeValue("ZeroThreshold") != null) {
                sb.append(" -Z ").append(inp.attributeValue("ZeroThreshold"));
            }
            ScreenMD.appendOptional(sb, inp, "DescriptorsAnd", "-r");
            ScreenMD.appendOptional(sb, inp, "MetricsAnd", "-m");
        }
    }

    private static void append(StringBuffer sb, Element n, String attr, String flag) {
        sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
    }

    private static void appendOptional(StringBuffer sb, Element n, String attr, String flag) {
        if (n.attributeValue(attr) != null) {
            sb.append(' ').append(flag).append(' ').append(n.attributeValue(attr));
        }
    }
}

