/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.HitStatistics;
import chemaxon.descriptors.OptimizeMetrics;
import chemaxon.descriptors.RandomMoleculeSubset;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.util.ArgumentException;
import chemaxon.util.CmdLine;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ScreeningOptimizer {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private String inputDir = ".";
    private String outputDir = ".";
    private String randomSetDir = ".";
    private String targetFile = null;
    private String activeFile = null;
    private boolean newRandomSets = false;
    private int numberOfRandomSets = 0;
    private int numberOfTargetTestStructures = 0;
    private int[] activeSetDivision = new int[]{35, 33, 32};
    private int[] selectedSets = null;
    private String optimizeMetricsConfigFileName = null;
    private String hitStatisticsConfigFileName = null;
    private List optimizeMetricsDescr = null;
    private static final String NL = System.getProperty("line.separator");
    private static final String UserHome = System.getProperty("user.home");
    private static final String PrgName = "ScreeningOptimizer";
    private static final String PrgHeader = NL + "ScreeningOptimizer" + " - " + "Virtual Screening Optimizer " + VersionInfo.JCHEM_VERSION + "," + NL + "(C) 2002-2012 ChemAxon Ltd." + NL;
    private static final String UsageInfo = PrgHeader + "Tunes and evaluates screening configurations to enrich hits." + NL + "" + NL + "Usage: screeningoptimizer <configuration file> [options]" + NL + "" + NL + "Options: " + NL + "  -h, --help               this help message" + NL + "  -v, --verbose            verbose" + NL + "" + NL + "";
    private static CmdLine cmdLine = null;
    private static boolean verbose = false;
    private static String configFileName = null;

    public ScreeningOptimizer() {
    }

    public ScreeningOptimizer(String configFileName) throws DocumentException, ArgumentException {
        this.processXMLConfig();
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setRandomSetDir(String randomSetDir) {
        this.randomSetDir = randomSetDir;
    }

    public void setTargetFileName(String targetFile) {
        this.targetFile = targetFile;
    }

    public void setActiveFileName(String activeFile) {
        this.activeFile = activeFile;
    }

    public void setNewRandomSets(boolean newRandomSets) {
        this.newRandomSets = newRandomSets;
    }

    public void setNumberOfRandomSets(int numberOfRandomSets) {
        this.numberOfRandomSets = numberOfRandomSets;
    }

    public void setNumberOfTargetTestStructures(int numberOfTargetTestStructures) {
        this.numberOfTargetTestStructures = numberOfTargetTestStructures;
    }

    public void setActiveSetDivision(int[] activeSetDivision) {
        this.activeSetDivision = activeSetDivision;
    }

    public void setSelectedSets(int[] selectedSets) {
        this.selectedSets = selectedSets;
    }

    public void setOptimizeMetricsConfigFileName(String fileName) {
        this.optimizeMetricsConfigFileName = fileName;
    }

    public void setHitStatisticsConfigFileName(String fileName) {
        this.hitStatisticsConfigFileName = fileName;
    }

    public void run(boolean verbose) throws ArgumentException, IOException, DocumentException {
        this.checkParams();
        if (this.newRandomSets) {
            this.generateRandomSets(verbose);
        }
        String tfn = this.getFileName(this.targetFile);
        String afn = this.getFileName(this.activeFile);
        this.transformConfigFile(this.optimizeMetricsConfigFileName, this.outputDir + FILE_SEP + "temp-optimi.xml", true);
        this.transformConfigFile(this.hitStatisticsConfigFileName, this.outputDir + FILE_SEP + "temp-hitstat.xml", false);
        String[] optArgs = new String[5 + (verbose ? 1 : 0)];
        String[] hitArgs = new String[7 + (verbose ? 1 : 0)];
        optArgs[0] = "config";
        hitArgs[0] = "config";
        optArgs[1] = this.outputDir + FILE_SEP + "temp-optimi.xml";
        hitArgs[1] = this.outputDir + FILE_SEP + "temp-hitstat.xml";
        if (verbose) {
            optArgs[5] = "-v";
            hitArgs[7] = "-v";
        }
        hitArgs[5] = "-o";
        for (int i = 0; i < this.selectedSets.length; ++i) {
            optArgs[2] = this.createRandomSetName("opt", this.selectedSets[i], tfn);
            optArgs[3] = this.createRandomSetName("opt-test", this.selectedSets[i], afn);
            optArgs[4] = this.createRandomSetName("opt-query", this.selectedSets[i], afn);
            OptimizeMetrics.main(optArgs);
            hitArgs[2] = this.createRandomSetName("hit", this.selectedSets[i], tfn);
            hitArgs[3] = this.createRandomSetName("hit", this.selectedSets[i], afn);
            hitArgs[4] = this.createRandomSetName("opt-query", this.selectedSets[i], afn);
            hitArgs[6] = this.outputDir + FILE_SEP + this.selectedSets[i] + "-" + tfn + "-" + afn + ".stat";
            HitStatistics.main(hitArgs);
        }
    }

    private void generateRandomSets(boolean verbose) throws IOException {
        int i;
        String[] args = new String[5 + (verbose ? 1 : 0)];
        String tfn = this.getFileName(this.targetFile);
        args[0] = this.inputDir + FILE_SEP + tfn;
        args[3] = "-n";
        args[4] = Integer.toString(this.numberOfTargetTestStructures);
        if (verbose) {
            args[5] = "-v";
        }
        for (int i2 = 0; i2 < this.numberOfRandomSets; ++i2) {
            args[1] = this.createRandomSetName("opt", i2 + 1, tfn);
            args[2] = this.createRandomSetName("hit", i2 + 1, tfn);
            RandomMoleculeSubset.main(args);
        }
        String afn = this.getFileName(this.activeFile);
        args[0] = this.inputDir + FILE_SEP + afn;
        args[3] = "-p";
        args[4] = Integer.toString(this.activeSetDivision[0]);
        for (i = 0; i < this.numberOfRandomSets; ++i) {
            args[1] = this.createRandomSetName("hit", i + 1, afn);
            args[2] = this.createRandomSetName("opt", i + 1, afn);
            RandomMoleculeSubset.main(args);
        }
        args[3] = "-p";
        args[4] = Integer.toString(this.activeSetDivision[1] * 100 / (100 - this.activeSetDivision[0]));
        for (i = 0; i < this.numberOfRandomSets; ++i) {
            args[0] = this.createRandomSetName("opt", i + 1, afn);
            args[1] = this.createRandomSetName("opt-test", i + 1, afn);
            args[2] = this.createRandomSetName("opt-query", i + 1, afn);
            RandomMoleculeSubset.main(args);
        }
    }

    private void transformConfigFile(String inFn, String outFn, boolean optimizeMetricsConfig) throws ArgumentException, DocumentException {
        try {
            Element out;
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new File(inFn));
            Element inp = (Element)doc.selectSingleNode("//*/Input");
            if (inp != null) {
                inp.detach();
            }
            if ((out = (Element)doc.selectSingleNode("//*/Output")) != null) {
                out.detach();
            }
            String tfn = this.getFileName(this.targetFile);
            String afn = this.getFileName(this.activeFile);
            if (optimizeMetricsConfig) {
                this.optimizeMetricsDescr = doc.selectNodes("//*/Descriptors/Descriptor");
                int i = 1;
                for (Element e : this.optimizeMetricsDescr) {
                    e.addAttribute("OutputFile", this.outputDir + FILE_SEP + "opt" + "-" + i + "-" + e.attributeValue("Type") + "-" + tfn + "-" + afn + ".xml");
                    ++i;
                }
            } else {
                Node descr = doc.selectSingleNode("//*/Descriptors");
                descr.detach();
                Element descriptors = doc.getRootElement().addElement("Descriptors");
                for (Element e : this.optimizeMetricsDescr) {
                    descriptors.addElement("Descriptor").addAttribute("Type", e.attributeValue("Type")).addAttribute("ConfigFile", e.attributeValue("OutputFile")).addText("\n");
                }
            }
            PrintStream f = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFn)));
            f.println(doc.asXML());
            f.close();
        }
        catch (IOException e) {
            throw new ArgumentException("I/O error. " + e.getMessage());
        }
    }

    private String getFileName(String fn) {
        return fn.substring(fn.lastIndexOf(FILE_SEP) + 1);
    }

    private String createRandomSetName(String prefix, int setId, String fn) {
        return this.randomSetDir + FILE_SEP + prefix + "-" + Integer.toString(setId) + "-" + fn;
    }

    private void checkParams() throws ArgumentException {
        if (this.targetFile == null) {
            throw new ArgumentException("TargetFile is not specified.");
        }
        if (this.activeFile == null) {
            throw new ArgumentException("ActiveFile is not specified.");
        }
        if (this.numberOfRandomSets == 0) {
            throw new ArgumentException("NumberOfRandomSets is not specified.");
        }
        if (this.newRandomSets && this.numberOfTargetTestStructures == 0) {
            throw new ArgumentException("NumberOfTargetTestStructures is not specified.");
        }
        if (this.selectedSets == null) {
            throw new ArgumentException("SelectedSets is not specified.");
        }
        if (this.optimizeMetricsConfigFileName == null) {
            throw new ArgumentException("OptimizeMetricsConfigFileName is not  specified.");
        }
        if (this.hitStatisticsConfigFileName == null) {
            throw new ArgumentException("HitStatisticsConfigFileName is not  specified.");
        }
    }

    private void processXMLConfig() throws ArgumentException {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new File(configFileName));
            this.processInputTag(doc);
            this.processRandomSetsTag(doc);
            this.processConfigurationTag(doc);
        }
        catch (DocumentException e) {
            throw new ArgumentException("Configuration error. " + e.getMessage());
        }
        catch (Exception e) {
            throw new ArgumentException("Configuration error. " + e.getMessage());
        }
    }

    private void processInputTag(Document doc) throws ArgumentException {
        Element inp = (Element)doc.selectSingleNode("//*/Input");
        if (inp == null) {
            throw new ArgumentException("Missing <Input> element in configuration");
        }
        if (inp.attributeValue("InputDir") != null) {
            this.inputDir = inp.attributeValue("InputDir");
        }
        if (inp.attributeValue("OutputDir") != null) {
            this.outputDir = inp.attributeValue("OutputDir");
        }
        if (inp.attributeValue("RandomSetDir") != null) {
            this.randomSetDir = inp.attributeValue("RandomSetDir");
        }
        this.targetFile = inp.attributeValue("TargetFile");
        this.activeFile = inp.attributeValue("ActiveFile");
    }

    private void processRandomSetsTag(Document doc) throws ArgumentException {
        StringTokenizer stok;
        Element rs = (Element)doc.selectSingleNode("//*/RandomSets");
        if (rs == null) {
            throw new ArgumentException("Missing <RandomSets> element in configuration");
        }
        if (rs.attributeValue("NewRandomSets") != null && rs.attributeValue("NewRandomSets").equals("true")) {
            this.newRandomSets = true;
        }
        if (rs.attributeValue("NumberOfRandomSets") == null) {
            throw new ArgumentException("Missing NumberOfRandomSets attribute in <RandomSets>");
        }
        this.numberOfRandomSets = Integer.parseInt(rs.attributeValue("NumberOfRandomSets"));
        if (rs.attributeValue("NumberOfTargetTestStructures") == null) {
            throw new ArgumentException("Missing NumberOfTargetTestStructures  attribute in <RandomSets>");
        }
        this.numberOfTargetTestStructures = Integer.parseInt(rs.attributeValue("NumberOfTargetTestStructures"));
        if (rs.attributeValue("ActiveSetDivision") != null) {
            stok = new StringTokenizer(rs.attributeValue("ActiveSetDivision"), "/");
            if (stok.countTokens() != 3) {
                throw new ArgumentException("Wrong format of ActiveSetDivision");
            }
            for (int i = 0; i < 3; ++i) {
                String d = stok.nextToken();
                this.activeSetDivision[i] = Integer.parseInt(d);
            }
        }
        if (rs.attributeValue("SelectedSets") == null) {
            throw new ArgumentException("Missing attribute SelectedSets.");
        }
        stok = new StringTokenizer(rs.attributeValue("SelectedSets"), ",");
        int nSelected = stok.countTokens();
        if (nSelected == 0) {
            throw new ArgumentException("Wrong format of SelectedSets");
        }
        this.selectedSets = new int[nSelected];
        for (int i = 0; i < nSelected; ++i) {
            String d = stok.nextToken();
            this.selectedSets[i] = Integer.parseInt(d);
        }
    }

    private void processConfigurationTag(Document doc) throws ArgumentException {
        Element cfg = (Element)doc.selectSingleNode("//*/Configuration");
        if (cfg == null) {
            throw new ArgumentException("Missing <Configuration> element in configuration.");
        }
        if (cfg.attributeValue("OptimizeMetrics") == null) {
            throw new ArgumentException("Missing attribute OptimizeMetrics.");
        }
        this.optimizeMetricsConfigFileName = cfg.attributeValue("OptimizeMetrics");
        if (cfg.attributeValue("HitStatistics") == null) {
            throw new ArgumentException("Missing attribute HitStatistics.");
        }
        this.hitStatisticsConfigFileName = cfg.attributeValue("HitStatistics");
    }

    public static void main(String[] args) {
        try {
            cmdLine = new CmdLine(args);
            if (ScreeningOptimizer.processCmdLineOptions()) {
                ScreeningOptimizer.verboseMsg(NL + "Processing started at " + new GregorianCalendar().getTime() + NL);
                ScreeningOptimizer o = new ScreeningOptimizer(configFileName);
                o.run(verbose);
                ScreeningOptimizer.verboseMsg("Processing finished at " + new GregorianCalendar().getTime() + NL);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static boolean processCmdLineOptions() throws ArgumentException {
        if (cmdLine.isEmpty() || cmdLine.find('h', "help") != -1) {
            System.out.println(UsageInfo);
            return false;
        }
        configFileName = cmdLine.getFileName(0);
        if (configFileName == null) {
            throw new ArgumentException("Missing configuration file name.");
        }
        verbose = cmdLine.find('v', "verbose") != -1;
        ScreeningOptimizer.verboseMsg(PrgHeader + NL);
        return true;
    }

    private static void verboseMsg(String msg) {
        if (verbose) {
            System.out.print(msg);
        }
    }
}

