/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.ShapeParameters;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.alignment.AlignmentException;
import chemaxon.marvin.alignment.AlignmentMolecule;
import chemaxon.marvin.alignment.Similarity3D;
import chemaxon.struc.Molecule;
import java.text.ParseException;

public class ShapeDescriptor
extends MolecularDescriptor
implements Licensable {
    AlignmentMolecule am;
    private String licenseEnvironment = "";
    Similarity3D sim = null;

    public ShapeDescriptor() {
    }

    public ShapeDescriptor(ShapeParameters params) {
        super(params);
        this.clear();
    }

    public ShapeDescriptor(String params) {
        this.setParameters(params);
    }

    @Override
    public float getDefaultThreshold(int metricIndex) {
        return Float.MAX_VALUE;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return new float[]{Float.MAX_VALUE};
    }

    public ShapeDescriptor(ShapeDescriptor sh) {
        ShapeDescriptor other = sh.clone();
        this.params = other.params;
        this.am = other.am;
        this.sim = other.sim;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("3D Screen", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("3D Screen", this.licenseEnvironment);
    }

    @Override
    public ShapeDescriptor clone() {
        ShapeDescriptor ret = new ShapeDescriptor();
        try {
            if (this.am != null) {
                ret.setAlignmentMolecule(this.am.clone());
            }
            ret.setParameters(this.getParameters());
            if (this.sim != null) {
                ret.sim = new Similarity3D(ret.am);
            }
        }
        catch (AlignmentException e) {
            throw new UnsupportedOperationException(e);
        }
        return ret;
    }

    public void setAlignmentMolecule(AlignmentMolecule am) {
        this.am = am;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        String[] s = this.params.generator.generate(m, this);
        return s;
    }

    @Override
    public String getName() {
        return "3D shape descriptor";
    }

    @Override
    public String getShortName() {
        return "Shape";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.ShapeParameters";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new ShapeParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
    }

    public void clear() {
        this.am = null;
    }

    @Override
    public byte[] toData() {
        return this.am.toData();
    }

    @Override
    public void fromData(byte[] dbRepr) {
        this.setAlignmentMolecule(AlignmentMolecule.create(dbRepr));
    }

    @Override
    public String toString() {
        byte[] b = this.toData();
        StringBuilder sb = new StringBuilder(b.length * 4);
        for (int i = 0; i < b.length - 1; ++i) {
            sb.append(b[i]);
            sb.append(";");
        }
        sb.append(b[b.length - 1]);
        return sb.toString();
    }

    @Override
    public String toDecimalString() {
        return this.toString();
    }

    @Override
    public void fromString(String descr) throws ParseException {
        String[] s = descr.split(";");
        byte[] b = new byte[s.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = Byte.parseByte(s[i].trim());
        }
        this.fromData(b);
    }

    @Override
    public float[] toFloatArray() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void fromFloatArray(float[] descr) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String toBinaryString() {
        return this.toString();
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return new String[]{"Similarity"};
    }

    private void initSimilarity() throws AlignmentException {
        this.sim = new Similarity3D(this.am);
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other) {
        this.checkLicense();
        ShapeDescriptor sd = (ShapeDescriptor)other;
        try {
            if (sd.sim == null) {
                sd.initSimilarity();
            }
            double tanimoto = sd.sim.similarity(this.am);
            return (float)(1.0 - tanimoto);
        }
        catch (AlignmentException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public float getShapeSimilarity(MolecularDescriptor other) {
        this.checkLicense();
        ShapeDescriptor sd = (ShapeDescriptor)other;
        try {
            if (sd.sim == null) {
                sd.initSimilarity();
            }
            double tanimoto = sd.sim.similarity(this.am);
            return (float)tanimoto;
        }
        catch (AlignmentException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public float getHistogramSimilarity(MolecularDescriptor other) {
        this.checkLicense();
        ShapeDescriptor sd = (ShapeDescriptor)other;
        try {
            if (sd.sim == null) {
                sd.initSimilarity();
            }
        }
        catch (AlignmentException ex) {
            throw new UnsupportedOperationException(ex);
        }
        return (float)sd.sim.getBestHistogram();
    }

    @Override
    public float getDissimilarity(MolecularDescriptor other, int parametrizedMetricIndex) {
        return this.getDissimilarity(other);
    }

    public AlignmentMolecule getAlignmenMolecule() {
        return this.am;
    }
}

