/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.MetricsType;
import chemaxon.descriptors.SimilarityCalculator;
import chemaxon.descriptors.SimilarityCalculators;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.BitSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimilarityCalculatorFactory {
    private Representation rep;
    public static String SEPARATOR = ";";
    private static String betweenNameAndValue = "=";
    private MetricsType mt;
    private float tverskyWeightForQuery;
    private float tverskyWeightForTarget;
    private BitSet wasAlreadySettedInParamString;
    private float threshold;

    private static boolean isThere(String s, String isin) {
        Pattern pattern = Pattern.compile(isin);
        Matcher matcher = pattern.matcher(s);
        return matcher.find();
    }

    private void setMetricsType(String s) throws ParseException {
        if (this.wasAlreadySettedInParamString.get(0)) {
            throw new ParseException("Metric name was already defined.", 0);
        }
        this.mt = MetricsType.valueOf(s);
        if (this.mt == MetricsType.SUBSTRUCTURE) {
            this.tverskyWeightForQuery = 1.0f;
            this.tverskyWeightForTarget = 0.0f;
        } else if (this.mt == MetricsType.SUPERSTRUCTURE) {
            this.tverskyWeightForQuery = 0.0f;
            this.tverskyWeightForTarget = 1.0f;
        } else if (this.mt == MetricsType.DICE) {
            this.tverskyWeightForQuery = 0.5f;
            this.tverskyWeightForTarget = 0.5f;
        }
        if (this.mt == MetricsType.DEFAULT) {
            this.mt = MetricsType.TANIMOTO;
        }
        this.wasAlreadySettedInParamString.set(0, true);
    }

    private SimilarityCalculatorFactory(String params) throws ParseException {
        block9: {
            int i;
            String[] a;
            block8: {
                this.rep = Representation.INTEGER_ARRAY_BIT_REPR;
                this.tverskyWeightForQuery = 1.0f;
                this.tverskyWeightForTarget = 1.0f;
                this.threshold = -1.0f;
                a = params.split(SEPARATOR);
                this.wasAlreadySettedInParamString = new BitSet();
                int count = 0;
                for (i = 0; i < a.length; ++i) {
                    if (!SimilarityCalculatorFactory.isThere(a[i], betweenNameAndValue)) continue;
                    ++count;
                }
                if (count > 0 && count < a.length) {
                    throw new ParseException("Do not mix the short hand notation with the normal parameter style.", 0);
                }
                if (count != 0) break block8;
                this.setMetricsType(a[0].trim().toUpperCase());
                if (this.mt != MetricsType.TVERSKY) break block9;
                if (a.length > 1) {
                    this.tverskyWeightForQuery = SimilarityCalculatorFactory.parse(a[1]);
                }
                if (a.length <= 2) break block9;
                this.tverskyWeightForTarget = SimilarityCalculatorFactory.parse(a[2]);
                break block9;
            }
            for (i = 0; i < a.length; ++i) {
                String[] b = a[i].split(betweenNameAndValue);
                String name = b[0].trim();
                String val = b[1].trim();
                if (name.equalsIgnoreCase("Metrics")) {
                    this.setMetricsType(val.toUpperCase());
                    continue;
                }
                if (name.equalsIgnoreCase("tverskyWeightForQuery")) {
                    if (this.wasAlreadySettedInParamString.get(1)) {
                        throw new ParseException("tverskyWeightForQuery was already defined.", 0);
                    }
                    this.wasAlreadySettedInParamString.set(1, true);
                    this.tverskyWeightForQuery = SimilarityCalculatorFactory.parse(val);
                    continue;
                }
                if (!name.equalsIgnoreCase("tverskyWeightForTarget")) continue;
                if (this.wasAlreadySettedInParamString.get(2)) {
                    throw new ParseException("tverskyWeightForTarget was already defined.", 0);
                }
                this.wasAlreadySettedInParamString.set(2, true);
                this.tverskyWeightForTarget = SimilarityCalculatorFactory.parse(val);
            }
        }
    }

    public static SimilarityCalculator<int[]> create(String params) throws ParseException {
        return SimilarityCalculatorFactory.create(params, -1, -1);
    }

    public static SimilarityCalculator<int[]> create(String params, int from, int to) throws ParseException {
        SimilarityCalculatorFactory f = new SimilarityCalculatorFactory(params);
        if (f.mt == MetricsType.EUCLIDEAN && f.rep == Representation.INTEGER_ARRAY_BIT_REPR) {
            return new SimilarityCalculators.BinaryEuclidean(from, to);
        }
        if (f.mt == MetricsType.TANIMOTO && f.rep == Representation.INTEGER_ARRAY_BIT_REPR) {
            return new SimilarityCalculators.BinaryTanimoto(from, to);
        }
        if ((f.mt == MetricsType.TVERSKY || f.mt == MetricsType.DICE || f.mt == MetricsType.SUBSTRUCTURE || f.mt == MetricsType.SUPERSTRUCTURE) && f.rep == Representation.INTEGER_ARRAY_BIT_REPR) {
            return new SimilarityCalculators.BinaryTversky(f.tverskyWeightForQuery, f.tverskyWeightForTarget, from, to);
        }
        if (f.mt == MetricsType.NORMALIZED_EUCLIDEAN && f.rep == Representation.INTEGER_ARRAY_BIT_REPR) {
            return new SimilarityCalculators.BinaryNormalizedEuclidean(from, to);
        }
        throw new UnsupportedOperationException("[BUG] If the param string is parsed the correct SimilarityCalculator object is returned. if do not ParseException is thrown. This point must not be reached at all. Sorry.");
    }

    public static float parse(String number) throws ParseException {
        float f = (float)SimilarityCalculatorFactory.getNumberFormat().parse(number.trim()).doubleValue();
        return f;
    }

    public static NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        nf.setMaximumFractionDigits(30);
        nf.setGroupingUsed(false);
        return nf;
    }

    public static enum Representation {
        SCALAR,
        INTEGER_ARRAY,
        INTEGER_ARRAY_BIT_REPR,
        FLOAT_ARRAY,
        ALIGNMENT;

    }
}

