/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.SimilarityCalculator;
import chemaxon.descriptors.SimilarityException;

public class SimilarityCalculators {
    private static String intToString(int a) {
        String s = "";
        int a2 = a;
        for (int j = 0; j < 31; ++j) {
            s = (a2 & 1) == 1 ? s + "1" : s + "0";
            a2 >>= 1;
        }
        return s;
    }

    public static class BinaryNormalizedEuclidean
    extends BinaryCalculator {
        BinaryNormalizedEuclidean(int from, int to) {
            super(from, to);
        }

        @Override
        public float getSimilarity(int[] fp) throws SimilarityException {
            return 1.0f - this.getDissimilarity(fp);
        }

        @Override
        public float getDissimilarity(int[] fp) throws SimilarityException {
            int y;
            int x;
            block5: {
                assert (((int[])this.query).length == fp.length);
                x = 0;
                y = 0;
                try {
                    for (int i = this.from; i < this.to; ++i) {
                        x += BinaryNormalizedEuclidean.calcBitCount(fp[i] ^ ((int[])this.query)[i]);
                        y += BinaryNormalizedEuclidean.calcBitCount(fp[i]);
                    }
                }
                catch (NullPointerException np) {
                    if (this.query == null) {
                        throw new SimilarityException("Query fingerprint has not been set.");
                    }
                    if (fp != null) break block5;
                    throw new SimilarityException("Target fingerprint is null.");
                }
            }
            return (float)(Math.sqrt(x) / (Math.sqrt(y) + Math.sqrt(this.bitCountOfQuery)));
        }
    }

    public static class BinaryEuclidean
    extends BinaryCalculator {
        BinaryEuclidean(int from, int to) {
            super(from, to);
        }

        @Override
        public float getSimilarity(int[] fp) throws SimilarityException {
            throw new UnsupportedOperationException("Eucledian metrics cannot provide similarity measure by its nature. Use normalized Euclidean metics instead.");
        }

        @Override
        public float getDissimilarity(int[] fp) throws SimilarityException {
            int x;
            block5: {
                assert (((int[])this.query).length == fp.length);
                x = 0;
                try {
                    for (int i = this.from; i < this.to; ++i) {
                        x += BinaryEuclidean.calcBitCount(fp[i] ^ ((int[])this.query)[i]);
                    }
                }
                catch (NullPointerException np) {
                    if (this.query == null) {
                        throw new SimilarityException("Query fingerprint has not been set.");
                    }
                    if (fp != null) break block5;
                    throw new SimilarityException("Target fingerprint is null.");
                }
            }
            return (float)Math.sqrt(x);
        }
    }

    public static class BinaryTversky
    extends NormalizedBinaryCalculator {
        float tverskyWeightForQuery;
        float tverskyWeightForTarget;

        public BinaryTversky(float tverskyWeightForQuery, float tverskyWeightForTarget, int from, int to) {
            super(from, to);
            this.tverskyWeightForQuery = tverskyWeightForQuery;
            this.tverskyWeightForTarget = tverskyWeightForTarget;
        }

        @Override
        public float getSimilarity(int[] fp) throws SimilarityException {
            float denominator;
            int onlyQ;
            int onlyFP;
            int common;
            block6: {
                assert (((int[])this.query).length == fp.length);
                common = 0;
                onlyFP = 0;
                onlyQ = 0;
                int xor = 0;
                try {
                    for (int i = this.from; i < this.to; ++i) {
                        common += BinaryTversky.calcBitCount(fp[i] & ((int[])this.query)[i]);
                        xor = fp[i] ^ ((int[])this.query)[i];
                        onlyFP += BinaryTversky.calcBitCount(xor & fp[i]);
                        onlyQ += BinaryTversky.calcBitCount(xor & ((int[])this.query)[i]);
                    }
                }
                catch (NullPointerException np) {
                    if (this.query == null) {
                        throw new SimilarityException("Query fingerprint has not been set.");
                    }
                    if (fp != null) break block6;
                    throw new SimilarityException("Target fingerprint is null.");
                }
            }
            if ((denominator = this.tverskyWeightForTarget * (float)onlyFP + this.tverskyWeightForQuery * (float)onlyQ + (float)common) == 0.0f) {
                return 1.0f;
            }
            return (float)common / denominator;
        }
    }

    public static class BinaryTanimoto
    extends NormalizedBinaryCalculator {
        BinaryTanimoto(int from, int to) {
            super(from, to);
        }

        @Override
        public float getSimilarity(int[] fp) throws SimilarityException {
            int y;
            int x;
            block5: {
                x = 0;
                y = 0;
                if (((int[])this.query).length != fp.length) {
                    throw new IllegalArgumentException("Different query and target length: " + ((int[])this.query).length + " and " + fp.length);
                }
                try {
                    y = this.calcBitCount(fp);
                    for (int i = this.from; i < this.to; ++i) {
                        x += BinaryTanimoto.calcBitCount(fp[i] & ((int[])this.query)[i]);
                    }
                }
                catch (NullPointerException np) {
                    if (this.query == null) {
                        throw new SimilarityException("Query fingerprint has not been set.");
                    }
                    if (fp != null) break block5;
                    throw new SimilarityException("Target fingerprint is null.");
                }
            }
            return (float)x / (float)(y + this.bitCountOfQuery - x);
        }
    }

    public static abstract class NormalizedBinaryCalculator
    extends BinaryCalculator {
        public NormalizedBinaryCalculator(int from, int to) {
            super(from, to);
        }

        @Override
        public float getDissimilarity(int[] fp) throws SimilarityException {
            return 1.0f - this.getSimilarity(fp);
        }
    }

    public static abstract class BinaryCalculator
    extends SimilarityCalculator<int[]> {
        int bitCountOfQuery = 0;
        int from = -1;
        int to = -1;
        private static int[] bitCount = null;

        public BinaryCalculator(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public BinaryCalculator() {
        }

        @Override
        public void setQueryFingerprint(int[] fp) throws SimilarityException {
            super.setQueryFingerprint(fp);
            if (this.from == -1) {
                this.from = 0;
            }
            if (this.to == -1) {
                this.to = ((int[])this.query).length;
            }
            if (this.from > ((int[])this.query).length || this.from < 0) {
                throw new SimilarityException("The from value was not defined correctly.");
            }
            if (this.to > ((int[])this.query).length || this.to < 0) {
                throw new SimilarityException("The to value was not defined correctly.");
            }
            if (this.from > this.to) {
                throw new SimilarityException("The from value was not defined correctly.");
            }
            this.bitCountOfQuery = this.calcBitCount(fp);
        }

        protected int calcBitCount(int[] v) {
            int bc = 0;
            for (int j = this.from; j < this.to; ++j) {
                bc += BinaryCalculator.calcBitCount(v[j]);
            }
            return bc;
        }

        public static int calcBitCount(int i) {
            int bc = bitCount[i & 0xFF];
            bc += bitCount[(i >>= 8) & 0xFF];
            bc += bitCount[(i >>= 8) & 0xFF];
            return bc += bitCount[(i >>= 8) & 0xFF];
        }

        static {
            bitCount = new int[256];
            for (int i = 0; i < 256; ++i) {
                int k = i;
                BinaryCalculator.bitCount[i] = 0;
                for (int j = 0; j < 8; ++j) {
                    int n = i;
                    bitCount[n] = bitCount[n] + (k & 1);
                    k >>= 1;
                }
            }
        }
    }
}

