/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors.scalars;

import chemaxon.calculations.ElementalAnalyser;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.SDParameters;
import chemaxon.descriptors.ScalarDescriptor;
import chemaxon.struc.Molecule;

public class Heavy
extends ScalarDescriptor {
    private ElementalAnalyser hacCalc = new ElementalAnalyser();

    public Heavy() {
    }

    public Heavy(SDParameters params) {
        super(params);
    }

    public Heavy(String params) {
        super(params);
    }

    public Heavy(ScalarDescriptor sd) {
        super(sd);
    }

    @Override
    public MolecularDescriptor clone() {
        return new Heavy(this);
    }

    @Override
    public String getName() {
        return "Number of heavy atoms";
    }

    @Override
    public String getShortName() {
        return "Heav";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new SDParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.SDParameters";
    }

    @Override
    public boolean needsConfig() {
        return false;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        super.generate(m);
        try {
            this.hacCalc.setMolecule(m);
            this.descrValue = this.hacCalc.atomCount() - this.hacCalc.atomCount(1);
            return null;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }
}

