/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors.scalars;

import chemaxon.calculations.training.logp.LogDPredictor;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.SDParameters;
import chemaxon.struc.Molecule;
import java.io.File;
import java.util.List;
import org.dom4j.Element;

public class LDParameters
extends SDParameters {
    public static final int DEFAULT_LOWER_BOUND = 0;
    public static final int DEFAULT_UPPER_BOUND = 14;
    public static final int DEFAULT_STEP_SIZE = 1;
    public static final int DEFAULT_PH = 7;
    private Element logDNode = null;
    private float lowerBound = 0.0f;
    private float upperBound = 14.0f;
    private float stepSize = 1.0f;
    private float[] references = null;
    private float pH = 7.0f;
    private LogDPredictor logDcalc = null;

    public LDParameters() {
        this.initParameters();
    }

    public LDParameters(File configFile) throws MDParametersException {
        super(configFile);
    }

    public LDParameters(String XMLconfig) throws MDParametersException {
        super(XMLconfig);
    }

    @Override
    public String toString() {
        try {
            return super.toString();
        }
        catch (MDParametersException p) {
            return null;
        }
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.logDcalc = new LogDPredictor();
        this.logDcalc.setpHLowerLimit(this.lowerBound);
        this.logDcalc.setpHUpperLimit(this.upperBound);
        this.logDcalc.setpHStepSize(this.stepSize);
    }

    protected float generate(Molecule m) throws MDGeneratorException {
        try {
            this.logDcalc.setMolecule(m);
            return (float)this.logDcalc.calclogDatFixpH(this.pH);
        }
        catch (Exception ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        super.readValues(all);
        List sdNodes = this.document.selectNodes("//ScalarDescriptorConfiguration/ScalarDescriptors/ScalarDescriptor");
        if (sdNodes == null) {
            throw new MDParametersException("Parameter configuration error.");
        }
        this.logDNode = null;
        for (Element c : sdNodes) {
            if (!c.attributeValue("Name").equals("LogD")) continue;
            this.logDNode = c;
            break;
        }
        if (this.logDNode != null) {
            String ph;
            String upper;
            String lower = this.logDNode.attributeValue("LowerBound");
            if (lower != null) {
                this.lowerBound = Float.parseFloat(lower);
            }
            if ((upper = this.logDNode.attributeValue("UpperBound")) != null) {
                this.upperBound = Float.parseFloat(upper);
            }
            if (this.upperBound < this.lowerBound) {
                throw new MDParametersException("UpperBound should be greater than LowerBound!");
            }
            String step = this.logDNode.attributeValue("StepSize");
            if (step != null) {
                this.stepSize = Float.parseFloat(step);
            }
            if ((ph = this.logDNode.attributeValue("pH")) != null) {
                this.pH = Float.parseFloat(ph);
            }
            if (this.pH < this.lowerBound) {
                throw new MDParametersException("pH should be greater than LowerBound");
            }
            if (this.pH > this.upperBound) {
                throw new MDParametersException("pH should be less than UpperBound");
            }
        }
        this.readMetricParameters();
    }
}

