/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors.scalars;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.SDParameters;
import chemaxon.descriptors.ScalarDescriptor;
import chemaxon.struc.Molecule;

public class TPSA
extends ScalarDescriptor {
    private chemaxon.calculations.TPSA TPSAcalc = new chemaxon.calculations.TPSA();

    public TPSA() {
    }

    public TPSA(SDParameters params) {
        super(params);
    }

    public TPSA(String params) {
        super(params);
    }

    public TPSA(ScalarDescriptor sd) {
        super(sd);
    }

    @Override
    public MolecularDescriptor clone() {
        return new TPSA(this);
    }

    @Override
    public String getName() {
        return "Topological Polar Surface Area";
    }

    @Override
    public String getShortName() {
        return "TPSA";
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            super.setParameters(new SDParameters(parameters));
        } else {
            this.params.fromString(parameters);
        }
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.SDParameters";
    }

    @Override
    public boolean needsConfig() {
        return false;
    }

    @Override
    public String[] generate(Molecule m) throws MDGeneratorException {
        super.generate(m);
        try {
            this.descrValue = (float)this.TPSAcalc.getTPSA(m);
            return null;
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new MDGeneratorException("Parameters are not set properly.");
        }
    }
}

