/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.fragment;

import chemaxon.drugdesign.fragment.FragmentBasedSearch;
import chemaxon.drugdesign.fragment.FragmentDB;
import chemaxon.drugdesign.fragment.FragmentationException;
import chemaxon.drugdesign.fragment.RandomStartingMoleculeBuilder;
import chemaxon.drugdesign.search.StartingMoleculeBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class AnalogMakerConfig {
    private Element root = null;
    private String dir = null;
    private FragmentBasedSearch search = null;

    public AnalogMakerConfig(File file) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            this.root = doc.getRootElement();
            this.dir = file.getParent();
            this.compileXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void compileXml() throws IOException, FragmentationException {
        FragmentBasedSearch fbSearch = this.buildSearch();
        FragmentDB fragmentDB = this.buildFragmentDB();
        fbSearch.setFragmentdb(fragmentDB);
        this.search = fbSearch;
        this.buildStartingMoleculeBuilders();
    }

    private void buildStartingMoleculeBuilders() {
        XPath path = DocumentHelper.createXPath((String)"StartingMoleculeBuilders");
        Element parent = (Element)path.selectSingleNode((Object)this.root);
        String dumpValue = parent.attributeValue("dump");
        if (dumpValue != null) {
            this.search.setStartingPopulationDump(new Boolean(dumpValue));
        }
        Iterator it = parent.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            StartingMoleculeBuilder smb = null;
            if (e.getName().equalsIgnoreCase("RandomStartingMoleculeBuilder")) {
                smb = this.parseRandomStartingMoleculeBuilder(e);
            }
            this.search.add(smb);
        }
    }

    private StartingMoleculeBuilder parseRandomStartingMoleculeBuilder(Element e) {
        RandomStartingMoleculeBuilder rsmb = new RandomStartingMoleculeBuilder();
        String molCountString = e.attributeValue("molCount", "100");
        int molCount = Integer.parseInt(molCountString);
        rsmb.setMolCount(molCount);
        String minFragmentCountString = e.attributeValue("minFragmentCount", "2");
        int minFragmentCount = Integer.parseInt(minFragmentCountString);
        rsmb.setMinFragmentCount(minFragmentCount);
        String maxFragmentCountString = e.attributeValue("maxFragmentCount", "10");
        int maxFragmentCount = Integer.parseInt(maxFragmentCountString);
        rsmb.setMaxFragmentCount(maxFragmentCount);
        return rsmb;
    }

    private FragmentBasedSearch buildSearch() {
        FragmentBasedSearch fbs = null;
        String ClassName = this.root.getName();
        if (!ClassName.equalsIgnoreCase("FragmentBasedSearch")) {
            return null;
        }
        fbs = new FragmentBasedSearch();
        String offspringGenerationSize = this.root.attributeValue("offspringGenerationSize", "1000");
        int ogs = Integer.parseInt(offspringGenerationSize);
        fbs.setOffspringGenerationSize(ogs);
        String allowedScoreDecrease = this.root.attributeValue("allowedScoreDecrease");
        double asd = 0.0;
        asd = allowedScoreDecrease != null ? Double.parseDouble(allowedScoreDecrease) : Double.POSITIVE_INFINITY;
        fbs.setAllowedScoreDecrease(asd);
        String goalFunction = this.root.attributeValue("goalFunction");
        if (goalFunction != null) {
            fbs.setGoalFunction(goalFunction);
        }
        return fbs;
    }

    private FragmentDB buildFragmentDB() throws IOException, FragmentationException {
        XPath path = DocumentHelper.createXPath((String)"FragmentDB");
        Element element = (Element)path.selectSingleNode((Object)this.root);
        FragmentDB fragmentDB = null;
        String fragmentFile = element.attributeValue("FragmentFile");
        String fragmentationXmlFile = element.attributeValue("FragmentationXmlFile");
        String minOccurrenceString = element.attributeValue("minOccurrence", "0");
        int minOccurrence = Integer.parseInt(minOccurrenceString);
        fragmentDB = new FragmentDB(fragmentFile, fragmentationXmlFile, minOccurrence);
        String dump = element.attributeValue("dump");
        if (dump != null && (dump.equalsIgnoreCase("true") || dump.equalsIgnoreCase("T"))) {
            fragmentDB.dump();
        }
        return fragmentDB;
    }

    public FragmentBasedSearch getSearch() {
        return this.search;
    }
}

