/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.fragment;

import chemaxon.common.util.IntVector;
import chemaxon.fragmenter.FragmenterConfig;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class FragmentConnectionTypes {
    private static int MAXMAPS = 1024;
    private Vector types = new Vector();

    public FragmentConnectionTypes(File file) throws IOException {
        this(new FragmenterConfig(file));
    }

    public FragmentConnectionTypes(FragmenterConfig config) throws IOException {
        RxnMolecule[] reactions = config.getReactions();
        String[] rids = config.getReactionIDs();
        ArrayList<int[]> blist = new ArrayList<int[]>();
        int[] map2type = new int[MAXMAPS];
        for (int i = 0; i < reactions.length; ++i) {
            int m1;
            boolean duplicate = false;
            for (int j = i - 1; j >= 0; --j) {
                if (!rids[i].equals(rids[j])) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            blist.clear();
            Arrays.fill(map2type, -1);
            Molecule reactant = reactions[i].getReactant(0);
            for (int j = reactant.getBondCount() - 1; j >= 0; --j) {
                MolBond bond = reactant.getBond(j);
                m1 = bond.getAtom1().getAtomMap();
                int m2 = bond.getAtom2().getAtomMap();
                if (m1 == 0 || m2 == 0) continue;
                boolean stored = false;
                for (int t = blist.size() - 1; t >= 0; --t) {
                    int[] p = (int[])blist.get(t);
                    if ((p[0] != m1 || p[1] != m2) && (p[0] != m2 || p[1] != m1)) continue;
                    stored = true;
                    break;
                }
                if (stored) continue;
                blist.add(new int[]{m1, m2, bond.getType()});
            }
            for (int k = reactions[i].getProductCount() - 1; k >= 0; --k) {
                Molecule product = reactions[i].getProduct(k);
                block5: for (int j = product.getBondCount() - 1; j >= 0; --j) {
                    MolBond bond = product.getBond(j);
                    int m12 = bond.getAtom1().getAtomMap();
                    int m2 = bond.getAtom2().getAtomMap();
                    if (m12 == 0 || m2 == 0) continue;
                    for (int t = blist.size() - 1; t >= 0; --t) {
                        int[] p = (int[])blist.get(t);
                        if ((p[0] != m12 || p[1] != m2) && (p[0] != m2 || p[1] != m12)) continue;
                        blist.remove(t);
                        continue block5;
                    }
                }
            }
            for (int t = blist.size() - 1; t >= 0; --t) {
                int[] p = (int[])blist.get(t);
                m1 = p[0];
                int m2 = p[1];
                int btype = p[2];
                if (map2type[m1] == -1) {
                    map2type[m1] = this.addType(rids[i] + ":" + m1, i, m1);
                }
                if (map2type[m2] == -1) {
                    map2type[m2] = this.addType(rids[i] + ":" + m2, i, m2);
                }
                this.addCompatibleConnection(map2type[m1], map2type[m2], btype);
            }
        }
    }

    public int addType(String name, int reactionNo, int map) {
        FCTRecord fctr = new FCTRecord(name, reactionNo, map, this.types.size());
        this.types.addElement(fctr);
        return this.types.size() - 1;
    }

    public int addCompatibleConnection(int type1, int type2, int bondType) {
        FCTRecord fct1 = (FCTRecord)this.types.elementAt(type1);
        FCTRecord fct2 = (FCTRecord)this.types.elementAt(type2);
        fct1.addCompatibleConnection(fct2, bondType);
        if (fct2 != fct1) {
            fct2.addCompatibleConnection(fct1, bondType);
        }
        return fct1.compatibleConnectionTypes.size() - 1;
    }

    public String getName(int i) {
        FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
        return fctr.getName();
    }

    public int getReactionNo(int i) {
        FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
        return fctr.getReactionNo();
    }

    public int getMap(int i) {
        FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
        return fctr.getMap();
    }

    public Vector getCompatibleConnectionTypes(int i) {
        FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
        return fctr.getCompatibleConnectionTypes();
    }

    public IntVector getBondOrders(int i) {
        FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
        return fctr.bondOrder;
    }

    public int getCount() {
        return this.types.size();
    }

    public int searchTypeIndex(String reactionName, int reactionMap) {
        int j = reactionName.length();
        for (int i = 0; i < this.types.size(); ++i) {
            FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
            String s = fctr.getName();
            if (reactionMap != fctr.getMap() || !s.startsWith(reactionName) || s.charAt(j) != ':') continue;
            return i;
        }
        return -1;
    }

    public FCTRecord searchType(String reactionName, int reactionMap) {
        int index = this.searchTypeIndex(reactionName, reactionMap);
        return index == -1 ? null : this.types.elementAt(index);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Rno\tRname        \tRmap\tCtypes\tBtypes");
        for (int i = 0; i < this.types.size(); ++i) {
            FCTRecord fctr = (FCTRecord)this.types.elementAt(i);
            s.append("\n");
            s.append(fctr.getReactionNo() + "\t" + fctr.getName() + " \t" + fctr.getMap() + "\t");
            if (fctr.getCompatibleConnectionTypes().size() != 0) {
                for (int j = 0; j < this.getCompatibleConnectionTypes(i).size(); ++j) {
                    if (j > 0) {
                        s.append(";");
                    }
                    FCTRecord compF = (FCTRecord)this.getCompatibleConnectionTypes(i).elementAt(j);
                    s.append(compF.getName());
                    s.append("(" + this.getBondOrders(i).elementAt(j) + ")");
                }
            }
            s.append("\t");
        }
        return new String(s);
    }

    public static class FCTRecord {
        private String name = null;
        private int reactionNo = 0;
        private int map = 0;
        private Vector compatibleConnectionTypes = new Vector();
        private IntVector bondOrder = new IntVector();
        private int index = -1;

        public FCTRecord(String name, int reactionNo, int map, int index) {
            this.name = name;
            this.reactionNo = reactionNo;
            this.map = map;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public int getReactionNo() {
            return this.reactionNo;
        }

        public int getMap() {
            return this.map;
        }

        public void addCompatibleConnection(FCTRecord c, int bondOrder) {
            this.compatibleConnectionTypes.addElement(c);
            this.bondOrder.addElement(bondOrder);
        }

        public Vector getCompatibleConnectionTypes() {
            return this.compatibleConnectionTypes;
        }

        public IntVector getCompatibleBondOrders() {
            return this.bondOrder;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "FCTRecord{name='" + this.name + "'" + "}";
        }
    }
}

