/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.fragment;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.drugdesign.fragment.FragmentBasedStrategyObject;
import chemaxon.drugdesign.fragment.FragmentConnectionTypes;
import chemaxon.drugdesign.fragment.FragmentEnumeration;
import chemaxon.drugdesign.fragment.FragmentationException;
import chemaxon.drugdesign.fragment.FragmentedMolecule;
import chemaxon.drugdesign.search.StrategyObject;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.fragmenter.FragmenterConfig;
import chemaxon.struc.Molecule;
import chemaxon.util.BinarySearch;
import chemaxon.util.Dumper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FragmentDB
extends StrategyObject
implements FragmentBasedStrategyObject {
    private int minOccurrence = 1;
    private String fragmentFile;
    private String fragmenterXmlFileName;
    private FragmenterConfig fragmenterConfig;
    private FragmentConnectionTypes fragmentConnectionTypes;
    private Vector fragmentPool = new Vector();
    private int[] connCountSegmentStart;
    private int maxConnectionsPerFragment;
    private int[] connInventory;
    private int[] connInventoryCounts;
    private int[] connInventoryFragmentIndices;

    public FragmentDB(String fragmentFileP, String fragmXmlFileNameP, int minOccurrenceP) throws IOException, FragmentationException {
        this.minOccurrence = minOccurrenceP;
        this.fragmentFile = fragmentFileP;
        this.fragmenterXmlFileName = fragmXmlFileNameP;
        this.loadFragmenterConfig();
        this.loadFragments();
    }

    public FragmentEnumeration selectExact(int[] connectionTypes, int connLength) {
        return new AtLeastFragmentEnumeration(this, connectionTypes, connLength, connLength, connLength);
    }

    public FragmentEnumeration selectAtLeast(int[] connectionTypes, int connLength, int maxConnections) {
        return new AtLeastFragmentEnumeration(this, connectionTypes, connLength, connLength, maxConnections);
    }

    public FragmentEnumeration selectAtLeast(int[] connectionTypes, int connLength, int minConnections, int maxConnections) {
        return new AtLeastFragmentEnumeration(this, connectionTypes, connLength, minConnections, maxConnections);
    }

    public FragmentEnumeration selectOneConn(int connectionType, int count, char relationToCount) {
        return new OneConnTypeFragmentEnumeration(this, connectionType, count, relationToCount, 0, this.connCountSegmentStart[this.maxConnectionsPerFragment + 1]);
    }

    IntVector getAllCompatibleFragIndices(FragmentConnectionTypes.FCTRecord attachmentType, int minConnections, int maxConnections) {
        IntVector possibleFragments = null;
        Vector compConnectionTypes = attachmentType.getCompatibleConnectionTypes();
        for (int i = 0; i < compConnectionTypes.size(); ++i) {
            FragmentConnectionTypes.FCTRecord nextCompCT = (FragmentConnectionTypes.FCTRecord)compConnectionTypes.elementAt(i);
            int[] ct = new int[]{nextCompCT.getIndex()};
            FragmentEnumeration fe = maxConnections == 0 ? this.selectExact(ct, 1) : this.selectAtLeast(ct, 1, minConnections, maxConnections);
            IntVector nextFrSet = fe.getAllRemaining();
            if (possibleFragments == null) {
                possibleFragments = nextFrSet;
                continue;
            }
            possibleFragments.addAll(nextFrSet);
        }
        return possibleFragments;
    }

    public FragmentEnumeration selectRoughly(int[] connectionTypes, int connLength) {
        return null;
    }

    public int[] getSegmentBoundaries(int connectionCount) {
        int[] r = null;
        if (connectionCount < this.maxConnectionsPerFragment && connectionCount >= 0) {
            r = new int[]{this.connCountSegmentStart[connectionCount], this.connCountSegmentStart[connectionCount + 1]};
        }
        return r;
    }

    public int[] getSegmentBoundaries(int lowConnCount, int highConnCount) {
        int[] r = null;
        if (highConnCount >= lowConnCount) {
            r = new int[]{this.connCountSegmentStart[lowConnCount], this.connCountSegmentStart[highConnCount + 1]};
        }
        return r;
    }

    public FragmentedMolecule getFragmentClone(int idx) {
        FragmentedMolecule fragment = this.getFragment(idx);
        return fragment != null ? (FragmentedMolecule)fragment.clone() : null;
    }

    public FragmentedMolecule getFragment(int idx) {
        if (idx < 0 || idx > this.fragmentPool.size()) {
            return null;
        }
        FragmentedMolecule fragment = (FragmentedMolecule)this.fragmentPool.elementAt(idx);
        return fragment;
    }

    public int getFragmentCount() {
        return this.fragmentPool.size();
    }

    public int getMaxConnectionPerFragment() {
        return this.maxConnectionsPerFragment;
    }

    public FragmentConnectionTypes getFragmentConnectionTypes() {
        return this.fragmentConnectionTypes;
    }

    private void loadFragmenterConfig() throws IOException {
        File file = new File(this.fragmenterXmlFileName);
        this.fragmenterConfig = new FragmenterConfig(file);
        this.fragmentConnectionTypes = new FragmentConnectionTypes(file);
    }

    private void loadFragments() throws IOException, FragmentationException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.fragmentFile));
        MolInputStream mis = new MolInputStream(is);
        MolImporter molimp = new MolImporter(mis);
        Molecule mol = new Molecule();
        int n = 1;
        while (molimp.read(mol)) {
            String occurrenceSt = mol.getProperty(this.fragmenterConfig.getCountTag());
            int occurrence = Integer.MAX_VALUE;
            if (occurrenceSt != null) {
                occurrence = Integer.parseInt(occurrenceSt);
            }
            if (occurrence < this.minOccurrence) continue;
            FragmentedMolecule fm = new FragmentedMolecule(mol, "Fragment " + n, this.fragmenterConfig, this.fragmentConnectionTypes);
            this.fragmentPool.addElement(fm);
            mol = new Molecule();
            ++n;
        }
        this.binSortFragmentations(this.fragmentPool);
        this.createConnInventory();
    }

    private void createConnInventory() {
        Vector tempConnInventory = new Vector();
        int[] connTypeCounts = new int[this.fragmentConnectionTypes.getCount()];
        for (int i = 0; i < this.fragmentConnectionTypes.getCount(); ++i) {
            tempConnInventory.addElement(new LinkedList());
        }
        int inventoryCount = 0;
        Arrays.fill(connTypeCounts, 0);
        for (int i = 0; i < this.fragmentPool.size(); ++i) {
            FragmentConnectionTypes.FCTRecord type;
            int j;
            FragmentedMolecule fm = (FragmentedMolecule)this.fragmentPool.elementAt(i);
            for (j = 0; j < fm.getAttachmentCount(); ++j) {
                type = fm.getAttachmentType(j);
                int n = type.getIndex();
                connTypeCounts[n] = connTypeCounts[n] + 1;
            }
            for (j = 0; j < fm.getAttachmentCount(); ++j) {
                type = fm.getAttachmentType(j);
                if (connTypeCounts[type.getIndex()] == 0) continue;
                LinkedList listToInsert = (LinkedList)tempConnInventory.elementAt(type.getIndex());
                int[] arrayToInsert = new int[]{i, connTypeCounts[type.getIndex()]};
                listToInsert.add(arrayToInsert);
                connTypeCounts[type.getIndex()] = 0;
                ++inventoryCount;
            }
        }
        this.connInventory = ArrayTools.initArray(this.connInventory, this.fragmentConnectionTypes.getCount() + 1);
        this.connInventoryCounts = ArrayTools.initArray(this.connInventoryCounts, inventoryCount);
        this.connInventoryFragmentIndices = ArrayTools.initArray(this.connInventoryFragmentIndices, inventoryCount);
        int j = 0;
        for (int i = 0; i < tempConnInventory.size(); ++i) {
            LinkedList list = (LinkedList)tempConnInventory.elementAt(i);
            this.connInventory[i] = j;
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                int[] tuple = (int[])it.next();
                this.connInventoryFragmentIndices[j] = tuple[0];
                this.connInventoryCounts[j] = tuple[1];
                ++j;
            }
        }
        this.connInventory[this.fragmentConnectionTypes.getCount()] = j;
    }

    private void binSortFragmentations(Vector input) {
        int i;
        Vector bins = new Vector();
        for (i = input.size() - 1; i >= 0; --i) {
            FragmentedMolecule f = (FragmentedMolecule)input.elementAt(i);
            input.removeElementAt(i);
            int occ = f.getAttachmentCount();
            if (occ >= bins.size()) {
                for (int j = bins.size(); j < occ + 1; ++j) {
                    bins.addElement(new Vector());
                }
            }
            Vector currentBin = (Vector)bins.elementAt(occ);
            currentBin.addElement(f);
        }
        this.maxConnectionsPerFragment = bins.size();
        this.connCountSegmentStart = ArrayTools.initArray(this.connCountSegmentStart, this.maxConnectionsPerFragment + 2);
        for (i = 0; i < bins.size(); ++i) {
            this.connCountSegmentStart[i] = input.size();
            Vector bin = (Vector)bins.elementAt(i);
            input.addAll(bin);
        }
        for (i = bins.size(); i < this.connCountSegmentStart.length; ++i) {
            this.connCountSegmentStart[i] = input.size();
        }
    }

    public void dump() {
        boolean success;
        System.err.println(this.privateToString());
        File dumpDir = new File("dump");
        if (!dumpDir.exists() && !(success = dumpDir.mkdir())) {
            return;
        }
        File outFdb = new File(dumpDir, "FDB.cxsmiles");
        if (outFdb.exists()) {
            outFdb.delete();
        }
        try {
            outFdb.createNewFile();
            MolExporter exporter = new MolExporter(new FileOutputStream(outFdb), "cxsmiles");
            for (int i = 0; i < this.fragmentPool.size(); ++i) {
                FragmentedMolecule fragmentedMolecule = (FragmentedMolecule)this.fragmentPool.elementAt(i);
                exporter.write(fragmentedMolecule);
            }
            exporter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < this.fragmentConnectionTypes.getCount(); ++i) {
            System.out.println("Dumping enumeration " + this.fragmentConnectionTypes.getName(i) + " into file.");
            String fileName = ("OneConnEnum_" + this.fragmentConnectionTypes.getName(i) + ".cxsmiles").replace(':', '_');
            File outFile = new File(dumpDir, fileName);
            try {
                outFile.createNewFile();
                MolExporter exp = new MolExporter(new FileOutputStream(outFile), "cxsmiles");
                FragmentEnumeration fe = this.selectOneConn(i, 1, '<');
                while (fe.hasMoreElements()) {
                    FragmentedMolecule m = fe.nextMolecule(false);
                    exp.write(m);
                }
                exp.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private String privateToString() {
        FragmentEnumeration fe;
        int[] conn;
        FragmentedMolecule fm;
        FragmentEnumeration fe2;
        int[] conn2;
        int i;
        StringBuffer s1 = new StringBuffer("FragmentDB{\nminOccurrence=" + this.minOccurrence + ",\n fragmentFile='" + this.fragmentFile + "'" + ",\n fragmenterXmlFileName='" + this.fragmenterXmlFileName + "'" + ",\n fragmentConnectionTypes=\n" + this.fragmentConnectionTypes + ",\n fragmentPool=(" + this.fragmentPool.size() + ") [");
        for (i = 0; i < this.fragmentPool.size(); ++i) {
            FragmentedMolecule fragmentedMolecule = (FragmentedMolecule)this.fragmentPool.elementAt(i);
            s1.append("\n   [" + i + "] " + fragmentedMolecule.toFormat("cxsmiles"));
        }
        s1.append(']');
        s1.append(",\n connCountSegmentStart=" + Dumper.dumpIntArray(this.connCountSegmentStart) + ",\n maxConnectionsPerFragment=" + this.maxConnectionsPerFragment + ",\n connInventory=" + Dumper.dumpIntArray(this.connInventory) + ",\n connInventoryCounts=" + Dumper.dumpIntArray(this.connInventoryCounts) + ",\n connInventoryFragmentIndices=" + Dumper.dumpIntArray(this.connInventoryFragmentIndices) + "}");
        s1.append("\nEnumerations:\n  OneConnEnumerations:\n");
        for (i = 0; i < this.fragmentConnectionTypes.getCount(); ++i) {
            s1.append("    " + this.fragmentConnectionTypes.getName(i) + " OneConnEn: ");
            FragmentEnumeration fe3 = this.selectOneConn(i, 1, '<');
            s1.append(Dumper.dumpFragmentEnumeration(fe3, this));
        }
        s1.append("\n  ExactEnumerations:\n");
        i = 0;
        while (i < this.fragmentConnectionTypes.getCount()) {
            s1.append("    " + this.fragmentConnectionTypes.getName(i) + " ExactEn: ");
            conn2 = new int[]{i++};
            fe2 = this.selectExact(conn2, 1);
            s1.append(Dumper.dumpFragmentEnumeration(fe2, this));
        }
        for (i = 0; i < this.fragmentPool.size(); ++i) {
            fm = (FragmentedMolecule)this.fragmentPool.elementAt(i);
            if (fm.getAttachmentCount() <= 1) continue;
            conn = new int[fm.getAttachmentCount()];
            s1.append("    ExactEn( ");
            for (int j = 0; j < fm.getAttachmentCount(); ++j) {
                conn[j] = fm.getAttachmentType(j).getIndex();
                s1.append(fm.getAttachmentType(j).getName() + " ");
            }
            s1.append("): ");
            fe = this.selectExact(conn, fm.getAttachmentCount());
            s1.append(Dumper.dumpFragmentEnumeration(fe, this));
        }
        s1.append("\n  AtLeastEnumerations:\n");
        i = 0;
        while (i < this.fragmentConnectionTypes.getCount()) {
            s1.append("    " + this.fragmentConnectionTypes.getName(i) + " AtLeastEn with max. 2 connections: ");
            conn2 = new int[]{i++};
            fe2 = this.selectAtLeast(conn2, 1, 2);
            s1.append(Dumper.dumpFragmentEnumeration(fe2, this));
        }
        for (i = 0; i < this.fragmentPool.size(); ++i) {
            fm = (FragmentedMolecule)this.fragmentPool.elementAt(i);
            if (fm.getAttachmentCount() <= 1) continue;
            conn = new int[fm.getAttachmentCount()];
            s1.append("    AtLeastEn( ");
            for (int j = 0; j < fm.getAttachmentCount(); ++j) {
                conn[j] = fm.getAttachmentType(j).getIndex();
                s1.append(fm.getAttachmentType(j).getName() + " ");
            }
            s1.append(") with max. 3 conn: ");
            fe = this.selectAtLeast(conn, fm.getAttachmentCount(), 3);
            s1.append(Dumper.dumpFragmentEnumeration(fe, this));
        }
        return s1.toString();
    }

    private static class OneConnTypeFragmentEnumeration
    extends FragmentEnumeration {
        int type;
        int count;
        char relationToCount;
        int lowerFragmentIdxLimit;
        int upperFragmentIdxLimit;
        int cILimitLow;
        int cILimitHigh;
        int currentIdxInCICounts;

        OneConnTypeFragmentEnumeration(FragmentDB pFdb, int pType, int pCount, char pRelationToCount, int lowerFragIdxLimit, int upperFragIdxLimit) {
            super(pFdb);
            this.type = pType;
            this.count = pCount;
            this.relationToCount = pRelationToCount;
            this.lowerFragmentIdxLimit = lowerFragIdxLimit;
            this.upperFragmentIdxLimit = upperFragIdxLimit;
            this.currentIdxInCICounts = -1;
            this.cILimitLow = this.fdb.connInventory[pType];
            this.cILimitHigh = this.fdb.connInventory[pType + 1];
        }

        private boolean isFinished() {
            if (this.currentIdxInCICounts >= this.cILimitHigh) {
                return true;
            }
            int currentFrIdx = this.fdb.connInventoryFragmentIndices[this.currentIdxInCICounts];
            return currentFrIdx >= this.upperFragmentIdxLimit;
        }

        private boolean isCurrentOK() {
            if (this.isFinished()) {
                return false;
            }
            int currentCount = this.fdb.connInventoryCounts[this.currentIdxInCICounts];
            if (this.relationToCount == '=') {
                return currentCount == this.count;
            }
            if (this.relationToCount == '<') {
                return this.count <= currentCount;
            }
            return false;
        }

        private void skipToNext() {
            this.currentIdxInCICounts = this.currentIdxInCICounts == -1 ? BinarySearch.intSearchInInterval(this.fdb.connInventoryFragmentIndices, this.cILimitLow, this.cILimitHigh, this.lowerFragmentIdxLimit) : ++this.currentIdxInCICounts;
            while (!this.isCurrentOK() && !this.isFinished()) {
                ++this.currentIdxInCICounts;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentIdxInCICounts == -1) {
                this.skipToNext();
            }
            return !this.isFinished();
        }

        @Override
        public int nextElement() {
            if (this.hasMoreElements()) {
                int toReturn = this.fdb.connInventoryFragmentIndices[this.currentIdxInCICounts];
                this.skipToNext();
                return toReturn;
            }
            throw new NoSuchElementException();
        }
    }

    private static class AtLeastFragmentEnumeration
    extends FragmentEnumeration {
        protected int[] connectionTypes;
        protected int[] connectionTypeCounts;
        protected int connectionTypeLength;
        protected int connectionTypeWholeLength;
        protected OneConnTypeFragmentEnumeration[] subEnums;
        protected boolean[] subHasMoreElement;
        protected int[] subNextElement;
        protected boolean finished;
        protected int minFragIdx = -1;
        protected int minConnIdx = -1;
        protected char relation = (char)60;
        protected int fragIdxLimitHigh;
        protected int fragIdxLimitLow;
        protected int maxConnections;
        protected int minConnections;

        AtLeastFragmentEnumeration(FragmentDB fdbpar, int[] connTypes, int connTypesLength, int minConn, int maxConn) {
            super(fdbpar);
            this.connectionTypes = new int[connTypesLength];
            this.connectionTypeCounts = new int[connTypesLength];
            this.connectionTypeWholeLength = connTypesLength;
            this.connectionTypeLength = 0;
            for (int i = 0; i < connTypesLength; ++i) {
                int idx = ArrayTools.indexInArray(this.connectionTypes, this.connectionTypeLength, connTypes[i]);
                if (idx == -1) {
                    this.connectionTypes[this.connectionTypeLength] = connTypes[i];
                    this.connectionTypeCounts[this.connectionTypeLength] = 1;
                    ++this.connectionTypeLength;
                    continue;
                }
                int n = idx;
                this.connectionTypeCounts[n] = this.connectionTypeCounts[n] + 1;
            }
            this.maxConnections = maxConn > this.fdb.maxConnectionsPerFragment ? fdbpar.maxConnectionsPerFragment : maxConn;
            this.fragIdxLimitHigh = this.fdb.connCountSegmentStart[this.maxConnections + 1];
            this.minConnections = minConn < 0 ? 0 : minConn;
            this.fragIdxLimitLow = this.fdb.connCountSegmentStart[this.minConnections];
            this.init();
        }

        protected void init() {
            this.subEnums = new OneConnTypeFragmentEnumeration[this.connectionTypeLength];
            this.subHasMoreElement = new boolean[this.connectionTypeLength];
            this.subNextElement = new int[this.connectionTypeLength];
            this.finished = false;
            for (int i = 0; i < this.connectionTypeLength; ++i) {
                this.subEnums[i] = new OneConnTypeFragmentEnumeration(this.fdb, this.connectionTypes[i], this.connectionTypeCounts[i], this.relation, this.fragIdxLimitLow, this.fragIdxLimitHigh);
            }
            this.stepWithEach();
            if (!this.isCurrentOK()) {
                this.skipToNext();
            }
        }

        protected void findMin() {
            if (!this.finished) {
                this.minFragIdx = Integer.MAX_VALUE;
                this.minConnIdx = -1;
                for (int i = 0; i < this.connectionTypeLength; ++i) {
                    if (!this.subHasMoreElement[i] || this.subNextElement[i] >= this.minFragIdx) continue;
                    this.minFragIdx = this.subNextElement[i];
                    this.minConnIdx = i;
                }
                if (this.minConnIdx == -1) {
                    this.finished = true;
                }
            }
        }

        protected void skipToNext() {
            while (!this.finished && !this.isCurrentOK()) {
                this.step();
            }
        }

        protected void step() {
            if (this.finished) {
                return;
            }
            this.subHasMoreElement[this.minConnIdx] = this.subEnums[this.minConnIdx].hasMoreElements();
            boolean bl = this.finished = !this.subHasMoreElement[this.minConnIdx];
            if (!this.finished) {
                this.subNextElement[this.minConnIdx] = this.subEnums[this.minConnIdx].nextElement();
                this.findMin();
            }
        }

        protected boolean isCurrentOK() {
            if (this.finished) {
                return false;
            }
            for (int i = 0; i < this.connectionTypeLength; ++i) {
                if (this.subNextElement[i] == this.minFragIdx) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasMoreElements() {
            return !this.finished;
        }

        @Override
        public int nextElement() {
            if (this.hasMoreElements()) {
                int toReturn = this.minFragIdx;
                this.stepWithEach();
                this.skipToNext();
                return toReturn;
            }
            throw new NoSuchElementException();
        }

        protected void stepWithEach() {
            for (int i = 0; i < this.connectionTypeLength; ++i) {
                this.subHasMoreElement[i] = this.subEnums[i].hasMoreElements();
                if (!this.subHasMoreElement[i]) {
                    this.finished = true;
                    return;
                }
                this.subNextElement[i] = this.subEnums[i].nextElement();
            }
            this.findMin();
        }
    }
}

