/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.fragment;

import chemaxon.common.util.IntVector;
import chemaxon.drugdesign.fragment.FragmentBasedSearch;
import chemaxon.drugdesign.fragment.FragmentBasedStrategyObject;
import chemaxon.drugdesign.fragment.FragmentConnectionTypes;
import chemaxon.drugdesign.fragment.FragmentDB;
import chemaxon.drugdesign.fragment.FragmentationException;
import chemaxon.drugdesign.fragment.FragmentedMolecule;
import chemaxon.drugdesign.search.StartingMoleculeBuilder;
import java.util.Random;
import java.util.Vector;

public class RandomStartingMoleculeBuilder
extends StartingMoleculeBuilder
implements FragmentBasedStrategyObject {
    private static final int DEFAULT_MOLCOUNT = 100;
    private static final int DEFAULT_MAXFRAGMENTCOUNT = 10;
    private int molCount = 100;
    private int minFragmentCount = 2;
    private int maxFragmentCount = 10;
    private int lowConnNumber;
    private int highConnNumber;
    private int[] segmentBounds;
    private FragmentDB fdb;
    private Random random = new Random();
    private int maxTrials = 300;

    @Override
    public void generate(Vector molecules) {
        int trials;
        this.fdb = ((FragmentBasedSearch)this.search).getFragmentdb();
        this.highConnNumber = this.maxFragmentCount - 1;
        if (this.highConnNumber > this.fdb.getMaxConnectionPerFragment()) {
            this.highConnNumber = this.fdb.getMaxConnectionPerFragment();
        }
        this.lowConnNumber = this.minFragmentCount <= 1 ? 0 : 1;
        this.segmentBounds = this.fdb.getSegmentBoundaries(this.lowConnNumber, this.highConnNumber);
        int i = 0;
        for (trials = 0; i < this.molCount && trials < this.maxTrials; ++trials) {
            FragmentedMolecule fm = null;
            try {
                fm = this.generateScaffold();
                fm = this.fillOpenNodes(fm);
            }
            catch (FragmentationException e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (fm == null) continue;
            molecules.add(fm);
            ++i;
        }
        System.out.println("Generated " + i + " molecules using " + trials + " attempts.");
    }

    private FragmentedMolecule fillOpenNodes(FragmentedMolecule fm) throws FragmentationException {
        while (fm.getAttachmentCount() > 0) {
            int oConn = this.random.nextInt(fm.getAttachmentCount());
            int maxExtraConn = this.maxFragmentCount - fm.getAttachmentCount() - fm.getFragmentCount();
            int minExtraConn = fm.getFragmentCount() + fm.getAttachmentCount() < this.minFragmentCount ? 1 : 0;
            FragmentConnectionTypes.FCTRecord attachmentType = fm.getAttachmentType(oConn);
            IntVector possibleFragments = this.fdb.getAllCompatibleFragIndices(attachmentType, minExtraConn + 1, maxExtraConn + 1);
            if (possibleFragments == null || possibleFragments.size() == 0) {
                return null;
            }
            int fi = this.random.nextInt(possibleFragments.size());
            FragmentedMolecule newPart = this.fdb.getFragment(possibleFragments.elementAt(fi));
            int oConnNewPart = newPart.getRandomCompAttachmentIdx(attachmentType);
            if (oConn != -1 && oConnNewPart != -1) {
                fm = FragmentedMolecule.connect(fm, oConn, newPart, oConnNewPart);
                continue;
            }
            throw new FragmentationException("Incompatible connection!");
        }
        return fm;
    }

    private FragmentedMolecule generateScaffold() throws FragmentationException {
        if (this.segmentBounds[1] == this.segmentBounds[0]) {
            throw new FragmentationException("Cannot generate molecule with such constraints.");
        }
        int fIndex = this.random.nextInt(this.segmentBounds[1] - this.segmentBounds[0]) + this.segmentBounds[0];
        return this.fdb.getFragmentClone(fIndex);
    }

    public int getMolCount() {
        return this.molCount;
    }

    public void setMolCount(int newMolCount) {
        this.molCount = newMolCount;
    }

    public int getMinFragmentCount() {
        return this.minFragmentCount;
    }

    public void setMinFragmentCount(int argMinFragmentCount) {
        this.minFragmentCount = argMinFragmentCount;
    }

    public int getMaxFragmentCount() {
        return this.maxFragmentCount;
    }

    public void setMaxFragmentCount(int argMaxFragmentCount) {
        this.maxFragmentCount = argMaxFragmentCount;
    }
}

