/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.search;

import chemaxon.drugdesign.search.MoleculeModifier;
import chemaxon.drugdesign.search.OperatorSelector;
import chemaxon.drugdesign.search.Parameter;
import chemaxon.drugdesign.search.ParentSelector;
import chemaxon.drugdesign.search.StartingMoleculeBuilder;
import chemaxon.drugdesign.search.StrategyObject;
import chemaxon.drugdesign.search.SurvivorSelector;
import chemaxon.drugdesign.search.TerminationCriterion;
import chemaxon.formats.MolExporter;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.VectorUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class EvolutionarySearch {
    public static final String GOALFUNCTION_VALUE_ID = "GoalFunction_Value";
    protected int offspringGenerationSize = 1000;
    protected int newMolInGenerationCount = 0;
    protected double allowedScoreDecrease = Double.POSITIVE_INFINITY;
    private boolean duplicateStructureAllowed;
    protected String goalFunction;
    protected Vector parentPool = new Vector(100);
    protected Vector offspringPool = new Vector(this.offspringGenerationSize);
    protected Vector startingMoleculeBuilders = new Vector();
    protected Vector generationTerminators = new Vector();
    protected Vector terminators = new Vector();
    protected OperatorSelector operatorSelector;
    protected ParentSelector parentSelector;
    protected Vector survivorSelectors = new Vector();
    protected Vector moleculeModifiers = new Vector();
    protected Vector parameters = new Vector();
    private Hashtable propertyHT = new Hashtable();
    private static Vector tempParents = new Vector();
    private static Vector tempOffspring = new Vector();
    private Vector tempParentsAndOffspring = new Vector(this.offspringGenerationSize);
    private Vector tempNewParents = new Vector();
    private Vector tempNewParents1 = new Vector();
    private Vector tempNewParents2 = new Vector();
    private MolSearch molSearch = new MolSearch();
    protected Vector strategyObjects = new Vector();
    private boolean startingPopulationDump = false;

    public Object getPropertyObject(String key) {
        return this.propertyHT.get(key);
    }

    public void setPropertyObject(String key, Object value) {
        this.propertyHT.put(key, value);
    }

    private void generateStartingMolecules() {
        this.parentPool.clear();
        for (int i = 0; i < this.startingMoleculeBuilders.size(); ++i) {
            StartingMoleculeBuilder smb = (StartingMoleculeBuilder)this.startingMoleculeBuilders.elementAt(i);
            smb.generate(this.parentPool);
        }
        if (this.startingPopulationDump) {
            try {
                this.dumpParentPool("StartingPopulation.sdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void dumpParentPool(String fileName) throws IOException {
        boolean success;
        File dumpDir = new File("dump");
        if (!dumpDir.exists() && !(success = dumpDir.mkdir())) {
            throw new IOException("Could not create directory dump.");
        }
        File outFdb = new File(dumpDir, fileName);
        if (outFdb.exists()) {
            outFdb.delete();
        }
        try {
            outFdb.createNewFile();
            MolExporter exporter = new MolExporter(new FileOutputStream(outFdb), "sdf");
            for (int i = 0; i < this.parentPool.size(); ++i) {
                Molecule mol = (Molecule)this.parentPool.elementAt(i);
                exporter.write(mol);
            }
            exporter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private boolean isTerminatingGeneration() {
        if (this.newMolInGenerationCount >= this.offspringGenerationSize) {
            return true;
        }
        for (int i = 0; i < this.generationTerminators.size(); ++i) {
            TerminationCriterion tc = (TerminationCriterion)this.generationTerminators.elementAt(i);
            if (!tc.isTerminating()) continue;
            return true;
        }
        return false;
    }

    private boolean isTerminating() {
        for (int i = 0; i < this.terminators.size(); ++i) {
            TerminationCriterion tc = (TerminationCriterion)this.terminators.elementAt(i);
            if (!tc.isTerminating()) continue;
            return true;
        }
        return false;
    }

    private int selectOperator() {
        if (null == this.operatorSelector) {
            return 1;
        }
        return this.operatorSelector.selectOperator();
    }

    private void selectParents(Vector parents, int modifierIdx) {
        MoleculeModifier mm = (MoleculeModifier)this.moleculeModifiers.elementAt(modifierIdx);
        int parentCount = mm.parentCount();
        parents.clear();
        parents.addElement(this.parentSelector.selectFirst());
        for (int i = 1; i < parentCount; ++i) {
            parents.addElement(this.parentSelector.selectNext());
        }
    }

    private void selectSurvivors() {
        Vector prevMols = null;
        Vector currentOutput = this.tempNewParents1;
        this.tempParentsAndOffspring.clear();
        this.tempParentsAndOffspring.ensureCapacity(this.parentPool.size() + this.offspringPool.size());
        this.tempParentsAndOffspring.addAll(this.parentPool);
        this.tempParentsAndOffspring.addAll(this.offspringPool);
        VectorUtil.assignIndices(this.tempParentsAndOffspring);
        this.tempNewParents.clear();
        this.tempNewParents.ensureCapacity(this.parentPool.capacity());
        this.tempNewParents1.clear();
        this.tempNewParents1.ensureCapacity(this.parentPool.capacity());
        this.tempNewParents2.clear();
        this.tempNewParents2.ensureCapacity(this.parentPool.capacity());
        for (int i = 0; i < this.survivorSelectors.size(); ++i) {
            SurvivorSelector ss = (SurvivorSelector)this.survivorSelectors.elementAt(i);
            currentOutput.clear();
            if (ss.isFilteringPrevious() && prevMols != null) {
                ss.select(prevMols, currentOutput);
            } else {
                if (prevMols != null) {
                    VectorUtil.mergeMoleculeVectors(this.tempNewParents, prevMols);
                }
                ss.select(this.tempParentsAndOffspring, currentOutput);
            }
            prevMols = currentOutput;
            currentOutput = currentOutput == this.tempNewParents1 ? this.tempNewParents2 : this.tempNewParents1;
        }
        if (prevMols != null) {
            VectorUtil.mergeMoleculeVectors(this.tempNewParents, prevMols);
        }
        if (!this.duplicateStructureAllowed) {
            this.removeDuplicates(this.tempNewParents);
        }
    }

    private void removeDuplicates(Vector molVector) {
        this.molSearch.setSearchOptions(new MolSearchOptions(5));
        this.tempNewParents1.clear();
        for (int i = 0; i < molVector.size(); ++i) {
            Molecule mol = (Molecule)molVector.elementAt(i);
            this.molSearch.setQuery(mol);
            for (int j = i + 1; j < molVector.size(); ++j) {
                Molecule m1 = (Molecule)molVector.elementAt(j);
                this.molSearch.setTarget(m1);
                try {
                    if (!this.molSearch.isMatching()) continue;
                    molVector.removeElementAt(j);
                    --j;
                    continue;
                }
                catch (SearchException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void generateOffspring() {
        int i;
        double bestParentScoreValue = Double.POSITIVE_INFINITY;
        Molecule bestParent = null;
        int operator = this.selectOperator();
        this.selectParents(tempParents, operator);
        for (i = 0; i < tempParents.size(); ++i) {
            Molecule p = (Molecule)tempParents.elementAt(i);
            double pValue = (Double)p.getPropertyObject(GOALFUNCTION_VALUE_ID);
            if (!(pValue < bestParentScoreValue)) continue;
            bestParent = p;
            bestParentScoreValue = pValue;
        }
        MoleculeModifier mm = (MoleculeModifier)this.moleculeModifiers.elementAt(operator);
        this.newMolInGenerationCount += mm.generateOffspring(tempParents, tempOffspring);
        for (i = 0; i < tempOffspring.size(); ++i) {
            Molecule offspring = (Molecule)tempOffspring.elementAt(i);
            double scoreValue = 0.0;
            if (!(scoreValue >= bestParentScoreValue - this.allowedScoreDecrease)) continue;
            offspring.setPropertyObject(GOALFUNCTION_VALUE_ID, new Double(scoreValue));
            this.offspringPool.addElement(offspring);
            this.statisticsForAdaptation(bestParent, bestParentScoreValue, offspring, scoreValue, operator);
        }
    }

    private void statisticsForAdaptation(Molecule parent, double parentScore, Molecule offspring, double offspringScore, int operator) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter p = (Parameter)this.parameters.elementAt(i);
            int modifierIdx = p.getModifierIdx();
            if (-1 != modifierIdx && operator != modifierIdx) continue;
            p.statistics(parent, parentScore, offspring, offspringScore, operator);
        }
    }

    private void startGeneration() {
        this.newMolInGenerationCount = 0;
        for (int i = 0; i < this.strategyObjects.size(); ++i) {
            StrategyObject so = (StrategyObject)this.strategyObjects.elementAt(i);
            so.startGeneration();
        }
    }

    private void finishGeneration() {
        for (int i = 0; i < this.strategyObjects.size(); ++i) {
            StrategyObject so = (StrategyObject)this.strategyObjects.elementAt(i);
            so.finishGeneration();
        }
    }

    public void mainLoop() {
        this.startSearch();
        this.generateStartingMolecules();
        while (!this.isTerminating()) {
            this.startGeneration();
            while (!this.isTerminatingGeneration()) {
                this.generateOffspring();
            }
            this.finishGeneration();
            this.selectSurvivors();
        }
        this.finishSearch();
    }

    private void finishSearch() {
        for (int i = 0; i < this.strategyObjects.size(); ++i) {
            StrategyObject so = (StrategyObject)this.strategyObjects.elementAt(i);
            so.finishSearch();
        }
    }

    private void startSearch() {
        for (int i = 0; i < this.strategyObjects.size(); ++i) {
            StrategyObject so = (StrategyObject)this.strategyObjects.elementAt(i);
            so.startSearch();
        }
    }

    public void add(StartingMoleculeBuilder smb) {
        this.startingMoleculeBuilders.addElement(smb);
        this.strategyObjects.addElement(smb);
        smb.setSearch(this);
    }

    public void add(MoleculeModifier mm) {
        this.moleculeModifiers.addElement(mm);
        this.strategyObjects.addElement(mm);
        mm.setSearch(this);
    }

    public void add(Parameter p) {
        this.parameters.addElement(p);
        this.strategyObjects.addElement(p);
        p.setSearch(this);
        this.setPropertyObject(p.getName(), new Double(p.getValue()));
    }

    public void add(OperatorSelector os) {
        this.operatorSelector = os;
        this.strategyObjects.addElement(os);
        os.setSearch(this);
    }

    public void addTerminator(TerminationCriterion tc) {
        this.terminators.addElement(tc);
        this.strategyObjects.addElement(tc);
        tc.setSearch(this);
    }

    public void addGenerationTerminator(TerminationCriterion tc) {
        this.generationTerminators.addElement(tc);
        this.strategyObjects.addElement(tc);
        tc.setSearch(this);
    }

    public void add(ParentSelector ps) {
        this.parentSelector = ps;
        this.strategyObjects.addElement(ps);
        ps.setSearch(this);
    }

    public void add(SurvivorSelector ss) {
        this.survivorSelectors.addElement(ss);
        this.strategyObjects.addElement(ss);
        ss.setSearch(this);
    }

    public int getOffspringGenerationSize() {
        return this.offspringGenerationSize;
    }

    public void setOffspringGenerationSize(int offspringGenerSizeP) {
        this.offspringGenerationSize = offspringGenerSizeP;
    }

    public int getNewMolInGenerationCount() {
        return this.newMolInGenerationCount;
    }

    public void setNewMolInGenerationCount(int value) {
        this.newMolInGenerationCount = value;
    }

    public double getAllowedScoreDecrease() {
        return this.allowedScoreDecrease;
    }

    public void setAllowedScoreDecrease(double val) {
        this.allowedScoreDecrease = val;
    }

    public boolean isDuplicateStructureAllowed() {
        return this.duplicateStructureAllowed;
    }

    public void setDuplicateStructureAllowed(boolean val) {
        this.duplicateStructureAllowed = val;
    }

    public String getGoalFunction() {
        return this.goalFunction;
    }

    public void setGoalFunction(String formula) {
        this.goalFunction = formula;
    }

    public void setStartingPopulationDump(boolean isDumpable) {
        this.startingPopulationDump = isDumpable;
    }
}

