/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.drugdesign.search;

import chemaxon.drugdesign.search.StrategyObject;

public class TerminationCriterion
extends StrategyObject {
    public static final int TERMINATE_SEARCH = 1;
    public static final int TERMINATE_GENERATION = 2;
    public static final int LESS_THAN = 60;
    public static final int GREATER_THAN = 62;
    public static final int EQUAL = 61;
    public static final int LESS_THAN_OR_EQUAL = 44;
    public static final int GREATER_THAN_OR_EQUAL = 46;
    private int whatToTerminate;
    private String parameterName;
    private double terminationValue;
    private int terminationRelation;
    public static final double EPSILON = 1.0E-9;

    private static boolean equal(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public boolean isTerminating() {
        Double parameterVDouble = (Double)this.search.getPropertyObject(this.parameterName);
        double parameterValue = parameterVDouble;
        switch (this.terminationRelation) {
            case 61: {
                return TerminationCriterion.equal(parameterValue, this.terminationValue);
            }
            case 46: {
                return parameterValue > this.terminationValue - 1.0E-9;
            }
            case 62: {
                return parameterValue > this.terminationValue + 1.0E-9;
            }
            case 60: {
                return parameterValue < this.terminationValue - 1.0E-9;
            }
            case 44: {
                return parameterValue < this.terminationValue + 1.0E-9;
            }
        }
        return false;
    }

    public int getWhatToTerminate() {
        return this.whatToTerminate;
    }

    public void setWhatToTerminate(int whatToTerminate) {
        this.whatToTerminate = whatToTerminate;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public double getTerminationValue() {
        return this.terminationValue;
    }

    public void setTerminationValue(double terminationValue) {
        this.terminationValue = terminationValue;
    }

    public int getTerminationRelation() {
        return this.terminationRelation;
    }

    public void setTerminationRelation(int terminationRelation) {
        this.terminationRelation = terminationRelation;
    }
}

