/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.ExpansionHelper;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.util.IntRange;
import java.math.BigInteger;
import java.util.ArrayList;

public class ExpansionCounter
extends ExpansionHelper
implements Licensable {
    private String licenseEnvironment = "";
    private static final String MULTIPLICITY = "MULTIPLICITY";
    private static final String MINREP = "MINREP";
    private static final String MAXREP = "MAXREP";
    private static final String DEPTH = "DEPTH";
    private static final String MULTIBOND = "MULTIBOND";
    private static final String RGROUP_MEMBER_INDEX = "RGROUP_MEMBER_INDEX";
    private static final String ORIGINDEX = "origIndex";
    private Molecule origMol = null;
    private MoleculeGraph expansionGraph = null;
    private MolAtom expansionRoot = null;
    private int[] expansionSequence = null;
    private MultiBond[] multiBonds = null;
    private boolean approx = false;
    boolean anyQueryBond = false;
    private boolean enumHomology = true;

    public static String getMarkushErrorMessage(Molecule mol) {
        try {
            ExpansionCounter.checkMarkushStructure(mol);
        }
        catch (ExpansionException e) {
            return e.getMessage();
        }
        return null;
    }

    public static void checkMarkushStructure(Molecule mol) throws ExpansionException {
        ExpansionCounter ec = new ExpansionCounter();
        ec.setEnumerateHomology(false);
        ec.setMolecule(mol);
        ec.createExpansionGraph0();
    }

    private MultiBond[] createMultiBonds(MoleculeGraph graph) throws ExpansionException {
        ArrayList<MultiBond> mbonds = new ArrayList<MultiBond>();
        ArrayList<MulticenterSgroup> mgroups = new ArrayList<MulticenterSgroup>();
        MultiBond newMultiBond = null;
        for (int i = 0; i < this.multicenterSgroups.length; ++i) {
            MulticenterSgroup msg = this.multicenterSgroups[i];
            MolAtom ca = msg.getCentralAtom();
            if (!SelectionUtil.isSelected(ca)) continue;
            for (int j = ca.getBondCount() - 1; j >= 0; --j) {
                MolBond mb = ca.getBond(j);
                MolAtom oa = mb.getOtherAtom(ca);
                if (SelectionUtil.isSelected(oa)) {
                    newMultiBond = null;
                    if (oa.getAtno() != 137) {
                        newMultiBond = new MultiBond(msg, oa, mb, graph);
                    } else {
                        for (int k = mgroups.size() - 1; k >= 0; --k) {
                            MulticenterSgroup m = (MulticenterSgroup)mgroups.get(k);
                            if (m.getCentralAtom() != oa) continue;
                            newMultiBond = new MultiBond(msg, m, mb, graph);
                            break;
                        }
                    }
                }
                if (mb.getType() == 9 || newMultiBond == null) continue;
                mbonds.add(newMultiBond);
            }
            mgroups.add(msg);
        }
        MultiBond[] res = new MultiBond[mbonds.size()];
        mbonds.toArray(res);
        return res;
    }

    public ExpansionCounter() {
    }

    public ExpansionCounter(Molecule mol) {
        this(mol, null);
    }

    public ExpansionCounter(Molecule mol, int[] indexes) {
        this.setMolecule(mol, indexes);
    }

    @Override
    public void setMolecule(Molecule mol) {
        this.setMolecule(mol, null);
    }

    public void setMolecule(Molecule mol, int[] indexes) {
        int i;
        mol = mol.cloneMolecule();
        mol.setGUIContracted(false);
        this.origMol = mol;
        for (i = mol.getAtomCount() - 1; i >= 0; --i) {
            mol.getAtom(i).setSetSeq(0);
        }
        for (i = mol.getBondCount() - 1; i >= 0; --i) {
            mol.getBond(i).setSetSeq(0);
        }
        if (indexes != null) {
            SelectionUtil.select(mol, indexes);
        }
        if (this.enumHomology && HomologyConstants.containsHomology(mol)) {
            HomologyConversionUtil hcu = new HomologyConversionUtil(mol, true, false);
            mol = hcu.getConvertedMol();
        }
        super.setMolecule(mol);
        this.expansionGraph = null;
        this.expansionRoot = null;
        this.expansionSequence = null;
    }

    @Override
    protected void setApproximateCount(boolean approx) {
        this.approx = approx;
    }

    public boolean isApproximateCount() {
        if (this.approx) {
            return true;
        }
        for (int i = 0; i < this.multiBonds.length; ++i) {
            if (!this.multiBonds[i].approx) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandable(MolAtom atom) {
        return SelectionUtil.isSelected(atom) && super.isExpandable(atom);
    }

    @Override
    public boolean isExpandable(MolBond bond) {
        return SelectionUtil.isSelected(bond.getAtom1()) && SelectionUtil.isSelected(bond.getAtom2()) && super.isExpandable(bond);
    }

    @Override
    public boolean isExpandable(RepeatingUnitSgroup sgroup) {
        return SelectionUtil.isSelected(sgroup) && super.isExpandable(sgroup);
    }

    @Override
    public boolean isExpandableMultiBond(MolBond bond) {
        return SelectionUtil.isSelected(bond.getAtom1()) && SelectionUtil.isSelected(bond.getAtom2()) && super.isExpandableMultiBond(bond);
    }

    public int countExpansionsMagnitude() throws ExpansionException {
        return this.countExpansionsString().length();
    }

    public String countExpansionsString() throws ExpansionException {
        return this.countExpansionsLarge().toString();
    }

    public BigInteger countExpansionsLarge() throws ExpansionException {
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        return this.countExpansionsLarge(this.expansionRoot);
    }

    public BigInteger countExpansionsLarge(int index) throws ExpansionException {
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        return this.countExpansionsLarge(this.getAtomFromExpansionGraph(index));
    }

    public BigInteger[] countExpansionsInRgroupMemberNodesLarge(int index) throws ExpansionException {
        MolAtom atom;
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        if ((atom = this.getAtomFromExpansionGraph(index)) == null) {
            return null;
        }
        ArrayList<MolAtom> memberHelpers = new ArrayList<MolAtom>();
        for (int j = atom.getBondCount() - 1; j >= 0; --j) {
            MolBond bond = atom.getBond(j);
            if (bond.getAtom1() != atom || bond.getSetSeq() != 1) continue;
            memberHelpers.add(bond.getAtom2());
        }
        BigInteger[] result = new BigInteger[memberHelpers.size()];
        for (int i = 0; i < result.length; ++i) {
            MolAtom memberHelper = (MolAtom)memberHelpers.get(i);
            result[((Integer)memberHelper.getProperty((String)RGROUP_MEMBER_INDEX)).intValue()] = this.countExpansionsLarge(memberHelper);
        }
        return result;
    }

    public BigInteger countRepUnitChildrenExpansionsLarge(int repunitIndex) throws ExpansionException {
        MolAtom atom;
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        if ((atom = this.getAtomFromExpansionGraph(this.mol.getSgroup(repunitIndex))) == null) {
            throw new ExpansionException("RepeatingUnit not found in expansion graph.");
        }
        return this.countChildrenExpansionsLarge(atom);
    }

    public BigInteger countChildrenExpansionsLarge(int index) throws ExpansionException {
        MolAtom atom;
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        if ((atom = this.getAtomFromExpansionGraph(index)) == null) {
            throw new ExpansionException("Atom: " + index + " not found in expansion graph.");
        }
        return this.countChildrenExpansionsLarge(atom);
    }

    private BigInteger countExpansionsLarge(MolAtom atom) {
        Object prop = atom.getProperty(MULTIPLICITY);
        if (prop instanceof BigInteger) {
            return (BigInteger)prop;
        }
        if (prop != null) {
            return BigInteger.valueOf((Long)prop);
        }
        BigInteger multiplicity = BigInteger.ONE;
        if (atom.getSetSeq() == 4) {
            multiplicity = this.countMultiBondExpansionsLarge(atom);
        } else {
            multiplicity = this.countChildrenExpansionsLarge(atom);
            RepeatingUnitSgroup repeatingUnit = (RepeatingUnitSgroup)atom.getProperty("REPEATINGUNIT");
            if (repeatingUnit != null) {
                int x = repeatingUnit.findCrossingBonds().length;
                if (x > 1 && x <= 4) {
                    IntRange range = new IntRange(repeatingUnit.getSubscript());
                    range.setMaxCount(10);
                    multiplicity = ExpansionCounter.countRepeatingUnitMultiplicityLarge(multiplicity, range);
                }
            } else if (atom.containsPropertyKey(MINREP)) {
                int minrep = (Integer)atom.getProperty(MINREP);
                int maxrep = (Integer)atom.getProperty(MAXREP);
                multiplicity = ExpansionCounter.countLinkNodeMultiplicityLarge(multiplicity, minrep, maxrep);
            }
        }
        atom.putProperty(MULTIPLICITY, multiplicity);
        atom.setExtraLabel(atom.getExtraLabel() + " M: " + multiplicity);
        return multiplicity;
    }

    private BigInteger countChildrenExpansionsLarge(MolAtom atom) {
        BigInteger s = BigInteger.ZERO;
        BigInteger m = atom.getAtno() == 128 ? BigInteger.valueOf(atom.getList().length) : BigInteger.ONE;
        for (int j = atom.getBondCount() - 1; j >= 0; --j) {
            MolBond bond = atom.getBond(j);
            if (bond.getAtom1() != atom) continue;
            BigInteger c = this.countExpansionsLarge(bond.getAtom2());
            if (bond.getSetSeq() == 1) {
                s = s.add(c);
                continue;
            }
            m = m.multiply(c);
        }
        if (s.equals(BigInteger.ZERO)) {
            return m;
        }
        return s.multiply(m);
    }

    private BigInteger countMultiBondExpansionsLarge(MolAtom atom) {
        return BigInteger.valueOf(this.countMultiBondExpansions(atom));
    }

    private static BigInteger countLinkNodeMultiplicityLarge(BigInteger multiplicity, int minrep, int maxrep) {
        if (multiplicity.equals(BigInteger.ONE)) {
            return BigInteger.valueOf(maxrep - minrep + 1);
        }
        BigInteger m1 = multiplicity.pow(maxrep + 1);
        BigInteger m2 = multiplicity.pow(minrep);
        return m1.subtract(m2).divide(multiplicity.subtract(BigInteger.ONE));
    }

    private static BigInteger countRepeatingUnitMultiplicityLarge(BigInteger multiplicity, IntRange range) {
        if (multiplicity.equals(BigInteger.ONE)) {
            return BigInteger.valueOf(range.size());
        }
        BigInteger sum = BigInteger.ZERO;
        while (range.hasNext()) {
            int n = range.next();
            sum = sum.add(multiplicity.pow(n));
        }
        return sum;
    }

    public long countExpansions() throws ExpansionException, ArithmeticOverflowException {
        if (this.expansionGraph == null) {
            this.createExpansionGraph();
        }
        return this.countExpansions(this.expansionRoot);
    }

    private long countExpansions(MolAtom atom) {
        Object prop = atom.getProperty(MULTIPLICITY);
        if (prop instanceof BigInteger) {
            throw new ArithmeticOverflowException(">= 2^63 (Arithmetic overflow)");
        }
        if (prop != null) {
            return (Long)prop;
        }
        long multiplicity = 1L;
        if (atom.getSetSeq() == 4) {
            multiplicity = this.countMultiBondExpansions(atom);
        } else {
            multiplicity = this.countChildrenExpansions(atom);
            RepeatingUnitSgroup repeatingUnit = (RepeatingUnitSgroup)atom.getProperty("REPEATINGUNIT");
            if (repeatingUnit != null) {
                int x = repeatingUnit.findCrossingBonds().length;
                if (x > 1 && x <= 4) {
                    IntRange range = new IntRange(repeatingUnit.getSubscript());
                    range.setMaxCount(10);
                    multiplicity = ExpansionCounter.countRepeatingUnitMultiplicity(multiplicity, range);
                }
            } else if (atom.containsPropertyKey(MINREP)) {
                int minrep = (Integer)atom.getProperty(MINREP);
                int maxrep = (Integer)atom.getProperty(MAXREP);
                multiplicity = ExpansionCounter.countLinkNodeMultiplicity(multiplicity, minrep, maxrep);
            }
        }
        atom.putProperty(MULTIPLICITY, new Long(multiplicity));
        atom.setExtraLabel(atom.getExtraLabel() + " M: " + multiplicity);
        return multiplicity;
    }

    private long countChildrenExpansions(MolAtom atom) {
        long s = 0L;
        long m = atom.getAtno() == 128 ? (long)atom.getList().length : 1L;
        for (int j = atom.getBondCount() - 1; j >= 0; --j) {
            MolBond bond = atom.getBond(j);
            if (bond.getAtom1() != atom) continue;
            long c = this.countExpansions(bond.getAtom2());
            if (bond.getSetSeq() == 1) {
                ExpansionCounter.checkAddition(s, c);
                s += c;
                continue;
            }
            ExpansionCounter.checkMultiplication(m, c);
            m *= c;
        }
        long multiplicity = m;
        if (s != 0L) {
            ExpansionCounter.checkMultiplication(s, m);
            multiplicity *= s;
        }
        return multiplicity;
    }

    private long countMultiBondExpansions(MolAtom atom) {
        MultiBond multiBond = (MultiBond)atom.getProperty(MULTIBOND);
        return multiBond.countMultiplicity();
    }

    private static long countLinkNodeMultiplicity(long multiplicity, int minrep, int maxrep) {
        if (multiplicity == 1L) {
            return maxrep - minrep + 1;
        }
        long m1 = multiplicity;
        for (int j = 0; j < maxrep; ++j) {
            ExpansionCounter.checkMultiplication(m1, multiplicity);
            m1 *= multiplicity;
        }
        long m2 = multiplicity;
        for (int j = 1; j < minrep; ++j) {
            m2 *= multiplicity;
        }
        return (m1 - m2) / (multiplicity - 1L);
    }

    private static long countRepeatingUnitMultiplicity(long multiplicity, IntRange range) {
        if (multiplicity == 1L) {
            return range.size();
        }
        long sum = 0L;
        long m = 1L;
        int p = 0;
        while (range.hasNext()) {
            int n = range.next();
            for (int j = p; j < n; ++j) {
                ExpansionCounter.checkMultiplication(m, multiplicity);
                m *= multiplicity;
            }
            ExpansionCounter.checkAddition(sum, m);
            sum += m;
            p = n;
        }
        return sum;
    }

    private static void checkAddition(long a, long b) throws ArithmeticOverflowException {
        if (b > Long.MAX_VALUE - a) {
            throw new ArithmeticOverflowException(">= 2^63 (Arithmetic overflow: " + a + " + " + b + ")");
        }
    }

    private static void checkMultiplication(long a, long b) throws ArithmeticOverflowException {
        if (a != 0L && b > Long.MAX_VALUE / a) {
            throw new ArithmeticOverflowException(">= 2^63 (Arithmetic overflow: " + a + " * " + b + ")");
        }
    }

    @Override
    public MoleculeGraph createExpansionGraph() throws ExpansionException {
        this.checkLicense();
        this.createExpansionGraph0();
        this.removeIndirectDependencies();
        return this.expansionGraph;
    }

    private void createExpansionGraph0() throws ExpansionException {
        int i;
        MoleculeGraph graph = super.createExpansionGraph();
        this.expansionGraph = new Molecule();
        this.expansionGraph.setValenceCheckEnabled(false);
        int count = graph.getAtomCount();
        for (i = 0; i < count; ++i) {
            MolAtom atom = graph.getAtom(i);
            MolAtom newatom = (MolAtom)atom.clone();
            if (this.expansionRoot == atom) {
                this.expansionRoot = newatom;
            } else if (newatom.isLinkNode()) {
                int minrep = newatom.getMinRepetitions();
                int maxrep = newatom.getMaxRepetitions();
                newatom.setSetSeq(5);
                newatom.setLinkNodeOuterAtom(0, -1);
                newatom.setLinkNodeOuterAtom(1, -1);
                newatom.setMaxRepetitions(1);
                newatom.putProperty(MINREP, minrep);
                newatom.putProperty(MAXREP, maxrep);
                newatom.putProperty(ORIGINDEX, this.mol.indexOf(atom));
                newatom.setExtraLabel("link: " + minrep + " - " + maxrep);
            } else if (newatom.getAtno() == 134) {
                newatom.putProperty(ORIGINDEX, this.mol.indexOf(atom));
            } else if (newatom.getSetSeq() == 4) {
                MultiBond multiBond = (MultiBond)newatom.getProperty(MULTIBOND);
                multiBond.setHelper(newatom);
            }
            this.expansionGraph.add(newatom);
        }
        for (i = graph.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = graph.getBond(i);
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            MolAtom newatom1 = this.expansionGraph.getAtom(graph.indexOf(atom1));
            MolAtom newatom2 = this.expansionGraph.getAtom(graph.indexOf(atom2));
            this.expansionGraph.add(bond.cloneBond(newatom1, newatom2));
        }
        this.expansionSequence = this.findExpansionSequence(this.expansionGraph, this.expansionGraph);
    }

    private void removeIndirectDependencies() {
        ArrayList<MolBond> list = new ArrayList<MolBond>();
        for (int i = 0; i < this.expansionSequence.length; ++i) {
            MolBond bond;
            int j;
            MolAtom atom = this.expansionGraph.getAtom(this.expansionSequence[i]);
            int depth = -1;
            for (j = atom.getBondCount() - 1; j >= 0; --j) {
                bond = atom.getBond(j);
                if (bond.getAtom2() != atom) continue;
                MolAtom atom1 = bond.getAtom1();
                int depth1 = (Integer)atom1.getProperty(DEPTH);
                depth = Math.max(depth1, depth);
                if (bond.getSetSeq() == 1) continue;
                list.add(bond);
            }
            for (j = list.size() - 1; j >= 0; --j) {
                bond = (MolBond)list.get(j);
                if ((Integer)bond.getAtom1().getProperty(DEPTH) >= depth) continue;
                this.expansionGraph.removeBond(bond);
            }
            list.clear();
            atom.putProperty(DEPTH, depth + 1);
            atom.setExtraLabel(atom.getExtraLabel() + "  D:" + (depth + 1));
        }
    }

    @Override
    protected boolean areBondsIncluded() {
        return true;
    }

    @Override
    protected void initExpansionGraph(MoleculeGraph graph) throws ExpansionException {
        int i;
        super.initExpansionGraph(graph);
        MolAtom root = ExpansionCounter.createHelperAtom(3);
        root.setExtraLabel("root");
        this.expansionRoot = root;
        graph.add(root);
        for (int i2 = this.mol.getAtomCount() - 1; i2 >= 0; --i2) {
            MolAtom depatom = this.mol.getAtom(i2);
            if (!this.isExpandable(depatom)) continue;
            ExpansionCounter.connect(graph, root, depatom);
        }
        Molecule parent = this.mol instanceof RgMolecule ? ((RgMolecule)this.mol).getRoot() : this.mol;
        for (i = this.mol.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = this.mol.getSgroup(i);
            if (!(sgroup instanceof RepeatingUnitSgroup) || sgroup.getParentMolecule() != parent || !this.isExpandable((RepeatingUnitSgroup)sgroup)) continue;
            MolAtom helper = (MolAtom)this.helperTable.get(sgroup);
            ExpansionCounter.connect(graph, root, helper);
        }
        for (i = this.mol.getBondCount() - 1; i >= 0; --i) {
            MolBond bond = this.mol.getBond(i);
            if (!this.isExpandable(bond)) continue;
            this.addBondListExpansion(graph, root, bond);
        }
        this.multiBonds = this.createMultiBonds(graph);
        for (i = 0; i < this.multiBonds.length; ++i) {
            this.addMultiBondExpansion(graph, root, this.multiBonds[i]);
        }
    }

    @Override
    protected void addRgroupMemberExpansion(MoleculeGraph graph, MolAtom atom, Molecule rgroup, int index) {
        MolAtom helper = (MolAtom)this.helperTable.get(rgroup);
        if (helper == null) {
            helper = ExpansionCounter.createHelperAtom(1);
            helper.setExtraLabel("rgroup");
            helper.putProperty(RGROUP_MEMBER_INDEX, index);
            graph.add(helper);
            this.helperTable.put(rgroup, helper);
            super.addRgroupMemberExpansion(graph, helper, rgroup, index);
        }
        ExpansionCounter.connect(graph, atom, helper, 1);
    }

    @Override
    protected void addBondListExpansion(MoleculeGraph graph, MolAtom atom, MolBond bond) {
        ExpansionCounter.connect(graph, atom, this.getBondHelper(bond, graph));
    }

    private MolAtom getBondHelper(MolBond bond, MoleculeGraph graph) {
        MolAtom helper = (MolAtom)this.helperTable.get(bond);
        if (helper == null) {
            helper = ExpansionCounter.createHelperAtom(2);
            int length = this.getBondTypes(bond).length;
            helper.putProperty(MULTIPLICITY, new Long(length));
            helper.setExtraLabel("bond: " + length);
            graph.add(helper);
            this.helperTable.put(bond, helper);
        }
        return helper;
    }

    protected void addMultiBondExpansion(MoleculeGraph graph, MolAtom atom, MultiBond multiBond) {
        MolAtom helper = ExpansionCounter.createHelperAtom(4);
        helper.putProperty(MULTIBOND, multiBond);
        graph.add(helper);
        ExpansionCounter.connect(graph, atom, helper);
        multiBond.setHelper(helper);
    }

    @Override
    protected void addMultiBondExpansion(MoleculeGraph graph, MolAtom atom, MolBond depbond) {
        ExpansionCounter.connect(graph, atom, this.getMultiBond((MolBond)depbond).helper);
    }

    private MultiBond getMultiBond(MolBond sourceBond) {
        for (int i = 0; i < this.multiBonds.length; ++i) {
            if (this.multiBonds[i].sourceBond != sourceBond) continue;
            return this.multiBonds[i];
        }
        return null;
    }

    private MolAtom getAtomFromExpansionGraph(int index) {
        for (int i = this.expansionGraph.getAtomCount() - 1; i >= 0; --i) {
            int origIndex;
            MolAtom atom = this.expansionGraph.getAtom(i);
            int n = origIndex = atom.containsPropertyKey(ORIGINDEX) ? (Integer)atom.getProperty(ORIGINDEX) : -1;
            if (origIndex != index) continue;
            return atom;
        }
        return null;
    }

    private MolAtom getAtomFromExpansionGraph(Sgroup repeatingUnit) {
        for (int i = this.expansionGraph.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = this.expansionGraph.getAtom(i);
            if (atom.getProperty("REPEATINGUNIT") != repeatingUnit) continue;
            return atom;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ExpansionCounter ec = new ExpansionCounter();
        MolExporter exporter = new MolExporter(System.out, "mrv");
        MolImporter importer = new MolImporter(args[0]);
        Molecule mol = null;
        while ((mol = importer.read()) != null) {
            ec.setMolecule(mol);
            Molecule graph = (Molecule)ec.createExpansionGraph();
            String count = ec.countExpansionsString();
            graph.setProperty("COUNT", "" + count);
            exporter.write(graph);
        }
        importer.close();
        exporter.close();
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Markush Enumeration Plugin", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Markush Enumeration Plugin", this.licenseEnvironment);
    }

    int[] getBondTypes(MolBond bond) {
        int t = bond.getType();
        if (this.anyQueryBond && t == 0) {
            return new int[]{1, 2, 3, 4, 9};
        }
        return BOND_TYPES[t];
    }

    public void setEnumerateHomology(boolean enumHomology2) {
        this.enumHomology = enumHomology2;
    }

    private class MultiBond {
        int[] atomIndexes1 = null;
        int[] atomIndexes2 = null;
        MolBond sourceBond = null;
        MolAtom helper = null;
        MolAtom parent = null;
        boolean approx = false;

        MultiBond(MulticenterSgroup sourceSgroup1, MolAtom atom2, MolBond sourceBond, MoleculeGraph graph) throws ExpansionException {
            this(sourceSgroup1.getAtomArray(), new MolAtom[]{atom2}, sourceBond, graph);
        }

        MultiBond(MulticenterSgroup sourceSgroup1, MulticenterSgroup sourceSgroup2, MolBond sourceBond, MoleculeGraph graph) throws ExpansionException {
            this(sourceSgroup1.getAtomArray(), sourceSgroup2.getAtomArray(), sourceBond, graph);
        }

        MultiBond(MolAtom[] atoms1, MolAtom[] atoms2, MolBond sourceBond, MoleculeGraph graph) throws ExpansionException {
            this.checkAtoms(atoms1);
            this.checkAtoms(atoms2);
            this.checkBond(sourceBond);
            this.sourceBond = sourceBond;
            this.atomIndexes1 = this.getAtomIndexes(atoms1, graph);
            this.atomIndexes2 = this.getAtomIndexes(atoms2, graph);
        }

        private void checkAtoms(MolAtom[] atoms) throws ExpansionException {
            if (atoms.length > 1) {
                for (int i = 0; i < atoms.length; ++i) {
                    this.checkAtom(atoms[i]);
                }
            }
        }

        private void checkAtom(MolAtom atom) throws ExpansionException {
            if (atom.getAtno() == 134 && ExpansionCounter.this.rgmol != null && ExpansionCounter.this.rgmol.findRgroupIndex(atom.getRgroup()) != -1) {
                throw new ExpansionException("R-atom (union atom: " + (ExpansionCounter.this.union.indexOf(atom) + 1) + ") in multicenter is not allowed.");
            }
        }

        private void checkBond(MolBond bond) throws ExpansionException {
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            Molecule parent = (Molecule)atom1.getParent();
            int atomIndex1 = parent.indexOf(atom1);
            int atomIndex2 = parent.indexOf(atom2);
            int bondIndex = parent.indexOf(bond);
            Molecule parentClone = parent.cloneMolecule();
            parentClone.removeBond(bondIndex);
            for (int i = parentClone.getSgroupCount() - 1; i >= 0; --i) {
                Sgroup sg = parentClone.getSgroup(i);
                if (sg instanceof MulticenterSgroup) continue;
                parentClone.ungroupSgroup(sg, 0);
            }
            int[] fragIds = parentClone.getFragIds(1);
            if (fragIds[atomIndex1] == fragIds[atomIndex2]) {
                throw new ExpansionException("Position variation / coordinate bond connects atoms in same fragment. Atoms: " + (ExpansionCounter.this.mol.indexOf(atom1) + 1) + ", " + (ExpansionCounter.this.mol.indexOf(atom2) + 1));
            }
        }

        private int[] getAtomIndexes(MolAtom[] atoms, MoleculeGraph graph) {
            int[] indexes = new int[atoms.length];
            for (int i = 0; i < atoms.length; ++i) {
                indexes[i] = graph.indexOf(atoms[i]);
            }
            return indexes;
        }

        void setHelper(MolAtom helper) {
            this.helper = helper;
        }

        long countMultiplicity() {
            this.parent = this.helper.getLigand(0);
            long a1 = this.countAtoms(this.atomIndexes1);
            long a2 = this.countAtoms(this.atomIndexes2);
            this.approx = a1 > (long)this.atomIndexes1.length || a2 > (long)this.atomIndexes2.length;
            this.helper.setExtraLabel("multiBond: " + a1 + "x" + a2);
            return a1 * a2;
        }

        private long countAtoms(int[] atomIndexes) {
            long count = 0L;
            int rgindex = -1;
            for (int i = 0; i < atomIndexes.length; ++i) {
                int minrep;
                if (atomIndexes[i] == -1) {
                    ++count;
                    continue;
                }
                MolAtom atom = ExpansionCounter.this.expansionGraph.getAtom(atomIndexes[i]);
                int n = minrep = atom.containsPropertyKey(ExpansionCounter.MINREP) ? (Integer)atom.getProperty(ExpansionCounter.MINREP) : -1;
                if (atom != this.parent && minrep != -1) {
                    int maxrep = (Integer)atom.getProperty(ExpansionCounter.MAXREP);
                    count += (long)maxrep;
                    continue;
                }
                ++count;
            }
            return count;
        }
    }

    public static class ArithmeticOverflowException
    extends ArithmeticException {
        public ArithmeticOverflowException() {
        }

        public ArithmeticOverflowException(String message) {
            super(message);
        }
    }
}

