/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.ExpansionException;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;

public class ExpansionHelper {
    protected static final int[][] BOND_TYPES = ExpansionUtil.BOND_TYPES;
    protected static final String REPEATINGUNIT = "REPEATINGUNIT";
    protected static final int HELPER_ROOT = 3;
    protected static final int HELPER_BOND = 2;
    protected static final int HELPER_RGROUP = 1;
    protected static final int HELPER_LINKNODE = 5;
    protected static final int HELPER_MULTIBOND = 4;
    protected static final int HELPER_REPEATINGUNIT = 6;
    protected Hashtable helperTable = new Hashtable();
    protected Molecule mol = null;
    protected MoleculeGraph union = null;
    protected RgMolecule rgmol = null;
    protected MulticenterSgroup[] multicenterSgroups = null;
    private MoleculeGraph orderGraph = null;
    private MolAtom orderAtom = null;
    private MolAtom orderOuter0Atom = null;
    private MolAtom orderOuter1Atom = null;
    private HashSet orderVisited = null;

    public ExpansionHelper() {
    }

    public ExpansionHelper(Molecule mol) {
        this.setMolecule(mol);
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
        this.union = mol.getGraphUnion();
        this.rgmol = mol instanceof RgMolecule ? (RgMolecule)mol : null;
        this.multicenterSgroups = ExpansionUtil.getMulticenterSgroups(mol);
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    protected boolean areBondsIncluded() {
        return false;
    }

    public int[] findExpansionSequence() throws ExpansionException {
        MoleculeGraph graph = this.createExpansionGraph();
        return this.findExpansionSequence(graph, this.union);
    }

    public int[] findExpansionSequence(MoleculeGraph graph, MoleculeGraph imol) throws ExpansionException {
        int count = graph.getAtomCount();
        int[] predCounts = new int[count];
        IntVector[] successors = new IntVector[count];
        for (int i = graph.getBondCount() - 1; i >= 0; --i) {
            MolBond edge = graph.getBond(i);
            int a1 = graph.indexOf(edge.getAtom1());
            int a2 = graph.indexOf(edge.getAtom2());
            if (successors[a1] == null) {
                successors[a1] = new IntVector();
            }
            successors[a1].addElement(a2);
            int n = a2;
            predCounts[n] = predCounts[n] + 1;
        }
        int[] sequence = new int[count];
        int k = 0;
        while (k < count) {
            int p = k;
            for (int i = 0; i < count; ++i) {
                if (predCounts[i] != 0) continue;
                int index = imol.indexOf(graph.getAtom(i));
                if (index == -1) {
                    RepeatingUnitSgroup sgroup = (RepeatingUnitSgroup)graph.getAtom(i).getProperty(REPEATINGUNIT);
                    index = ExpansionHelper.getSgroupIndex(sgroup, this.mol);
                    assert (index != -1);
                    index += imol.getAtomCount();
                }
                sequence[k++] = index;
                if (k == count) break;
                if (successors[i] != null) {
                    for (int j = successors[i].size() - 1; j >= 0; --j) {
                        int n = successors[i].elementAt(j);
                        predCounts[n] = predCounts[n] - 1;
                    }
                }
                predCounts[i] = -1;
            }
            if (p != k) continue;
            MolAtom[] cycle = ExpansionHelper.findCycle(graph, predCounts, successors);
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < cycle.length; ++i) {
                b.append(" " + (imol.indexOf(cycle[i]) + 1));
            }
            throw new ExpansionException("Circular dependency in order graph.\nCycle atom indexes:" + new String(b));
        }
        return sequence;
    }

    private static MolAtom[] findCycle(MoleculeGraph graph, int[] predCounts, IntVector[] successors) {
        int i;
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        int k = -1;
        for (i = 0; i < predCounts.length; ++i) {
            if (predCounts[i] <= 0) continue;
            k = i;
            break;
        }
        list.add(graph.getAtom(k));
        for (i = 0; i < predCounts.length; ++i) {
            if (predCounts[i] <= 0 || successors[i] == null || !successors[i].contains(k)) continue;
            k = i;
            MolAtom atom = graph.getAtom(k);
            if (list.contains(atom)) {
                MolAtom[] cycle = new MolAtom[list.size()];
                for (int j = 0; j < cycle.length; ++j) {
                    cycle[j] = (MolAtom)list.get(cycle.length - 1 - j);
                }
                return cycle;
            }
            list.add(atom);
            i = -1;
        }
        return null;
    }

    private static int getSgroupIndex(Sgroup sgroup, Molecule mol) {
        for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
            if (mol.getSgroup(i) != sgroup) continue;
            return i;
        }
        return -1;
    }

    public MoleculeGraph createExpansionGraph() throws ExpansionException {
        SelectionMolecule graph = new SelectionMolecule();
        graph.setValenceCheckEnabled(false);
        this.initExpansionGraph(graph);
        int count = graph.getAtomCount();
        for (int i = 0; i < count; ++i) {
            MolAtom atom = graph.getAtom(i);
            if (atom.containsPropertyKey(REPEATINGUNIT)) {
                this.addRepeatingUnitExpansion(graph, atom);
                continue;
            }
            if (atom.isLinkNode()) {
                this.addLinkNodeExpansion(graph, atom);
            }
            if (atom.getAtno() != 134 || this.rgmol == null) continue;
            this.addRgroupExpansion(graph, atom);
        }
        this.finishExpansionGraph(graph);
        return graph;
    }

    protected void initExpansionGraph(MoleculeGraph graph) throws ExpansionException {
        int i;
        int count = this.union.getAtomCount();
        for (i = 0; i < count; ++i) {
            MolAtom atom = this.union.getAtom(i);
            if (!this.isExpandable(atom)) continue;
            graph.add(atom);
        }
        count = this.mol.getSgroupCount();
        for (i = 0; i < count; ++i) {
            Sgroup sgroup = this.mol.getSgroup(i);
            if (!(sgroup instanceof RepeatingUnitSgroup) || !this.isExpandable((RepeatingUnitSgroup)sgroup)) continue;
            MolAtom helper = ExpansionHelper.createHelperAtom(6);
            helper.putProperty(REPEATINGUNIT, sgroup);
            helper.setExtraLabel("sgroup: " + i);
            graph.add(helper);
            this.helperTable.put(sgroup, helper);
            for (int j = sgroup.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = sgroup.getAtom(j);
                MolAtom sgHelper = (MolAtom)this.helperTable.get(atom);
                if (sgHelper != null) {
                    Sgroup outer = (Sgroup)sgHelper.getProperty(REPEATINGUNIT);
                    if (outer.getAtomCount() <= sgroup.getAtomCount()) continue;
                    this.helperTable.put(atom, helper);
                    continue;
                }
                this.helperTable.put(atom, helper);
            }
        }
    }

    private static Sgroup getOuterRepeatingUnit(Sgroup sgroup, Containment type) {
        Sgroup outer = null;
        Sgroup parent = sgroup;
        do {
            if (!(parent instanceof RepeatingUnitSgroup)) continue;
            outer = parent;
            if (type == Containment.SMALLEST) {
                return outer;
            }
            if (type != Containment.WRAPPER || outer == sgroup) continue;
            return outer;
        } while ((parent = parent.getParentSgroup()) != null);
        return type == Containment.WRAPPER ? null : outer;
    }

    protected void finishExpansionGraph(MoleculeGraph graph) {
        this.helperTable.clear();
    }

    protected void setApproximateCount(boolean approx) {
    }

    protected void addRepeatingUnitExpansion(MoleculeGraph graph, MolAtom atom) throws ExpansionException {
        Sgroup sgroup = (Sgroup)atom.getProperty(REPEATINGUNIT);
        if (this.areBondsIncluded()) {
            MolBond[] xbonds = sgroup.findCrossingBonds();
            for (int i = 0; i < xbonds.length; ++i) {
                if (!this.isExpandable(xbonds[i])) continue;
                this.addBondListExpansion(graph, atom, xbonds[i]);
                this.setApproximateCount(true);
            }
            SelectionMolecule sgroupGraph = sgroup.getSgroupGraph();
            for (int i = sgroupGraph.getBondCount() - 1; i >= 0; --i) {
                MolBond bond = sgroupGraph.getBond(i);
                if (this.isExpandable(bond)) {
                    this.addBondListExpansion(graph, atom, bond);
                }
                if (!this.isExpandableMultiBond(bond)) continue;
                this.addMultiBondExpansion(graph, atom, bond);
            }
        }
        for (int i = sgroup.getAtomCount() - 1; i >= 0; --i) {
            MolAtom sgatom = sgroup.getAtom(i);
            if (!this.isExpandable(sgatom)) continue;
            ExpansionHelper.connect(graph, atom, sgatom, 6);
        }
        Sgroup outer = ExpansionHelper.getOuterRepeatingUnit(sgroup, Containment.SMALLEST);
        if (outer != sgroup) {
            ExpansionHelper.connect(graph, (MolAtom)this.helperTable.get(outer), (MolAtom)this.helperTable.get(sgroup));
        }
    }

    protected void addLinkNodeExpansion(MoleculeGraph graph, MolAtom atom) throws ExpansionException {
        MolAtom outer1Atom;
        int idx0 = atom.getLinkNodeOuterAtom(0);
        int idx1 = atom.getLinkNodeOuterAtom(1);
        MolBond outer0Bond = idx0 != -1 ? atom.getBond(idx0) : null;
        MolBond outer1Bond = idx1 != -1 ? atom.getBond(idx1) : null;
        MolAtom outer0Atom = idx0 != -1 ? outer0Bond.getOtherAtom(atom) : null;
        MolAtom molAtom = outer1Atom = idx1 != -1 ? outer1Bond.getOtherAtom(atom) : null;
        if (this.areBondsIncluded()) {
            MolBond linkerBond = outer0Bond;
            if (linkerBond == null || outer1Bond != null && linkerBond.getType() > outer1Bond.getType()) {
                linkerBond = outer1Bond;
            }
            if (linkerBond != null && this.isExpandable(linkerBond)) {
                this.addBondListExpansion(graph, atom, linkerBond);
            }
        }
        this.orderGraph = graph;
        this.orderAtom = atom;
        this.orderOuter0Atom = outer0Atom;
        this.orderOuter1Atom = outer1Atom;
        if (this.orderVisited == null) {
            this.orderVisited = new HashSet();
        }
        if (MolImportUtil.countAttachments(atom) != 0) {
            throw new ExpansionException("R-group attachment point within link node fragment.\nUnion atom indexes:\nlink node: " + (this.union.indexOf(atom) + 1) + "\n" + "R-group attachment point: " + (this.union.indexOf(atom) + 1));
        }
        this.orderVisited.add(atom);
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            if (ligand == this.orderOuter0Atom || ligand == this.orderOuter1Atom) continue;
            this.addExpansion(ligand, atom.getBond(i));
        }
        this.orderVisited.clear();
    }

    private void addLinkNodeExpansion(MolAtom atom) throws ExpansionException {
        MolAtom sgroupHelper;
        int i;
        if (MolImportUtil.countAttachments(atom) != 0) {
            throw new ExpansionException("R-group attachment point within link node fragment.\nUnion atom indexes:\nlink node: " + (this.union.indexOf(this.orderAtom) + 1) + "\n" + "R-group attachment point: " + (this.union.indexOf(atom) + 1));
        }
        this.orderVisited.add(atom);
        for (int i2 = atom.getBondCount() - 1; i2 >= 0; --i2) {
            MolAtom ligand = atom.getLigand(i2);
            if (ligand != this.orderOuter0Atom && ligand != this.orderOuter1Atom) {
                if (this.orderVisited.contains(ligand)) continue;
                this.addExpansion(ligand, atom.getBond(i2));
                continue;
            }
            throw new ExpansionException("Circular dependency for link node.\nUnion atom index: " + (this.union.indexOf(this.orderAtom) + 1));
        }
        if (atom.getAtno() == 137) {
            Sgroup sg = this.getMulticenterSgroup(atom);
            for (i = sg.getAtomCount() - 1; i >= 0; --i) {
                this.addExpansion(sg.getAtom(i));
            }
        } else {
            MolAtom[] multicenters = this.getMulticenters(atom);
            for (i = 0; i < multicenters.length; ++i) {
                this.addExpansion(multicenters[i]);
            }
        }
        if ((sgroupHelper = (MolAtom)this.helperTable.get(atom)) != null) {
            Sgroup sgroup = (Sgroup)sgroupHelper.getProperty(REPEATINGUNIT);
            MolAtom helper = null;
            while (!sgroup.getSgroupGraph().contains(this.orderOuter0Atom) && !sgroup.getSgroupGraph().contains(this.orderOuter1Atom)) {
                helper = (MolAtom)this.helperTable.get(sgroup);
                if ((sgroup = ExpansionHelper.getOuterRepeatingUnit(sgroup, Containment.WRAPPER)) != null) continue;
            }
            if (helper != null) {
                this.addExpansion(helper);
            }
        }
    }

    private void addExpansion(MolAtom ligand) throws ExpansionException {
        if (ligand != this.orderOuter0Atom && ligand != this.orderOuter1Atom) {
            if (!this.orderVisited.contains(ligand)) {
                if (this.isExpandable(ligand)) {
                    ExpansionHelper.connect(this.orderGraph, this.orderAtom, ligand);
                }
                this.addLinkNodeExpansion(ligand);
            }
        } else {
            throw new ExpansionException("Circular dependency for link node.\nUnion atom index: " + (this.union.indexOf(this.orderAtom) + 1));
        }
    }

    private void addExpansion(MolAtom ligand, MolBond bond) throws ExpansionException {
        if (this.isExpandable(ligand)) {
            ExpansionHelper.connect(this.orderGraph, this.orderAtom, ligand);
        }
        if (this.areBondsIncluded()) {
            if (this.isExpandable(bond)) {
                this.addBondListExpansion(this.orderGraph, this.orderAtom, bond);
            }
            if (this.isExpandableMultiBond(bond)) {
                this.addMultiBondExpansion(this.orderGraph, this.orderAtom, bond);
            }
        }
        this.addLinkNodeExpansion(ligand);
    }

    private void addRgroupExpansion(MoleculeGraph graph, MolAtom atom) throws ExpansionException {
        int rgindex = this.rgmol.findRgroupIndex(atom.getRgroup());
        if (rgindex != -1) {
            for (int i = this.rgmol.getRgroupMemberCount(rgindex) - 1; i >= 0; --i) {
                int outerCount;
                Molecule rgroup = this.rgmol.getRgroupMember(rgindex, i);
                int innerCount = ExpansionUtil.countAttachments(rgroup);
                if (rgroup.getAtomCount() - innerCount > 1 && (outerCount = atom.getBondCount()) != 0) {
                    if (innerCount == 0) {
                        throw new ExpansionException("No R-group attachment point for atom: R" + atom.getRgroup());
                    }
                    if (innerCount < outerCount) {
                        throw new ExpansionException("Inconsistent R-group attachment data for atom: R" + atom.getRgroup() + " innerCount=" + innerCount + " outerCount=" + outerCount);
                    }
                }
                if (atom.getBondCount() != 0 && rgroup.getAtomCount() > 1 && ExpansionUtil.countAttachments(rgroup) == 0) {
                    throw new ExpansionException("No R-group attachment point for atom: R" + atom.getRgroup());
                }
                this.addRgroupMemberExpansion(graph, atom, rgroup, i);
            }
        }
    }

    protected void addRgroupMemberExpansion(MoleculeGraph graph, MolAtom atom, Molecule rgroup, int index) {
        int i;
        for (i = rgroup.getAtomCount() - 1; i >= 0; --i) {
            MolAtom depatom = rgroup.getAtom(i);
            if (!this.isExpandable(depatom)) continue;
            ExpansionHelper.connect(graph, atom, depatom);
        }
        for (i = rgroup.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sgroup = rgroup.getSgroup(i);
            MolAtom sgroupHelper = (MolAtom)this.helperTable.get(sgroup);
            if (sgroupHelper == null) continue;
            ExpansionHelper.connect(graph, atom, sgroupHelper);
        }
        if (this.areBondsIncluded()) {
            for (i = rgroup.getBondCount() - 1; i >= 0; --i) {
                MolBond depbond = rgroup.getBond(i);
                if (this.isExpandable(depbond)) {
                    this.addBondListExpansion(graph, atom, depbond);
                }
                if (!this.isExpandableMultiBond(depbond)) continue;
                this.addMultiBondExpansion(graph, atom, depbond);
            }
        }
    }

    protected void addBondListExpansion(MoleculeGraph graph, MolAtom atom, MolBond bond) {
    }

    protected void addMultiBondExpansion(MoleculeGraph graph, MolAtom atom, MolBond bond) {
    }

    protected static void connect(MoleculeGraph graph, MolAtom atom, MolAtom depatom) {
        graph.add(new MolBond(atom, depatom));
    }

    protected static void connect(MoleculeGraph graph, MolAtom atom, MolAtom depatom, int set) {
        MolBond b = new MolBond(atom, depatom);
        b.setSetSeq(set);
        graph.add(b);
    }

    public boolean isExpandable(MolAtom atom) {
        int atno = atom.getAtno();
        return atno == 134 && this.rgmol != null || atno == 128 || atom.isLinkNode() || atom.containsPropertyKey(REPEATINGUNIT) || atno == 136 && (HomologyConstants.isHandledHomology(atom.getAliasstr()) || HomologyConstants.isConvertibleHomology(atom.getAliasstr()));
    }

    public boolean isExpandable(MolBond bond) {
        return bond.isQuery();
    }

    public boolean isExpandable(RepeatingUnitSgroup sgroup) {
        return !PolymerUtil.isPolymerSgroup(sgroup) && sgroup.findCrossingBonds().length <= 4;
    }

    public boolean isExpandableMultiBond(MolBond bond) {
        return bond.getType() != 9 && (bond.getAtom1().getAtno() == 137 || bond.getAtom2().getAtno() == 137);
    }

    public static MolAtom createHelperAtom() {
        return ExpansionUtil.createHelperAtom();
    }

    public static MolAtom createHelperAtom(int set) {
        return ExpansionUtil.createHelperAtom(set);
    }

    public static boolean isHelperAtom(MolAtom atom) {
        return ExpansionUtil.isHelperAtom(atom);
    }

    private Sgroup getMulticenterSgroup(MolAtom centralAtom) {
        for (int i = 0; i < this.multicenterSgroups.length; ++i) {
            if (this.multicenterSgroups[i].getCentralAtom() != centralAtom) continue;
            return this.multicenterSgroups[i];
        }
        return null;
    }

    private MolAtom[] getMulticenters(MolAtom sgroupAtom) {
        ArrayList<MolAtom> multicenters = new ArrayList<MolAtom>();
        for (int i = 0; i < this.multicenterSgroups.length; ++i) {
            if (!this.multicenterSgroups[i].getSgroupGraph().contains(sgroupAtom)) continue;
            multicenters.add(this.multicenterSgroups[i].getCentralAtom());
        }
        MolAtom[] res = new MolAtom[multicenters.size()];
        multicenters.toArray(res);
        return res;
    }

    private static enum Containment {
        SMALLEST,
        WRAPPER,
        LARGEST;

    }
}

