/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration;

import chemaxon.common.util.IntVector;
import chemaxon.enumeration.AromUtil;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.MarkushEnumeratorFactory;
import chemaxon.enumeration.MolEnumerator;
import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayUtil;
import chemaxon.util.MolFilter;
import java.awt.Color;
import java.util.Stack;
import java.util.logging.Level;

public class MarkushEnumerator
extends MolEnumerator {
    private MarkushEnumeratorFactory factory = null;
    private RgMolecule rgmol = null;
    private int features = 6201;
    private MolFilter filter = null;
    private String structureID = null;
    private boolean keepSelectionMarkers = false;
    private Stack<Molecule> mols = new Stack();
    private Stack<MolEnumerator> enumerators = new Stack();
    private IntVector enumsToGetFromBranch = new IntVector();
    private boolean afterBacktrack = false;
    private Molecule mol = null;
    private Molecule origMol = null;
    private Molecule nextMol = null;

    @Override
    public void setNumberOfRandomEnumeratesToGenerate(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The number of enumerates should be at least one");
        }
        this.numOfEnums = n;
        this.enumsToGetFromBranch.clear();
        this.enumsToGetFromBranch.add(n);
    }

    protected MarkushEnumerator() {
    }

    protected MarkushEnumerator(Molecule molP) {
        this.setMol(molP);
    }

    public void setKeepSelectionMarkers(boolean keepSelectionMarkers) {
        this.keepSelectionMarkers = keepSelectionMarkers;
    }

    public void setFilter(MolFilter filter) {
        this.filter = filter;
    }

    public MolFilter getFilter() {
        return this.filter;
    }

    @Override
    protected void setFeatures(int features) {
        this.features = features;
    }

    @Override
    public Object clone() {
        MarkushEnumerator ce = (MarkushEnumerator)super.clone();
        ce.factory = this.factory;
        ce.mol = this.mol;
        ce.mols = (Stack)this.mols.clone();
        ce.enumerators = new Stack();
        return ce;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.filter == null) {
            return this.hasMoreElements0();
        }
        if (this.nextMol == null) {
            this.nextMol = this.nextElement0();
        }
        return this.nextMol != null;
    }

    @Override
    protected boolean hasMoreElements0() {
        return !this.mols.empty();
    }

    @Override
    public Molecule nextElement() {
        Molecule m = null;
        if (this.filter == null) {
            m = this.nextElement0();
        } else if (this.nextMol == null) {
            m = this.nextElement0();
        } else {
            m = this.nextMol;
            this.nextMol = null;
        }
        return m;
    }

    private void checkRemainingHomologies(Molecule mol2) {
        if (!this.enumHomology) {
            return;
        }
        int n = mol2.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom atom = mol2.getAtom(i);
            if (!SelectionUtil.isSelected(atom) || !atom.isPseudo() || !HomologyConstants.isHomology(atom.getAliasstr())) continue;
            Object property = atom.getProperty("homology_property_enumeration_failure");
            String errorStr = property instanceof String ? (String)property : "";
            throw new IllegalArgumentException("Some homology atoms could not be enumerated. " + errorStr);
        }
    }

    private static Molecule getNextFilteredMol(MolEnumerator me, MolFilter filter) {
        Molecule m = null;
        while (m == null && me.hasMoreElements()) {
            m = me.nextElement();
            if (filter == null || filter.accept(m)) continue;
            m = null;
        }
        return m;
    }

    private void addEnumerators(boolean random) {
        Molecule m;
        Molecule lastMol;
        MolEnumerator me;
        if (logger.isLoggable(Level.FINER)) {
            this.logEnumerators();
        }
        if ((me = this.factory.getFirstEnumeratorClone(lastMol = this.mols.peek(), this.rgmol, this.features, this.licenseEnvironment)) == null) {
            return;
        }
        int enumLabel = me.getEnumeratorLabel();
        if (random) {
            logger.fine("depth : " + this.enumerators.size());
            me.setNumberOfRandomEnumeratesToGenerate(this.calcNumberOfRandomEnumeratesToGenerate());
            if (me.hasMoreElements() && enumLabel != -1 && this.rp[enumLabel] != null) {
                me.randomPossibilities = this.rp[enumLabel];
            }
        }
        if (random && enumLabel != -1 && this.rp[enumLabel] == null) {
            this.rp[enumLabel] = me.randomPossibilities;
        }
        if ((m = MarkushEnumerator.getNextFilteredMol(me, this.filter)) != null) {
            this.enumerators.push(me);
            this.mols.push(m);
            if (random) {
                this.enumsToGetFromBranch.add(me.getNumOfEnumsFromBranch() + 1);
            }
            this.addEnumerators(random);
        } else {
            if (this.hasMoreElements0()) {
                this.mols.pop();
            }
            this.step();
            if (this.hasMoreElements0()) {
                this.addEnumerators(random);
            }
        }
    }

    private int calcNumberOfRandomEnumeratesToGenerate() {
        int n = 0;
        n = this.enumerators.size() > 0 ? this.enumerators.peek().getNumOfEnumsFromBranch() + 1 : this.numOfEnums;
        if (this.afterBacktrack) {
            this.afterBacktrack = false;
            if (logger.isLoggable(Level.FINE)) {
                MarkushEnumerator.logState(this.enumerators.peek(), n);
            }
        }
        return n;
    }

    @Override
    protected Molecule nextElement0() {
        HitColoringAndAlignmentOptions options;
        if (!this.hasMoreElements0()) {
            return null;
        }
        this.addEnumerators(this.random);
        if (!this.hasMoreElements0()) {
            return null;
        }
        Molecule result = this.mols.pop();
        if (this.origNeeded) {
            result.setPropertyObject("nonEnumeratedMol", this.mol.cloneMolecule());
        }
        this.step();
        this.checkRemainingHomologies(result);
        if (MarkushEnumeratorFactory.isEnumeratedFeature(6201, this.features)) {
            this.checkLicense();
        }
        if ((options = this.getHitColoringAndAlignmentOptions()) != null) {
            result.clean(2, "t2000");
            if (this.getAlignScaffold()) {
                result = HitDisplayUtil.getScaffoldOrientatedHit(this.scaffoldSkeleton, result);
            }
            if (options.coloring) {
                HitDisplayUtil.color(this.scaffoldSkeleton, result, options);
            }
        }
        if (this.getEnumCodeNeeded()) {
            MarkushEnumerator.setEnumCode(result, this.getStructureID(this.mol));
        }
        result.setValenceCheckEnabled(true);
        result.valenceCheck();
        this.removeHelperProperties(result);
        if (this.rgmol != null) {
            result = ExpansionUtil.addRgroupDefs(result, this.rgmol);
        }
        AromUtil.finishAromatize(result);
        result.setName(null);
        MarkushEnumerator.fixBrackets(result);
        if (!this.keepSelectionMarkers) {
            SelectionUtil.select(result);
        }
        return result;
    }

    private static void setEnumCode(Molecule result, String strID) {
        String mCode = result.getProperty("Markush code");
        strID = strID != null ? (mCode != null ? strID + "(" + mCode + ")" : strID + "()") : (mCode != null ? mCode : "");
        result.setProperty("Markush code", strID);
    }

    private HitColoringAndAlignmentOptions getHitColoringAndAlignmentOptions() {
        HitColoringAndAlignmentOptions options = null;
        if (this.getAlignScaffold()) {
            options = new HitColoringAndAlignmentOptions();
            options.hitColor = Color.BLACK;
            options.alignmentMode = 1;
        }
        if (this.isScaffoldColoring() || this.isRgroupColoring()) {
            if (options == null) {
                options = new HitColoringAndAlignmentOptions();
            }
            options.coloring = true;
            if (this.isScaffoldColoring()) {
                options.hitColor = Color.RED;
                if (this.isRgroupColoring()) {
                    options.nonHitColor = Color.RED;
                }
            }
        }
        return options;
    }

    private static void fixBrackets(Molecule m) {
        for (int i = m.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = m.getSgroup(i);
            if (sg.getType() != 2) continue;
            CleanUtil.generateBracketCoords(sg, 1);
        }
    }

    private void step() {
        int size = this.enumerators.size();
        MolEnumerator lastEnum = size == 0 ? null : (MolEnumerator)this.enumerators.get(size - 1);
        Molecule m = null;
        while (size != 0 && (m = MarkushEnumerator.getNextFilteredMol(lastEnum, this.filter)) == null) {
            this.mols.pop();
            this.enumerators.pop();
            if (this.random) {
                this.enumsToGetFromBranch.removeLast();
                this.afterBacktrack = true;
            }
            if ((lastEnum = --size == 0 ? null : this.enumerators.peek()) == null || !this.random) continue;
            lastEnum.switchToTheNextBranch();
        }
        if (m != null) {
            this.mols.push(m);
        }
    }

    @Override
    public void setMol(Molecule molP) {
        this.mols.clear();
        this.enumerators.clear();
        this.enumsToGetFromBranch.clear();
        this.afterBacktrack = false;
        molP.setGUIContracted(false);
        this.origMol = molP;
        if (this.enumHomology && HomologyConstants.containsHomology(molP)) {
            HomologyConversionUtil hcu = new HomologyConversionUtil(molP, true, false, false);
            molP = hcu.getConvertedMol();
        }
        if (molP instanceof RgMolecule) {
            if (molP == this.origMol) {
                molP = molP.cloneMolecule();
            }
            AromUtil.initAromatize((RgMolecule)molP);
        }
        if (this.filter != null && !this.filter.accept(molP)) {
            return;
        }
        this.mol = molP;
        this.rgmol = this.mol instanceof RgMolecule ? (RgMolecule)this.mol : null;
        Molecule m = this.rgmol != null ? this.rgmol.getRoot() : this.mol;
        this.mols.push(m);
        int n = 0;
        if (this.mol instanceof RgMolecule) {
            n = ((RgMolecule)this.mol).getRgroupCount();
            if (this.isRgroupColoring()) {
                this.prepareRgroupsForColoring();
            }
        }
        this.nextLinkNode = n;
        if (this.isRandom()) {
            n = this.labellingLinkNodes(n);
        }
        if (n > 0) {
            this.rp = new double[n][];
        }
        if (this.getAlignScaffold() || this.isScaffoldColoring()) {
            this.setScaffoldSkeleton(this.mol);
        }
        if (this.getEnumCodeNeeded()) {
            this.prepareMarkushIndexesForEnumCode();
        }
    }

    private void prepareRgroupsForColoring() {
        if (this.mol == null) {
            return;
        }
        new MDocument(this.mol);
        int color = 2;
        int count = this.mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            if (this.mol.getAtom(i).getAtno() != 134 || HomologyConstants.isHomologyRAtom(this.mol.getAtom(i))) continue;
            this.mol.getAtom(i).setSetSeq(color++);
        }
    }

    @Override
    public void setRandom(boolean random) {
        if (this.isRandom() != random) {
            super.setRandom(random);
            this.factory.setRandom(random);
            if (this.origMol != null) {
                this.setMol(this.origMol);
            }
        }
    }

    private int labellingLinkNodes(int n) {
        for (int i = this.mol.getGraphUnion().getAtomCount() - 1; i >= 0; --i) {
            if (!this.mol.getAtom(i).isLinkNode()) continue;
            this.mol.getAtom(i).putProperty("randomlabel", n++);
        }
        return n;
    }

    protected void setFactory(MarkushEnumeratorFactory f) {
        this.factory = f;
    }

    @Override
    public void setAlignScaffold(boolean alignScaffold) {
        super.setAlignScaffold(alignScaffold);
        if (alignScaffold) {
            this.setScaffoldSkeleton(this.mol);
        }
    }

    @Override
    protected void setColoring(int coloring) {
        super.setColoring(coloring);
        if ((coloring & 1) != 0) {
            this.setScaffoldSkeleton(this.mol);
        }
        if ((coloring & 2) != 0) {
            this.prepareRgroupsForColoring();
        }
    }

    @Override
    public void setEnumCodeNeeded(boolean enumCodeNeeded) {
        super.setEnumCodeNeeded(enumCodeNeeded);
        if (enumCodeNeeded) {
            this.prepareMarkushIndexesForEnumCode();
        }
    }

    public void setStructureID(String id) {
        this.structureID = id;
    }

    private String getStructureID(Molecule mol) {
        if (!this.getEnumCodeNeeded()) {
            return null;
        }
        String idOrTagName = this.structureID;
        if (idOrTagName == null) {
            return null;
        }
        String id = mol.getProperty(idOrTagName);
        if (id == null) {
            id = idOrTagName;
        }
        return id;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Markush Enumeration Plugin", this.licenseEnvironment);
    }

    private void checkLicense() {
        LicenseHandler.getInstance().checkLicense("Markush Enumeration Plugin", this.licenseEnvironment);
    }

    private void setScaffoldSkeleton(Molecule m) {
        int i;
        int n;
        if (m == null) {
            return;
        }
        this.scaffoldSkeleton = m instanceof RgMolecule ? ((RgMolecule)m).getRoot().cloneMolecule() : m.cloneMolecule();
        int count = n = this.scaffoldSkeleton.getAtomCount();
        int[] temp = new int[n];
        for (i = n - 1; i >= 0; --i) {
            MolAtom a = this.scaffoldSkeleton.getAtom(i);
            int atno = a.getAtno();
            if (atno > 109 && atno != 128 && atno != 129) {
                this.scaffoldSkeleton.removeAtom(i);
                temp[i] = -1;
                --count;
                continue;
            }
            if (a.isLinkNode() && this.isScaffoldColoring()) {
                a = m.getAtom(i);
                a.setSetSeq(1);
                a.getBond(a.getLinkNodeOuterAtom(0)).setSetSeq(63);
                a.getBond(a.getLinkNodeOuterAtom(1)).setSetSeq(63);
            }
            temp[i] = i;
        }
        if (this.isScaffoldColoring()) {
            for (i = m.getSgroupCount() - 1; i >= 0; --i) {
                MolBond[] bonds;
                Sgroup sgroup = m.getSgroup(i);
                if (!(sgroup instanceof RepeatingUnitSgroup)) continue;
                RepeatingUnitSgroup repunit = (RepeatingUnitSgroup)sgroup;
                for (int j = repunit.getAtomCount() - 1; j >= 0; --j) {
                    repunit.getAtom(j).setSetSeq(1);
                }
                SelectionMolecule sm = sgroup.getSgroupGraph();
                for (int j = sm.getBondCount() - 1; j >= 0; --j) {
                    sm.getBond(j).setSetSeq(63);
                }
                for (MolBond bond : bonds = repunit.findCrossingBonds()) {
                    bond.setSetSeq(63);
                }
            }
        }
        if (count > 0) {
            int j = 0;
            for (i = 0; i < count && j < n; ++i) {
                while (temp[j++] == -1) {
                }
                m.getAtom(j - 1).putProperty("alignHit", i);
            }
        }
    }

    private void prepareMarkushIndexesForEnumCode() {
        if (this.mol == null) {
            return;
        }
        MoleculeGraph m = this.mol instanceof RgMolecule ? this.mol.getGraphUnion() : this.mol;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            a.putProperty("EnumIndex", this.mol.indexOf(a));
        }
    }

    protected void removeHelperProperties(Molecule m) {
        int acount = m.getAtomCount();
        for (int i = 0; i < acount; ++i) {
            MolAtom a = m.getAtom(i);
            a.removeProperty("EnumIndex");
            a.removeProperty("alignHit");
        }
    }

    @Override
    public void setEnumerateHomology(boolean enumerate) {
        boolean changed = this.enumHomology != enumerate;
        super.setEnumerateHomology(enumerate);
        if (changed && this.origMol != null) {
            this.setMol(this.origMol);
        }
    }

    private void logEnumerators() {
        StringBuffer b = new StringBuffer();
        int size = this.enumerators.size();
        b.append("" + size + " enumerators:\n");
        for (int i = 0; i < size; ++i) {
            b.append(this.enumerators.get(i));
        }
        logger.finer(new String(b));
    }

    private static void logState(MolEnumerator me, int n) {
        logger.fine("After backtrack, generate " + n + " on branch " + me.getBranchIndex());
        me.logState();
        int nEnum = me.getNumberOfEnumeratesGeneratedSoFar();
        int nAll = me.getNumberOfRandomEnumeratesToGenerate();
        int nRem = me.getRemainingEnumeratesOnTheBranches();
        logger.finer("Gen. " + nEnum + " of " + nAll + ", remaining " + nRem);
        assert (nAll == nRem + nEnum);
    }
}

